/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.extenders;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Holo;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import gregtech.tileentity.extenders.MultiTileEntityExtender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;

public class MultiTileEntityFilter
extends MultiTileEntityExtender {
    public ItemStack[] mFilter = new ItemStack[54];

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        for (int i = 0; i < this.mFilter.length; ++i) {
            this.mFilter[i] = aNBT.func_74764_b("gt.tankfilter." + i) ? UT.Fluids.display(UT.Fluids.load(aNBT, "gt.tankfilter." + i), false) : UT.Stacks.load(aNBT, "gt.invfilter." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        for (int i = 0; i < this.mFilter.length; ++i) {
            UT.Stacks.save(aNBT, "gt.invfilter." + i, this.mFilter[i]);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mFilter.length; ++i) {
            UT.Stacks.save(aNBT, "gt.invfilter." + i, this.mFilter[i]);
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUIClientFilter(aPlayer.field_71071_by, this);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUICommonFilter(aPlayer.field_71071_by, this);
    }

    @Override
    public int getSizeInventoryGUI() {
        return this.mFilter == null ? 0 : this.mFilter.length;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mFilter[aSlot];
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        this.mInventoryChanged = true;
        if (this.mFilter[aSlot] != null) {
            if (this.mFilter[aSlot].field_77994_a <= aDecrement) {
                ItemStack tStack = this.mFilter[aSlot];
                this.mFilter[aSlot] = null;
                return tStack;
            }
            ItemStack rStack = this.mFilter[aSlot].func_77979_a(aDecrement);
            if (this.mFilter[aSlot].field_77994_a <= 0) {
                this.mFilter[aSlot] = null;
            }
            return rStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        ItemStack rStack = this.mFilter[aSlot];
        this.mFilter[aSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.mInventoryChanged = true;
        this.mFilter[aSlot] = OM.get(aStack);
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return 1;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.filter";
    }

    public boolean allowInput(ItemStack aStack) {
        for (ItemStack tStack : this.mFilter) {
            if (!UT.Stacks.valid(tStack) || !UT.Stacks.equal_(tStack, aStack, !tStack.func_77942_o())) continue;
            return true;
        }
        return false;
    }

    public boolean allowInput(FluidStack aFluid) {
        return aFluid != null && this.allowInput(aFluid.getFluid());
    }

    public boolean allowInput(Fluid aFluid) {
        if (aFluid != null) {
            for (ItemStack tStack : this.mFilter) {
                if (!IL.Display_Fluid.equal(tStack, true, true) || aFluid.getID() != UT.Stacks.meta(tStack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0 && UT.Stacks.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.mLastSide == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && UT.Stacks.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.mLastSide == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && UT.Stacks.valid(aStack) && (this.mLastSide != this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.mLastSide == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102008_b(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if ((this.mModes & 2) != 0 && (UT.Code.side(aDirection) == this.mFacing || this.allowInput(aFluid))) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(UT.Code.side(aDirection) == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if ((this.mModes & 2) != 0 && (UT.Code.side(aDirection) != this.mFacing || this.allowInput(aFluid))) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(UT.Code.side(aDirection) == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aToDrain, boolean aDoDrain) {
        if ((this.mModes & 2) != 0) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(UT.Code.side(aDirection) == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return UT.Code.side(aDirection) != this.mFacing || this.allowInput(((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, false)) ? ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, aDoDrain) : null;
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0 && (UT.Code.side(aDirection) == this.mFacing || this.allowInput(aFluid))) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(UT.Code.side(aDirection) == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0 && (UT.Code.side(aDirection) != this.mFacing || this.allowInput(aFluid))) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(UT.Code.side(aDirection) == this.mFacing ? this.mSecondFacing : this.mFacing, false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientFilter
    extends ContainerClient {
        private int mRows;

        public MultiTileEntityGUIClientFilter(InventoryPlayer aInventoryPlayer, MultiTileEntityFilter aTileEntity) {
            super(new MultiTileEntityGUICommonFilter(aInventoryPlayer, aTileEntity), CS.RES_PATH_GUI + "machines/Filter.png");
            this.mRows = this.mContainer.mTileEntity.getSizeInventoryGUI() / 9 + (this.mContainer.mTileEntity.getSizeInventoryGUI() % 9 == 0 ? 0 : 1);
            this.field_147000_g = 114 + this.mRows * 18;
        }

        @Override
        protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
            this.field_146289_q.func_78276_b(this.mContainer.mTileEntity.getInventoryNameGUI(), 8, 6, 0x404040);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
        }

        @Override
        protected void drawGuiContainerBackgroundLayer2(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k = (this.field_146294_l - this.field_146999_f) / 2;
            int l = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.mRows * 18 + 17);
            this.func_73729_b(k, l + this.mRows * 18 + 17, 0, 126, this.field_146999_f, 96);
        }
    }

    public class MultiTileEntityGUICommonFilter
    extends ContainerCommon {
        public MultiTileEntityGUICommonFilter(InventoryPlayer aInventoryPlayer, MultiTileEntityFilter aTileEntity) {
            super(aInventoryPlayer, aTileEntity);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            int tSize = this.mTileEntity.getSizeInventoryGUI();
            int tRows = tSize / 9 + (tSize % 9 == 0 ? 0 : 1);
            int i = 0;
            for (int y = 0; y < tRows; ++y) {
                for (int x = 0; x < 9 && i < tSize; ++x) {
                    this.func_75146_a(new Slot_Holo(this.mTileEntity, i++, 8 + x * 18, 18 + y * 18, true, false, 1));
                }
            }
            return 103 + (tRows - 4) * 18;
        }

        @Override
        public int getSlotCount() {
            return 0;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 0;
        }

        @Override
        public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
            if (aSlotIndex < 0 || aSlotIndex >= this.mTileEntity.getSizeInventoryGUI()) {
                return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
            }
            Slot tSlot = (Slot)this.field_75151_b.get(aSlotIndex);
            if (tSlot != null) {
                ItemStack tStack = aPlayer.field_71071_by.func_70445_o();
                if (tStack == null) {
                    tStack = tSlot.func_75211_c();
                    if (aMouseclick == 0) {
                        tSlot.func_75215_d(null);
                    } else if (tStack != null) {
                        FluidStack tFluid = UT.Fluids.getFluidForFilledItem(tStack, true);
                        if (tFluid != null && (((MultiTileEntityFilter)this.mTileEntity).mModes & 2) != 0) {
                            tSlot.func_75215_d(UT.Fluids.display(tFluid.getFluid()));
                        } else if (tStack.func_77942_o()) {
                            tStack.func_77982_d(null);
                        } else if (!tStack.func_77973_b().func_77614_k()) {
                            tStack.func_77964_b(Short.MAX_VALUE);
                        }
                    }
                } else {
                    FluidStack tFluid = UT.Fluids.getFluidForFilledItem(tStack, true);
                    if (tFluid != null && (((MultiTileEntityFilter)this.mTileEntity).mModes & 1) == 0) {
                        tSlot.func_75215_d(UT.Fluids.display(tFluid.getFluid()));
                    } else {
                        tSlot.func_75215_d(UT.Stacks.amount(1L, tStack));
                    }
                }
            }
            return null;
        }
    }
}

