/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.TileEntityBase11Motor;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityTurbineSteam
extends TileEntityBase11Motor
implements IFluidHandler,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    protected FluidTank[] mTanks = new FluidTank[]{new FluidTank(640)};
    protected long mSteamCounter = 0L;
    protected long mEnergyProducedNextTick = 0L;
    public static final int STEAM_PER_WATER = 200;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/side")};
    public static IIconContainer[] sOverlaysActiveLS = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/side")};
    public static IIconContainer[] sOverlaysActiveLF = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/side")};
    public static IIconContainer[] sOverlaysActiveRS = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/side")};
    public static IIconContainer[] sOverlaysActiveRF = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.energy.su")) {
            this.mSteamCounter = aNBT.func_74763_f("gt.energy.su");
        }
        if (aNBT.func_74764_b("gt.output.su")) {
            this.mEnergyProducedNextTick = aNBT.func_74763_f("gt.output.su");
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            if (aNBT.func_74764_b("gt.tank." + i)) {
                NBTTagCompound tNBT = aNBT.func_74775_l("gt.tank." + i);
                this.mTanks[i].readFromNBT(tNBT);
            }
            this.mTanks[i].setCapacity((int)UT.Code.bind_(200L, Integer.MAX_VALUE, this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6) * 4L));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy.su", this.mSteamCounter);
        UT.NBT.setNumber(aNBT, "gt.output.su", this.mEnergyProducedNextTick);
        for (int i = 0; i < this.mTanks.length; ++i) {
            aNBT.func_74782_a("gt.tank." + i, (NBTBase)this.mTanks[i].writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.emits.used.steam") + " (" + LH.get("gt.lang.face.sides") + ", 80%)");
    }

    @Override
    public void doConversion(long aTimer) {
        if (this.mEnergyProducedNextTick > 0L) {
            this.mEnergy += this.mEnergyProducedNextTick;
            this.mEnergyProducedNextTick = 0L;
        } else if (this.mTanks[0].getFluidAmount() >= UT.Code.bindInt(this.getEnergySizeInputMin(this.mEnergyTypeAccepted, (byte)6)) * 2) {
            int tSteam = this.mTanks[0].getFluidAmount();
            this.mSteamCounter += (long)tSteam;
            this.mEnergy += (long)(tSteam / 2);
            this.mEnergyProducedNextTick += (long)(tSteam / 2);
            this.mTanks[0].setFluid(CS.NF);
            if (this.mSteamCounter >= 200L) {
                FluidStack tDrainableSteam = UT.Fluids.distilledwater(this.mSteamCounter / 200L);
                for (byte tDir : CS.FACING_SIDES[this.mFacing]) {
                    DelegatorTileEntity<IFluidHandler> tTank = this.getAdjacentTank(tDir);
                    if (tTank.mTileEntity != null) {
                        tDrainableSteam.amount -= ((IFluidHandler)tTank.mTileEntity).fill(tTank.getForgeSideOfTileEntity(), tDrainableSteam.copy(), true);
                    }
                    if (tDrainableSteam.amount <= 0) break;
                }
                this.mSteamCounter %= 200L;
            }
        }
        super.doConversion(aTimer);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 0.5f : 0.25f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return true;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return true;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.isInput(aSide) && !this.mStopped && UT.Fluids.steam(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.isOutput(aSide) ? null : this.mTanks;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((float)this.field_145848_d + (this.mFacing == 1 ? CS.PIXELS_NEG[2] : 1.0f)), (double)(this.field_145849_e + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mActiveState > 0) {
            aEntity.field_70177_z = aEntity.field_70177_z + (float)((this.mCounterClockwise ? -2 : 2) * (this.mFast ? 2 : 1));
            if (aEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)aEntity).field_70759_as = ((EntityLivingBase)aEntity).field_70759_as + (float)((this.mCounterClockwise ? -2 : 2) * (this.mFast ? 2 : 1));
            }
        }
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPPOSITES[this.mFacing] ? 1 : 2);
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa);
        iTextureArray[1] = BlockTextureDefault.get((this.mActiveState > 0 ? (this.mCounterClockwise ? (this.mFast ? sOverlaysActiveLF : sOverlaysActiveLS) : (this.mFast ? sOverlaysActiveRF : sOverlaysActiveRS)) : sOverlays)[aIndex]);
        return BlockTextureMulti.get(iTextureArray);
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.back");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.turbines.rotation_steam";
    }
}

