/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityEmitter;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntitySolarPanelElectric
extends TileEntityBase09FacingSingle
implements ITileEntityEnergyElectricityEmitter,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff {
    protected boolean mEmitsEnergy = false;
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected boolean oActive = false;
    protected boolean mCheck = true;
    protected boolean mSky = false;
    protected long mEnergy = 0L;
    protected long mOutput = 8L;
    protected TagData mEnergyTypeEmitted = TD.Energy.QU;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/colored/side_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/colored/side"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/colored/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/colored/top")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay/side_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay/top")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay_active/side_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay_active/side"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay_active/bottom_facing"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/solarpanels/solarpanel_electric_8eu/overlay_active/top")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.func_74767_n("gt.active.energy");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutput = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        this.addToolTipsEnergy(aList, aStack, aF3_H);
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEnergy(List aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.front"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && !this.mStopped) {
            this.generateEnergy(aTimer);
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActive != this.oActive || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oActive = this.mActive;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActive = (aData & 1) != 0;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return this.mEnergy;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mOutput / 8L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeEmitted);
    }

    public double getOfferedEnergy() {
        return this.mEmitsEnergy ? 0.0 : (double)this.mEnergy;
    }

    public void drawEnergy(double aAmount) {
        this.mEnergy = (long)((double)this.mEnergy - aAmount);
    }

    @Override
    public long doExtract(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        if ((aSize = Math.abs(aSize)) * aAmount <= this.mEnergy) {
            if (aDoExtract) {
                this.mEnergy -= aSize * aAmount;
            }
            return aAmount;
        }
        return 0L;
    }

    public void generateEnergy(long aTimer) {
        if (this.mCheck || this.mBlockUpdated || this.mTimer % 600L == 5L) {
            this.mCheck = false;
            this.mSky = this.getSkyAtSide((byte)1);
        }
        this.mEnergy = this.mSky ? (this.field_145850_b.func_72911_I() ? 0L : (this.field_145850_b.func_72935_r() ? (this.field_145850_b.func_72896_J() && this.getBiome().field_76751_G > 0.0f ? this.mOutput / 8L : this.mOutput) : (this.field_145850_b.func_72896_J() && this.getBiome().field_76751_G > 0.0f ? 0L : this.mOutput / 8L))) : 0L;
        this.mActive = this.mEnergy >= this.getEnergySizeOutputMin(this.mEnergyTypeEmitted, (byte)6);
        this.mEmitsEnergy = false;
        if (this.mActive) {
            if (this.mTimer % 600L == 5L) {
                this.doDefaultStructuralChecks();
            }
            if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyTypeEmitted)) {
                this.mEmitsEnergy = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, this.mEnergy, this) > 0L;
            } else {
                boolean bl = this.mEmitsEnergy = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mEnergy, 1L, this) > 0L;
            }
        }
        if (this.mEmitsEnergy) {
            this.mEnergy = 0L;
        }
    }

    @Override
    public boolean isRainProof(byte aSide) {
        return true;
    }

    @Override
    public boolean isThunderProof(byte aSide) {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        if (this.mStopped && aOnOff) {
            this.mCheck = true;
        }
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM_HORIZONTAL;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mActive ? 1 : 0);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = CS.SIDES_TOP[aSide] ? 4 : (aSide == this.mFacing ? (CS.SIDES_HORIZONTAL[aSide] ? 0 : 2) : (CS.SIDES_HORIZONTAL[aSide] ? 1 : 3));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get((this.mActive ? sOverlaysActive : sOverlays)[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.solarpanel.electric_8eu";
    }
}

