/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import buildcraft.api.power.ILaserTarget;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityLaserBuildcraft
extends TileEntityBase10EnergyConverter
implements ITileEntityEnergyElectricityAcceptor,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;
    public static IIconContainer[] sLasers;

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.assemblylaser"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void doConversion(long aTimer) {
        if (EnergyCompat.BC_LASER) {
            long tOutput = UT.Code.units(this.mEnergy, this.mInput, this.mOutput, false);
            this.mEmitsEnergy = false;
            DelegatorTileEntity<TileEntity> tLaser = this.getAdjacentTileEntity(this.mFacing, false, false);
            if (tOutput >= this.getEnergySizeOutputMin(this.mEnergyTypeEmitted, (byte)6) && tLaser.mTileEntity instanceof ILaserTarget && ((ILaserTarget)tLaser.mTileEntity).requiresLaserEnergy()) {
                long tMaxOut = this.getEnergySizeOutputMax(this.mEnergyTypeEmitted, (byte)6);
                if (tOutput > tMaxOut && TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mEnergyTypeAccepted)) {
                    tOutput = tMaxOut;
                }
                if (tOutput > tMaxOut) {
                    this.overload(this.mEnergy, this.mEnergyTypeEmitted);
                } else {
                    ((ILaserTarget)tLaser.mTileEntity).receiveLaserEnergy(UT.Code.bindInt(tOutput));
                }
                this.mEnergy = Math.max(0L, this.mEnergy - this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6));
                this.mEmitsEnergy = true;
                this.mActive = true;
            } else {
                this.mActive = false;
            }
        }
    }

    @Override
    public byte getDefaultSide() {
        return 1;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM;
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.back");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? 0.5f : 0.0f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[this.mFacing == 4 ? 8 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[this.mFacing == 0 ? 8 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[this.mFacing == 2 ? 8 : 0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[this.mFacing == 5 ? 8 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[this.mFacing == 1 ? 8 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[this.mFacing == 3 ? 8 : 0]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[this.mFacing == 4 ? 8 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[this.mFacing == 0 ? 8 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[this.mFacing == 2 ? 8 : 0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[this.mFacing == 5 ? 8 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[this.mFacing == 1 ? 8 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[this.mFacing == 3 ? 8 : 0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[this.mFacing == 4 ? 8 : 0], CS.PIXELS_POS[this.mFacing == 0 ? 8 : 0], CS.PIXELS_POS[this.mFacing == 2 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 5 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 1 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 3 ? 8 : 0]);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 5;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return this.mActiveState != 0 || aRenderPass < 2;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[this.mFacing == 4 ? 8 : 0], CS.PIXELS_POS[this.mFacing == 0 ? 8 : 0], CS.PIXELS_POS[this.mFacing == 2 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 5 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 1 ? 8 : 0], CS.PIXELS_NEG[this.mFacing == 3 ? 8 : 0]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[4], CS.PIXELS_POS[4], CS.PIXELS_NEG[4], CS.PIXELS_NEG[4], CS.PIXELS_NEG[4]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(this.mFacing == 4 ? -0.99f : CS.PIXELS_POS[5], this.mFacing == 0 ? -0.99f : CS.PIXELS_POS[5], this.mFacing == 2 ? -0.99f : CS.PIXELS_POS[5], this.mFacing == 5 ? 1.99f : CS.PIXELS_NEG[5], this.mFacing == 1 ? 1.99f : CS.PIXELS_NEG[5], this.mFacing == 3 ? 1.99f : CS.PIXELS_NEG[5]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(this.mFacing == 4 ? -0.99f : CS.PIXELS_POS[6], this.mFacing == 0 ? -0.99f : CS.PIXELS_POS[6], this.mFacing == 2 ? -0.99f : CS.PIXELS_POS[6], this.mFacing == 5 ? 1.99f : CS.PIXELS_NEG[6], this.mFacing == 1 ? 1.99f : CS.PIXELS_NEG[6], this.mFacing == 3 ? 1.99f : CS.PIXELS_NEG[6]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(this.mFacing == 4 ? -0.99f : CS.PIXELS_POS[7], this.mFacing == 0 ? -0.99f : CS.PIXELS_POS[7], this.mFacing == 2 ? -0.99f : CS.PIXELS_POS[7], this.mFacing == 5 ? 1.99f : CS.PIXELS_NEG[7], this.mFacing == 1 ? 1.99f : CS.PIXELS_NEG[7], this.mFacing == 3 ? 1.99f : CS.PIXELS_NEG[7]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                int tIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPPOSITES[this.mFacing] ? 1 : 2);
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[tIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[tIndex]));
            }
            case 1: {
                if (aSide == CS.OPPOSITES[this.mFacing]) break;
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aSide == this.mFacing ? 3 : 4], MT.Diamond.mRGBaSolid), BlockTextureDefault.get(sOverlays[aSide == this.mFacing ? 3 : 4]));
            }
        }
        if (!CS.ALONG_AXIS[aSide][this.mFacing]) {
            return BlockTextureDefault.get(sLasers[aRenderPass - 2], MT.Diamond.mRGBaSolid);
        }
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.lasers.buildcraft_electric";
    }

    static {
        LH.add("gt.tooltip.assemblylaser", "Place directly ontop of the Laser powered BC Device");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/back"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/side"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/laser_front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/laser_side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/laser_front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/laser_side")};
        sLasers = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser3"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser2"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser1")};
    }
}

