/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityGeneratorSolid
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityRunningActively,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    private static int FLAME_RANGE = 3;
    protected short mEfficiency = (short)10000;
    protected long mEnergy = 0L;
    protected long mRate = 1L;
    protected boolean mBurning = false;
    protected boolean oBurning = false;
    protected TagData mEnergyTypeEmitted = TD.Energy.HU;
    protected Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sFurnaceFuel;
    protected Recipe mLastRecipe = null;
    protected ItemStack mOutput1 = null;
    private static final int[] ACCESSABLE_SLOTS = new int[]{0, 1};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/colored/back")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay/back")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_solid/overlay_active/back")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        this.mBurning = aNBT.func_74767_n("gt.active");
        this.mOutput1 = UT.Stacks.load(aNBT, "gt.invout.1");
        if (aNBT.func_74764_b("gt.output")) {
            this.mRate = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.fuelmap"));
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mBurning);
        UT.Stacks.save(aNBT, "gt.invout.1", this.mOutput1);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.top"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.air.front"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.empty.ashes") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.inventory") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.fire") + " (" + (FLAME_RANGE + 1) + "m)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact") + " (" + LH.get("gt.lang.face.top") + ")");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mBurning) {
                if (this.mEnergy > 0L) {
                    this.mEnergy -= Math.max(1L, Math.max(this.mRate / 2L, ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, Math.min(this.mRate, this.mEnergy), this)));
                    if (this.mEfficiency < 1 || this.getRandomNumber(this.mEfficiency) == 0) {
                        UT.Worlds.setToFire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.getRandomNumber(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), true);
                    }
                }
                if (this.mEnergy < this.mRate * 2L) {
                    Recipe tRecipe;
                    UT.Worlds.setToFire(this.field_145850_b, this.getOffset(this.mFacing, 1), true);
                    if (this.addStackToSlot(1, this.mOutput1)) {
                        this.mOutput1 = null;
                    }
                    if (this.mOutput1 == null && !UT.Worlds.hasBlockHitBox(this.field_145850_b, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing)) && (tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, true, Long.MAX_VALUE, null, CS.ZL_FLUIDSTACK, this.slot(0))) != null && tRecipe.isRecipeInputEqual(true, false, CS.ZL_FLUIDSTACK, this.slot(0))) {
                        this.mLastRecipe = tRecipe;
                        ItemStack[] tOutputs = tRecipe.getOutputs(this.field_145850_b.field_73012_v);
                        if (tOutputs.length > 0) {
                            this.mOutput1 = UT.Stacks.copy(tOutputs[0]);
                        }
                        this.mEnergy += UT.Code.units(Math.abs(tRecipe.mEUt * tRecipe.mDuration), 10000L, this.mEfficiency, false);
                        this.removeAllDroppableNullStacks();
                    }
                }
            }
            if (this.mEnergy <= 0L) {
                this.mEnergy = 0L;
                this.mBurning = false;
            }
        } else if (this.mBurning && this.getRandomNumber(4) == 0) {
            this.spawnBurningParticles((double)this.field_145851_c + 0.5 + (double)CS.OFFSETS_X[this.mFacing] * 0.55 + (double)(CS.SIDES_AXIS_X[this.mFacing] ? 0.0f : this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f), (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat() * 0.375f, (double)this.field_145849_e + 0.5 + (double)CS.OFFSETS_Z[this.mFacing] * 0.55 + (double)(CS.SIDES_AXIS_Z[this.mFacing] ? 0.0f : this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f));
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        if (this.isServerSide()) {
            ItemStack aStack = aPlayer.func_71045_bC();
            if (aStack == null) {
                if (this.slot(1) != null) {
                    aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, this.slot(1));
                    this.slot(1, null);
                    return true;
                }
                if (!this.mBurning && this.slot(0) != null) {
                    aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, this.slot(0));
                    this.slot(0, null);
                    return true;
                }
            } else if (this.slot(0) == null) {
                if (this.func_102007_a(0, aStack, 6)) {
                    this.slot(0, aStack);
                    aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, null);
                    return true;
                }
            } else {
                if (UT.Stacks.equal(aStack, this.slot(0))) {
                    int tDifference = Math.min(aStack.field_77994_a, this.slot(0).func_77976_d() - this.slot((int)0).field_77994_a);
                    aStack.field_77994_a -= tDifference;
                    this.slot((int)0).field_77994_a += tDifference;
                    return true;
                }
                if (UT.Stacks.equal(aStack, this.slot(1))) {
                    int tDifference = Math.min(this.slot((int)1).field_77994_a, aStack.func_77976_d() - aStack.field_77994_a);
                    aStack.field_77994_a += tDifference;
                    this.slot((int)1).field_77994_a -= tDifference;
                    this.removeAllDroppableNullStacks();
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("igniter") && (aSide == this.mFacing || aPlayer == null)) {
            this.mBurning = true;
            return 10000L;
        }
        if (aTool.equals("extinguisher") && (aSide == this.mFacing || aPlayer == null)) {
            this.mBurning = false;
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mBurning != this.oBurning || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oBurning = this.mBurning;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mBurning = (aData & 1) != 0;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mBurning ? 1 : 0);
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACING_ROTATIONS[this.mFacing][aSide]], this.mRGBa), BlockTextureDefault.get((this.mBurning ? sOverlaysActive : sOverlays)[CS.FACING_ROTATIONS[this.mFacing][aSide]])) : null;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mBurning) {
            UT.Entities.applyHeatDamage(aEntity, (float)this.mRate / 10.0f);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 0.875), (double)((double)this.field_145849_e + 1.0));
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return aSide == this.mFacing ? CS.ZL_INTEGER : ACCESSABLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aStack != null && aSlot == 0 && aSide != this.mFacing && this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aStack != null && aSlot == 1 && aSide != this.mFacing;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return CS.SIDES_TOP[aSide] && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return Math.min(this.mRate, this.mEnergy);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mBurning;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mBurning;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mBurning;
    }

    protected void spawnBurningParticles(double aX, double aY, double aZ) {
        this.field_145850_b.func_72869_a("smoke", aX, aY, aZ, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("flame", aX, aY, aZ, 0.0, 0.0, 0.0);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.burning_solid";
    }
}

