/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.energy.ITileEntityEnergyFluxHandler;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityEngineElectric
extends TileEntityBase09FacingSingle
implements ITileEntityEnergyFluxHandler,
ITileEntityEnergyElectricityAcceptor,
ITileEntitySwitchableOnOff,
ITileEntityRunningActively,
ITileEntitySwitchableMode {
    public static final int[] sEngineColors = new int[]{255, 4590, 8925, 13260, 17595, 21930, 26265, 30600, 34935, 39270, 43605, 47940, 52275, 56610, 60945, 65280, 65280, 0x11EE00, 0x22DD00, 0x33CC00, 0x44BB00, 0x55AA00, 0x669900, 0x778800, 0x887700, 0x996600, 0xAA5500, 0xBB4400, 0xCC3300, 0xDD2200, 0xEE1100, 0xFF0000};
    protected boolean mEmitsEnergy = false;
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected boolean oActive = false;
    protected byte mState = (byte)15;
    protected byte mPiston = 0;
    protected long mEnergy = 0L;
    protected long mInput = 32L;
    protected long mOutput = 16L;
    protected TagData mEnergyTypeEmitted = TD.Energy.KU;
    protected TagData mEnergyTypeAccepted = TD.Energy.EU;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/front"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/back"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/cage"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/engine"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/colored/engine_hull")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/cage"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/engine"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_electric/overlay/engine_hull")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.func_74767_n("gt.active.energy");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mState = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.piston")) {
            this.mPiston = aNBT.func_74771_c("gt.piston");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutput = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        if (this.mState != 15) {
            aNBT.func_74774_a("gt.mode", this.mState);
        }
        aNBT.func_74774_a("gt.piston", this.mPiston);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mState != 15) {
            aNBT.func_74774_a("gt.mode", this.mState);
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, this.mEnergyTypeEmitted, LH.get("gt.lang.face.back"), LH.get("gt.lang.face.front"));
        this.addToolTipsEfficiency(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEfficiency(List aList, ItemStack aStack, boolean aF3_H) {
        if (TD.Energy.ALL_EU.contains(this.mEnergyTypeAccepted)) {
            if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted)) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * 2L, false)));
            } else if (this.mEnergyTypeEmitted == TD.Energy.RF) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput * 4L, this.mOutput * 2L, false)));
            }
        } else if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted) && this.mEnergyTypeAccepted == TD.Energy.RF) {
            aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * 8L, false)));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (this.mActive && aTimer % (long)(32 - this.mState) == 0L) {
            this.mPiston = (byte)(this.mPiston + 1);
            this.mPiston = (byte)(this.mPiston & 3);
        }
        this.mEmitsEnergy = false;
        if (aIsServerSide) {
            long tOutput = this.mOutput * (long)(this.mState + 1) / 16L;
            long tInput = this.mInput * (long)(this.mState + 1) / 16L + (long)(this.mInput * (long)(this.mState + 1) % 16L == 0L ? 0 : 1);
            boolean bl = this.mActive = this.mEnergy >= tInput;
            if (this.mActive) {
                this.mEmitsEnergy = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mPiston > 1 ? -tOutput : tOutput, 1L, this) > 0L;
                this.mEnergy -= tInput;
                if (this.mTimer % 600L == 5L) {
                    this.doDefaultStructuralChecks();
                }
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("screwdriver")) {
            this.mState = (byte)((this.mState + 1) % 32);
            aChatReturn.add("Input: " + (this.mInput * (long)(this.mState + 1) / 16L + (long)(this.mInput * (long)(this.mState + 1) % 16L == 0L ? 0 : 1)));
            aChatReturn.add("Output: " + this.mOutput * (long)(this.mState + 1) / 16L);
            this.updateClientData();
            return 1000L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mState = UT.Code.bind5(this.mState);
        return this.mActive != this.oActive || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oActive = this.mActive;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mPiston = (byte)(aData & 3);
        this.mActive = (aData & 4) != 0;
        this.mState = (byte)(aData >>> 3 & 0x1F);
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mPiston & 3 | (this.mActive ? 4 : 0) | this.mState << 3);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 0.5f : 0.25f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        long tInputMax = this.getEnergySizeInputMax(aEnergyType, aSide);
        if ((aSize = Math.abs(aSize)) > tInputMax) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        long tInput = Math.min(tInputMax - this.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte setStateMode(byte aMode) {
        if (this.mState != (aMode = (byte)(aMode * 2 + 1))) {
            this.mState = aMode;
            this.updateClientData();
        }
        return this.getStateMode();
    }

    @Override
    public byte getStateMode() {
        return (byte)(this.mState / 2);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting ? aEnergyType == this.mEnergyTypeEmitted : aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (aTheoretical || !this.mStopped) && aSide == CS.OPPOSITES[this.mFacing] && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeEmitted, this.mEnergyTypeAccepted);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 5;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 14 : 0], CS.PIXELS_NEG[CS.SIDES_AXIS_Y[this.mFacing] ? 14 : 0], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 14 : 0]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 14 : 0], CS.PIXELS_POS[CS.SIDES_AXIS_Y[this.mFacing] ? 14 : 0], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 14 : 0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 4], CS.PIXELS_POS[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 4], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 4], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 4], CS.PIXELS_NEG[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 4], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 4]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 3], CS.PIXELS_POS[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 3], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 3], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 3], CS.PIXELS_NEG[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 3], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 3]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return CS.ALONG_AXIS[aSide][this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[3], this.mRGBa), BlockTextureDefault.get(sOverlays[3]));
            }
            case 1: 
            case 2: {
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aSide == this.mFacing ? 0 : (aSide == CS.OPPOSITES[this.mFacing] ? 1 : 2)], this.mRGBa), BlockTextureDefault.get(sOverlays[aSide == this.mFacing ? 0 : (aSide == CS.OPPOSITES[this.mFacing] ? 1 : 2)]));
            }
            case 3: {
                return aSide == CS.OPPOSITES[this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[4], sEngineColors[this.mState]), BlockTextureDefault.get(sOverlays[4]));
            }
            case 4: {
                return CS.ALONG_AXIS[aSide][this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[5], this.mRGBa), BlockTextureDefault.get(sOverlays[5]));
            }
        }
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.engine.kinetic_electricity";
    }
}

