/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityBoilerTank
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityFunnelAccessible,
ITileEntityGibbl,
ITileEntityEnergyDataCapacitor,
IFluidHandler,
IMultiTileEntity.IMTE_RemovedByPlayer,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    protected byte mBarometer = 0;
    protected byte oBarometer = 0;
    protected short mEfficiency = (short)10000;
    protected short mCoolDownResetTimer = (short)128;
    protected long mEnergy = 0L;
    protected long mCapacity = 640000L;
    protected long mOutput = 6400L;
    protected TagData mEnergyTypeAccepted = TD.Energy.HU;
    protected FluidTank[] mTanks = new FluidTank[]{new FluidTank(4000), new FluidTank(64000)};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.visual")) {
            this.mBarometer = aNBT.func_74771_c("gt.visual");
        }
        if (aNBT.func_74764_b("gt.capacity")) {
            this.mCapacity = aNBT.func_74763_f("gt.capacity");
        }
        if (aNBT.func_74764_b("gt.capacity.su")) {
            this.mTanks[1].setCapacity(aNBT.func_74762_e("gt.capacity.su"));
        }
        if (aNBT.func_74764_b("gt.output.su")) {
            this.mOutput = aNBT.func_74763_f("gt.output.su");
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            if (!aNBT.func_74764_b("gt.tank." + i)) continue;
            NBTTagCompound tNBT = aNBT.func_74775_l("gt.tank." + i);
            this.mTanks[i].readFromNBT(tNBT);
            if (!tNBT.func_74764_b("cap")) continue;
            this.mTanks[i].setCapacity(tNBT.func_74762_e("cap"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        if (this.mEfficiency != 10000) {
            aNBT.func_74777_a("gt.eff", this.mEfficiency);
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            aNBT.func_74782_a("gt.tank." + i, (NBTBase)this.mTanks[i].writeToNBT(UT.NBT.getNBTInteger(null, "cap", this.mTanks[i].getCapacity())));
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " 1 L " + UT.Fluids.name(FluidRegistry.WATER, true) + " " + LH.get("gt.lang.energy.convert.to") + " 160 L " + UT.Fluids.name(UT.Fluids.steam(0L), true) + " " + LH.get("gt.lang.energy.convert.using") + " 80 " + this.mEnergyTypeAccepted.getLocalisedNameShort());
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + (float)this.mOutput / (float)CS.STEAM_PER_EU + " " + this.mEnergyTypeAccepted.getChatFormat() + this.mEnergyTypeAccepted.getLocalisedNameShort() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.any") + ")");
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + this.mEnergyTypeAccepted.getChatFormat() + this.mEnergyTypeAccepted.getLocalisedNameShort() + LH.Chat.WHITE);
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + UT.Code.units(this.mOutput, 10000L, this.mEfficiency, false) + " " + TD.Energy.STEAM.getChatFormat() + TD.Energy.STEAM.getLocalisedNameLong() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + TD.Energy.STEAM.getChatFormat() + TD.Energy.STEAM.getLocalisedNameLong() + LH.Chat.WHITE);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.water.pure"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.explosion.steam"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.chisel.to.decalcify"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            FluidStack tDrainableSteam;
            int tAmount;
            long tConversions = Math.min((long)(this.mTanks[1].getCapacity() / 2560), Math.min(this.mEnergy / 80L, (long)this.mTanks[0].getFluidAmount()));
            if (tConversions > 0L) {
                this.mTanks[0].getFluid().amount = (int)((long)this.mTanks[0].getFluid().amount - tConversions);
                if (this.getRandomNumber(10) == 0 && !UT.Fluids.distilledwater(this.mTanks[0].getFluid())) {
                    this.mEfficiency = (short)((long)this.mEfficiency - tConversions);
                }
                if (this.mTanks[0].getFluidAmount() <= 0) {
                    this.mTanks[0].setFluid(null);
                }
                this.mTanks[1].setFluid(UT.Fluids.steam((long)this.mTanks[1].getFluidAmount() + UT.Code.units(tConversions, 10000L, this.mEfficiency * 160, false)));
                this.mEnergy -= tConversions * 80L;
                this.mCoolDownResetTimer = (short)128;
            }
            short s = this.mCoolDownResetTimer;
            this.mCoolDownResetTimer = (short)(s - 1);
            if (s <= 0) {
                this.mCoolDownResetTimer = 0;
                this.mEnergy -= this.mOutput / (long)CS.STEAM_PER_EU;
                this.mTanks[1].drain((int)this.mOutput, true);
                if (this.mEnergy <= 0L) {
                    this.mEnergy = 0L;
                    this.mCoolDownResetTimer = (short)128;
                }
            }
            if ((tAmount = this.mTanks[1].getFluidAmount() - this.mTanks[1].getCapacity() / 2) > 0 && (tDrainableSteam = this.mTanks[1].drain(Math.min((int)(tAmount > this.mTanks[1].getCapacity() / 4 ? this.mOutput * 2L : this.mOutput), tAmount), false)) != null) {
                DelegatorTileEntity<IFluidHandler> tTank = this.getAdjacentTank((byte)1);
                if (tTank.mTileEntity != null) {
                    this.mTanks[1].drain(((IFluidHandler)tTank.mTileEntity).fill(CS.FORGE_DIR[tTank.mSideOfTileEntity], tDrainableSteam, true), true);
                }
            }
            this.mBarometer = (byte)UT.Code.scale(this.mTanks[1].getFluidAmount(), this.mTanks[1].getCapacity(), 31L, false);
            if (this.mEnergy > this.mCapacity || this.mTanks[1].getFluidAmount() > this.mTanks[1].getCapacity()) {
                this.explode();
            }
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (aSide != this.mFacing) {
            return false;
        }
        if (this.isServerSide() && (aStack = aPlayer.func_71045_bC()) != null && (aStack.func_77973_b() == Items.field_151131_as || IL.Woodbucket_Cu_Water.equal(aStack, false, true) || IL.Woodbucket_Sn_Water.equal(aStack, false, true) || IL.Woodbucket_Zn_Water.equal(aStack, false, true) || IL.Woodbucket_Pb_Water.equal(aStack, false, true) || IL.Woodbucket_Bi_Water.equal(aStack, false, true) || IL.Woodbucket_Bronze_Water.equal(aStack, false, true) || IL.Woodbucket_Brass_Water.equal(aStack, false, true) || IL.Woodbucket_BismuthBronze_Water.equal(aStack, false, true)) && this.mTanks[0].getFluidAmount() < this.mTanks[0].getCapacity()) {
            if (!UT.Entities.hasInfiniteItems(aPlayer) && aStack.field_77994_a != 111) {
                UT.Stacks.set(aStack, UT.Stacks.container(aStack, true, aStack.field_77994_a));
            }
            this.mTanks[0].fill(UT.Fluids.water(1000 * aStack.field_77994_a), true);
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("chisel")) {
            int rResult = 10000 - this.mEfficiency;
            if (rResult > 0) {
                if (this.mBarometer > 15) {
                    this.explode();
                } else {
                    if (this.mEnergy + (long)(this.mTanks[1].getFluidAmount() / CS.STEAM_PER_EU) > 2000L) {
                        UT.Entities.applyHeatDamage(aPlayer, (float)(this.mEnergy + (long)(this.mTanks[1].getFluidAmount() / 2)) / 2000.0f);
                    }
                    this.mTanks[1].setFluid(CS.NF);
                    this.mEfficiency = (short)10000;
                    this.mEnergy = 0L;
                    return rResult;
                }
            }
            return 0L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                int rResult = 10000 - this.mEfficiency;
                if (rResult > 0) {
                    aChatReturn.add("Calcification: " + rResult / 100 + "." + rResult % 100 + "%");
                } else {
                    aChatReturn.add("No Calcification in this Boiler");
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, boolean aWillHarvest) {
        if (this.isServerSide() && !UT.Entities.isCreative(aPlayer) && this.mBarometer > 4) {
            this.explode();
        }
        return this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        super.onExploded(aExplosion);
        if (this.isServerSide() && this.mBarometer > 4) {
            this.explode();
        }
    }

    @Override
    public void explode() {
        this.explode(Math.sqrt(this.mTanks[1].getFluidAmount()) / 100.0);
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mBarometer = UT.Code.bind5(this.mBarometer);
        return this.mBarometer != this.oBarometer || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oBarometer = this.mBarometer;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mBarometer = (byte)(aData & 0x1F);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]), aSide != this.mFacing ? null : BlockTextureDefault.get(BI.BAROMETER), aSide != this.mFacing ? null : BlockTextureDefault.get(BI.BAROMETER_SCALE[this.mBarometer], CS.CA_RED_64)) : null;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mEnergy + (long)(this.mTanks[1].getFluidAmount() / CS.STEAM_PER_EU) > 2000L) {
            UT.Entities.applyHeatDamage(aEntity, (float)(this.mEnergy + (long)(this.mTanks[1].getFluidAmount() / 2)) / 2000.0f);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[2]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[2]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public byte getVisualData() {
        return this.mBarometer;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mEnergy += Math.abs(aAmount * aSize);
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mCapacity : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeAccepted);
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeAccepted);
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] && UT.Fluids.water(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public long getGibblValue(byte aSide) {
        return this.mTanks[1].getFluidAmount();
    }

    @Override
    public long getGibblMax(byte aSide) {
        return this.mTanks[1].getCapacity();
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tank.boiler_steam";
    }
}

