/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.autotools;

import gregapi.block.IBlockToolable;
import gregapi.code.TagData;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityAutoToolIgniter
extends TileEntityBase09FacingSingle
implements ITileEntityEnergyElectricityAcceptor,
ITileEntitySwitchableOnOff {
    public boolean mStopped = false;
    public byte mQuality = (byte)2;
    public byte mCoolDown = 0;
    public byte mSendSound = 0;
    public long mEnergy = 0L;
    public long mInput = 32L;
    public TagData mEnergyTypeAccepted = TD.Energy.EU;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/autotools/igniter/colored/front"), new Textures.BlockIcons.CustomIcon("machines/autotools/igniter/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/autotools/igniter/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/autotools/igniter/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.quality")) {
            this.mQuality = aNBT.func_74771_c("gt.quality");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.igniter"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.quality") + ": " + LH.Chat.WHITE + this.mQuality);
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, LH.get("gt.lang.face.any.but.front"), null);
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (aTimer % 10L == 0L) {
                if (this.mCoolDown > 0) {
                    this.mCoolDown = (byte)(this.mCoolDown - 1);
                }
                if (this.mEnergy > 0L) {
                    DelegatorTileEntity<TileEntity> tD = this.getAdjacentTileEntity(this.mFacing);
                    if (IBlockToolable.Util.onToolClick("igniter", this.mEnergy * 20L, (long)this.mQuality, null, null, null, false, null, tD.mWorld, tD.mSideOfTileEntity, tD.mX, tD.mY, tD.mZ, 0.5f, 0.5f, 0.5f) > 0L || UT.Worlds.setToFire(tD.mWorld, tD.getCoords(), false)) {
                        this.mSendSound = 1;
                    }
                    this.mEnergy = 0L;
                    this.mCoolDown = (byte)10;
                }
            }
        } else if (this.mSendSound != 0) {
            UT.Sounds.play("fire.ignite", 20, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.mSendSound = 0;
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mSendSound != 0 || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.mSendSound = 0;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mSendSound = aData;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        aAmount = Math.min(aAmount, 2L);
        if (aDoInject && this.mEnergy < this.mInput * 10L) {
            if (this.mCoolDown <= 0) {
                this.mEnergy += aSize * aAmount;
            }
            if (aSize > this.getEnergySizeInputMax(aEnergyType, aSide)) {
                this.overcharge(aSize, aEnergyType);
            }
        }
        return aAmount;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public byte getVisualData() {
        return this.mSendSound;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (aTheoretical || !this.mStopped) && aSide != this.mFacing && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : 1;
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.autotool.igniter";
    }
}

