/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.c;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Loader_Thread_Decomposition
implements Runnable {
    @Override
    public void run() {
        try {
            for (OreDictMaterial aMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                IOreDictConfigurationComponent tComponents;
                if (aMaterial.mTargetRegistration != aMaterial || (tComponents = aMaterial.mComponents) == null || tComponents.getCommonDivider() > 64L || !aMaterial.contains(TD.Compounds.DECOMPOSABLE)) continue;
                ArrayListNoNulls<Recipe.RecipeMap> tRecipeMaps = new ArrayListNoNulls<Recipe.RecipeMap>();
                if (aMaterial.contains(TD.Processing.CENTRIFUGE)) {
                    tRecipeMaps.add(Recipe.RecipeMap.sCentrifugeRecipes);
                }
                if (aMaterial.contains(TD.Processing.ELECTROLYSER)) {
                    tRecipeMaps.add(Recipe.RecipeMap.sElectrolyzerRecipes);
                }
                if (tRecipeMaps.isEmpty()) continue;
                ArrayListNoNulls<ItemStack> tStackOutputs = new ArrayListNoNulls<ItemStack>();
                ArrayListNoNulls<FluidStack> tFluidOutputs = new ArrayListNoNulls<FluidStack>();
                long tAmount = 0L;
                for (OreDictMaterialStack tMaterial : tComponents.getUndividedComponents()) {
                    tAmount += tMaterial.mAmount;
                    if (!(tMaterial.mMaterial.mPlasmaPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.plasma(tMaterial.mAmount, false)) || tMaterial.mMaterial.mBoilingPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.gas(tMaterial.mAmount, false)) || tMaterial.mMaterial.mMeltingPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.liquid(tMaterial.mAmount, false))) && !tStackOutputs.add(OM.dust(tMaterial.mMaterial, tMaterial.mAmount))) continue;
                }
                if (tStackOutputs.size() <= 0 && tFluidOutputs.size() <= 0) continue;
                for (Recipe.RecipeMap tRecipeMap : tRecipeMaps) {
                    ItemStack aStack;
                    if (tRecipeMap.mInputItemsCount > 0 && (aStack = OP.dust.mat(aMaterial, tComponents.getCommonDivider())) != null) {
                        tRecipeMap.addRecipe1(true, false, false, false, false, tAmount * 16L / 420076800L, UT.Code.units(tAmount, 420076800L, 256L, true), aStack, CS.ZL_FLUIDSTACK, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FLUIDSTACK)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_ITEMSTACK)));
                    }
                    if (tRecipeMap.mInputFluidCount <= 0) continue;
                    FluidStack aFluid = aMaterial.liquid(tComponents.getCommonDivider() * 420076800L, true);
                    if (aFluid != null) {
                        tRecipeMap.addRecipe0(true, false, false, false, false, tAmount * 16L / 420076800L, UT.Code.units(tAmount, 420076800L, 256L, true), new FluidStack[]{aFluid}, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FLUIDSTACK)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_ITEMSTACK)));
                    }
                    if ((aFluid = aMaterial.gas(tComponents.getCommonDivider() * 420076800L, true)) == null) continue;
                    tRecipeMap.addRecipe0(true, false, false, false, false, tAmount * 16L / 420076800L, UT.Code.units(tAmount, 420076800L, 256L, true), new FluidStack[]{aFluid}, UT.Code.makeArray(new FluidStack[tRecipeMap.mOutputFluidCount], tFluidOutputs.toArray(CS.ZL_FLUIDSTACK)), UT.Code.makeArray(new ItemStack[tRecipeMap.mOutputItemsCount], tStackOutputs.toArray(CS.ZL_ITEMSTACK)));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }
}

