/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.b;

import gregapi.GT_API;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ICondition;
import gregapi.config.ConfigCategories;
import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.cover.covers.CoverTextureMulti;
import gregapi.cover.covers.CoverTextureSimple;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.OreDictNames;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.IOreDictListenerEvent;
import gregapi.oredict.IOreDictRecyclableListener;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialCondition;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Loader_OreProcessing
implements Runnable {
    static final long RECIPE_BITS = GT_ModHandler.RecipeBits.DEFAULT_NAC_NCC | GT_ModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL;

    @Override
    public void run() {
        CS.OUT.println("GT_Mod: Register Ore processing.");
        OP.plate.addListener(new OreProcessing_CoversMulti(new ICondition.Nor<OreDictMaterial>(MT.Wood), OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.casingMachine, OP.blockDust));
        OP.plateDouble.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineDouble, OP.blockPlate, OP.blockSolid, OP.blockIngot, OP.blockDust));
        OP.plateTriple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockPlate, OP.blockSolid, OP.blockIngot, OP.casingMachineDouble, OP.blockDust));
        OP.plateQuadruple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockIngot, OP.blockPlate, OP.blockSolid, OP.casingMachineQuadruple, OP.blockDust));
        OP.plateQuintuple.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineQuadruple, OP.blockIngot, OP.blockPlate, OP.blockSolid, OP.blockDust));
        OP.plateDense.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachineDense, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.blockDust));
        OP.plateCurved.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.casingMachine, OP.blockSolid, OP.blockPlate, OP.blockIngot, OP.blockDust));
        OP.plateGem.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.blockGem, OP.blockPlateGem, OP.blockDust));
        OP.foil.addListener(new OreProcessing_CoversMulti(ICondition.TRUE, OP.foil));
        OP.scrapGt.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dust.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustSmall.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustTiny.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustImpure.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustPure.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustRefined.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.chunk.addListener(new OreProcessing_Smelting(840153600L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.rubble.addListener(new OreProcessing_Smelting(840153600L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.pebbles.addListener(new OreProcessing_Smelting(840153600L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cluster.addListener(new OreProcessing_Smelting(840153600L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushed.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedTiny.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedPurified.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedPurifiedTiny.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedCentrifuged.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedCentrifugedTiny.addListener(new OreProcessing_Smelting(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.chunk.addListener(new OreProcessing_Maceration(OP.dustImpure, 2L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.rubble.addListener(new OreProcessing_Maceration(OP.dustImpure, 2L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.pebbles.addListener(new OreProcessing_Maceration(OP.dustImpure, 2L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cluster.addListener(new OreProcessing_Maceration(OP.dustImpure, 2L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushed.addListener(new OreProcessing_Maceration(OP.dustImpure, 1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedPurified.addListener(new OreProcessing_Maceration(OP.dustPure, 1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedPurifiedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedCentrifuged.addListener(new OreProcessing_Maceration(OP.dustTiny, 11L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedCentrifugedTiny.addListener(new OreProcessing_Maceration(OP.dustTiny, 1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.chemtube.addListener(new OreProcessing_GlassTube(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plantGtBerry.addListener(new OreProcessing_PlantSqueezing(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plantGtTwig.addListener(new OreProcessing_PlantSqueezing(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plantGtFiber.addListener(new OreProcessing_PlantSqueezing(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plantGtWart.addListener(new OreProcessing_PlantSqueezing(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plantGtBlossom.addListener(new OreProcessing_PlantSqueezing(-1L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushed.addListener(new OreProcessing_OreCrushed());
        OP.crushedTiny.addListener(new OreProcessing_OreCrushed_Tiny());
        OP.crushedPurified.addListener(new OreProcessing_OrePurified());
        OP.crushedPurifiedTiny.addListener(new OreProcessing_OrePurified_Tiny());
        OP.dustImpure.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sCentrifugeRecipes, 0L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustPure.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sCentrifugeRecipes, 1L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustRefined.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sCentrifugeRecipes, 2L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustImpure.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sElectrolyzerRecipes, 1L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustPure.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sElectrolyzerRecipes, 2L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustRefined.addListener(new OreProcessing_ImpureProcessing(Recipe.RecipeMap.sElectrolyzerRecipes, 3L, 46675200L, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dye.addListener(new OreProcessing_Dye());
        String tCategory = (Object)((Object)ConfigCategories.Recipes.gregtechrecipes) + ".";
        OP.stickLong.addListener(new OreProcessing_CraftFrom(1L, tCategory + "sticks2stickLong", new String[][]{{"ShS"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.ring.addListener(new OreProcessing_CraftFrom(1L, tCategory + "stick2ring", new String[][]{{"hS", " o"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.spring.addListener(new OreProcessing_CraftFrom(1L, tCategory + "stick2spring", new String[][]{{"zXh"}}, OP.stickLong, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.springSmall.addListener(new OreProcessing_CraftFrom(1L, tCategory + "wire2springSmall", new String[][]{{"oXh"}}, OP.wireGt01, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.springSmall.addListener(new OreProcessing_CraftFrom(1L, tCategory + "stick2springSmall", new String[][]{{"oSh"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.casingSmall.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plate2casingSmall", new String[][]{{"h P"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.rotor.addListener(new OreProcessing_CraftFrom(1L, tCategory + "rotor", new String[][]{{"YhY", "TXf", "YdY"}}, OP.ring, OP.plateCurved, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.ingotDouble.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2ingotDouble", new String[][]{{"h", "I", "I"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.ingotTriple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2ingotTriple", new String[][]{{"h", "I", "X"}}, OP.ingotDouble, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.ingotQuadruple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2ingotQuadruple", new String[][]{{"h", "I", "X"}}, OP.ingotTriple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.ingotQuintuple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2ingotQuintuple", new String[][]{{"h", "I", "X"}}, OP.ingotQuadruple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plate.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2plate", new String[][]{{"h", "X"}}, OP.ingotDouble, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateDouble.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2plateDouble", new String[][]{{"h", "X"}}, OP.ingotTriple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateTriple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2plateTriple", new String[][]{{"h", "X"}}, OP.ingotQuadruple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateQuadruple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2plateQuadruple", new String[][]{{"h", "X"}}, OP.ingotQuintuple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateDouble.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingots2plateDouble", new String[][]{{"h", "P", "P"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateTriple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plates2plateTriple", new String[][]{{"h", "P", "X"}}, OP.plateDouble, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateQuadruple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plates2plateQuadruple", new String[][]{{"h", "P", "X"}}, OP.plateTriple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateQuintuple.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plates2plateQuintuple", new String[][]{{"h", "P", "X"}}, OP.plateQuadruple, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.plateCurved.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plate2plateCurved", new String[][]{{"h", "P", "z"}}, null, null, null, null, null, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER), OreDictMaterialCondition.tag(TD.Processing.SMITHABLE))));
        OP.casingMachine.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plate, OP.stickLong, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.casingMachineDouble.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateDouble, OP.stickLong, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.casingMachineQuadruple.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateQuadruple, OP.stickLong, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.casingMachineDense.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"YXX", "XwX", "XXY"}}, OP.plateDense, OP.stickLong, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.blockGem.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XXX", "XXX", "XXX"}}, OP.gem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.blockDust.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XXX", "XXX", "XXX"}}, OP.dust, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.blockIngot.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XXX", "XXX", "XXX"}}, OP.ingot, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.blockPlate.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XXX", "XXX", "XXX"}}, OP.plate, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.blockPlateGem.addListener(new OreProcessing_CraftFrom(1L, null, new String[][]{{"XXX", "XXX", "XXX"}}, OP.plateGem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gem.addListener(new OreProcessing_CraftFrom(16L, null, new String[][]{{"c", "X"}}, OP.crateGtGem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dust.addListener(new OreProcessing_CraftFrom(16L, null, new String[][]{{"c", "X"}}, OP.crateGtDust, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.ingot.addListener(new OreProcessing_CraftFrom(16L, null, new String[][]{{"c", "X"}}, OP.crateGtIngot, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plate.addListener(new OreProcessing_CraftFrom(16L, null, new String[][]{{"c", "X"}}, OP.crateGtPlate, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(16L, null, new String[][]{{"c", "X"}}, OP.crateGtPlateGem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustDiv72.addListener(new OreProcessing_CraftFrom(18L, null, new String[][]{{"X "}}, OP.dustSmall, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustDiv72.addListener(new OreProcessing_CraftFrom(8L, null, new String[][]{{"X "}}, OP.dustTiny, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustTiny.addListener(new OreProcessing_CraftFrom(9L, null, new String[][]{{"X "}}, OP.dust, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dustSmall.addListener(new OreProcessing_CraftFrom(4L, null, new String[][]{{" X"}}, OP.dust, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.nugget.addListener(new OreProcessing_CraftFrom(9L, tCategory + "ingot2nuggets", new String[][]{{"X "}}, OP.ingot, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.chunkGt.addListener(new OreProcessing_CraftFrom(4L, tCategory + "ingot2chunks", new String[][]{{" X"}}, OP.ingot, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemFlawless, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemExquisite, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stickLong.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2stickLong", new String[][]{{"sf", " X"}}, OP.gemLegendary, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(1L, tCategory + "ingot2stick", new String[][]{{"f ", " I"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(2L, tCategory + "stickLong2stick", new String[][]{{"s ", " X"}}, OP.stickLong, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemFlawless, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemExquisite, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.stick.addListener(new OreProcessing_CraftFrom(8L, tCategory + "gem2stick", new String[][]{{"s ", "fX"}}, OP.gemLegendary, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.bolt.addListener(new OreProcessing_CraftFrom(2L, tCategory + "stick2bolt", new String[][]{{"s ", " S"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.screw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "bolt2screw", new String[][]{{"fX", "X "}}, OP.bolt, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.round.addListener(new OreProcessing_CraftFrom(1L, tCategory + "chunk2round", new String[][]{{"f ", " X"}}, OP.chunkGt, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.wireFine.addListener(new OreProcessing_CraftFrom(1L, tCategory + "foil2wireFine", new String[][]{{"Xx"}}, OP.foil, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.wireGt01.addListener(new OreProcessing_CraftFrom(1L, tCategory + "plate2wire", new String[][]{{"Px"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.foil.addListener(new OreProcessing_CraftFrom(2L, tCategory + "plate2foil", new String[][]{{"hPz"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "plate2plateTiny", new String[][]{{"s ", " P"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "plate2plateTiny", new String[][]{{"s ", " C"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(2L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemChipped, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(4L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemFlawed, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGemTiny.addListener(new OreProcessing_CraftFrom(8L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gem, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(1L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemFlawless, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(3L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemExquisite, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(7L, tCategory + "gem2plateGem", new String[][]{{"s ", " X"}}, OP.gemLegendary, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.plateGem.addListener(new OreProcessing_CraftFrom(3L, tCategory + "boule2plateGem", new String[][]{{"s ", " X"}}, OP.boule, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.arrowGtWood.addListener(new OreProcessing_CraftFrom(1L, tCategory + "arrowsWooden", new String[][]{{"  X", " W ", "V  "}}, OP.toolHeadArrow, null, null, (Object)OreDictNames.craftingFeather, OP.stick.dat(MT.Wood), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.arrowGtWood.addListener(new OreProcessing_CraftFrom(1L, tCategory + "arrowsWooden", new String[][]{{"  X", "VW ", "VV "}}, OP.toolHeadArrow, null, null, OP.plateTiny.dat(MT.Plastic), OP.stick.dat(MT.Wood), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.arrowGtPlastic.addListener(new OreProcessing_CraftFrom(1L, tCategory + "arrowsPlastic", new String[][]{{"  X", " W ", "V  "}}, OP.toolHeadArrow, null, null, (Object)OreDictNames.craftingFeather, OP.stick.dat(MT.Plastic), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.arrowGtPlastic.addListener(new OreProcessing_CraftFrom(1L, tCategory + "arrowsPlastic", new String[][]{{"  X", "VW ", "VV "}}, OP.toolHeadArrow, null, null, OP.plateTiny.dat(MT.Plastic), OP.stick.dat(MT.Plastic), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.minecartWheels.addListener(new OreProcessing_CraftFrom(1L, tCategory + "minecartWheels", new String[][]{{" h ", "XSX", " w "}}, OP.ring, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadBuzzSaw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "toolHeadBuzzSaw", new String[][]{{"wPh", "P P", "fPx"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.toolHeadBuzzSaw.addListener(new OreProcessing_CraftFrom(1L, tCategory + "toolHeadBuzzSaw", new String[][]{{"wCh", "C C", "fCx"}}, null, null, null, null, null, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.gem.addListener(new OreProcessing_Shapeless(9L, null, new Object[]{OP.blockGem}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dust.addListener(new OreProcessing_Shapeless(9L, null, new Object[]{OP.blockDust}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.ingot.addListener(new OreProcessing_Shapeless(9L, null, new Object[]{OP.blockIngot}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plate.addListener(new OreProcessing_Shapeless(9L, null, new Object[]{OP.blockPlate}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plateGem.addListener(new OreProcessing_Shapeless(9L, null, new Object[]{OP.blockPlateGem}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt02.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt01, OP.wireGt01}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt04.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt02, OP.wireGt02}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt08.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt04, OP.wireGt04}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt12.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt04, OP.wireGt04, OP.wireGt04}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt12.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt08, OP.wireGt04}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt16.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt08, OP.wireGt08}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt01.addListener(new OreProcessing_Shapeless(2L, null, new Object[]{OP.wireGt02}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt01.addListener(new OreProcessing_Shapeless(4L, null, new Object[]{OP.wireGt04}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt01.addListener(new OreProcessing_Shapeless(8L, null, new Object[]{OP.wireGt08}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt01.addListener(new OreProcessing_Shapeless(12L, null, new Object[]{OP.wireGt12}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.wireGt01.addListener(new OreProcessing_Shapeless(16L, null, new Object[]{OP.wireGt16}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cableGt01.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt01, OP.plate.dat(MT.Rubber)}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cableGt02.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt02, OP.plate.dat(MT.Rubber)}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cableGt04.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt04, OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber)}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cableGt08.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt08, OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber)}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.cableGt12.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.wireGt12, OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber), OP.plate.dat(MT.Rubber)}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.chemtube.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.dustTiny, OP.chemtube.mat(MT.Empty, 1L)}, ICondition.TRUE));
        OP.dustTiny.addListener(new OreProcessing_Shapeless(8L, null, new Object[]{"craftingToolMortar", OP.scrapGt, OP.scrapGt, OP.scrapGt, OP.scrapGt, OP.scrapGt, OP.scrapGt, OP.scrapGt, OP.scrapGt}, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.fullpulver(), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER))));
        OP.dustTiny.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{"craftingToolMortar", OP.scrapGt}, new ICondition.And<OreDictMaterial>(OreDictMaterialCondition.fullpulver(), OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER))));
        OP.dustTiny.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.chemtube}, OreDictMaterialCondition.meltmin(293L)));
        OP.dustTiny.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.dustDiv72, OP.dustDiv72, OP.dustDiv72, OP.dustDiv72, OP.dustDiv72, OP.dustDiv72, OP.dustDiv72, OP.dustDiv72}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dust.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny, OP.dustTiny}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.dust.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.dustSmall, OP.dustSmall, OP.dustSmall, OP.dustSmall}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.ingot.addListener(new OreProcessing_Shapeless(1L, tCategory + "nugget2ingot", new Object[]{OP.nugget, OP.nugget, OP.nugget, OP.nugget, OP.nugget, OP.nugget, OP.nugget, OP.nugget, OP.nugget}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.ingot.addListener(new OreProcessing_Shapeless(1L, tCategory + "chunk2ingot", new Object[]{OP.chunkGt, OP.chunkGt, OP.chunkGt, OP.chunkGt}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.crushed.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny, OP.crushedTiny}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedPurified.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny, OP.crushedPurifiedTiny}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.crushedCentrifuged.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny, OP.crushedCentrifugedTiny}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawUniversalSpade.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadShovel, "craftingToolFile", "craftingToolSaw"}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.toolHeadConstructionPickaxe.addListener(new OreProcessing_Shapeless(1L, null, new Object[]{OP.toolHeadRawPickaxe, "craftingToolFile", "craftingToolHardHammer"}, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER, TD.Compounds.COATED)));
        OP.nugget.addListener(new OreProcessing_Sharpening(OP.round, 1L, false, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.plateGem.addListener(new OreProcessing_Sharpening(OP.lens, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.ingot.addListener(new OreProcessing_Sharpening(OP.stick, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gemChipped.addListener(new OreProcessing_Sharpening(OP.toolHeadArrow, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawArrow.addListener(new OreProcessing_Sharpening(OP.toolHeadArrow, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawSaw.addListener(new OreProcessing_Sharpening(OP.toolHeadSaw, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawChisel.addListener(new OreProcessing_Sharpening(OP.toolHeadChisel, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawSword.addListener(new OreProcessing_Sharpening(OP.toolHeadSword, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawPickaxe.addListener(new OreProcessing_Sharpening(OP.toolHeadPickaxe, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawShovel.addListener(new OreProcessing_Sharpening(OP.toolHeadShovel, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawUniversalSpade.addListener(new OreProcessing_Sharpening(OP.toolHeadUniversalSpade, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawAxe.addListener(new OreProcessing_Sharpening(OP.toolHeadAxe, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawAxeDouble.addListener(new OreProcessing_Sharpening(OP.toolHeadAxeDouble, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawHoe.addListener(new OreProcessing_Sharpening(OP.toolHeadHoe, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawSense.addListener(new OreProcessing_Sharpening(OP.toolHeadSense, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.toolHeadRawPlow.addListener(new OreProcessing_Sharpening(OP.toolHeadPlow, 1L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gemLegendary.addListener(new OreProcessing_Crushing(OP.gemExquisite, 2L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gemExquisite.addListener(new OreProcessing_Crushing(OP.gemFlawless, 2L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gemFlawless.addListener(new OreProcessing_Crushing(OP.gem, 2L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gem.addListener(new OreProcessing_Crushing(OP.gemFlawed, 2L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OP.gemFlawed.addListener(new OreProcessing_Crushing(OP.gemChipped, 2L, true, OreDictMaterialCondition.tagnor(TD.Atomic.ANTIMATTER)));
        OreProcessing_Ore tProcessor = new OreProcessing_Ore();
        for (OreDictPrefix tPrefix : OreDictPrefix.VALUES) {
            if (!tPrefix.contains(TD.Prefix.ORE) || tPrefix == OP.oreBedrock || tPrefix == OP.orePoor || tPrefix == OP.oreSmall || tPrefix == OP.oreRich || tPrefix == OP.oreNormal) continue;
            tPrefix.addListener(tProcessor);
        }
        OreDictManager.INSTANCE.addListener(new RecyclingProcessing());
        if (CS.CODE_CLIENT) {
            OreDictManager.INSTANCE.addListener(new RecyclingProcessingCrucibleFakeRecipes());
        }
    }

    public static class OreProcessing_CraftFrom
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final String[][] mRecipes;
        private final String mCategoryName;
        private final OreDictPrefix mSpecialPrefix1;
        private final OreDictPrefix mSpecialPrefix2;
        private final OreDictPrefix mSpecialPrefix3;
        private final Object mSpecialObject1;
        private final Object mSpecialObject2;
        private final long mOutputAmount;

        public OreProcessing_CraftFrom(long aOutputAmount, String aCategoryName, String[][] aRecipes, OreDictPrefix aSpecialPrefix1, OreDictPrefix aSpecialPrefix2, OreDictPrefix aSpecialPrefix3, Object aSpecialObject1, Object aSpecialObject2, ICondition<OreDictMaterial> aCondition) {
            this.mSpecialPrefix1 = aSpecialPrefix1;
            this.mSpecialPrefix2 = aSpecialPrefix2;
            this.mSpecialPrefix3 = aSpecialPrefix3;
            this.mSpecialObject1 = aSpecialObject1;
            this.mSpecialObject2 = aSpecialObject2;
            this.mOutputAmount = aOutputAmount;
            this.mRecipes = aRecipes;
            this.mCondition = aCondition;
            this.mCategoryName = aCategoryName;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mNotAlreadyRegisteredName && this.mCondition.isTrue(aEvent.mMaterial) && (this.mCategoryName == null || CS.ConfigsGT.RECIPES.get((Object)this.mCategoryName, aEvent.mMaterial.mNameInternal, true))) {
                for (int i = 0; i < this.mRecipes.length; ++i) {
                    if (this.mRecipes[i] == null || this.mRecipes[i].length <= 0) continue;
                    if (this.mRecipes[i].length == 1) {
                        GT_ModHandler.addCraftingRecipe(UT.Stacks.amount(this.mOutputAmount, aEvent.mStack), RECIPE_BITS, new Object[]{this.mRecipes[i][0], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), (this.mSpecialPrefix1 == null ? OP.plate : this.mSpecialPrefix1).dat(aEvent.mMaterial), Character.valueOf('Y'), (this.mSpecialPrefix2 == null ? OP.plate : this.mSpecialPrefix2).dat(aEvent.mMaterial), Character.valueOf('Z'), (this.mSpecialPrefix3 == null ? OP.plate : this.mSpecialPrefix3).dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                        continue;
                    }
                    if (this.mRecipes[i].length == 2) {
                        GT_ModHandler.addCraftingRecipe(UT.Stacks.amount(this.mOutputAmount, aEvent.mStack), RECIPE_BITS, new Object[]{this.mRecipes[i][0], this.mRecipes[i][1], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), (this.mSpecialPrefix1 == null ? OP.plate : this.mSpecialPrefix1).dat(aEvent.mMaterial), Character.valueOf('Y'), (this.mSpecialPrefix2 == null ? OP.plate : this.mSpecialPrefix2).dat(aEvent.mMaterial), Character.valueOf('Z'), (this.mSpecialPrefix3 == null ? OP.plate : this.mSpecialPrefix3).dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                        continue;
                    }
                    GT_ModHandler.addCraftingRecipe(UT.Stacks.amount(this.mOutputAmount, aEvent.mStack), RECIPE_BITS, new Object[]{this.mRecipes[i][0], this.mRecipes[i][1], this.mRecipes[i][2], Character.valueOf('G'), OP.gem.dat(aEvent.mMaterial), Character.valueOf('I'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.ingot.dat(aEvent.mMaterial), Character.valueOf('P'), aEvent.mMaterial == MT.Wood ? OP.plank.dat(aEvent.mMaterial) : OP.plate.dat(aEvent.mMaterial), Character.valueOf('C'), OP.plateGem.dat(aEvent.mMaterial), Character.valueOf('S'), OP.stick.dat(aEvent.mMaterial), Character.valueOf('T'), OP.screw.dat(aEvent.mMaterial), Character.valueOf('N'), OP.nugget.dat(aEvent.mMaterial), Character.valueOf('V'), this.mSpecialObject1 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject1, Character.valueOf('W'), this.mSpecialObject2 == null ? OP.plate.dat(aEvent.mMaterial) : this.mSpecialObject2, Character.valueOf('X'), (this.mSpecialPrefix1 == null ? OP.plate : this.mSpecialPrefix1).dat(aEvent.mMaterial), Character.valueOf('Y'), (this.mSpecialPrefix2 == null ? OP.plate : this.mSpecialPrefix2).dat(aEvent.mMaterial), Character.valueOf('Z'), (this.mSpecialPrefix3 == null ? OP.plate : this.mSpecialPrefix3).dat(aEvent.mMaterial), Character.valueOf('H'), OP.stick.dat(aEvent.mMaterial.mHandleMaterial)});
                }
            }
        }
    }

    public static class OreProcessing_Shapeless
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final String mCategoryName;
        private final Object[] mRecipe;
        private final long mOutputAmount;

        public OreProcessing_Shapeless(long aOutputAmount, String aCategoryName, Object[] aRecipe, ICondition<OreDictMaterial> aCondition) {
            this.mOutputAmount = aOutputAmount;
            this.mRecipe = aRecipe;
            this.mCondition = aCondition;
            this.mCategoryName = aCategoryName;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mNotAlreadyRegisteredName && this.mCondition.isTrue(aEvent.mMaterial) && (this.mCategoryName == null || CS.ConfigsGT.RECIPES.get((Object)this.mCategoryName, aEvent.mMaterial.mNameInternal, true))) {
                Object[] tRecipe = new Object[this.mRecipe.length];
                for (int i = 0; i < tRecipe.length; ++i) {
                    tRecipe[i] = this.mRecipe[i] instanceof OreDictPrefix ? ((OreDictPrefix)this.mRecipe[i]).dat(aEvent.mMaterial) : this.mRecipe[i];
                }
                GT_ModHandler.addShapelessCraftingRecipe(UT.Stacks.amount(this.mOutputAmount, aEvent.mStack), RECIPE_BITS, tRecipe);
            }
        }
    }

    public static class OreProcessing_Smelting
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final long mTargetAmount;

        public OreProcessing_Smelting(long aTargetAmount, ICondition<OreDictMaterial> aCondition) {
            this.mTargetAmount = aTargetAmount;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                if (aEvent.mMaterial.contains(TD.Processing.FURNACE)) {
                    GT_ModHandler.addSmeltingRecipe(aEvent.mStack, OM.ingot(aEvent.mMaterial.mTargetSmelting.mMaterial.mTargetSolidifying.mMaterial, UT.Code.units(UT.Code.units(aEvent.mMaterial.mTargetSmelting.mAmount, 420076800L, aEvent.mMaterial.mTargetSmelting.mMaterial.mTargetSolidifying.mAmount, false), 420076800L, this.mTargetAmount < 0L ? aEvent.mPrefix.mAmount : this.mTargetAmount, false)));
                } else {
                    GT_ModHandler.removeFurnaceSmelting(aEvent.mStack);
                }
            }
        }
    }

    public static class OreProcessing_Decomposition
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final Recipe.RecipeMap mTargetRecipeMap;

        public OreProcessing_Decomposition(Recipe.RecipeMap aTargetRecipeMap, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mTargetRecipeMap = aTargetRecipeMap;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            IOreDictConfigurationComponent tComponents;
            if (this.mCondition.isTrue(aEvent.mMaterial) && (tComponents = aEvent.mMaterial.mComponents) != null && tComponents.getCommonDivider() <= 64L) {
                ArrayListNoNulls<ItemStack> tStackOutputs = new ArrayListNoNulls<ItemStack>();
                ArrayListNoNulls<FluidStack> tFluidOutputs = new ArrayListNoNulls<FluidStack>();
                long tAmount = 0L;
                for (OreDictMaterialStack tMaterial : tComponents.getUndividedComponents()) {
                    tAmount += tMaterial.mAmount;
                    if (!(tMaterial.mMaterial.mPlasmaPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.plasma(tMaterial.mAmount, false)) || tMaterial.mMaterial.mBoilingPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.gas(tMaterial.mAmount, false)) || tMaterial.mMaterial.mMeltingPoint <= 293L && tFluidOutputs.add(tMaterial.mMaterial.liquid(tMaterial.mAmount, false))) && !tStackOutputs.add(OM.dust(tMaterial.mMaterial, tMaterial.mAmount))) continue;
                }
                while (tStackOutputs.size() > this.mTargetRecipeMap.mOutputItemsCount) {
                    tStackOutputs.remove(tStackOutputs.size() - 1);
                }
                while (tFluidOutputs.size() > this.mTargetRecipeMap.mOutputFluidCount) {
                    tFluidOutputs.remove(tFluidOutputs.size() - 1);
                }
                if (tStackOutputs.size() > 0 || tFluidOutputs.size() > 0) {
                    this.mTargetRecipeMap.addRecipe(true, new ItemStack[]{UT.Stacks.amount(tComponents.getCommonDivider(), aEvent.mStack)}, tStackOutputs.toArray(CS.ZL_ITEMSTACK), CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, tFluidOutputs.toArray(CS.ZL_FLUIDSTACK), UT.Code.units(tAmount, 420076800L, 256L, true), tAmount * 16L / 420076800L, 0L);
                }
            }
        }
    }

    public static class OreProcessing_Welding
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final OreDictPrefix mTargetPrefix;
        private final long mInputAmount;
        private final long mOutputAmount;

        public OreProcessing_Welding(OreDictPrefix aTargetPrefix, long aInputAmount, long aOutputAmount, ICondition<OreDictMaterial> aCondition) {
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
            this.mInputAmount = aInputAmount;
            this.mOutputAmount = aOutputAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            ItemStack tStack;
            if (this.mCondition.isTrue(aEvent.mMaterial) && (tStack = this.mTargetPrefix.mat(aEvent.mMaterial, this.mOutputAmount)) != null) {
                Recipe.RecipeMap.sWelderRecipes.addRecipe2(true, 16L, UT.Code.units(aEvent.mPrefix.mAmount * this.mInputAmount, 420076800L, 64 + 64 * aEvent.mMaterial.mToolQuality, true), IL.Circuit_Selector.getWithMeta(0L, this.mInputAmount, new Object[0]), UT.Stacks.amount(this.mInputAmount, aEvent.mStack), tStack);
            }
        }
    }

    public static class OreProcessing_PlantSqueezing
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final long mOutputMaterialAmount;

        public OreProcessing_PlantSqueezing(long aOutputMaterialAmount, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mOutputMaterialAmount = aOutputMaterialAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                FluidStack tFluid = aEvent.mMaterial.fluid(293L, this.mOutputMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mOutputMaterialAmount, false);
                ItemStack tStack = OM.dust(aEvent.mMaterial, this.mOutputMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mOutputMaterialAmount);
                if (tFluid == null || tFluid.amount <= 0) {
                    tFluid = null;
                }
                if (tStack != null || tFluid != null) {
                    Recipe.RecipeMap.sSqueezerRecipes.addRecipe1(true, 16L, UT.Code.units(aEvent.mPrefix.mAmount, 420076800L, 256 + 256 * aEvent.mMaterial.mToolQuality, true), aEvent.mStack, CS.NF, tFluid, new ItemStack[]{tFluid == null ? tStack : null});
                }
            }
        }
    }

    public static class OreProcessing_GlassTube
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final long mMaterialAmount;

        public OreProcessing_GlassTube(long aOutputMaterialAmount, ICondition<OreDictMaterial> aCondition) {
            this.mCondition = aCondition;
            this.mMaterialAmount = aOutputMaterialAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial) && aEvent.mMaterial != MT.Empty) {
                FluidStack tFluid = aEvent.mMaterial.fluid(293L, this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount, false);
                ItemStack tStack = OM.dust(aEvent.mMaterial, this.mMaterialAmount < 0L ? aEvent.mPrefix.mAmount : this.mMaterialAmount);
                if (tFluid == null || tFluid.amount <= 0) {
                    tFluid = null;
                }
                if (tStack != null || tFluid != null) {
                    Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, 16L, aEvent.mStack, CS.NF, tStack == null ? tFluid : CS.NF, aEvent.mPrefix.mat(MT.Empty, 1L), tStack);
                    Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, tStack, aEvent.mPrefix.mat(MT.Empty, 1L), tStack == null ? tFluid : CS.NF, CS.NF, aEvent.mStack);
                }
            }
        }
    }

    public static class OreProcessing_Maceration
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final OreDictPrefix mTargetPrefix;
        private final long mAmount;

        public OreProcessing_Maceration(OreDictPrefix aTargetPrefix, long aAmount, ICondition<OreDictMaterial> aCondition) {
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
            this.mAmount = aAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                GT_ModHandler.addPulverisationRecipe(aEvent.mStack, this.mTargetPrefix.mat(aEvent.mMaterial, this.mAmount));
            }
        }
    }

    public static class OreProcessing_Crushing
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final OreDictPrefix mTargetPrefix;
        private final boolean mAllowCrafting;
        private final long mAmount;

        public OreProcessing_Crushing(OreDictPrefix aTargetPrefix, long aAmount, boolean aAllowCrafting, ICondition<OreDictMaterial> aCondition) {
            this.mAllowCrafting = aAllowCrafting;
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
            this.mAmount = aAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            ItemStack tStack;
            if (this.mCondition.isTrue(aEvent.mMaterial) && (tStack = this.mTargetPrefix.mat(aEvent.mMaterial, this.mAmount)) != null) {
                if (this.mAllowCrafting && aEvent.mNotAlreadyRegisteredName) {
                    GT_ModHandler.addShapelessCraftingRecipe(tStack, RECIPE_BITS, new Object[]{aEvent.mOreDictName, "craftingToolHardHammer"});
                }
                Recipe.RecipeMap.sCrusherRecipes.addRecipe1(true, 16L, UT.Code.units(aEvent.mPrefix.mAmount, 420076800L, 256 + 256 * aEvent.mMaterial.mToolQuality, true), aEvent.mStack, tStack, OM.pulverize(aEvent.mMaterial, aEvent.mPrefix.mAmount - this.mTargetPrefix.mAmount * this.mAmount));
            }
        }
    }

    public static class OreProcessing_Sharpening
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final OreDictPrefix mTargetPrefix;
        private final boolean mAllowCrafting;
        private final long mAmount;

        public OreProcessing_Sharpening(OreDictPrefix aTargetPrefix, long aAmount, boolean aAllowCrafting, ICondition<OreDictMaterial> aCondition) {
            this.mAllowCrafting = aAllowCrafting;
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
            this.mAmount = aAmount;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            ItemStack tStack;
            if (this.mCondition.isTrue(aEvent.mMaterial) && (tStack = this.mTargetPrefix.mat(aEvent.mMaterial, this.mAmount)) != null) {
                if (this.mAllowCrafting && aEvent.mNotAlreadyRegisteredName) {
                    GT_ModHandler.addShapelessCraftingRecipe(tStack, RECIPE_BITS, new Object[]{aEvent.mOreDictName, "craftingToolFile"});
                }
                Recipe.RecipeMap.sSharpeningRecipes.addRecipe1(true, 16L, UT.Code.units(aEvent.mPrefix.mAmount, 420076800L, 256 + 256 * aEvent.mMaterial.mToolQuality, true), new long[]{10000L, 9000L}, aEvent.mStack, tStack, OM.pulverize(aEvent.mMaterial, aEvent.mPrefix.mAmount - this.mTargetPrefix.mAmount * this.mAmount));
            }
        }
    }

    public static class OreProcessing_Ore
    implements IOreDictListenerEvent {
        private ArrayList<OreDictMaterial> mAlreadyListedOres = new ArrayListNoNulls<OreDictMaterial>(1000);

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            boolean tIsRich;
            boolean bl = tIsRich = aEvent.mPrefix == OP.oreNether || aEvent.mPrefix == OP.oreEnd || aEvent.mPrefix == OP.oreDense;
            if (aEvent.mMaterial == MT.Oilsands) {
                Recipe.RecipeMap.sCentrifugeRecipes.addRecipe1(true, 16L, tIsRich ? 512L : 128L, tIsRich ? 10000L : 5000L, aEvent.mStack, CS.NF, MT.Oil.liquid(tIsRich ? 420076800L : 210038400L, false), UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 0L));
            } else {
                this.registerStandardOreRecipes(aEvent.mPrefix, aEvent.mMaterial, aEvent.mStack, aEvent.mMaterial.mOreProcessingMultiplier * (tIsRich ? 2 : 1));
            }
        }

        private boolean registerStandardOreRecipes(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aOreStack, int aMultiplier) {
            if (aOreStack == null || aMaterial == null) {
                return false;
            }
            if (GT_API.sCompatIC2 != null) {
                GT_API.sCompatIC2.valuable(UT.Stacks.block(aOreStack), UT.Stacks.meta(aOreStack), 3);
            }
            OreDictMaterial tPrimaryByMaterial = null;
            OreDictMaterial tSecondaryByMaterial = null;
            OreDictMaterial tTertiaryByMaterial = null;
            aOreStack = UT.Stacks.amount(1L, aOreStack);
            ItemStack tGem = OP.gem.mat(aMaterial, 1L);
            ItemStack tSmeltInto = OM.ingot(aMaterial.mTargetSmelting);
            ItemStack tTiny = OM.dustOrIngot(aMaterial, 46675200L);
            ItemStack tSmall = OM.dustOrIngot(aMaterial, 105019200L);
            ItemStack tDust = OM.get(OP.dust, aMaterial, tGem, 1L);
            ItemStack tCleaned = OM.get(OP.crushedPurified, aMaterial, tDust, 1L);
            ItemStack tCrushed = OP.crushed.mat(aMaterial, UT.Code.bindStack(aMaterial.mOreMultiplier * aMultiplier));
            ItemStack tPrimaryByProduct = null;
            ItemStack tPrimaryByProductSmall = null;
            ItemStack tPrimaryByProductTiny = null;
            ItemStack tSecondaryByProduct = null;
            ItemStack tSecondaryByProductSmall = null;
            ItemStack tSecondaryByProductTiny = null;
            ItemStack tTertiaryByProduct = null;
            ItemStack tTertiaryByProductSmall = null;
            ItemStack tTertiaryByProductTiny = null;
            if (tSmeltInto == null) {
                tSmeltInto = OM.gem(aMaterial.mTargetSmelting);
            }
            if (tCrushed == null) {
                tCrushed = OM.get(OP.dustImpure, aMaterial, UT.Stacks.amount(UT.Code.bindStack(aMaterial.mOreMultiplier * aMultiplier), tCleaned, tDust, tGem), aMaterial.mOreMultiplier * aMultiplier);
            }
            ArrayListNoNulls<ItemStack> tByProductStacks = new ArrayListNoNulls<ItemStack>();
            for (OreDictMaterial tMat : aMaterial.mByProducts) {
                ItemStack tByProduct = OM.dustOrIngot(tMat, 420076800L);
                if (tByProduct != null) {
                    ((ArrayList)tByProductStacks).add(tByProduct);
                }
                if (tPrimaryByProduct == null) {
                    tPrimaryByMaterial = tMat;
                    tPrimaryByProduct = OM.dustOrIngot(tMat, 420076800L);
                    tPrimaryByProductSmall = OM.dustOrIngot(tMat, 105019200L);
                    tPrimaryByProductTiny = OM.dustOrIngot(tMat, 46675200L);
                }
                if (tSecondaryByProduct == null || tSecondaryByMaterial == tPrimaryByMaterial) {
                    tSecondaryByMaterial = tMat;
                    tSecondaryByProduct = OM.dustOrIngot(tMat, 420076800L);
                    tSecondaryByProductSmall = OM.dustOrIngot(tMat, 105019200L);
                    tSecondaryByProductTiny = OM.dustOrIngot(tMat, 46675200L);
                }
                if (tTertiaryByProduct != null && tTertiaryByMaterial != tPrimaryByMaterial && tTertiaryByMaterial != tSecondaryByMaterial) continue;
                tTertiaryByMaterial = tMat;
                tTertiaryByProduct = OM.dustOrIngot(tMat, 420076800L);
                tTertiaryByProductSmall = OM.dustOrIngot(tMat, 105019200L);
                tTertiaryByProductTiny = OM.dustOrIngot(tMat, 46675200L);
            }
            if (!tByProductStacks.isEmpty() && !this.mAlreadyListedOres.contains(aMaterial)) {
                this.mAlreadyListedOres.add(aMaterial);
                Recipe.RecipeMap.sByProductList.addFakeRecipe(false, new ItemStack[]{OM.get(OP.ore, aMaterial, aOreStack, 1L)}, tByProductStacks.toArray(CS.ZL_ITEMSTACK), null, null, null, null, 0L, 0L, 0L);
            }
            if (tPrimaryByMaterial == null) {
                tPrimaryByMaterial = aMaterial;
            }
            if (tPrimaryByProduct == null) {
                tPrimaryByProduct = tDust;
            }
            if (tPrimaryByProductSmall == null) {
                tPrimaryByProductSmall = tSmall;
            }
            if (tPrimaryByProductTiny == null) {
                tPrimaryByProductTiny = tTiny;
            }
            if (tSecondaryByMaterial == null) {
                tSecondaryByMaterial = tPrimaryByMaterial;
            }
            if (tSecondaryByProduct == null) {
                tSecondaryByProduct = tPrimaryByProduct;
            }
            if (tSecondaryByProductSmall == null) {
                tSecondaryByProductSmall = tPrimaryByProductSmall;
            }
            if (tSecondaryByProductTiny == null) {
                tSecondaryByProductTiny = tPrimaryByProductTiny;
            }
            if (tTertiaryByMaterial == null) {
                tTertiaryByMaterial = tSecondaryByMaterial;
            }
            if (tTertiaryByProduct == null) {
                tTertiaryByProduct = tSecondaryByProduct;
            }
            if (tTertiaryByProductSmall == null) {
                tTertiaryByProductSmall = tSecondaryByProductSmall;
            }
            if (tTertiaryByProductTiny == null) {
                tTertiaryByProductTiny = tSecondaryByProductTiny;
            }
            if (tSmeltInto != null) {
                if (aMaterial.contains(TD.Processing.FURNACE)) {
                    GT_ModHandler.addSmeltingRecipe(aOreStack, tSmeltInto);
                } else {
                    GT_ModHandler.removeFurnaceSmelting(aOreStack);
                }
            }
            if (tCrushed != null && aPrefix.contains(TD.Prefix.DUST_ORE) && tCleaned != null) {
                Recipe.RecipeMap.sSifterRecipes.addRecipe1(true, 16L, 256L, new long[]{10000L, 1500L, 1000L, 500L}, aOreStack, UT.Stacks.amount(tCrushed.field_77994_a * 2, tCleaned), UT.Stacks.amount(tCrushed.field_77994_a, tPrimaryByProductTiny), UT.Stacks.amount(tCrushed.field_77994_a, tSecondaryByProductTiny), UT.Stacks.amount(tCrushed.field_77994_a, tTertiaryByProductTiny));
            }
            return true;
        }
    }

    public static class OreProcessing_Dye
    implements IOreDictListenerEvent {
        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            int aIndex;
            for (aIndex = 0; aIndex < 16 && !CS.DYE_OREDICTS[aIndex].equals(aEvent.mOreDictName); ++aIndex) {
            }
            if (aIndex < 16 && UT.Stacks.container(aEvent.mStack, true) == null) {
                GT_ModHandler.addAlloySmelterRecipe(OM.get(OP.dust, MT.Glass, 8L), aEvent.mStack, UT.Stacks.make((Block)Blocks.field_150399_cn, 8L, (long)(15 - aIndex)), 200, 8, false);
                GT_ModHandler.addAlloySmelterRecipe(UT.Stacks.make(Blocks.field_150359_w, 8L, 32767L), aEvent.mStack, UT.Stacks.make((Block)Blocks.field_150399_cn, 8L, (long)(15 - aIndex)), 200, 8, false);
            }
        }
    }

    public static class OreProcessing_OrePurified_Tiny
    implements IOreDictListenerEvent {
        public static final long[] MAGNET_CHANCES = new long[]{10000L, 5000L, 5000L, 5000L, 5000L, 5000L};

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            ItemStack tGem;
            if (aEvent.mMaterial.contains(TD.Atomic.ANTIMATTER)) {
                return;
            }
            GT_ModHandler.addThermalCentrifugeRecipe(UT.Stacks.amount(9L, aEvent.mStack), (int)Math.min(5000L, Math.abs(aEvent.mMaterial.getMass() * 20L)), OM.get(OP.crushedCentrifuged, aEvent.mMaterial, OP.dust.mat(aEvent.mMaterial, 1L), 1L), (aEvent.mPrefix == OP.crushed || aEvent.mPrefix == OP.crushedPurified ? OP.crushedCentrifugedTiny : OP.dustTiny).mat(UT.Code.selectInList(1L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 1L));
            ArrayListNoNulls<OreDictMaterial> tMagnetList = new ArrayListNoNulls<OreDictMaterial>();
            if (aEvent.mMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) {
                for (OreDictMaterial tMaterial : aEvent.mMaterial.mByProducts) {
                    if (tMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) continue;
                    tMagnetList.add(tMaterial);
                }
            } else {
                for (OreDictMaterial tMaterial : aEvent.mMaterial.mByProducts) {
                    if (!tMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) continue;
                    tMagnetList.add(tMaterial);
                }
            }
            if (!tMagnetList.isEmpty()) {
                Recipe.RecipeMap.sMagneticSeparatorRecipes.addRecipe1(true, 16L, 256L, MAGNET_CHANCES, UT.Stacks.amount(9L, aEvent.mStack), OP.crushedCentrifuged.mat(aEvent.mMaterial, 1L), OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(0), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(0), 2L)), tMagnetList.size() <= 1 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(1), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(1), 2L)), tMagnetList.size() <= 2 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(2), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(2), 2L)), tMagnetList.size() <= 3 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(3), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(3), 2L)), tMagnetList.size() <= 4 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(4), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(4), 2L)), tMagnetList.size() <= 5 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(5), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(5), 2L)));
            }
            if ((tGem = OP.gem.mat(aEvent.mMaterial, 1L)) != null) {
                Recipe.RecipeMap.sSifterRecipes.addRecipe1(true, 16L, 128L, new long[]{1L, 100L, 400L, 1500L, 2000L, 4000L, 5000L}, UT.Stacks.amount(9L, aEvent.mStack), OM.get(OP.gemLegendary, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemExquisite, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemFlawless, aEvent.mMaterial, tGem, 1L), tGem, OM.get(OP.gemFlawed, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemChipped, aEvent.mMaterial, tGem, 1L), OM.get(OP.dust, aEvent.mMaterial, tGem, 1L));
            }
        }
    }

    public static class OreProcessing_OrePurified
    implements IOreDictListenerEvent {
        public static final long[] MAGNET_CHANCES = new long[]{10000L, 5000L, 5000L, 5000L, 5000L, 5000L};

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            ItemStack tGem;
            if (aEvent.mMaterial.contains(TD.Atomic.ANTIMATTER)) {
                return;
            }
            if (aEvent.mNotAlreadyRegisteredName) {
                GT_ModHandler.addShapelessCraftingRecipe(OP.gemFlawed.mat(aEvent.mMaterial, 1L), RECIPE_BITS, new Object[]{aEvent.mOreDictName});
            }
            GT_ModHandler.addThermalCentrifugeRecipe(aEvent.mStack, (int)Math.min(5000L, Math.abs(aEvent.mMaterial.getMass() * 20L)), OM.get(OP.crushedCentrifuged, aEvent.mMaterial, OP.dust.mat(aEvent.mMaterial, 1L), 1L), (aEvent.mPrefix == OP.crushed || aEvent.mPrefix == OP.crushedPurified ? OP.crushedCentrifugedTiny : OP.dustTiny).mat(UT.Code.selectInList(1L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 1L));
            ArrayListNoNulls<OreDictMaterial> tMagnetList = new ArrayListNoNulls<OreDictMaterial>();
            if (aEvent.mMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) {
                for (OreDictMaterial tMaterial : aEvent.mMaterial.mByProducts) {
                    if (tMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) continue;
                    tMagnetList.add(tMaterial);
                }
            } else {
                for (OreDictMaterial tMaterial : aEvent.mMaterial.mByProducts) {
                    if (!tMaterial.containsAny(TD.Properties.MAGNETIC_PASSIVE, TD.Properties.MAGNETIC_ACTIVE)) continue;
                    tMagnetList.add(tMaterial);
                }
            }
            if (!tMagnetList.isEmpty()) {
                Recipe.RecipeMap.sMagneticSeparatorRecipes.addRecipe1(true, 16L, 256L, MAGNET_CHANCES, aEvent.mStack, OP.crushedCentrifuged.mat(aEvent.mMaterial, 1L), OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(0), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(0), 2L)), tMagnetList.size() <= 1 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(1), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(1), 2L)), tMagnetList.size() <= 2 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(2), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(2), 2L)), tMagnetList.size() <= 3 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(3), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(3), 2L)), tMagnetList.size() <= 4 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(4), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(4), 2L)), tMagnetList.size() <= 5 ? null : OP.crushedCentrifugedTiny.mat((OreDictMaterial)tMagnetList.get(5), 2L, OP.dustTiny.mat((OreDictMaterial)tMagnetList.get(5), 2L)));
            }
            if ((tGem = OP.gem.mat(aEvent.mMaterial, 1L)) != null) {
                Recipe.RecipeMap.sSifterRecipes.addRecipe1(true, 16L, 128L, new long[]{1L, 100L, 400L, 1500L, 2000L, 4000L, 5000L}, aEvent.mStack, OM.get(OP.gemLegendary, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemExquisite, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemFlawless, aEvent.mMaterial, tGem, 1L), tGem, OM.get(OP.gemFlawed, aEvent.mMaterial, tGem, 1L), OM.get(OP.gemChipped, aEvent.mMaterial, tGem, 1L), OM.get(OP.dust, aEvent.mMaterial, tGem, 1L));
            }
        }
    }

    public static class OreProcessing_OreCrushed_Tiny
    implements IOreDictListenerEvent {
        public static final long[] SLUICE_CHANCES = new long[]{10000L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L};

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mMaterial.contains(TD.Atomic.ANTIMATTER)) {
                return;
            }
            if (CS.ENABLE_ADDING_IC2_OREWASHER_RECIPES) {
                GT_ModHandler.addOreWasherRecipe(UT.Stacks.amount(9L, aEvent.mStack), 1000L, OP.crushedPurified.mat(aEvent.mMaterial, 1L), OP.crushedPurifiedTiny.mat(UT.Code.selectInList(0L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 2L), OP.dust.mat(MT.Stone, 1L));
            }
            GT_ModHandler.addThermalCentrifugeRecipe(UT.Stacks.amount(9L, aEvent.mStack), Math.min(5000L, Math.abs(aEvent.mMaterial.getMass() * 20L)), OP.crushedCentrifuged.mat(aEvent.mMaterial, 1L), OP.crushedCentrifugedTiny.mat(UT.Code.selectInList(1L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 1L), OP.dust.mat(MT.Stone, 1L));
            OreDictMaterial[] tSluiceProducts = new OreDictMaterial[8];
            for (int i = 0; i < tSluiceProducts.length; ++i) {
                tSluiceProducts[i] = aEvent.mMaterial.mByProducts.isEmpty() ? aEvent.mMaterial : aEvent.mMaterial.mByProducts.get(i % aEvent.mMaterial.mByProducts.size());
            }
            Recipe.RecipeMap.sSluiceRecipes.addRecipe1(true, 16L, 128L, SLUICE_CHANCES, UT.Stacks.amount(9L, aEvent.mStack), UT.Fluids.water(1000L), UT.Fluids.make("sluicejuice", 1000L), OP.crushedPurified.mat(aEvent.mMaterial, 1L, OP.dust.mat(aEvent.mMaterial, 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[0], 1L, OP.dustTiny.mat(tSluiceProducts[0], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[1], 1L, OP.dustTiny.mat(tSluiceProducts[1], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[2], 1L, OP.dustTiny.mat(tSluiceProducts[2], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[3], 1L, OP.dustTiny.mat(tSluiceProducts[3], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[4], 1L, OP.dustTiny.mat(tSluiceProducts[4], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[5], 1L, OP.dustTiny.mat(tSluiceProducts[5], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[6], 1L, OP.dustTiny.mat(tSluiceProducts[6], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[7], 1L, OP.dustTiny.mat(tSluiceProducts[7], 1L)));
            Recipe.RecipeMap.sSluiceRecipes.addRecipe1(true, 16L, 128L, SLUICE_CHANCES, UT.Stacks.amount(9L, aEvent.mStack), UT.Fluids.distilledwater(1000L), UT.Fluids.make("sluicejuice", 1000L), OP.crushedPurified.mat(aEvent.mMaterial, 1L, OP.dust.mat(aEvent.mMaterial, 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[0], 1L, OP.dustTiny.mat(tSluiceProducts[0], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[1], 1L, OP.dustTiny.mat(tSluiceProducts[1], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[2], 1L, OP.dustTiny.mat(tSluiceProducts[2], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[3], 1L, OP.dustTiny.mat(tSluiceProducts[3], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[4], 1L, OP.dustTiny.mat(tSluiceProducts[4], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[5], 1L, OP.dustTiny.mat(tSluiceProducts[5], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[6], 1L, OP.dustTiny.mat(tSluiceProducts[6], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[7], 1L, OP.dustTiny.mat(tSluiceProducts[7], 1L)));
            ItemStack tByProductMercury = null;
            ItemStack tByproductSodiumPersulfate = null;
            for (OreDictMaterial tByProduct : aEvent.mMaterial.mByProducts) {
                if (tByProduct.contains(TD.Processing.WASHING_MERCURY)) {
                    tByProductMercury = OP.dust.mat(tByProduct, 1L);
                }
                if (!tByProduct.contains(TD.Processing.WASHING_SODIUMPERSULFATE)) continue;
                tByproductSodiumPersulfate = OP.dust.mat(tByProduct, 1L);
            }
            if (aEvent.mMaterial.contains(TD.Processing.WASHING_MERCURY)) {
                tByProductMercury = OP.dust.mat(aEvent.mMaterial, 1L);
            }
            if (aEvent.mMaterial.contains(TD.Processing.WASHING_SODIUMPERSULFATE)) {
                tByproductSodiumPersulfate = OP.dust.mat(aEvent.mMaterial, 1L);
            }
            if (tByProductMercury != null) {
                Recipe.RecipeMap.sBathRecipes.addRecipe1(true, 0L, 256L, UT.Stacks.amount(9L, aEvent.mStack), MT.Hg.liquid(420076800L, true), CS.NF, OP.crushedPurified.mat(aEvent.mMaterial, 1L), tByProductMercury);
            }
            if (tByproductSodiumPersulfate != null) {
                Recipe.RecipeMap.sBathRecipes.addRecipe2(true, 0L, 256L, UT.Stacks.amount(9L, aEvent.mStack), OM.dust(MT.SodiumPersulfate), UT.Fluids.water(1000L), CS.NF, OP.crushedPurified.mat(aEvent.mMaterial, 1L), tByproductSodiumPersulfate);
            }
        }
    }

    public static class OreProcessing_OreCrushed
    implements IOreDictListenerEvent {
        public static final long[] SLUICE_CHANCES = new long[]{10000L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L, 2500L};

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (aEvent.mMaterial.contains(TD.Atomic.ANTIMATTER)) {
                return;
            }
            if (aEvent.mNotAlreadyRegisteredName) {
                GT_ModHandler.addShapelessCraftingRecipe(OP.gemFlawed.mat(aEvent.mMaterial, 1L), RECIPE_BITS, new Object[]{aEvent.mOreDictName});
            }
            if (CS.ENABLE_ADDING_IC2_OREWASHER_RECIPES) {
                GT_ModHandler.addOreWasherRecipe(aEvent.mStack, 1000L, OP.crushedPurified.mat(aEvent.mMaterial, 1L), OP.crushedPurifiedTiny.mat(UT.Code.selectInList(0L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 2L), OP.dust.mat(MT.Stone, 1L));
            }
            GT_ModHandler.addThermalCentrifugeRecipe(aEvent.mStack, Math.min(5000L, Math.abs(aEvent.mMaterial.getMass() * 20L)), OP.crushedCentrifuged.mat(aEvent.mMaterial, 1L), OP.crushedCentrifugedTiny.mat(UT.Code.selectInList(1L, aEvent.mMaterial, aEvent.mMaterial.mByProducts), 1L), OP.dust.mat(MT.Stone, 1L));
            OreDictMaterial[] tSluiceProducts = new OreDictMaterial[8];
            for (int i = 0; i < tSluiceProducts.length; ++i) {
                tSluiceProducts[i] = aEvent.mMaterial.mByProducts.isEmpty() ? aEvent.mMaterial : aEvent.mMaterial.mByProducts.get(i % aEvent.mMaterial.mByProducts.size());
            }
            Recipe.RecipeMap.sSluiceRecipes.addRecipe1(true, 16L, 128L, SLUICE_CHANCES, aEvent.mStack, UT.Fluids.water(1000L), UT.Fluids.make("sluicejuice", 1000L), OP.crushedPurified.mat(aEvent.mMaterial, 1L, OP.dust.mat(aEvent.mMaterial, 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[0], 1L, OP.dustTiny.mat(tSluiceProducts[0], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[1], 1L, OP.dustTiny.mat(tSluiceProducts[1], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[2], 1L, OP.dustTiny.mat(tSluiceProducts[2], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[3], 1L, OP.dustTiny.mat(tSluiceProducts[3], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[4], 1L, OP.dustTiny.mat(tSluiceProducts[4], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[5], 1L, OP.dustTiny.mat(tSluiceProducts[5], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[6], 1L, OP.dustTiny.mat(tSluiceProducts[6], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[7], 1L, OP.dustTiny.mat(tSluiceProducts[7], 1L)));
            Recipe.RecipeMap.sSluiceRecipes.addRecipe1(true, 16L, 128L, SLUICE_CHANCES, aEvent.mStack, UT.Fluids.distilledwater(1000L), UT.Fluids.make("sluicejuice", 1000L), OP.crushedPurified.mat(aEvent.mMaterial, 1L, OP.dust.mat(aEvent.mMaterial, 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[0], 1L, OP.dustTiny.mat(tSluiceProducts[0], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[1], 1L, OP.dustTiny.mat(tSluiceProducts[1], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[2], 1L, OP.dustTiny.mat(tSluiceProducts[2], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[3], 1L, OP.dustTiny.mat(tSluiceProducts[3], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[4], 1L, OP.dustTiny.mat(tSluiceProducts[4], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[5], 1L, OP.dustTiny.mat(tSluiceProducts[5], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[6], 1L, OP.dustTiny.mat(tSluiceProducts[6], 1L)), OP.crushedPurifiedTiny.mat(tSluiceProducts[7], 1L, OP.dustTiny.mat(tSluiceProducts[7], 1L)));
            ItemStack tByProductMercury = null;
            ItemStack tByproductSodiumPersulfate = null;
            for (OreDictMaterial tByProduct : aEvent.mMaterial.mByProducts) {
                if (tByProduct.contains(TD.Processing.WASHING_MERCURY)) {
                    tByProductMercury = OP.dust.mat(tByProduct, 1L);
                }
                if (!tByProduct.contains(TD.Processing.WASHING_SODIUMPERSULFATE)) continue;
                tByproductSodiumPersulfate = OP.dust.mat(tByProduct, 1L);
            }
            if (aEvent.mMaterial.contains(TD.Processing.WASHING_MERCURY)) {
                tByProductMercury = OP.dust.mat(aEvent.mMaterial, 1L);
            }
            if (aEvent.mMaterial.contains(TD.Processing.WASHING_SODIUMPERSULFATE)) {
                tByproductSodiumPersulfate = OP.dust.mat(aEvent.mMaterial, 1L);
            }
            if (tByProductMercury != null) {
                Recipe.RecipeMap.sBathRecipes.addRecipe1(true, 0L, 256L, aEvent.mStack, MT.Hg.liquid(420076800L, true), CS.NF, OP.crushedPurified.mat(aEvent.mMaterial, 1L), tByProductMercury);
            }
            if (tByproductSodiumPersulfate != null) {
                Recipe.RecipeMap.sBathRecipes.addRecipe2(true, 0L, 256L, aEvent.mStack, OM.dust(MT.SodiumPersulfate), UT.Fluids.water(1000L), CS.NF, OP.crushedPurified.mat(aEvent.mMaterial, 1L), tByproductSodiumPersulfate);
            }
        }
    }

    public static class OreProcessing_ImpureProcessing
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        private final Recipe.RecipeMap mTargetRecipeMap;
        public final long mByProductAmount;
        public final long mTargetByproductIndex;

        public OreProcessing_ImpureProcessing(Recipe.RecipeMap aTargetRecipeMap, long aTargetByproductIndex, long aByProductAmount, ICondition<OreDictMaterial> aCondition) {
            this.mTargetByproductIndex = aTargetByproductIndex;
            this.mTargetRecipeMap = aTargetRecipeMap;
            this.mByProductAmount = aByProductAmount;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                OreDictMaterial tMaterial = UT.Code.selectInList(this.mTargetByproductIndex, aEvent.mMaterial, aEvent.mMaterial.mByProducts);
                FluidStack tFluid = tMaterial.fluid(293L, this.mByProductAmount, false);
                if (this.mTargetRecipeMap.mOutputFluidCount < 1) {
                    tFluid = null;
                }
                this.mTargetRecipeMap.addRecipe1(true, 16L, (long)(256 + 256 * aEvent.mMaterial.mToolQuality), aEvent.mStack, CS.NF, tFluid, OM.dust(aEvent.mMaterial, aEvent.mPrefix.mAmount), tFluid == null ? OM.dust(tMaterial, this.mByProductAmount) : null);
            }
        }
    }

    public static class RecyclingProcessingCrucibleFakeRecipes
    implements IOreDictRecyclableListener {
        @Override
        public void onRecycleableRegistration(IOreDictRecyclableListener.OreDictRecyclingContainer aEvent) {
            if (aEvent.mItemData == null || aEvent.mItemData.mPrefix != null && aEvent.mItemData.mPrefix.contains(TD.Prefix.INGOT_BASED)) {
                return;
            }
            ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
            for (OreDictMaterialStack tMaterial : aEvent.mItemData.getAllMaterialStacks()) {
                if (tMaterial.mMaterial.mTargetSmelting.mAmount <= 0L || !tMaterial.mMaterial.contains(TD.Processing.MELTING)) continue;
                OM.stack(UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetSmelting.mAmount, false), tMaterial.mMaterial.mTargetSmelting.mMaterial).addToList(tList);
            }
            if (tList.isEmpty()) {
                return;
            }
            ArrayListNoNulls<ItemStack> tIngots = new ArrayListNoNulls<ItemStack>();
            for (OreDictMaterialStack tMaterial : tList) {
                tIngots.add(OM.ingotOrDust(tMaterial.mMaterial, tMaterial.mAmount));
            }
            if (!tIngots.isEmpty()) {
                Recipe.RecipeMap.sCrucibleSmelting.addFakeRecipe(false, new ItemStack[]{aEvent.mStack}, tIngots.toArray(CS.ZL_ITEMSTACK), null, null, null, null, 0L, 0L, aEvent.mItemData.mMaterial.mMaterial.mMeltingPoint);
            }
        }
    }

    public static class RecyclingProcessing
    implements IOreDictRecyclableListener {
        @Override
        public void onRecycleableRegistration(IOreDictRecyclableListener.OreDictRecyclingContainer aEvent) {
            OreDictMaterialStack tMaterial2;
            if (aEvent.mItemData == null || UT.Stacks.container(aEvent.mStack, true) != null || aEvent.mItemData.mPrefix != null && aEvent.mItemData.mPrefix.containsAny(TD.Prefix.ORE_PROCESSING_DIRTY, TD.Prefix.ORE)) {
                return;
            }
            ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
            for (OreDictMaterialStack tMaterial2 : aEvent.mItemData.getAllMaterialStacks()) {
                if (tMaterial2.mMaterial.mTargetSmelting.mAmount <= 0L || !tMaterial2.mMaterial.contains(TD.Processing.MELTING) || tMaterial2.mMaterial.contains(TD.Processing.BLACKLISTED_SMELTER)) continue;
                OM.stack(UT.Code.units(tMaterial2.mAmount, 420076800L, tMaterial2.mMaterial.mTargetSmelting.mAmount, false), tMaterial2.mMaterial.mTargetSmelting.mMaterial).addToList(tList);
            }
            if (tList.isEmpty()) {
                return;
            }
            FluidStack tFluid = null;
            tMaterial2 = null;
            for (OreDictMaterialStack iMaterial : tList) {
                if (tFluid == null) {
                    tMaterial2 = iMaterial;
                    tFluid = iMaterial.mMaterial.liquid(iMaterial.mAmount, false);
                    continue;
                }
                if (iMaterial.mMaterial.liquid(iMaterial.mAmount, false) == null) continue;
                tFluid = null;
                break;
            }
            if (tFluid != null && tFluid.amount > 0 && UT.Fluids.temperature(tFluid) < 4618L && tMaterial2 != null) {
                Recipe.RecipeMap.sSmelterRecipes.addRecipe1(true, 16L, (long)Math.max(UT.Fluids.lava(tFluid) ? (double)Math.max(16, tFluid.amount * CS.EU_PER_LAVA / 16 + (tFluid.amount * CS.EU_PER_LAVA % 16 == 0 ? 0 : 1)) : 16.0, OM.weight(aEvent.mItemData.getAllMaterialStacks()) * (double)(Math.max(tMaterial2.mMaterial.mMeltingPoint, (long)tFluid.getFluid().getTemperature()) - 293L) / 1600.0), aEvent.mStack, CS.NF, tFluid, CS.ZL_ITEMSTACK);
            }
        }
    }

    public static class OreProcessing_CoversMulti
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        public final OreDictPrefix[] mTargetPrefixes;

        public OreProcessing_CoversMulti(ICondition<OreDictMaterial> aCondition, OreDictPrefix ... aTargetPrefixes) {
            this.mTargetPrefixes = aTargetPrefixes;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                ITexture[] tTextures = new ITexture[this.mTargetPrefixes.length];
                for (int i = 0; i < tTextures.length; ++i) {
                    tTextures[i] = BlockTextureDefault.get(aEvent.mMaterial, this.mTargetPrefixes[i], aEvent.mMaterial.contains(TD.Properties.GLOWING));
                }
                CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureMulti(tTextures));
            }
        }
    }

    public static class OreProcessing_CoversSimple
    implements IOreDictListenerEvent {
        private final ICondition<OreDictMaterial> mCondition;
        public final OreDictPrefix mTargetPrefix;

        public OreProcessing_CoversSimple(ICondition<OreDictMaterial> aCondition, OreDictPrefix aTargetPrefix) {
            this.mTargetPrefix = aTargetPrefix;
            this.mCondition = aCondition;
        }

        @Override
        public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
            if (this.mCondition.isTrue(aEvent.mMaterial)) {
                CoverRegistry.put(aEvent.mStack, (ICover)new CoverTextureSimple(BlockTextureDefault.get(aEvent.mMaterial, this.mTargetPrefix, aEvent.mMaterial.contains(TD.Properties.GLOWING))));
            }
        }
    }
}

