/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.machine;

import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregtech.items.behaviors.Behavior_Tool;
import gregtech.items.tools.GT_Tool;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GT_Tool_Screwdriver
extends GT_Tool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityCaveSpider.class.getName(), EntitySpider.class.getName(), "EntityTFHedgeSpider", "EntityTFKingSpider", "EntityTFSwarmSpider", "EntityTFTowerBroodling");

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(".") + 1)) ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 200;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 1.5f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return CS.SFX.IC_WRENCH;
    }

    @Override
    public boolean isMiningTool() {
        return false;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && tTool.equalsIgnoreCase("screwdriver") || aBlock.func_149688_o() == Material.field_151594_q;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return !aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadScrewdriver.mIconIndexItem) : Textures.ItemIcons.HANDLE_SCREWDRIVER;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return !aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Wood).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("screwdriver", CS.SFX.IC_WRENCH, 100L, !this.canBlock()));
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] has screwed with [KILLER] for the last time!";
    }
}

