/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.early;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import gregtech.items.behaviors.Behavior_Tool;
import gregtech.items.tools.GT_Tool;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_HardHammer
extends GT_Tool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");
    public static GT_Tool_HardHammer INSTANCE;

    public GT_Tool_HardHammer() {
        if (INSTANCE == null && this.getClass() == GT_Tool_HardHammer.class) {
            INSTANCE = this;
        }
    }

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(".") + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 50;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getSpeedMultiplier() {
        return 0.75f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return "random.anvil_use";
    }

    @Override
    public String getBreakingSound() {
        return "random.anvil_break";
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && (tTool.equalsIgnoreCase("hammer") || tTool.equalsIgnoreCase("pickaxe")) || aBlock.func_149688_o() == Material.field_151576_e || aBlock.func_149688_o() == Material.field_151592_s || aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x || Recipe.RecipeMap.sHammerRecipes.containsInput(UT.Stacks.make(aBlock, 1L, (long)aMetaData), null, CS.NI);
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        Recipe tRecipe;
        int rConversions = 0;
        if (aBlock.hasTileEntity((int)aMetaData) || null == (tRecipe = Recipe.RecipeMap.sHammerRecipes.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FLUIDSTACK, UT.Stacks.make(aBlock, 1L, (long)aMetaData)))) {
            ArrayListNoNulls<ItemStack> tDrops = new ArrayListNoNulls<ItemStack>();
            for (int i = 0; i < aDrops.size(); ++i) {
                tRecipe = Recipe.RecipeMap.sHammerRecipes.findRecipe(null, null, true, Integer.MAX_VALUE, null, CS.ZL_FLUIDSTACK, UT.Stacks.amount(1L, aDrops.get(i)));
                if (tRecipe == null) continue;
                byte tStackSize = (byte)aDrops.get((int)i).field_77994_a;
                rConversions += tStackSize;
                aDrops.remove(i--);
                if (tRecipe.mOutputs.length <= 0) continue;
                for (byte j = 0; j < tStackSize; j = (byte)(j + 1)) {
                    ItemStack[] tHammeringOutput = tRecipe.getOutputs(aPlayer == null ? null : aPlayer.field_70170_p.field_73012_v);
                    for (int k = 0; k < tHammeringOutput.length; ++k) {
                        if (tHammeringOutput[k] == null) continue;
                        tDrops.add(tHammeringOutput[k]);
                    }
                }
            }
            aDrops.addAll(tDrops);
        } else {
            aDrops.clear();
            ItemStack[] tHammeringOutput = tRecipe.getOutputs(aPlayer == null ? null : aPlayer.field_70170_p.field_73012_v);
            for (int k = 0; k < tHammeringOutput.length; ++k) {
                if (tHammeringOutput[k] == null) continue;
                aDrops.add(tHammeringOutput[k]);
            }
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadHammer.mIconIndexItem) : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Wood).mTextureSetsItems.get(OP.stick.mIconIndexItem);
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Wood).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("hammer", "random.anvil_use", 100L, true));
        aItem.addItemBehavior(aID, new Behavior_Tool("prospector", "random.anvil_use", 100L, true));
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] was squashed by [KILLER]";
    }
}

