/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.early;

import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import gregtech.items.tools.GT_Tool;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Axe
extends GT_Tool {
    private static boolean LOCK = true;

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 10;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 100;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && tTool.equalsIgnoreCase("axe") || aBlock.func_149688_o() == Material.field_151575_d || aBlock.func_149688_o() == Material.field_151570_A || aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableConversions, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rAmount = 0;
        if (LOCK && !aPlayer.field_70170_p.field_72995_K && !aPlayer.func_70093_af() && (aBlock.isWood((IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ) || OP.log.contains(UT.Stacks.make(aBlock, 1L, (long)aMetaData)))) {
            try {
                int tIncrement = (int)Math.max(1.0f, aBlock.func_149712_f(aPlayer.field_70170_p, aX, aY, aZ) * (float)this.getToolDamagePerBlockBreak() / 10.0f);
                LOCK = false;
                int tH = aPlayer.field_70170_p.func_72800_K();
                for (int tY = aY + 1; tY < tH && (long)rAmount <= aAvailableConversions && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock && aPlayer.field_70170_p.func_147480_a(aX, tY, aZ, true); ++tY) {
                    rAmount += ++tIncrement;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            LOCK = true;
        }
        return rAmount;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        if (aBlock.isWood((IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ) || OP.log.contains(UT.Stacks.make(aBlock, 1L, (long)aMetaData))) {
            float rAmount = 1.0f;
            float tIncrement = 1.0f;
            if (!aPlayer.func_70093_af()) {
                int tH = aPlayer.field_70170_p.func_72800_K();
                for (int tY = aY + 1; tY < tH && aPlayer.field_70170_p.func_147439_a(aX, tY, aZ) == aBlock; ++tY) {
                    rAmount += (tIncrement += 0.1f);
                }
            }
            return 2.0f * aDefault / rAmount;
        }
        return aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151582_l || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151572_C ? aDefault / 4.0f : aDefault;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mTextureSetsItems.get(OP.toolHeadAxe.mIconIndexItem) : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Wood).mTextureSetsItems.get(OP.stick.mIconIndexItem);
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : MultiItemTool.getSecondaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Wood).mRGBaSolid;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] has been chopped by [KILLER]";
    }
}

