/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools;

import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public abstract class GT_Tool
implements IToolStats {
    public static final Enchantment[] FORTUNE_ENCHANTMENT = new Enchantment[]{Enchantment.field_77346_s};
    public static final Enchantment[] LOOTING_ENCHANTMENT = new Enchantment[]{Enchantment.field_77335_o};
    private long mMaterialAmount = 0L;

    @Override
    public int getToolDamagePerBlockBreak() {
        return 100;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance;
    }

    @Override
    public float getExhaustionPerAttack(Entity aEntity) {
        return 0.3f;
    }

    @Override
    public String getMiningSound() {
        return null;
    }

    @Override
    public String getCraftingSound() {
        return null;
    }

    @Override
    public String getEntityHitSound() {
        return null;
    }

    @Override
    public String getBreakingSound() {
        return "random.break";
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean isWrench() {
        return false;
    }

    @Override
    public boolean isCrowbar() {
        return false;
    }

    @Override
    public boolean isGrafter() {
        return false;
    }

    @Override
    public boolean isWeapon() {
        return false;
    }

    @Override
    public boolean isRangedWeapon() {
        return false;
    }

    @Override
    public boolean isMiningTool() {
        return true;
    }

    public abstract boolean isMinableBlock(Block var1, byte var2);

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData) {
        return this.isMinableBlock(aBlock, aMetaData) ? 1.0f : 0.0f;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        return aDefault;
    }

    @Override
    public DamageSource getDamageSource(EntityLivingBase aPlayer, Entity aEntity) {
        return DamageSources.getCombatDamage(aPlayer instanceof EntityPlayer ? "player" : "mob", aPlayer, aEntity instanceof EntityLivingBase ? this.getDeathMessage(aPlayer, (EntityLivingBase)aEntity) : null);
    }

    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        String rMessage = this.getDeathMessage();
        if (UT.Code.stringInvalid(rMessage)) {
            return new EntityDamageSource(aPlayer instanceof EntityPlayer ? "player" : "mob", (Entity)aPlayer).func_151519_b(aEntity);
        }
        return new ChatComponentText(rMessage.replace("[KILLER]", EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE).replace("[VICTIM]", EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE));
    }

    public String getDeathMessage() {
        return "";
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableConversions, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        return 0;
    }

    public GT_Tool setMaterialAmount(long aMaterialAmount) {
        this.mMaterialAmount = aMaterialAmount;
        return this;
    }

    @Override
    public ItemStack getBrokenItem(ItemStack aStack) {
        ItemStack tStack = OP.scrapGt.mat(MultiItemTool.getPrimaryMaterial(aStack, MT.NULL), new Random(UT.NBT.getNBT(aStack).func_74765_d("gt.rand")).nextInt(1 + (int)(4L * this.mMaterialAmount / 420076800L)));
        return tStack == null || tStack.field_77994_a < 1 ? null : tStack;
    }

    @Override
    public Enchantment[] getEnchantments(ItemStack aStack, OreDictMaterial aMaterial) {
        return CS.ZL_ENCHANTMENT;
    }

    @Override
    public int[] getEnchantmentLevels(ItemStack aStack) {
        return CS.ZL_INTEGER;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        aPlayer.func_71029_a((StatBase)AchievementList.field_76004_f);
        aPlayer.func_71029_a((StatBase)AchievementList.field_76005_g);
        aPlayer.func_71029_a((StatBase)AchievementList.field_76017_h);
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
    }

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        return aOriginalDamage;
    }

    @Override
    public float getMagicDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        return aOriginalDamage;
    }

    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return Textures.ItemIcons.VOID;
    }

    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return null;
    }

    @Override
    public int getRenderPasses() {
        return 4;
    }

    @Override
    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        switch (aRenderPass) {
            case 0: {
                return this.getIcon(false, aStack).getIcon(0);
            }
            case 1: {
                return this.getIcon(false, aStack).getIcon(1);
            }
            case 2: {
                return this.getIcon(true, aStack).getIcon(0);
            }
            case 3: {
                return this.getIcon(true, aStack).getIcon(1);
            }
        }
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack, int aRenderPass) {
        switch (aRenderPass) {
            case 0: {
                return this.getRGBa(false, aStack);
            }
            case 1: {
                return CS.UNCOLOURED;
            }
            case 2: {
                return this.getRGBa(true, aStack);
            }
            case 3: {
                return CS.UNCOLOURED;
            }
        }
        return CS.UNCOLOURED;
    }
}

