/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockFoamable;
import gregapi.block.metatype.BlockMetaType;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import gregtech.blocks.BlockCFoamFresh;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Spray_Foam_Hardener
extends IBehavior.Behaviour_None {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final String mTooltip;
    private final String mTooltipUses = LanguageHandler.get("gt.behaviour.hardenerspray.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = LanguageHandler.get("gt.behaviour.unstackable", "Not usable when stacked!");

    public Behavior_Spray_Foam_Hardener(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mTooltip = LanguageHandler.get("gt.behaviour.foamhardenerspray.tooltip", "Can harden C-Foam");
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        long tHardened;
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (UT.Stacks.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mUsed));
            tUses = this.mUses;
        }
        if (UT.Stacks.equal(aStack, this.mUsed, true) && (tHardened = this.harden(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack)) > 0L) {
            UT.Sounds.send(aWorld, CS.SFX.IC_SPRAY, 1.0f, -1.0f, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tHardened;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                UT.Stacks.meta(aStack, UT.Stacks.meta(this.mEmpty));
            }
        }
        return rOutput;
    }

    public long harden(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack) {
        Block aBlock;
        block9: {
            if (aUses < 1L) {
                return 0L;
            }
            DelegatorTileEntity<TileEntity> aTileEntity = UT.Worlds.getTileEntity(aWorld, aX, aY, aZ, aSide, true);
            if (aTileEntity.mTileEntity instanceof ITileEntityFoamable) {
                return ((ITileEntityFoamable)aTileEntity.mTileEntity).dryFoam(aTileEntity.mSideOfTileEntity) ? 10L : 0L;
            }
            aBlock = aTileEntity.getBlock();
            aWorld = aTileEntity.mWorld;
            aX = aTileEntity.mX;
            aY = aTileEntity.mY;
            aZ = aTileEntity.mZ;
            if (aBlock instanceof IBlockFoamable) {
                return ((IBlockFoamable)aBlock).dryFoam(aWorld, aX, aY, aZ, aTileEntity.mSideOfTileEntity) ? (aBlock instanceof BlockCFoamFresh && CS.SIDES_VALID[((BlockMetaType)aBlock).mSide] ? 5L : 10L) : 0L;
            }
            try {
                if (UT.Reflection.getClassName(aTileEntity.mTileEntity).startsWith("TileEntityCable")) {
                    if (aUses >= 10L && UT.Reflection.getPublicField(aTileEntity.mTileEntity, "foamed").getByte(aTileEntity.mTileEntity) == 1) {
                        UT.Reflection.callPublicMethod(aTileEntity.mTileEntity, "changeFoam", (byte)2);
                        return 10L;
                    }
                    return 0L;
                }
            }
            catch (Throwable e) {
                if (!CS.D1) break block9;
                e.printStackTrace(CS.ERR);
            }
        }
        if (IL.IC2_Foam.getBlock() == aBlock) {
            return aUses >= 10L && aWorld.func_147465_d(aX, aY, aZ, IL.IC2_Wall.getBlock(), 7, 3) ? 10L : 0L;
        }
        if (IL.IC2_Foam_Reinforced.getBlock() == aBlock) {
            return aUses >= 10L && aWorld.func_147465_d(aX, aY, aZ, IL.IC2_Wall_Reinforced.getBlock(), 0, 3) ? 10L : 0L;
        }
        return 0L;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = UT.Stacks.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(this.mTooltipUses + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

