/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class Behavior_Spray_Extinguisher
extends IBehavior.Behaviour_None {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final String mTooltip;
    private final String mTooltipUses = LanguageHandler.get("gt.behaviour.extinguisher.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = LanguageHandler.get("gt.behaviour.unstackable", "Not usable when stacked!");

    public Behavior_Spray_Extinguisher(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mTooltip = LanguageHandler.get("gt.behaviour.extinguisher.tooltip", "Extinguishes Fire");
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long tExtinguished;
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (UT.Stacks.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mUsed));
            tUses = this.mUses;
        }
        if (UT.Stacks.equal(aStack, this.mUsed, true) && (tExtinguished = this.extinguish(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack, aHitX, aHitY, aHitZ)) > 0L) {
            UT.Sounds.send(aWorld, CS.SFX.IC_SPRAY, 1.0f, 2.0f, aX, aY, aZ);
            UT.Sounds.send(aWorld, "random.fizz", 1.0f, 1.5f, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tExtinguished;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                UT.Stacks.meta(aStack, UT.Stacks.meta(this.mEmpty));
            }
        }
        return rOutput;
    }

    public long extinguish(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer == null || CS.SIDES_INVALID[aSide] || aPlayer instanceof FakePlayer || !UT.Worlds.isSideObstructed(aWorld, aX, aY, aZ, aSide)) {
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("extinguisher", aUses * 1000L, 1L, (Entity)aPlayer, tChatReturn, (IInventory)(aPlayer == null ? null : aPlayer.field_71071_by), aPlayer != null && aPlayer.func_70093_af(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
            UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
            if (tDamage > 0L) {
                return Math.min(10L, tDamage / 1000L);
            }
        }
        if (aUses < 10L) {
            return 0L;
        }
        long rUses = 0L;
        aX += CS.OFFSETS_X[aSide];
        aY += CS.OFFSETS_Y[aSide];
        aZ += CS.OFFSETS_Z[aSide];
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (rUses + 10L > aUses) {
                        return rUses;
                    }
                    if (aWorld.func_147439_a(aX + i, aY + j, aZ + k) != Blocks.field_150480_ab || !aWorld.func_147465_d(aX + i, aY + j, aZ + k, CS.NB, 0, 3)) continue;
                    rUses += 10L;
                }
            }
        }
        for (Object tEntity : aWorld.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(aX - 2), (double)(aY - 2), (double)(aZ - 2), (double)(aX + 3), (double)(aY + 3), (double)(aZ + 3)))) {
            if (rUses + 10L > aUses) {
                return rUses;
            }
            if (tEntity.getClass() == EntityBlaze.class) {
                ((EntityBlaze)tEntity).func_70097_a(DamageSources.getCombatDamage("player", (EntityLivingBase)aPlayer, null), 10.0f);
                rUses += 10L;
                continue;
            }
            if (!((Entity)tEntity).func_70027_ad()) continue;
            ((Entity)tEntity).func_70066_B();
            rUses += 10L;
        }
        return rUses;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = UT.Stacks.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(this.mTooltipUses + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

