/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockDecolorable;
import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.tileentity.ITileEntityDecolorable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Spray_Color_Remover
extends IBehavior.Behaviour_None {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final String mTooltip;
    private final String mTooltipUses = LanguageHandler.get("gt.behaviour.paintremoverspray.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = LanguageHandler.get("gt.behaviour.unstackable", "Not usable when stacked!");

    public Behavior_Spray_Color_Remover(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mTooltip = LanguageHandler.get("gt.behaviour.paintremoverspray.tooltip", "Can Decolor things");
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (UT.Stacks.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mUsed));
            tUses = this.mUses;
        }
        if (UT.Stacks.equal(aStack, this.mUsed, true) && Behavior_Spray_Color_Remover.decolorize(aWorld, aX, aY, aZ, aSide)) {
            UT.Sounds.send(aWorld, CS.SFX.IC_SPRAY, 1.0f, 1.0f, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= 10L;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                UT.Stacks.meta(aStack, UT.Stacks.meta(this.mEmpty));
            }
        }
        return rOutput;
    }

    private static boolean decolorize(World aWorld, int aX, int aY, int aZ, byte aSide) {
        DelegatorTileEntity<TileEntity> aDelegator = UT.Worlds.getTileEntity(aWorld, aX, aY, aZ, aSide, true);
        if (aDelegator.mTileEntity instanceof ITileEntityDecolorable) {
            return ((ITileEntityDecolorable)aDelegator.mTileEntity).removePaint(aDelegator.mSideOfTileEntity);
        }
        Block aBlock = aDelegator.getBlock();
        if (aBlock instanceof IBlockDecolorable) {
            return ((IBlockDecolorable)aBlock).removePaint(aWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ, aDelegator.mSideOfTileEntity);
        }
        if (aBlock == Blocks.field_150406_ce) {
            return aDelegator.setBlock(Blocks.field_150405_ch);
        }
        if (aBlock == Blocks.field_150397_co) {
            return aDelegator.setBlock(Blocks.field_150410_aZ);
        }
        if (aBlock == Blocks.field_150399_cn) {
            return aDelegator.setBlock(Blocks.field_150359_w);
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = UT.Stacks.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(this.mTooltipUses + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

