/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Behavior_Spray_Color
extends IBehavior.Behaviour_None {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final byte mColor;
    private final Collection<Block> mAllowedVanillaBlocks = Arrays.asList(Blocks.field_150359_w, Blocks.field_150410_aZ, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150404_cg, Blocks.field_150405_ch, Blocks.field_150406_ce, IL.TE_Rockwool.getBlock());
    private final String mTooltip;
    private final String mTooltipUses = LanguageHandler.get("gt.behaviour.paintspray.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = LanguageHandler.get("gt.behaviour.unstackable", "Not usable when stacked!");

    public Behavior_Spray_Color(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses, byte aColor) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mColor = UT.Code.bind4(aColor);
        this.mTooltip = LanguageHandler.get("gt.behaviour.paintspray." + this.mColor + ".tooltip", "Can Color things in " + CS.DYE_NAMES[this.mColor]);
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (UT.Stacks.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mUsed));
            tUses = this.mUses;
        }
        if (UT.Stacks.equal(aStack, this.mUsed, true) && this.colorize(aWorld, aX, aY, aZ, aSide)) {
            UT.Sounds.send(aWorld, CS.SFX.IC_SPRAY, 1.0f, 1.0f, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= 10L;
            }
            rOutput = true;
        }
        tNBT.func_82580_o("gt.remaining");
        if (tUses > 0L) {
            UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                UT.Stacks.meta(aStack, UT.Stacks.meta(this.mEmpty));
            }
        }
        return rOutput;
    }

    private boolean colorize(World aWorld, int aX, int aY, int aZ, byte aSide) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock != CS.NB && (this.mAllowedVanillaBlocks.contains(aBlock) || aBlock instanceof BlockColored)) {
            if (aBlock == Blocks.field_150405_ch) {
                aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150406_ce, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aBlock == Blocks.field_150410_aZ) {
                aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150397_co, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aBlock == Blocks.field_150359_w) {
                aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150399_cn, ~this.mColor & 0xF, 3);
                return true;
            }
            if (aWorld.func_72805_g(aX, aY, aZ) == (~this.mColor & 0xF)) {
                return false;
            }
            aWorld.func_72921_c(aX, aY, aZ, ~this.mColor & 0xF, 3);
            return true;
        }
        return aBlock.recolourBlock(aWorld, aX, aY, aZ, CS.FORGE_DIR[aSide], ~this.mColor & 0xF);
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = UT.Stacks.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(this.mTooltipUses + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

