/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.tileentity.ITileEntityRemoteActivateable;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class Behavior_Remote
extends IBehavior.Behaviour_None {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Remote();
    private final String mTooltip = LanguageHandler.get("gt.behaviour.remote", "Activates up to 16 Blocks within a Range of 128m");

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ChunkCoordinates tCoords;
        ArrayListNoNulls<ChunkCoordinates> tList;
        if (aWorld.field_72995_K || aPlayer == null || !aPlayer.func_70093_af() || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        if (!aStack.func_77942_o()) {
            aStack.func_77982_d(new NBTTagCompound());
        }
        if ((tList = this.getCoordinateList(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g)).contains(tCoords = new ChunkCoordinates(aX, aY, aZ))) {
            UT.Entities.chat((Object)aPlayer, "Coordinates removed!");
            UT.Sounds.send(aWorld, CS.SFX.IC_SCANNER, 1.0f, 1.0f, tCoords);
            tList.remove(tCoords);
        } else if (tList.size() >= 16) {
            UT.Entities.chat((Object)aPlayer, "Cant hold more than 16 Coordinates per Dimension!");
        } else {
            TileEntity tTileEntity = UT.Worlds.getTileEntity(aWorld, tCoords, false);
            if (tTileEntity instanceof ITileEntityRemoteActivateable) {
                UT.Entities.chat((Object)aPlayer, "Coordinates added!");
                UT.Sounds.send(aWorld, CS.SFX.IC_SCANNER, 1.0f, 1.0f, tCoords);
                tList.add(tCoords);
            } else {
                UT.Entities.chat((Object)aPlayer, "This cannot be added!");
            }
        }
        this.setCoordinateList(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g, tList);
        if (aStack.func_77978_p().func_82582_d()) {
            aStack.func_77982_d(null);
        }
        return true;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aWorld.field_72995_K || aPlayer.func_70093_af() || !aStack.func_77942_o()) {
            return aStack;
        }
        ArrayListNoNulls<ChunkCoordinates> tToBeKept = new ArrayListNoNulls<ChunkCoordinates>();
        for (ChunkCoordinates tCoords : this.getCoordinateList(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g)) {
            if (Math.abs((double)tCoords.field_71574_a - aPlayer.field_70165_t) <= 128.0 && Math.abs((double)tCoords.field_71572_b - aPlayer.field_70163_u) <= 128.0 && Math.abs((double)tCoords.field_71573_c - aPlayer.field_70161_v) <= 128.0) {
                TileEntity tTileEntity = UT.Worlds.getTileEntity(aWorld, tCoords, false);
                if (!(tTileEntity instanceof ITileEntityRemoteActivateable) || !((ITileEntityRemoteActivateable)tTileEntity).remoteActivate()) continue;
                tToBeKept.add(tCoords);
                continue;
            }
            tToBeKept.add(tCoords);
        }
        this.setCoordinateList(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g, tToBeKept);
        UT.Sounds.send(aWorld, "random.click", 1.0f, 1.0f, (Entity)aPlayer);
        return aStack;
    }

    public ArrayListNoNulls<ChunkCoordinates> getCoordinateList(NBTTagCompound aNBT, int aDimension) {
        ArrayListNoNulls<ChunkCoordinates> rList = new ArrayListNoNulls<ChunkCoordinates>();
        if (aNBT == null) {
            return rList;
        }
        NBTTagCompound tNBT = aNBT.func_74775_l("gt.remote.dim." + aDimension);
        if (tNBT.func_82582_d()) {
            return rList;
        }
        int i = -1;
        while (++i < 16 && tNBT.func_74764_b("x" + i)) {
            rList.add(new ChunkCoordinates(tNBT.func_74762_e("x" + i), tNBT.func_74762_e("y" + i), tNBT.func_74762_e("z" + i)));
        }
        return rList;
    }

    public void setCoordinateList(NBTTagCompound aNBT, int aDimension, ArrayListNoNulls<ChunkCoordinates> aList) {
        NBTTagCompound tNBT = new NBTTagCompound();
        int j = aList.size();
        for (int i = 0; i < j; ++i) {
            ChunkCoordinates tCoords = (ChunkCoordinates)aList.get(i);
            tNBT.func_74768_a("x" + i, tCoords.field_71574_a);
            tNBT.func_74768_a("y" + i, tCoords.field_71572_b);
            tNBT.func_74768_a("z" + i, tCoords.field_71573_c);
        }
        aNBT.func_74782_a("gt.remote.dim." + aDimension, (NBTBase)tNBT);
        if (tNBT.func_82582_d()) {
            aNBT.func_82580_o("gt.remote.dim." + aDimension);
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

