/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import codechicken.lib.math.MathHelper;
import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Behavior_Lighter
extends IBehavior.Behaviour_None {
    private final ItemStack mEmptyLighter;
    private final ItemStack mUsedLighter;
    private final ItemStack mFullLighter;
    private final long mFuelAmount;
    private final long mChance;
    private final String mTooltip = LanguageHandler.get("gt.behaviour.lighter.tooltip", "Can light things on Fire");
    private final String mTooltipUses = LanguageHandler.get("gt.behaviour.lighter.uses", "Remaining Uses:");
    private final String mTooltipChance = LanguageHandler.get("gt.behaviour.lighter.chance", "Chance:");
    private final String mTooltipUnstackable = LanguageHandler.get("gt.behaviour.unstackable", "Not usable when stacked!");
    private final String mTooltipSingleuse = LanguageHandler.get("gt.behaviour.singleuse", "Single Use");

    public Behavior_Lighter(ItemStack aEmptyLighter, ItemStack aUsedLighter, ItemStack aFullLighter, long aFuelAmount, long aChance) {
        this.mFullLighter = aFullLighter;
        this.mUsedLighter = aUsedLighter;
        this.mEmptyLighter = aEmptyLighter;
        this.mFuelAmount = aFuelAmount;
        this.mChance = UT.Code.bind(0L, 10000L, aChance);
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aPlayer.field_70170_p.field_72995_K || aStack.field_77994_a != 1 && (this.mFuelAmount != 1L || this.mEmptyLighter != null)) {
            return false;
        }
        boolean rOutput = false;
        if (aEntity instanceof EntityCreeper) {
            this.prepare(aStack);
            long tFuelAmount = UT.NBT.getLighterFuel(aStack);
            if (UT.Stacks.equal(aStack, this.mUsedLighter, true)) {
                UT.Sounds.send(aPlayer.field_70170_p, "fire.ignite", 1.0f, 1.0f, MathHelper.floor_double((double)aEntity.field_70165_t), MathHelper.floor_double((double)aEntity.field_70163_u), MathHelper.floor_double((double)aEntity.field_70161_v));
                ((EntityCreeper)aEntity).func_146079_cb();
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    --tFuelAmount;
                }
                rOutput = true;
            }
            UT.NBT.setLighterFuel(aStack, tFuelAmount);
            if (tFuelAmount <= 0L) {
                this.useUp(aStack);
            }
        }
        return rOutput;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 && (this.mFuelAmount != 1L || this.mEmptyLighter != null)) {
            return false;
        }
        this.prepare(aStack);
        if (UT.Stacks.equal(aStack, this.mUsedLighter, true)) {
            UT.Sounds.send(aWorld, "fire.ignite", 1.0f, 1.0f, aX, aY, aZ);
            long tDamage = 0L;
            if ((long)aWorld.field_73012_v.nextInt(10000) < this.mChance) {
                ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 3L, (Entity)aPlayer, tChatReturn, (IInventory)aPlayer.field_71071_by, aPlayer.func_70093_af(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
                UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
                if (tDamage == 0L) {
                    if (!UT.Worlds.isAir(aWorld, aX += CS.OFFSETS_X[aSide], aY += CS.OFFSETS_Y[aSide], aZ += CS.OFFSETS_Z[aSide]) || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
                        return false;
                    }
                    aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                    tDamage = 10000L;
                }
            } else {
                tDamage = 10000L;
            }
            if (tDamage != 0L) {
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    long tFuelAmount = UT.NBT.getLighterFuel(aStack) - UT.Code.units(tDamage, 10000L, 1L, true);
                    UT.NBT.setLighterFuel(aStack, tFuelAmount);
                    if (tFuelAmount <= 0L) {
                        this.useUp(aStack);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void prepare(ItemStack aStack) {
        if (UT.Stacks.equal(aStack, this.mFullLighter, true)) {
            aStack.func_150996_a(this.mUsedLighter.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mUsedLighter));
            UT.NBT.setLighterFuel(aStack, this.mFuelAmount);
        }
    }

    private void useUp(ItemStack aStack) {
        if (this.mEmptyLighter == null) {
            --aStack.field_77994_a;
        } else {
            aStack.func_150996_a(this.mEmptyLighter.func_77973_b());
            UT.Stacks.meta(aStack, UT.Stacks.meta(this.mEmptyLighter));
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (this.mFuelAmount > 1L) {
            long tFuelAmount = tNBT == null ? (UT.Stacks.equal(aStack, this.mFullLighter, true) ? this.mFuelAmount : 0L) : UT.NBT.getLighterFuel(aStack);
            aList.add(this.mTooltipUses + " " + tFuelAmount);
        } else {
            aList.add(this.mTooltipSingleuse);
        }
        if (this.mChance < 10000L) {
            aList.add(this.mTooltipChance + " " + this.mChance / 100L + "." + this.mChance % 100L + "%");
        }
        if (this.mFuelAmount != 1L || this.mEmptyLighter != null) {
            aList.add(this.mTooltipUnstackable);
        }
        return aList;
    }
}

