/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import codechicken.lib.math.MathHelper;
import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.util.UT;
import gregtech.GT_Mod;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class Behavior_FlintAndTinder
extends IBehavior.Behaviour_None {
    private final String mTooltip = LanguageHandler.get("gt.behaviour.flintandtinder", "Ignites a Fire with a Chance of ");

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer != null && CS.SIDES_VALID[aSide] && !(aPlayer instanceof FakePlayer) && UT.Worlds.isSideObstructed(aWorld, aX, aY, aZ, aSide)) {
            return false;
        }
        ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
        long tDamage = 10000L;
        if (aWorld.field_73012_v.nextInt(100) < GT_Mod.gregtechproxy.mFlintChance) {
            tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 1L, (Entity)aPlayer, tChatReturn, (IInventory)(aPlayer == null ? null : aPlayer.field_71071_by), aPlayer == null ? false : aPlayer.func_70093_af(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
        }
        UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
        if (aWorld.field_72995_K) {
            return false;
        }
        if (aPlayer == null || !UT.Entities.hasInfiniteItems(aPlayer)) {
            ((MultiItemTool)aItem).doDamage(aStack, UT.Code.units(Math.max(10000L, tDamage), 10000L, 100L, true));
        }
        UT.Sounds.send(aWorld, "fire.ignite", 1.0f, 1.0f, aX, aY, aZ);
        return true;
    }

    @Override
    public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        return true;
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        if (aEntity instanceof EntityCreeper) {
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                ((MultiItemTool)aItem).doDamage(aStack, 100L);
            }
            UT.Sounds.send(aPlayer.field_70170_p, "fire.ignite", 1.0f, 1.0f, MathHelper.floor_double((double)aEntity.field_70165_t), MathHelper.floor_double((double)aEntity.field_70163_u), MathHelper.floor_double((double)aEntity.field_70161_v));
            ((EntityCreeper)aEntity).func_146079_cb();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip + GT_Mod.gregtechproxy.mFlintChance + "%");
        return aList;
    }
}

