/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.data.CS;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class Behavior_Bucket_Simple
extends IBehavior.Behaviour_None {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Bucket_Simple(CS.NI);
    public ItemStack mDefaultFullBucket;

    public Behavior_Bucket_Simple(ItemStack aDefault) {
        this.mDefaultFullBucket = aDefault;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        FluidStack mFluid = UT.Fluids.getFluidForFilledItem(aStack, true);
        MovingObjectPosition tPosition = this.getMovingObjectPositionFromPlayer(aWorld, aPlayer, mFluid == null);
        if (tPosition == null || tPosition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return aStack;
        }
        int tX = tPosition.field_72311_b;
        int tY = tPosition.field_72312_c;
        int tZ = tPosition.field_72309_d;
        ItemStack tBucket = UT.Stacks.make(Items.field_151133_ar, 1L, 0L);
        if (mFluid == null) {
            FluidStack tFluid;
            Block tFluidBlock = aWorld.func_147439_a(tX, tY, tZ);
            if ((tFluidBlock == Blocks.field_150355_j || tFluidBlock == Blocks.field_150358_i) && aWorld.func_72805_g(tX, tY, tZ) == 0) {
                tBucket = tBucket.func_77973_b().func_77659_a(tBucket, aWorld, aPlayer);
            }
            if (tFluidBlock instanceof IFluidBlock && (tFluid = ((IFluidBlock)tFluidBlock).drain(aWorld, tX, tY, tZ, false)) != null) {
                if (UT.Fluids.fillFluidContainer(tFluid, aStack, false, true) != null) {
                    tBucket = tBucket.func_77973_b().func_77659_a(tBucket, aWorld, aPlayer);
                }
                if (UT.Fluids.milk(tFluid) && tFluid.amount >= 1000) {
                    tBucket = UT.Stacks.make(Items.field_151117_aB, 1L, 0L);
                }
            }
        } else if (UT.Stacks.valid(this.mDefaultFullBucket)) {
            tBucket = UT.Stacks.copy(this.mDefaultFullBucket);
            tBucket = tBucket.func_77973_b().func_77659_a(tBucket, aWorld, aPlayer);
        } else {
            if ((tBucket = UT.Fluids.fillFluidContainer(mFluid, tBucket, false, true)) == null) {
                return aStack;
            }
            tBucket = tBucket.func_77973_b().func_77659_a(tBucket, aWorld, aPlayer);
        }
        aPlayer.func_71041_bz();
        return this.processBucket(tBucket, aStack, mFluid != null);
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (!(UT.Fluids.getFluidForFilledItem(aStack, true) != null || aEntity.getClass() != EntityCow.class && aEntity.getClass() != EntityMooshroom.class || ((EntityCow)aEntity).func_70631_g_())) {
            if (!aPlayer.field_70170_p.field_72995_K || UT.Entities.hasInfiniteItems(aPlayer)) {
                UT.Stacks.set(aStack, UT.Fluids.fillFluidContainer(UT.Fluids.milk(Integer.MAX_VALUE), aStack, false, true));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock instanceof BlockCauldron) {
            FluidStack mFluid = UT.Fluids.getFluidForFilledItem(aStack, true);
            if (mFluid == null) {
                return false;
            }
            if (aWorld.func_72805_g(aX, aY, aZ) < 3 && UT.Fluids.water(mFluid) && mFluid.amount >= 1000) {
                ((BlockCauldron)aBlock).func_150024_a(aWorld, aX, aY, aZ, 3);
                UT.Stacks.set(aStack, UT.Stacks.container(aStack, true));
                return true;
            }
        }
        return false;
    }

    protected ItemStack processBucket(ItemStack aBucket, ItemStack aStack, boolean aWasFull) {
        if (aBucket == null) {
            return aStack;
        }
        if (aWasFull) {
            if (aBucket.func_77973_b() == Items.field_151133_ar) {
                aBucket = UT.Stacks.container(aStack, false);
                if (aBucket == null) {
                    aStack.field_77994_a = 0;
                } else {
                    aStack = aBucket;
                }
                return aStack;
            }
        } else {
            FluidStack tFluid = UT.Fluids.getFluidForFilledItem(aBucket, true);
            if (tFluid != null) {
                aBucket = UT.Fluids.fillFluidContainer(tFluid, aStack, false, true);
                if (aBucket == null) {
                    aStack.field_77994_a = 0;
                } else {
                    aStack = aBucket;
                }
                return aStack;
            }
        }
        return aStack;
    }
}

