/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks;

import gregapi.block.BlockBaseMachineUpdate;
import gregapi.block.metatype.ItemBlockMeta;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLongDistWire
extends BlockBaseMachineUpdate {
    public final IIconContainer[] mIcons;
    public final byte[] mTiers;

    public BlockLongDistWire(String aUnlocalised, IIconContainer[] aIcons, byte[] aTiers) {
        super(ItemBlockMeta.class, aUnlocalised, Material.field_151573_f, -1);
        this.func_149672_a(field_149775_l);
        this.mTiers = aTiers;
        this.mIcons = aIcons;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            LH.add(aUnlocalised + "." + i + ".name", "Long Distance Electric Wire (" + CS.VN[this.mTiers[i]] + ")");
        }
    }

    @Override
    public void addInformation(ItemStack aStack, int aMeta, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.voltage") + CS.V[this.mTiers[aMeta]] * 2L + " " + TD.Energy.EU.getLocalisedNameShort() + " (" + CS.VN[this.mTiers[aMeta]] + ")");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.amperage") + "UNLIMITED");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.loss") + "0.125 " + TD.Energy.EU.getLocalisedNameShort() + "/m");
    }

    public final int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return 150;
    }

    public final int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return 150;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "cutter";
    }

    public int getHarvestLevel(int aMeta) {
        return 3;
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150339_S.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return this.getExplosionResistance(aWorld.func_72805_g(aX, aY, aZ));
    }

    public float func_149638_a(Entity aEntity) {
        return this.getExplosionResistance(0);
    }

    @Override
    public float getExplosionResistance(int aMeta) {
        return 10.0f;
    }

    public void func_149666_a(Item aItem, CreativeTabs par2CreativeTabs, List aList) {
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            aList.add(UT.Stacks.make(aItem, 1L, (long)i));
        }
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        if (aMeta >= 0 && aMeta < this.mIcons.length) {
            return this.mIcons[aMeta].getIcon(0);
        }
        return this.mIcons[0].getIcon(0);
    }
}

