/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregapi.api.Abstract_Mod;
import gregapi.api.Abstract_Proxy;
import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.config.ConfigCategories;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.fluid.FluidGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import gregtech.entities.GT_Entity_Arrow;
import gregtech.tileentity.misc.MultiTileEntityCertificate;
import java.net.URL;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_Proxy
extends Abstract_Proxy {
    public final HashSetNoNulls<String> mSupporterListSilver = new HashSetNoNulls();
    public final HashSetNoNulls<String> mSupporterListGold = new HashSetNoNulls();
    public String mMessage = "";
    public boolean mDisableVanillaOres = true;
    public boolean mIncreaseDungeonLoot = true;
    public boolean mNerfedVanillaTools = true;
    public int mSkeletonsShootGTArrows = 16;
    public int mMaxEqualEntitiesAtOneSpot = 3;
    public int mFlintChance = 30;
    public int mItemDespawnTime = 6000;
    public ArrayListNoNulls<EntityOcelot> mOcelots = new ArrayListNoNulls();
    private static final EnumSet<OreGenEvent.GenerateMinable.EventType> PREVENTED_ORES = EnumSet.of(OreGenEvent.GenerateMinable.EventType.COAL, new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.QUARTZ});
    private static final HashSetNoNulls<String> CHECKED_PLAYERS = new HashSetNoNulls();

    public GT_Proxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void onProxyBeforePreInit(Abstract_Mod aMod, FMLPreInitializationEvent aEvent) {
        super.onProxyBeforePreInit(aMod, aEvent);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String[] tSupporterListGoldDefault = new String[]{"Mine_Sasha", "Bear989Sr", "Ngar", "Vash505", "tyra_oa", "adamcirillo", "Buuz135", "123mcprorot123", "Schlaibi", "MarconosII", "k0jul", "Trilexcom", "laurynasl", "Axlegear", "mtimmerije", "FPSaddiction", "Yabdat", "Goshen", "InsaneyHaney", "KrotanHill", "buizerd007", "Lehran", "GrandKaiser", "kei_kouma", "Mehrin", "leagris", "BloodyAsp", "kehaan", "DarthUmbris"};
                String[] tSupporterListSilverDefault = new String[]{"Bear989jr", "ultrasn0wz", "pitchcherry", "negersvend", "jorstar", "Ralacroix", "Raganork", "TexanMD", "Morehatz", "MiniKatalyst", "Thanatos_00", "Goshen_Ithilien", "TheSkera", "LuxusDarkangel", "Ashleee", "Pit_of_Darkness", "DoughnutDev", "GeekTechMedia", "Heph", "Mileaos2", "CodingWithClass", "UltraPeeks", "boredi", "Lushiita", "Moothox", "fry_lad", "cdaser", "renadi", "hanakocz", "GeoStyx", "Beardedflea", "MysteryDump", "Flaver4", "x_Fame", "Azuxul", "manf", "Bimgo", "leagris", "IAmMinecrafter02", "Cerous", "Devilin_Pixy", "Bkarlsson87", "BadAlchemy", "CaballoCraft", "melanclock", "Resursator", "demanzke", "AndrewAmmerlaan", "Deathlycraft", "Jirajha", "Axlegear", "kei_kouma", "Dracion", "dungi", "Dorfschwein", "Zero Tw0", "mattiagraz85", "sebastiank30", "Plem", "invultri", "grillo126", "malcanteth", "Malevolence_", "Nicholas_Manuel", "Sirbab", "kehaan", "bpgames123", "semig0d", "9000bowser", "Sovereignty89", "Kris1432", "xander_cage_", "XanderT", "samuraijp", "bsaa", "SpwnX", "tworf", "Kadah", "kanni", "Stute", "Hegik", "Onlyme", "t3hero", "Hotchi", "jagoly", "Nullav", "BH5432", "Sibmer", "inceee", "foxxx0", "Hartok", "TMSama", "Shlnen", "Carsso", "zessirb", "meep310", "Seldron", "yttr1um", "hohounk", "freebug", "Sylphio", "jmarler", "Saberawr", "r00teniy", "Neonbeta", "yinscape", "voooon24", "Quintine", "peach774", "lepthymo", "bildeman", "Kremnari", "Aerosalo", "OndraSter", "oscares91", "crdl_pls", "Daxx367x2", "EGERTRONx", "aka13_404", "Abouttabs", "Johnstaal", "djshiny99", "megatronp", "DZCreeper", "Kane_Hart", "Truculent", "vidplace7", "simon6689", "MomoNasty", "UnknownXLV", "goreacraft", "Fluttermine", "Daddy_Cecil", "MrMaleficus", "TigersFangs", "cublikefoot", "chainman564", "NikitaBuker", "Misha999777", "25FiveDetail", "AntiCivilBoy", "michaelbrady", "Asutoro", "Speedynutty68", "GarretSidzaka", "HallowCharm977", "mastermind1919", "The_Hypersonic", "diamondguy2798", "zF4ll3nPr3d4t0r", "CrafterOfMines57", "XxELIT3xSNIP3RxX", "SuterusuKusanagi", "xavier0014", "adamros", "alexbegt"};
                CS.OUT.println("GT_Download_Thread: Downloading Silver Supporter List.");
                if (GT_Proxy.this.downloadSupporterListSilverFromMain()) {
                    CS.OUT.println("GT_Download_Thread: Success downloading Silver Supporter List!");
                } else {
                    CS.OUT.println("GT_Download_Thread: Failed downloading Silver Supporter List, trying Dropbox!");
                    if (GT_Proxy.this.downloadSupporterListSilverFromDropBox()) {
                        CS.OUT.println("GT_Download_Thread: Success downloading Silver Supporter List!");
                    } else {
                        CS.OUT.println("GT_Download_Thread: Failed downloading Silver Supporter List, using Hardcoded!");
                        for (String tName : tSupporterListSilverDefault) {
                            GT_Proxy.this.mSupporterListSilver.add(tName.toLowerCase());
                        }
                    }
                }
                CS.OUT.println("GT_Download_Thread: Downloading Gold Supporter List.");
                if (GT_Proxy.this.downloadSupporterListGoldFromMain()) {
                    CS.OUT.println("GT_Download_Thread: Success downloading Gold Supporter List!");
                } else {
                    CS.OUT.println("GT_Download_Thread: Failed downloading Gold Supporter List, trying Dropbox!");
                    if (GT_Proxy.this.downloadSupporterListGoldFromDropBox()) {
                        CS.OUT.println("GT_Download_Thread: Success downloading Gold Supporter List!");
                    } else {
                        CS.OUT.println("GT_Download_Thread: Failed downloading Gold Supporter List, using Hardcoded!");
                        for (String tName : tSupporterListGoldDefault) {
                            GT_Proxy.this.mSupporterListGold.add(tName.toLowerCase());
                        }
                    }
                }
                try {
                    CS.OUT.println("GT_Download_Thread: Downloading News.");
                    Scanner tScanner = new Scanner(new URL("http://gregtech.overminddl1.com/com/gregoriust/gregtech/message.txt").openStream());
                    while (tScanner.hasNextLine()) {
                        GT_Proxy.this.mMessage = GT_Proxy.this.mMessage + tScanner.nextLine() + " ";
                    }
                    tScanner.close();
                }
                catch (Throwable e) {
                    CS.OUT.println("GT_Download_Thread: Failed downloading News!");
                }
                GT_Proxy.this.mSupporterListSilver.removeAll(GT_Proxy.this.mSupporterListGold);
            }
        }).start();
    }

    @Override
    public void onProxyBeforePostInit(Abstract_Mod aMod, FMLPostInitializationEvent aEvent) {
        if (this.mIncreaseDungeonLoot) {
            CS.OUT.println("GT_Mod: Increasing general amount of Loot in Dungeon Chests and alike");
            ChestGenHooks tChest = ChestGenHooks.getInfo((String)"bonusChest");
            tChest.setMax(tChest.getMax() + 8);
            tChest.setMin(tChest.getMin() + 4);
            tChest = ChestGenHooks.getInfo((String)"dungeonChest");
            tChest.setMax(tChest.getMax() + 6);
            tChest.setMin(tChest.getMin() + 3);
            tChest = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
            tChest.setMax(tChest.getMax() + 8);
            tChest.setMin(tChest.getMin() + 4);
            tChest = ChestGenHooks.getInfo((String)"pyramidJungleChest");
            tChest.setMax(tChest.getMax() + 16);
            tChest.setMin(tChest.getMin() + 8);
            tChest = ChestGenHooks.getInfo((String)"pyramidJungleDispenser");
            tChest.setMax(tChest.getMax() + 2);
            tChest.setMin(tChest.getMin() + 1);
            tChest = ChestGenHooks.getInfo((String)"mineshaftCorridor");
            tChest.setMax(tChest.getMax() + 4);
            tChest.setMin(tChest.getMin() + 2);
            tChest = ChestGenHooks.getInfo((String)"villageBlacksmith");
            tChest.setMax(tChest.getMax() + 12);
            tChest.setMin(tChest.getMin() + 6);
            tChest = ChestGenHooks.getInfo((String)"strongholdCrossing");
            tChest.setMax(tChest.getMax() + 8);
            tChest.setMin(tChest.getMin() + 4);
            tChest = ChestGenHooks.getInfo((String)"strongholdCorridor");
            tChest.setMax(tChest.getMax() + 6);
            tChest.setMin(tChest.getMin() + 3);
            tChest = ChestGenHooks.getInfo((String)"strongholdLibrary");
            tChest.setMax(tChest.getMax() + 16);
            tChest.setMin(tChest.getMin() + 8);
        }
        if (this.mNerfedVanillaTools) {
            CS.OUT.println("GT_Mod: Nerfing Vanilla Tool Durability");
            Items.field_151041_m.func_77656_e(4);
            Items.field_151039_o.func_77656_e(4);
            Items.field_151038_n.func_77656_e(4);
            Items.field_151053_p.func_77656_e(4);
            Items.field_151017_I.func_77656_e(4);
            Items.field_151052_q.func_77656_e(16);
            Items.field_151050_s.func_77656_e(16);
            Items.field_151051_r.func_77656_e(16);
            Items.field_151049_t.func_77656_e(16);
            Items.field_151018_J.func_77656_e(16);
            Items.field_151040_l.func_77656_e(80);
            Items.field_151035_b.func_77656_e(80);
            Items.field_151037_a.func_77656_e(80);
            Items.field_151036_c.func_77656_e(80);
            Items.field_151019_K.func_77656_e(80);
            Items.field_151010_B.func_77656_e(8);
            Items.field_151005_D.func_77656_e(8);
            Items.field_151011_C.func_77656_e(8);
            Items.field_151006_E.func_77656_e(8);
            Items.field_151013_M.func_77656_e(8);
            Items.field_151048_u.func_77656_e(240);
            Items.field_151046_w.func_77656_e(240);
            Items.field_151047_v.func_77656_e(240);
            Items.field_151056_x.func_77656_e(240);
            Items.field_151012_L.func_77656_e(240);
        }
        CS.OUT.println("GT_Mod: Adding Tool Usage Crafting Recipes for OreDict Items.");
        long tBits = GT_ModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL | GT_ModHandler.RecipeBits.DEFAULT_NCC;
        for (OreDictMaterial aMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
            if (aMaterial.contains(TD.Properties.INVALID_MATERIAL) || aMaterial.mTargetRegistration != aMaterial) continue;
            GT_ModHandler.addCraftingRecipe(OP.toolHeadWrench.mat(aMaterial, 1L), tBits, new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), OP.plate.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel), Character.valueOf('R'), OP.ring.dat(MT.Steel), Character.valueOf('W'), OP.screw.dat(MT.Steel)});
            GT_ModHandler.addCraftingRecipe(OP.toolHeadWrench.mat(aMaterial, 1L), tBits, new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), OP.plateGem.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel), Character.valueOf('R'), OP.ring.dat(MT.Steel), Character.valueOf('W'), OP.screw.dat(MT.Steel)});
            GT_ModHandler.addCraftingRecipe(OP.toolHeadChainsaw.mat(aMaterial, 1L), tBits, new Object[]{"SRS", "XhX", "SRS", Character.valueOf('X'), OP.plate.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel), Character.valueOf('R'), OP.ring.dat(MT.Steel)});
            GT_ModHandler.addCraftingRecipe(OP.toolHeadChainsaw.mat(aMaterial, 1L), tBits, new Object[]{"SRS", "XhX", "SRS", Character.valueOf('X'), OP.plateGem.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel), Character.valueOf('R'), OP.ring.dat(MT.Steel)});
            GT_ModHandler.addCraftingRecipe(OP.toolHeadDrill.mat(aMaterial, 1L), tBits, new Object[]{"XSX", "XSX", "ShS", Character.valueOf('X'), OP.plate.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel)});
            GT_ModHandler.addCraftingRecipe(OP.toolHeadDrill.mat(aMaterial, 1L), tBits, new Object[]{"XSX", "XSX", "ShS", Character.valueOf('X'), OP.plateGem.dat(aMaterial), Character.valueOf('S'), OP.plate.dat(MT.Steel)});
            if (!aMaterial.contains(TD.Compounds.COATED)) {
                GT_ModHandler.addCraftingRecipe(OP.gearGtSmall.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"P ", aMaterial.contains(TD.Properties.WOOD) ? " s" : (aMaterial.contains(TD.Properties.STONE) ? " f" : " h"), Character.valueOf('P'), OP.plate.dat(aMaterial)});
                GT_ModHandler.addCraftingRecipe(OP.gearGt.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"SPS", aMaterial.contains(TD.Properties.WOOD) ? "PsP" : (aMaterial.contains(TD.Properties.STONE) ? "PfP" : "PwP"), "SPS", Character.valueOf('P'), OP.plate.dat(aMaterial), Character.valueOf('S'), OP.stick.dat(aMaterial)});
            }
            GT_ModHandler.addCraftingRecipe(OP.dust.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.crushedCentrifuged.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dust.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.crystalline.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dust.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.crystal.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustPure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.crushedPurified.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustPure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.cleanGravel.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustPure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.reduced.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustImpure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.clump.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustImpure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.shard.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustImpure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.crushed.dat(aMaterial)});
            GT_ModHandler.addCraftingRecipe(OP.dustImpure.mat(aMaterial.mTargetPulver.mMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"h", "X", Character.valueOf('X'), OP.dirtyGravel.dat(aMaterial)});
            if (!aMaterial.contains(TD.Processing.MORTAR) || !CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Tools.mortar, aMaterial.mNameInternal, true)) continue;
            GT_ModHandler.addShapelessCraftingRecipe(OP.dustSmall.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gemChipped.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dustSmall.mat(aMaterial, 2L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gemFlawed.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gem.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 2L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gemFlawless.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 4L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gemExquisite.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 8L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.gemLegendary.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.ingot.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.plate.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.plateGem.dat(aMaterial)});
            GT_ModHandler.addShapelessCraftingRecipe(OP.dust.mat(aMaterial, 1L), tBits | GT_ModHandler.RecipeBits.NOT_AUTOCRAFTABLE, new Object[]{"craftingToolMortar", OP.plateCurved.dat(aMaterial)});
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
    }

    @SubscribeEvent
    public void onEndermanTeleportEvent(EnderTeleportEvent aEvent) {
        if (aEvent.entityLiving instanceof EntityEnderman && aEvent.entityLiving.func_70660_b(Potion.field_76437_t) != null) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawningEvent(EntityJoinWorldEvent aEvent) {
        if (aEvent.entity != null && !aEvent.entity.field_70170_p.field_72995_K && this.mSkeletonsShootGTArrows > 0 && aEvent.entity.getClass() == EntityArrow.class && aEvent.entity.field_70170_p.field_73012_v.nextInt(this.mSkeletonsShootGTArrows) == 0 && ((EntityArrow)aEvent.entity).field_70250_c instanceof EntitySkeleton) {
            aEvent.entity.field_70170_p.func_72838_d((Entity)new GT_Entity_Arrow((EntityArrow)aEvent.entity, new ArrayListNoNulls<ItemStackContainer>(OP.arrowGtWood.mRegisteredItems).get(aEvent.entity.field_70170_p.field_73012_v).toStack()));
            aEvent.entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public void onOreGenEvent(OreGenEvent.GenerateMinable aGenerator) {
        if (this.mDisableVanillaOres && aGenerator.generator instanceof WorldGenMinable && PREVENTED_ORES.contains(aGenerator.type)) {
            aGenerator.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerInteraction(PlayerInteractEvent aEvent) {
        ItemStack aStack;
        if (aEvent.entityPlayer == null || aEvent.entityPlayer.field_70170_p == null || aEvent.action == null || aEvent.world.field_73011_w == null) {
            return;
        }
        if (!aEvent.world.field_72995_K && CHECKED_PLAYERS.add(aEvent.entityPlayer.func_70005_c_().toLowerCase()) && (this.mSupporterListSilver.contains(aEvent.entityPlayer.func_110124_au().toString()) || this.mSupporterListGold.contains(aEvent.entityPlayer.func_110124_au().toString()) || this.mSupporterListSilver.contains(aEvent.entityPlayer.func_70005_c_().toLowerCase()) || this.mSupporterListGold.contains(aEvent.entityPlayer.func_70005_c_().toLowerCase())) && !MultiTileEntityCertificate.ALREADY_RECEIVED.contains(aEvent.entityPlayer.func_70005_c_().toLowerCase())) {
            MultiTileEntityCertificate.ALREADY_RECEIVED.add(aEvent.entityPlayer.func_70005_c_().toLowerCase());
            UT.Inventories.addStackToPlayerInventory(aEvent.entityPlayer, MultiTileEntityCertificate.getCertificate(1, aEvent.entityPlayer.func_70005_c_()), false);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, LH.Chat.WHITE + "<" + LH.Chat.BLUE + "GregoriusT" + LH.Chat.WHITE + "> Thank you, " + aEvent.entityPlayer.func_70005_c_() + " for Supporting GregTech! Here, have a Certificate. ;)");
        }
        if ((aStack = aEvent.entityPlayer.func_71045_bC()) != null && aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && aStack.func_77973_b() == Items.field_151033_d) {
            if (!aEvent.world.field_72995_K && !UT.Entities.hasInfiniteItems(aEvent.entityPlayer) && aEvent.world.field_73012_v.nextInt(100) >= this.mFlintChance) {
                aEvent.setCanceled(true);
                aStack.func_77972_a(1, (EntityLivingBase)aEvent.entityPlayer);
                if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                    --aStack.field_77994_a;
                }
                if (aStack.field_77994_a <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)aEvent.entityPlayer, (ItemStack)aStack);
                }
                return;
            }
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("igniter", aStack.func_77960_j() * 10000, 1L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.field_71071_by, aEvent.entityPlayer.func_70093_af(), aStack, aEvent.world, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, tChatReturn, false);
            if (tDamage > 0L) {
                aEvent.setCanceled(true);
                aStack.func_77972_a(UT.Code.bindInt(UT.Code.units(tDamage, 10000L, 1L, true)), (EntityLivingBase)aEvent.entityPlayer);
                UT.Sounds.send(aEvent.world, "fire.ignite", 1.0f, 1.0f, aEvent.x, aEvent.y, aEvent.z);
                if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                    --aStack.field_77994_a;
                }
                if (aStack.field_77994_a <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)aEvent.entityPlayer, (ItemStack)aStack);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDropsEventEvent(LivingDropsEvent aEvent) {
        if (aEvent.entity.field_70170_p.field_72995_K || aEvent.entity instanceof EntityPlayer) {
            return;
        }
        String aEntityClassName = aEvent.entityLiving.getClass().getName().substring(aEvent.entityLiving.getClass().getName().lastIndexOf(".") + 1);
        if (aEntityClassName == null) {
            return;
        }
        int tRandomNumber = CS.RANDOM.nextInt(144);
        int tIntestinesAmount = 0;
        if (tRandomNumber == 0) {
            if (aEvent.entityLiving instanceof EntitySpider) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, UT.Code.selectInArray(CS.RANDOM.nextInt(2), IL.Food_Cookie_Raisins, IL.Food_Cookie_Raisins, IL.Food_Cookie_Chocolate_Raisins).getWithName(1L, "Spider Cookie", new Object[0])));
            }
            if (aEvent.entityLiving instanceof EntityZombie) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, UT.Code.selectInArray(CS.RANDOM.nextInt(3), IL.Food_Pomeraisins, IL.Food_Raisins_Green, IL.Food_Raisins_Purple, IL.Food_Pomeraisins).getWithName(1L, "Member Berries", new Object[0])));
            }
        }
        if (aEntityClassName.equalsIgnoreCase("MoCEntityBoar")) {
            int tAmount = 1 + CS.RANDOM.nextInt(3);
            if (aEvent.lootingLevel > 0) {
                tAmount += CS.RANDOM.nextInt(aEvent.lootingLevel + 1);
            }
            while (tAmount-- > 0) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, aEvent.entityLiving.func_70027_ad() ? UT.Stacks.make(Items.field_151157_am, 1L, 0L) : UT.Stacks.make(Items.field_151147_al, 1L, 0L)));
            }
        } else if (aEntityClassName.equalsIgnoreCase("MoCEntityDeer")) {
            ItemStack tRaw = IL.TF_Venison_Raw.get(1L, UT.Stacks.make(MD.HaC, "venisonrawItem", 1L, 0));
            ItemStack tCooked = IL.TF_Venison_Cooked.get(1L, UT.Stacks.make(MD.HaC, "venisoncookedItem", 1L, 0));
            if (tRaw != null && tCooked != null) {
                int tAmount = 1 + CS.RANDOM.nextInt(3);
                if (aEvent.lootingLevel > 0) {
                    tAmount += CS.RANDOM.nextInt(aEvent.lootingLevel + 1);
                }
                while (tAmount-- > 0) {
                    aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, aEvent.entityLiving.func_70027_ad() ? tCooked : tRaw));
                }
            }
        } else if (aEntityClassName.equalsIgnoreCase("MoCEntityOstrich")) {
            int tAmount = 1 + CS.RANDOM.nextInt(3);
            if (aEvent.lootingLevel > 0) {
                tAmount += CS.RANDOM.nextInt(aEvent.lootingLevel + 1);
            }
            while (tAmount-- > 0) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, UT.Stacks.make(Items.field_151008_G, 1L, 0L)));
            }
        } else if (aEntityClassName.equalsIgnoreCase("MoCEntityWWolf") || aEntityClassName.equalsIgnoreCase("EntityTFMistWolf") || aEntityClassName.equalsIgnoreCase("EntityTFWinterWolf")) {
            int tAmount = 1 + CS.RANDOM.nextInt(4);
            if (aEvent.lootingLevel > 0) {
                tAmount += CS.RANDOM.nextInt(aEvent.lootingLevel + 1);
            }
            while (tAmount-- > 0) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, aEvent.entityLiving.func_70027_ad() ? IL.Food_DogMeat_Cooked.get(1L, new Object[0]) : IL.Food_DogMeat_Raw.get(1L, new Object[0])));
            }
        } else if (aEvent.entityLiving instanceof EntityWolf && !((EntityWolf)aEvent.entityLiving).func_70631_g_()) {
            int tAmount = CS.RANDOM.nextInt(3);
            if (aEvent.lootingLevel > 0) {
                tAmount += CS.RANDOM.nextInt(aEvent.lootingLevel + 1);
            }
            while (tAmount-- > 0) {
                aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, aEvent.entityLiving.func_70027_ad() ? IL.Food_DogMeat_Cooked.get(1L, new Object[0]) : IL.Food_DogMeat_Raw.get(1L, new Object[0])));
            }
        }
        for (EntityItem tEntity : aEvent.drops) {
            ItemStack tStack = tEntity.func_92059_d();
            if (tStack == null) continue;
            if (CS.RANDOM.nextInt(3) == 0 && !OM.is("listAllmeatsubstitute", tStack) && (OM.is("listAllmeatraw", tStack) || OM.is("listAllmeatcooked", tStack))) {
                ++tIntestinesAmount;
            }
            if (tStack.func_77973_b() == Items.field_151147_al) {
                switch (tRandomNumber % 3) {
                    case 0: {
                        UT.Stacks.set(tStack, IL.Food_Ham_Raw.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                        break;
                    }
                    case 1: {
                        UT.Stacks.set(tStack, IL.Food_Bacon_Raw.getWithNBT(UT.Code.bindStack(tStack.field_77994_a * (3 + CS.RANDOM.nextInt(3))), tStack.func_77978_p(), new Object[0]));
                    }
                }
            } else if (tStack.func_77973_b() == Items.field_151157_am) {
                switch (tRandomNumber % 3) {
                    case 0: {
                        UT.Stacks.set(tStack, IL.Food_Ham_Cooked.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                        break;
                    }
                    case 1: {
                        UT.Stacks.set(tStack, IL.Food_Bacon_Cooked.getWithNBT(UT.Code.bindStack(tStack.field_77994_a * (3 + CS.RANDOM.nextInt(3))), tStack.func_77978_p(), new Object[0]));
                    }
                }
            } else if (tStack.func_77973_b() == Items.field_151082_bd || IL.TF_Meef_Raw.equal(tStack, true, true)) {
                switch (tRandomNumber % 3) {
                    case 0: {
                        UT.Stacks.set(tStack, IL.Food_Rib_Raw.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                        break;
                    }
                    case 1: {
                        UT.Stacks.set(tStack, IL.Food_RibEyeSteak_Raw.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                    }
                }
            } else if (tStack.func_77973_b() == Items.field_151083_be || IL.TF_Meef_Cooked.equal(tStack, true, true)) {
                switch (tRandomNumber % 3) {
                    case 0: {
                        UT.Stacks.set(tStack, IL.Food_Rib_Cooked.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                        break;
                    }
                    case 1: {
                        UT.Stacks.set(tStack, IL.Food_RibEyeSteak_Cooked.getWithNBT(tStack.field_77994_a, tStack.func_77978_p(), new Object[0]));
                    }
                }
            }
            tEntity.func_92058_a(tStack);
            ++tRandomNumber;
        }
        while (tIntestinesAmount-- > 0) {
            aEvent.drops.add(new EntityItem(aEvent.entityLiving.field_70170_p, aEvent.entityLiving.field_70165_t, aEvent.entityLiving.field_70163_u, aEvent.entityLiving.field_70161_v, IL.Food_Scrap_Meat.get(1L, new Object[0])));
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent aEvent) {
        if (!aEvent.entity.field_70170_p.field_72995_K && aEvent.entity instanceof EntityPlayer && (UT.Stacks.equal(((EntityPlayer)aEvent.entity).func_71045_bC(), UT.Stacks.make(CS.ToolsGT.sMetaTool, 1L, 64L), true) || UT.Stacks.equal(((EntityPlayer)aEvent.entity).func_71045_bC(), UT.Stacks.make(CS.ToolsGT.sMetaTool, 1L, 1012L), true))) {
            aEvent.distance *= 2.0f;
        }
    }

    @SubscribeEvent
    public void onEntityConstructingEvent(EntityEvent.EntityConstructing aEvent) {
        if (Abstract_Mod.sFinalized < Abstract_Mod.sModCountUsingGTAPI) {
            return;
        }
        if (aEvent.entity instanceof EntityOcelot) {
            this.mOcelots.add((EntityOcelot)aEvent.entity);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent aEvent) {
        if (aEvent.side.isServer() && aEvent.phase == TickEvent.Phase.START) {
            try {
                Iterator tIterator = this.mOcelots.iterator();
                while (tIterator.hasNext()) {
                    EntityOcelot tOcelot = (EntityOcelot)tIterator.next();
                    if (tOcelot != null && tOcelot.field_70714_bg != null) {
                        tOcelot.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)tOcelot, 0.6, CS.ItemsGT.sMultiItemCans, true));
                    }
                    tIterator.remove();
                }
                this.mOcelots.clear();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent aEvent) {
        if (aEvent.side.isServer() && aEvent.phase == TickEvent.Phase.START && aEvent.world.func_82737_E() % 100L == 0L && (this.mItemDespawnTime != 6000 || this.mMaxEqualEntitiesAtOneSpot > 0)) {
            for (int i = 0; i < aEvent.world.field_72996_f.size(); ++i) {
                if (!(aEvent.world.field_72996_f.get(i) instanceof Entity)) continue;
                Entity tEntity = (Entity)aEvent.world.field_72996_f.get(i);
                if (tEntity instanceof EntityItem && this.mItemDespawnTime != 6000 && ((EntityItem)tEntity).lifespan == 6000) {
                    ((EntityItem)tEntity).lifespan = this.mItemDespawnTime;
                    continue;
                }
                if (!(tEntity instanceof EntityLivingBase) || this.mMaxEqualEntitiesAtOneSpot <= 0 || tEntity instanceof EntityPlayer || !((EntityLivingBase)tEntity).func_70104_M() || !(((EntityLivingBase)tEntity).func_110143_aJ() > 0.0f)) continue;
                List tList = tEntity.field_70170_p.func_72839_b(tEntity, tEntity.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
                Class<?> tClass = tEntity.getClass();
                int tEntityCount = 1;
                if (tList != null) {
                    for (int j = 0; j < tList.size(); ++j) {
                        if (tList.get(j) == null || tList.get(j).getClass() != tClass) continue;
                        ++tEntityCount;
                    }
                }
                if (tEntityCount <= this.mMaxEqualEntitiesAtOneSpot) continue;
                tEntity.func_70097_a(DamageSource.field_76368_d, (float)(tEntityCount - this.mMaxEqualEntitiesAtOneSpot));
            }
        }
    }

    public Fluid addAutogeneratedMoltenFluid(OreDictMaterial aMaterial, boolean aSimple, boolean aAcid) {
        return this.addFluid("molten." + aMaterial.mNameInternal.toLowerCase(), "molten.autogenerated", "Molten " + aMaterial.mNameLocal, aMaterial, aMaterial.mRGBaLiquid, 1, 144L, aMaterial.mMeltingPoint <= 0L ? 1000L : aMaterial.mMeltingPoint, aSimple, aAcid, null, null, 0);
    }

    public Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, boolean aSimple, boolean aAcid) {
        return this.addFluid(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, aSimple, aAcid, null, null, 0);
    }

    public Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, boolean aSimple, boolean aAcid, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount) {
        return this.addFluid(aName, aName.toLowerCase(), aLocalized, aMaterial, null, aState, aAmountPerUnit, aTemperatureK, aSimple, aAcid, aFullContainer, aEmptyContainer, aFluidAmount);
    }

    public Fluid addFluid(String aName, String aTexture, String aLocalized, OreDictMaterial aMaterial, short[] aRGBa, int aState, long aAmountPerUnit, long aTemperatureK, boolean aSimple, boolean aAcid, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount) {
        aName = aName.toLowerCase();
        FluidGT rFluid = new FluidGT(aName, aTexture, aRGBa != null ? aRGBa : CS.UNCOLOURED, aTemperatureK);
        LH.add(rFluid.getUnlocalizedName(), aLocalized == null ? aName : aLocalized);
        if (aSimple) {
            CS.FluidsGT.SIMPLE.add(aName);
        }
        if (aAcid) {
            CS.FluidsGT.ACID.add(aName);
        }
        if (FluidRegistry.registerFluid((Fluid)rFluid)) {
            switch (aState) {
                case 0: {
                    rFluid.setGaseous(false);
                    rFluid.setViscosity(10000);
                    break;
                }
                case 1: 
                case 4: {
                    rFluid.setGaseous(false);
                    rFluid.setViscosity(1000);
                    break;
                }
                case 2: {
                    rFluid.setGaseous(true);
                    rFluid.setDensity(-100);
                    rFluid.setViscosity(200);
                    break;
                }
                case 3: {
                    rFluid.setGaseous(true);
                    rFluid.setDensity(-10000);
                    rFluid.setViscosity(10);
                    rFluid.setLuminosity(15);
                }
            }
        } else {
            rFluid = FluidRegistry.getFluid((String)aName);
            if (rFluid.getTemperature() == new Fluid("test").getTemperature() || rFluid.getTemperature() <= 0) {
                rFluid.setTemperature(UT.Code.bindInt(aTemperatureK));
            }
        }
        if (aMaterial != null) {
            switch (aState) {
                case 1: {
                    aMaterial.liquid(new FluidStack((Fluid)rFluid, UT.Code.bindInt(aAmountPerUnit)));
                    break;
                }
                case 2: {
                    aMaterial.gas(new FluidStack((Fluid)rFluid, UT.Code.bindInt(aAmountPerUnit)));
                    break;
                }
                case 3: {
                    aMaterial.plasma(new FluidStack((Fluid)rFluid, UT.Code.bindInt(aAmountPerUnit)));
                }
            }
        }
        if (aFullContainer != null && aEmptyContainer != null && !FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack((Fluid)rFluid, aFluidAmount), (ItemStack)aFullContainer, (ItemStack)aEmptyContainer)) {
            Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, (long)Math.max(aFluidAmount / 64, 16), aFullContainer, CS.NF, new FluidStack((Fluid)rFluid, aFluidAmount), UT.Stacks.container(aFullContainer, false));
        }
        return rFluid;
    }

    public boolean downloadSupporterListSilverFromMain() {
        try {
            Scanner tScanner = new Scanner(new URL("http://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlist.txt").openStream());
            while (tScanner.hasNextLine()) {
                this.mSupporterListSilver.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
            return this.mSupporterListSilver.size() > 3;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.DEB);
            return false;
        }
    }

    public boolean downloadSupporterListSilverFromDropBox() {
        try {
            Scanner tScanner = new Scanner(new URL("https://dl.dropboxusercontent.com/u/88825306/CapeList.txt").openStream());
            while (tScanner.hasNextLine()) {
                this.mSupporterListSilver.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
            return this.mSupporterListSilver.size() > 3;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.DEB);
            return false;
        }
    }

    public boolean downloadSupporterListGoldFromMain() {
        try {
            Scanner tScanner = new Scanner(new URL("http://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlistgold.txt").openStream());
            while (tScanner.hasNextLine()) {
                this.mSupporterListGold.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
            return this.mSupporterListGold.size() > 3;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.DEB);
            return false;
        }
    }

    public boolean downloadSupporterListGoldFromDropBox() {
        try {
            Scanner tScanner = new Scanner(new URL("https://dl.dropboxusercontent.com/u/88825306/CapeListGold.txt").openStream());
            while (tScanner.hasNextLine()) {
                this.mSupporterListGold.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
            return this.mSupporterListGold.size() > 3;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.DEB);
            return false;
        }
    }
}

