/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.api.Abstract_Proxy;
import gregapi.block.behaviors.Drops;
import gregapi.block.behaviors.Drops_SmallOre;
import gregapi.block.prefixblock.PrefixBlock;
import gregapi.block.prefixblock.PrefixBlockItem;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.item.prefixitem.PrefixItem;
import gregapi.network.IPacket;
import gregapi.network.NetworkHandler;
import gregapi.old.Textures;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapReplicator;
import gregapi.render.BlockTextureCopied;
import gregapi.util.OM;
import gregapi.util.UT;
import gregtech.GT_Proxy;
import gregtech.entities.GT_Entity_Arrow;
import gregtech.entities.GT_Entity_Arrow_Potion;
import gregtech.items.tools.early.GT_Tool_Scoop;
import gregtech.loaders.a.Loader_Blocks;
import gregtech.loaders.a.Loader_Fluids;
import gregtech.loaders.a.Loader_Items;
import gregtech.loaders.a.Loader_OreDictionary;
import gregtech.loaders.a.Loader_Ores;
import gregtech.loaders.a.Loader_Others;
import gregtech.loaders.a.Loader_PrefixBlocks;
import gregtech.loaders.a.Loader_Tools;
import gregtech.loaders.b.Loader_Books;
import gregtech.loaders.b.Loader_CoverBehaviors;
import gregtech.loaders.b.Loader_Fuels;
import gregtech.loaders.b.Loader_ItemIterator;
import gregtech.loaders.b.Loader_MultiTileEntities;
import gregtech.loaders.b.Loader_OreProcessing;
import gregtech.loaders.b.Loader_Worldgen;
import gregtech.loaders.c.Loader_BlockResistance;
import gregtech.loaders.c.Loader_Crops;
import gregtech.loaders.c.Loader_Loot;
import gregtech.loaders.c.Loader_Recipes_AppliedEnergistics;
import gregtech.loaders.c.Loader_Recipes_Atum;
import gregtech.loaders.c.Loader_Recipes_BiomesOPlenty;
import gregtech.loaders.c.Loader_Recipes_Books;
import gregtech.loaders.c.Loader_Recipes_Botania;
import gregtech.loaders.c.Loader_Recipes_BuildCraft;
import gregtech.loaders.c.Loader_Recipes_Copying;
import gregtech.loaders.c.Loader_Recipes_ExtraBiomesXL;
import gregtech.loaders.c.Loader_Recipes_ExtraUtilities;
import gregtech.loaders.c.Loader_Recipes_Factorization;
import gregtech.loaders.c.Loader_Recipes_ForbiddenMagic;
import gregtech.loaders.c.Loader_Recipes_Forestry;
import gregtech.loaders.c.Loader_Recipes_GregTech;
import gregtech.loaders.c.Loader_Recipes_HarvestCraft;
import gregtech.loaders.c.Loader_Recipes_ImmersiveEngineering;
import gregtech.loaders.c.Loader_Recipes_IndustrialCraft;
import gregtech.loaders.c.Loader_Recipes_JABBA;
import gregtech.loaders.c.Loader_Recipes_Mariculture;
import gregtech.loaders.c.Loader_Recipes_MineFactoryReloaded;
import gregtech.loaders.c.Loader_Recipes_MoCreatures;
import gregtech.loaders.c.Loader_Recipes_ProjectRed;
import gregtech.loaders.c.Loader_Recipes_Railcraft;
import gregtech.loaders.c.Loader_Recipes_RecipeMapHandlers;
import gregtech.loaders.c.Loader_Recipes_Reika;
import gregtech.loaders.c.Loader_Recipes_Replacing;
import gregtech.loaders.c.Loader_Recipes_Thaumcraft;
import gregtech.loaders.c.Loader_Recipes_ThermalExpansion;
import gregtech.loaders.c.Loader_Recipes_TwilightForest;
import gregtech.loaders.c.Loader_Recipes_Vanilla;
import gregtech.loaders.c.Loader_RecyclerBlacklist;
import gregtech.loaders.c.Loader_ScrapboxDrops;
import gregtech.loaders.c.Loader_Thread_Decomposition;
import gregtech.loaders.c.Loader_Thread_Extruder;
import gregtech.old.Loader_CircuitBehaviors;
import gregtech.old.Loader_Covers;
import gregtech.old.Loader_Sonictron;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="gregtech", name="GregTech", version="GT6-MC1710", dependencies="required-after:gregapi_post")
public class GT_Mod
extends Abstract_Mod {
    @SidedProxy(modId="gregtech", clientSide="gregtech.GT_Client", serverSide="gregtech.GT_Server")
    public static GT_Proxy gregtechproxy;
    public static int MIN_IC2;
    public static int MAX_IC2;
    private static final Collection<String> KNOWN_OREDICT_NAMES;

    public GT_Mod() {
        CS.GT = this;
        CS.NW_GT = new NetworkHandler(MD.GT.mID, "GREG", new IPacket[0]);
        Textures.BlockIcons.VOID.toString();
        Textures.ItemIcons.VOID.toString();
    }

    @Override
    public void onModPreInit2(FMLPreInitializationEvent aEvent) {
        Configuration tMainConfig;
        block9: {
            tMainConfig = new Configuration(new File(CS.DirectoriesGT.CONFIG_GT, "GregTech.cfg"));
            tMainConfig.load();
            CS.OUT.println(this.getModNameForLog() + ": Setting Configs");
            GT_Mod.gregtechproxy.mMaxEqualEntitiesAtOneSpot = tMainConfig.get("general", "MaxEqualEntitiesAtOneSpot", 3).getInt(3);
            GT_Mod.gregtechproxy.mSkeletonsShootGTArrows = tMainConfig.get("general", "SkeletonsShootGTArrows", 16).getInt(16);
            GT_Mod.gregtechproxy.mFlintChance = tMainConfig.get("general", "FlintAndSteelChance", 30).getInt(30);
            GT_Mod.gregtechproxy.mItemDespawnTime = tMainConfig.get("general", "ItemDespawnTime", 6000).getInt(6000);
            GT_Mod.gregtechproxy.mDisableVanillaOres = tMainConfig.get("general", "DisableVanillaOres", true).getBoolean(true);
            GT_Mod.gregtechproxy.mIncreaseDungeonLoot = tMainConfig.get("general", "IncreaseDungeonLoot", true).getBoolean(true);
            GT_Mod.gregtechproxy.mNerfedVanillaTools = tMainConfig.get("general", "SmallerVanillaToolDurability", true).getBoolean(true);
            if (tMainConfig.get("general", "EnsureToBeLoadedLast", true).getBoolean(true)) {
                try {
                    CS.OUT.println(this.getModNameForLog() + ": Sorting GregTech to the end of the Mod List for further processing.");
                    LoadController tLoadController = (LoadController)UT.Reflection.getFieldContent(Loader.instance(), "modController", true, true);
                    List tModList = tLoadController.getActiveModList();
                    ArrayList<ModContainer> tNewModsList = new ArrayList<ModContainer>(tModList.size());
                    ModContainer tGregTech = null;
                    for (int i = 0; i < tModList.size(); i = (int)((short)(i + 1))) {
                        ModContainer tMod = (ModContainer)tModList.get(i);
                        if (tMod.getModId().equalsIgnoreCase(MD.GT.mID)) {
                            tGregTech = tMod;
                            continue;
                        }
                        tNewModsList.add(tMod);
                    }
                    if (tGregTech != null) {
                        tNewModsList.add(tGregTech);
                    }
                    UT.Reflection.getField(tLoadController, "activeModList", true, true).set(tLoadController, tNewModsList);
                }
                catch (Throwable e) {
                    if (!CS.D1) break block9;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        CS.OUT.println(this.getModNameForLog() + ": Saving Main Config");
        tMainConfig.save();
        if (GT_API.sCompatIC2 != null) {
            block10: {
                CS.OUT.println(this.getModNameForLog() + ": Removing all original Scrapbox Drops.");
                try {
                    UT.Reflection.getField("ic2.core.item.ItemScrapbox$Drop", "topChance", true, true).set(null, 0);
                    ((List)UT.Reflection.getFieldContent(UT.Reflection.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "drops", true, true)).clear();
                }
                catch (Throwable e) {
                    if (!CS.D1) break block10;
                    e.printStackTrace(CS.ERR);
                }
            }
            CS.OUT.println(this.getModNameForLog() + ": Adding Scrap with a Weight of 200.0F to the Scrapbox Drops.");
            GT_API.sCompatIC2.scrapbox(200.0f, IL.IC2_Scrap.get(1L, new Object[0]));
        }
        EntityRegistry.registerModEntity(GT_Entity_Arrow.class, (String)"GT_Entity_Arrow", (int)1, (Object)CS.GT, (int)160, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(GT_Entity_Arrow_Potion.class, (String)"GT_Entity_Arrow_Potion", (int)2, (Object)CS.GT, (int)160, (int)1, (boolean)true);
        OP.ingot.disableItemGeneration(MT.Chocolate, MT.Cheese, MT.MeatRaw, MT.MeatCooked, MT.FishRaw, MT.FishCooked, MT.Tofu, MT.SoylentGreen);
        OP.bottle.disableItemGeneration(MT.Milk, MT.Honey, MT.Honeydew, MT.HolyWater, MT.SunflowerOil, MT.OliveOil, MT.NutOil, MT.Creosote);
        new Loader_OreDictionary().run();
        new Loader_Fluids().run();
        new Loader_Tools().run();
        new Loader_Items().run();
        new Loader_PrefixBlocks().run();
        new Loader_Blocks().run();
        new Loader_Ores().run();
        new Loader_Others().run();
        new Loader_CircuitBehaviors().run();
        new Loader_CoverBehaviors().run();
        new Loader_Sonictron().run();
    }

    @Override
    public void onModInit2(FMLInitializationEvent aEvent) {
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || UT.Stacks.meta(tData.filledContainer) != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        OP.chemtube.mContainerItem = OP.chemtube.mat(MT.Empty, 1L);
        Block tAtumStone = UT.Stacks.block(MD.ATUM, "tile.stone");
        Block tAtumCobble = UT.Stacks.block(MD.ATUM, "tile.cobble");
        Block tAtumSand = UT.Stacks.block(MD.ATUM, "tile.sand");
        if (tAtumCobble != CS.NB && tAtumStone != CS.NB) {
            CS.BlocksGT.oreAtumLimestone = new PrefixBlock(MD.GT.mID, MD.GT.mID, "gt.meta.ore.normal.atum", OP.oreLimestone, null, null, null, BlockTextureCopied.get(tAtumStone, 6, 0), tAtumStone.func_149688_o(), tAtumStone.field_149762_H, "pickaxe", 2.0f, 2.0f, 0, 0, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, false, false, false, false, true, true, false, false, true, true, true, true, true, false);
            CS.BlocksGT.oreBrokenAtumLimestone = new PrefixBlock(MD.GT.mID, MD.GT.mID, "gt.meta.ore.broken.atum", OP.oreLimestone, null, null, null, BlockTextureCopied.get(tAtumCobble, 6, 0), tAtumCobble.func_149688_o(), tAtumCobble.field_149762_H, "pickaxe", 1.0f, 1.0f, -1, 0, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true, false, false, false, true, true, false, false, true, true, true, true, true, false);
            CS.BlocksGT.oreSmallAtumLimestone = new PrefixBlock(MD.GT.mID, MD.GT.mID, "gt.meta.ore.small.atum", OP.oreSmall, null, null, new Drops_SmallOre(MT.Limestone), BlockTextureCopied.get(tAtumStone, 6, 0), tAtumStone.func_149688_o(), tAtumStone.field_149762_H, "pickaxe", 2.0f, 2.0f, -1, 0, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, false, false, false, false, true, true, false, false, true, true, true, true, true, false);
            CS.BlocksGT.oreAtumLimestone.mDrops = new Drops((Block)CS.BlocksGT.oreBrokenAtumLimestone, (Block)CS.BlocksGT.oreAtumLimestone);
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                CS.BlocksGT.stoneToBrokenOres.put(new ItemStackContainer(tAtumStone, 1L, (long)i), CS.BlocksGT.oreBrokenAtumLimestone);
                CS.BlocksGT.stoneToNormalOres.put(new ItemStackContainer(tAtumStone, 1L, (long)i), CS.BlocksGT.oreAtumLimestone);
                CS.BlocksGT.stoneToSmallOres.put(new ItemStackContainer(tAtumStone, 1L, (long)i), CS.BlocksGT.oreSmallAtumLimestone);
            }
        }
        if (tAtumSand != CS.NB) {
            CS.BlocksGT.oreAtumSand = new PrefixBlock(MD.GT.mID, MD.GT.mID, "gt.meta.ore.normal.sand.atum", OP.ore, null, null, null, BlockTextureCopied.get(tAtumSand, 6, 0), tAtumSand.func_149688_o(), tAtumSand.field_149762_H, "shovel", 2.0f, 2.0f, 0, 0, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, false, false, false, false, true, true, false, false, true, true, true, true, true, false);
            CS.BlocksGT.oreSmallAtumSand = new PrefixBlock(MD.GT.mID, MD.GT.mID, "gt.meta.ore.small.sand.atum", OP.oreSmall, null, null, new Drops_SmallOre(MT.Limestone), BlockTextureCopied.get(tAtumSand, 6, 0), tAtumSand.func_149688_o(), tAtumSand.field_149762_H, "shovel", 2.0f, 2.0f, -1, 0, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, false, false, false, false, true, true, false, false, true, true, true, true, true, false);
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                CS.BlocksGT.stoneToNormalOres.put(new ItemStackContainer(tAtumSand, 1L, (long)i), CS.BlocksGT.oreAtumSand);
                CS.BlocksGT.stoneToBrokenOres.put(new ItemStackContainer(tAtumSand, 1L, (long)i), CS.BlocksGT.oreAtumSand);
                CS.BlocksGT.stoneToSmallOres.put(new ItemStackContainer(tAtumSand, 1L, (long)i), CS.BlocksGT.oreSmallAtumSand);
            }
        }
        if (IL.TC_Silverwood_Log.exists()) {
            Recipe.RecipeMap.sCokeOvenRecipes.addRecipe1(true, 0L, 3600L, IL.TC_Silverwood_Log.get(1L, new Object[0]), CS.NF, MT.Creosote.liquid(420076800L, false), OP.gem.mat(MT.Charcoal, 4L));
        }
        if (IL.TC_Greatwood_Log.exists()) {
            Recipe.RecipeMap.sCokeOvenRecipes.addRecipe1(true, 0L, 2700L, IL.TC_Greatwood_Log.get(1L, new Object[0]), CS.NF, MT.Creosote.liquid(210038400L, false), OP.gem.mat(MT.Charcoal, 2L));
        }
        new Loader_MultiTileEntities().run();
        new Loader_Books().run();
        new Loader_OreProcessing().run();
        new Loader_Worldgen().run();
        new Loader_ItemIterator().run();
    }

    @Override
    public void onModPostInit2(FMLPostInitializationEvent aEvent) {
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || UT.Stacks.meta(tData.filledContainer) != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        Items.field_151105_aU.func_77625_d(64);
        Items.field_151135_aq.func_77625_d(8);
        Items.field_151139_aw.func_77625_d(8);
        new Loader_Fuels().run();
        new Loader_Loot().run();
        new Loader_BlockResistance().run();
        new Loader_RecyclerBlacklist().run();
        new Loader_ScrapboxDrops().run();
        new Loader_Crops().run();
        new Loader_Covers().run();
        ArrayListNoNulls<Thread> tThreadList = new ArrayListNoNulls<Thread>(false, new Thread(new Loader_Thread_Extruder()), new Thread(new Loader_Thread_Decomposition()));
        for (Thread tThread : tThreadList) {
            tThread.start();
        }
        new Loader_Recipes_Vanilla().run();
        new Loader_Recipes_GregTech().run();
        new Loader_Recipes_IndustrialCraft().run();
        new Loader_Recipes_BuildCraft().run();
        new Loader_Recipes_Railcraft().run();
        new Loader_Recipes_ThermalExpansion().run();
        new Loader_Recipes_Forestry().run();
        new Loader_Recipes_Atum().run();
        new Loader_Recipes_JABBA().run();
        new Loader_Recipes_Factorization().run();
        new Loader_Recipes_MineFactoryReloaded().run();
        new Loader_Recipes_AppliedEnergistics().run();
        new Loader_Recipes_ProjectRed().run();
        new Loader_Recipes_HarvestCraft().run();
        new Loader_Recipes_MoCreatures().run();
        new Loader_Recipes_TwilightForest().run();
        new Loader_Recipes_ExtraBiomesXL().run();
        new Loader_Recipes_BiomesOPlenty().run();
        new Loader_Recipes_Mariculture().run();
        new Loader_Recipes_ImmersiveEngineering().run();
        new Loader_Recipes_Reika().run();
        new Loader_Recipes_Thaumcraft().run();
        new Loader_Recipes_ForbiddenMagic().run();
        new Loader_Recipes_Botania().run();
        new Loader_Recipes_ExtraUtilities().run();
        new Loader_Recipes_Books().run();
        new Loader_Recipes_Replacing().run();
        new Loader_Recipes_Copying().run();
        new Loader_Recipes_RecipeMapHandlers().run();
        ItemStack tLignite = UT.Stacks.make(MD.UB, "ligniteCoal", 1L, 0);
        if (UT.Stacks.valid(tLignite)) {
            GT_ModHandler.removeRecipe(tLignite, tLignite, tLignite, tLignite, tLignite, tLignite, tLignite, tLignite, tLignite);
        }
        for (Thread tThread : tThreadList) {
            try {
                tThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace(CS.ERR);
            }
        }
        Block tBlock = UT.Stacks.block(MD.FR, "beehives", CS.NB);
        if (tBlock != CS.NB) {
            tBlock.setHarvestLevel("scoop", 0);
            GT_Tool_Scoop.sBeeHiveMaterial = tBlock.func_149688_o();
        }
        CS.OUT.println(this.getModNameForLog() + ": Adding Fake Recipes for NEI");
        if (IL.FR_Bee_Drone.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Bee_Drone.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Bee_Drone.getWithName(1L, "Scanned Drone", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Bee_Princess.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Bee_Princess.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Bee_Princess.getWithName(1L, "Scanned Princess", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Bee_Queen.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Bee_Queen.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Bee_Queen.getWithName(1L, "Scanned Queen", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Tree_Sapling.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Tree_Sapling.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Tree_Sapling.getWithName(1L, "Scanned Sapling", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Butterfly.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Butterfly.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Butterfly.getWithName(1L, "Scanned Butterfly", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Larvae.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Larvae.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Larvae.getWithName(1L, "Scanned Larvae", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Serum.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Serum.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Serum.getWithName(1L, "Scanned Serum", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_Caterpillar.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_Caterpillar.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_Caterpillar.getWithName(1L, "Scanned Caterpillar", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.FR_PollenFertile.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.FR_PollenFertile.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.FR_PollenFertile.getWithName(1L, "Scanned Pollen", new Object[0])}, null, new FluidStack[]{MT.Honey.liquid(21003840L, true)}, null, 500L, 2L, 0L);
        }
        if (IL.IC2_Crop_Seeds.get(1L, new Object[0]) != null) {
            Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.IC2_Crop_Seeds.getWildcard(1L, new Object[0])}, new ItemStack[]{IL.IC2_Crop_Seeds.getWithName(1L, "Scanned Seeds", new Object[0])}, null, null, null, 160L, 8L, 0L);
        }
        Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make(Items.field_151164_bB, 1L, 32767L)}, new ItemStack[]{IL.Tool_DataStick.getWithName(1L, "Scanned Book Data", new Object[0])}, IL.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128L, 32L, 0L);
        Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make((Item)Items.field_151098_aY, 1L, 32767L)}, new ItemStack[]{IL.Tool_DataStick.getWithName(1L, "Scanned Map Data", new Object[0])}, IL.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128L, 32L, 0L);
        Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.Tool_DataOrb.getWithName(1L, "Orb to overwrite", new Object[0])}, new ItemStack[]{IL.Tool_DataOrb.getWithName(1L, "Copy of the Orb", new Object[0])}, IL.Tool_DataOrb.getWithName(0L, "Orb to copy", new Object[0]), null, null, 512L, 32L, 0L);
        Recipe.RecipeMap.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{IL.Tool_DataStick.getWithName(1L, "Stick to overwrite", new Object[0])}, new ItemStack[]{IL.Tool_DataStick.getWithName(1L, "Copy of the Stick", new Object[0])}, IL.Tool_DataStick.getWithName(0L, "Stick to copy", new Object[0]), null, null, 128L, 32L, 0L);
        Recipe.RecipeMap.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{OP.dust.mat(MT.Redstone, 1L)}, new ItemStack[]{UT.Stacks.make(Blocks.field_150343_Z, 1L, 0L)}, null, null, null, 128L, 32L, 0L);
        for (ItemStack tStack : OreDictManager.getOres("bookWritten", false)) {
            Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{tStack, IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), tStack}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 512L, 16L, 0L);
        }
        Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{IL.Paper_Printed_Pages.get(1L, new Object[0]), IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), IL.Paper_Printed_Pages.get(1L, new Object[0])}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 512L, 16L, 0L);
        Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{IL.Paper_Printed_Pages_Many.get(1L, new Object[0]), IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), IL.Paper_Printed_Pages_Many.get(1L, new Object[0])}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 512L, 16L, 0L);
        for (ItemStack tStack : OreDictManager.getOres("gt:canvas", false)) {
            Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{tStack, IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), tStack}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 64L, 16L, 0L);
        }
        Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make(Blocks.field_150462_ai, 1L, 0L, "ANY BLOCK"), IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), UT.Stacks.make(Blocks.field_150462_ai, 1L, 0L, "ANY BLOCK")}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 512L, 16L, 0L);
        Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make((Item)Items.field_151098_aY, 1L, 32767L), IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), UT.Stacks.make((Item)Items.field_151098_aY, 1L, 32767L)}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 64L, 16L, 0L);
        Recipe.RecipeMap.sScannerVisualsRecipes.addFakeRecipe(false, new ItemStack[]{IL.Paper_Blueprint_Used.get(1L, new Object[0]), IL.USB_Stick_1.get(1L, new Object[0])}, new ItemStack[]{IL.USB_Stick_1.get(1L, new Object[0]), IL.Paper_Blueprint_Used.get(1L, new Object[0])}, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, 64L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addRecipe1(true, 16L, 256L, UT.Stacks.make(Items.field_151122_aG, 1L, 32767L), CS.DYE_FLUIDS_CHEMICAL[0], CS.NF, UT.Books.getBookWithTitle("Manual_Printer", UT.Stacks.make(Items.field_151164_bB, 1L, 0L)));
        for (ItemStack tStack : OreDictManager.getOres("gt:canvas", false)) {
            Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{tStack, IL.USB_Stick_1.getWithName(0L, "Containing scanned Block", new Object[0])}, new ItemStack[]{tStack}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[11], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[13], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[6], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true)}, CS.ZL_FLUIDSTACK, 64L, 16L, 0L);
        }
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{IL.Paper_Punch_Card_Empty.get(1L, new Object[0]), IL.USB_Stick_1.getWithName(0L, "Containing scanned Punchcard", new Object[0])}, new ItemStack[]{IL.Paper_Punch_Card_Encoded.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true)}, CS.ZL_FLUIDSTACK, 32L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{IL.Paper_Blueprint_Empty.get(1L, new Object[0]), IL.USB_Stick_1.getWithName(0L, "Containing scanned Blueprint", new Object[0])}, new ItemStack[]{IL.Paper_Blueprint_Used.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[15], 1L, 9L, true)}, CS.ZL_FLUIDSTACK, 32L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make(Items.field_151121_aF, 1L, 32767L), IL.USB_Stick_1.getWithName(0L, "Containing scanned Blueprint", new Object[0])}, new ItemStack[]{IL.Paper_Blueprint_Used.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[4], 1L, 1L, true)}, CS.ZL_FLUIDSTACK, 128L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make(Items.field_151121_aF, 3L, 32767L), IL.USB_Stick_1.getWithName(0L, "Containing scanned Book", new Object[0])}, new ItemStack[]{IL.Paper_Printed_Pages.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 2L, true)}, CS.ZL_FLUIDSTACK, 512L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make(Items.field_151121_aF, 6L, 32767L), IL.USB_Stick_1.getWithName(0L, "Containing large scanned Book", new Object[0])}, new ItemStack[]{IL.Paper_Printed_Pages_Many.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 1L, true)}, CS.ZL_FLUIDSTACK, 1024L, 16L, 0L);
        Recipe.RecipeMap.sPrinterRecipes.addFakeRecipe(false, new ItemStack[]{UT.Stacks.make((Item)Items.field_151148_bJ, 1L, 32767L), IL.USB_Stick_1.getWithName(0L, "Containing scanned Map", new Object[0])}, new ItemStack[]{UT.Stacks.make((Item)Items.field_151098_aY, 1L, 0L)}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[11], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[13], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[6], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true)}, CS.ZL_FLUIDSTACK, 64L, 16L, 0L);
        if (CS.CODE_CLIENT) {
            for (OreDictMaterial aMaterial : OreDictMaterial.ALLOYS) {
                for (IOreDictConfigurationComponent tAlloy : aMaterial.mAlloyCreationRecipes) {
                    boolean temp = true;
                    ArrayListNoNulls<ItemStack> tDusts = new ArrayListNoNulls<ItemStack>();
                    ArrayListNoNulls<ItemStack> tIngots = new ArrayListNoNulls<ItemStack>();
                    ArrayListNoNulls<Long> tMeltingPoints = new ArrayListNoNulls<Long>();
                    for (OreDictMaterialStack tMaterial : tAlloy.getUndividedComponents()) {
                        tMeltingPoints.add(tMaterial.mMaterial.mMeltingPoint);
                        if (!tDusts.add(OM.dustOrIngot(tMaterial.mMaterial, tMaterial.mAmount))) {
                            temp = false;
                            break;
                        }
                        tIngots.add(OM.ingotOrDust(tMaterial.mMaterial, tMaterial.mAmount));
                    }
                    Collections.sort(tMeltingPoints);
                    if (!temp) continue;
                    Recipe.RecipeMap.sCrucibleAlloying.addFakeRecipe(false, tDusts.toArray(CS.ZL_ITEMSTACK), new ItemStack[]{OM.ingotOrDust(aMaterial, tAlloy.getCommonDivider() * 420076800L)}, null, null, null, null, 0L, 0L, tMeltingPoints.size() > 1 ? Math.max((Long)tMeltingPoints.get(tMeltingPoints.size() - 2), aMaterial.mMeltingPoint) : aMaterial.mMeltingPoint);
                    Recipe.RecipeMap.sCrucibleAlloying.addFakeRecipe(false, tIngots.toArray(CS.ZL_ITEMSTACK), new ItemStack[]{OM.ingotOrDust(aMaterial, tAlloy.getCommonDivider() * 420076800L)}, null, null, null, null, 0L, 0L, tMeltingPoints.size() > 1 ? Math.max((Long)tMeltingPoints.get(tMeltingPoints.size() - 2), aMaterial.mMeltingPoint) : aMaterial.mMeltingPoint);
                }
            }
            for (OreDictMaterial aMaterial : OreDictMaterial.MATERIAL_ARRAY) {
                Recipe tRecipe;
                if (aMaterial == null || (tRecipe = RecipeMapReplicator.getReplicatorRecipe(aMaterial, IL.USB_Stick_3.getWithName(0L, "Mat Data: " + aMaterial.getLocal(), new Object[0]))) == null) continue;
                Recipe.RecipeMap.sReplicatorRecipes.addFakeRecipe(false, tRecipe);
            }
        }
    }

    @Override
    public void onModServerStarting2(FMLServerStartingEvent aEvent) {
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() != Items.field_151068_bn || UT.Stacks.meta(tData.filledContainer) != 0) continue;
            tData.fluid.amount = 0;
            break;
        }
        CS.ORD.println("============================");
        CS.ORD.println("Outputting Unknown Materials");
        CS.ORD.println("============================");
        for (String tUnknown : OreDictManager.INSTANCE.getUnknownMaterials()) {
            if (KNOWN_OREDICT_NAMES.contains(tUnknown)) continue;
            CS.ORD.println(tUnknown);
        }
        CS.ORD.println("============================");
        if (CS.CODE_CLIENT) {
            CS.ORD.println("============================");
            CS.ORD.println("Outputting Colors of unknown Materials");
            CS.ORD.println("============================");
            for (OreDictMaterial tUnknown : OreDictMaterial.MATERIAL_MAP.values()) {
                if (tUnknown == null || !tUnknown.contains(TD.Properties.UNUSED_MATERIAL) || tUnknown.contains(TD.Properties.IGNORE_IN_COLOR_LOG)) continue;
                for (ItemStackContainer aStack : tUnknown.mRegisteredItems) {
                    short[] tRGB;
                    ItemStack tStack = aStack.toStack();
                    if (!UT.Stacks.valid(tStack) || UT.Stacks.block(aStack) != CS.NB || tStack.func_77973_b() instanceof PrefixItem || tStack.func_77973_b() instanceof PrefixBlockItem || (tRGB = UT.Code.color(tStack)) == null || tRGB == CS.UNCOLOURED) continue;
                    CS.ORD.println(tUnknown.mNameInternal + "  -  RGB: " + tRGB[0] + ", " + tRGB[1] + ", " + tRGB[2] + "  -  " + UT.Stacks.names(tStack));
                }
            }
            CS.ORD.println("============================");
        }
        CS.ORD.println("================================");
        CS.ORD.println("Outputting Unknown OreDict Names");
        CS.ORD.println("================================");
        for (String tUnknown : OreDictManager.INSTANCE.getUnknownNames()) {
            if (KNOWN_OREDICT_NAMES.contains(tUnknown)) continue;
            CS.ORD.println(tUnknown);
        }
        CS.ORD.println("================================");
    }

    @Override
    public void onModServerStarted2(FMLServerStartedEvent aEvent) {
    }

    @Override
    public void onModServerStopping2(FMLServerStoppingEvent aEvent) {
        block7: {
            try {
                if (CS.D1 || CS.ORD != System.out) {
                    CS.ORD.println("*");
                    CS.ORD.println("Printing List of GregTech TagData instances:");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    for (TagData tData : TagData.TAGS) {
                        CS.ORD.println(tData.mName);
                    }
                    CS.ORD.println("*");
                    CS.ORD.println("Printing List of all registered Objects inside the OreDictionary, now with free extra Sorting:");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    Object[] tList = OreDictionary.getOreNames();
                    Arrays.sort(tList);
                    for (Object tOreName : tList) {
                        int tAmount = OreDictionary.getOres((String)tOreName).size();
                        if (tAmount <= 0) continue;
                        CS.ORD.println((tAmount < 10 ? " " : "") + tAmount + "x " + (String)tOreName);
                    }
                    CS.ORD.println("*");
                    CS.ORD.println("Printing List of all registered Objects inside the Fluid Registry, now with free extra Sorting:");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    tList = FluidRegistry.getRegisteredFluids().keySet().toArray(CS.ZL_STRING);
                    Arrays.sort(tList);
                    for (Object tFluidName : tList) {
                        CS.ORD.println((String)tFluidName);
                    }
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("Outputting all the Names inside the Biomeslist");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
                        if (BiomeGenBase.func_150565_n()[i] == null) continue;
                        CS.ORD.println(BiomeGenBase.func_150565_n()[i].field_76756_M + " = " + BiomeGenBase.func_150565_n()[i].field_76791_y);
                    }
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("END GregTech-Debug");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                    CS.ORD.println("*");
                }
            }
            catch (Throwable e) {
                if (!CS.D1) break block7;
                e.printStackTrace(CS.ERR);
            }
        }
    }

    @Override
    public void onModServerStopped2(FMLServerStoppedEvent aEvent) {
    }

    @Override
    public String getModID() {
        return MD.GT.mID;
    }

    @Override
    public String getModName() {
        return MD.GT.mName;
    }

    @Override
    public String getModNameForLog() {
        return "GT_Mod";
    }

    @Override
    public Abstract_Proxy getProxy() {
        return gregtechproxy;
    }

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        this.onModPreInit(aEvent);
    }

    @Mod.EventHandler
    public void onLoad(FMLInitializationEvent aEvent) {
        this.onModInit(aEvent);
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        this.onModPostInit(aEvent);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent aEvent) {
        this.onModServerStarting(aEvent);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent aEvent) {
        this.onModServerStarted(aEvent);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent aEvent) {
        this.onModServerStopping(aEvent);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent aEvent) {
        this.onModServerStopped(aEvent);
    }

    static {
        MIN_IC2 = 720;
        MAX_IC2 = Integer.MAX_VALUE;
        KNOWN_OREDICT_NAMES = new HashSetNoNulls<String>(Arrays.asList("clayHardened", "hardenedClay", "holystone", "darkStone", "whiteStone", "brightStone", "lavastone", "livingwood", "livingwoodTwig", "livingrock", "dreamwood", "dreamwoodTwig", "mycelium", "podzol", "grass", "soulSand", "taintedSoil", "snowLayer", "ice", "cloud", "antiBlock", "transdimBlock", "carpet", "tyrian", "redstoneCrystal", "arcaneAsh", "camoPaste", "burntQuartz", "KangarooPaw", "redstoneRoot", "pigment", "diamondShard", "slimeball", "slimeballPink", "eternalLifeEssence", "honeyDrop", "grubBee", "salmonRaw", "stringFluxed", "aquaRegia", "sludge", "lexicaBotania", "resourceTaint", "chainLink", "sulfuricAcid", "scribingTools", "bacon", "redalloyBundled", "bluestoneInsulated", "infusedteslatiteInsulated", "bluestoneBundled", "redalloyInsulated", "infusedteslatiteBundled", "universalCable", "bamboo", "laserReceptor", "laserEmitter", "laserFocus", "laserMirror", "mobEgg", "fruitBait", "fishtrapBait", "grainBait", "veggieBait", "enderChest", "awesomeiteHammer", "pestleAndMortar", "awesomeCore", "bPlaceholder", "bVial", "bRedString", "bEnderAirBottle", "bFlask", "brDeviceCyaniteProcessor", "prbackpack", "itemGhastTear", "diamondNugget", "gaiaIngot", "pebble", "treatedStick", "universalReactant", "matterDustRefined", "sourceVegetableOil", "matterDust", "drawerBasic", "hempBrick", "hempBlock", "savehempBrick", "savehempBlock", "saveplatedHempBrick", "saveplatedHempBlock", "platedHempBrick", "platedHempBlock", "platedHemp", "savehemp", "saveplatedHemp"));
    }
}

