/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.block.IBlockPlacable;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.Worldgen_GT_Ore_Layer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraftforge.common.util.ForgeDirection;

public class Worldgenerator
implements IWorldGenerator {
    public static boolean sAsteroids = true;
    public List<Runnable> mList = new ArrayListNoNulls<Runnable>();
    public static boolean sIsGenerating = false;
    public static boolean sCanGenerateUniqueFeatureForThisChunk = true;
    public static final List<WorldgenObject> sWorldgenList = new ArrayListNoNulls<WorldgenObject>();

    public Worldgenerator() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
    }

    public void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        this.mList.add(new WorldGenContainer(new Random(aRandom.nextInt()), aX * 16, aZ * 16, aWorld.field_73011_w.field_76574_g == -1 || aChunkGenerator instanceof ChunkProviderHell || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76778_j ? -1 : (aWorld.field_73011_w.field_76574_g == 1 || aChunkGenerator instanceof ChunkProviderEnd || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76779_k ? 1 : 0), aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y));
        if (!sIsGenerating) {
            sIsGenerating = true;
            while (!this.mList.isEmpty()) {
                this.mList.remove(0).run();
            }
            sIsGenerating = false;
        }
    }

    public static boolean isReplaceable(World aWorld, int aX, int aY, int aZ, boolean aAllowAir) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return aAllowAir;
        }
        byte aMetaData = (byte)aWorld.func_72805_g(aX, aY, aZ);
        if (CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(aBlock, 1L, (long)aMetaData))) {
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
            return true;
        }
        return aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs);
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && Worldgenerator.setOreBlock(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        IBlockPlacable tBlock = CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(aBlock, 1L, (long)aWorld.func_72805_g(aX, aY, aZ)));
        if (tBlock == null) {
            if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                tBlock = CS.BlocksGT.ore;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
                tBlock = CS.BlocksGT.oreGravel;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
                tBlock = CS.BlocksGT.oreSand;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                tBlock = CS.BlocksGT.oreNetherrack;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                tBlock = CS.BlocksGT.oreEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean setSmallOreBlock(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && Worldgenerator.setSmallOreBlock(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setSmallOreBlock(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        IBlockPlacable tBlock = CS.BlocksGT.stoneToSmallOres.get(new ItemStackContainer(aBlock, 1L, (long)aWorld.func_72805_g(aX, aY, aZ)));
        if (tBlock == null) {
            if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                tBlock = CS.BlocksGT.oreSmall;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
                tBlock = CS.BlocksGT.oreSmallGravel;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
                tBlock = CS.BlocksGT.oreSmallSand;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                tBlock = CS.BlocksGT.oreSmallNetherrack;
            } else if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                tBlock = CS.BlocksGT.oreSmallEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean removeBedrock(World aWorld, int aX, int aY, int aZ) {
        if (aWorld.func_147439_a(aX, aY, aZ) == Blocks.field_150357_h) {
            for (int i = 1; i < 10; ++i) {
                for (ForgeDirection tDirection : ForgeDirection.VALID_DIRECTIONS) {
                    int tMetaData;
                    Block tBlock = aWorld.func_147439_a(aX + tDirection.offsetX * i, aY + tDirection.offsetY * i, aZ + tDirection.offsetZ * i);
                    if (tBlock == Blocks.field_150357_h || tBlock == CS.NB || !CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(tBlock, 1L, (long)(tMetaData = aWorld.func_72805_g(aX + tDirection.offsetX * i, aY + tDirection.offsetY * i, aZ + tDirection.offsetZ * i))))) continue;
                    return aWorld.func_147465_d(aX, aY, aZ, tBlock, tMetaData, 0);
                }
            }
        }
        return aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150348_b, 0, 0);
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        @Override
        public void run() {
            for (int tX = -32; tX <= 32; tX += 16) {
                for (int tZ = -32; tZ <= 32; tZ += 16) {
                    int tChunkX = this.mX + tX;
                    int tChunkZ = this.mZ + tZ;
                    if ((tChunkX / 16 + 0x18000000) % 3 != 1 || (tChunkZ / 16 + 0x18000000) % 3 != 1) continue;
                    Random aRandom = new Random(this.mWorld.func_72905_C());
                    aRandom = new Random((aRandom.nextLong() >> 3) * (long)(tChunkX / 16) + (aRandom.nextLong() >> 3) * (long)(tChunkZ / 16) ^ this.mWorld.func_72905_C());
                    if (Worldgen_GT_Ore_Layer.sWeight <= 0 || Worldgen_GT_Ore_Layer.sList.size() <= 0) continue;
                    boolean temp = true;
                    block6: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = aRandom.nextInt(Worldgen_GT_Ore_Layer.sWeight);
                        for (Worldgen_GT_Ore_Layer tWorldGen : Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                if (!tWorldGen.executeWorldgen(this.mWorld, aRandom, this.mBiome, this.mDimensionType, this.mX, this.mZ, tChunkX, tChunkZ, this.mChunkGenerator, this.mChunkProvider)) continue block6;
                                temp = false;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(CS.ERR);
                            }
                            continue block6;
                        }
                    }
                }
            }
            String tBiome = this.mWorld.func_72807_a((int)(this.mX + 8), (int)(this.mZ + 8)).field_76791_y;
            if (tBiome == null) {
                tBiome = BiomeGenBase.field_76772_c.field_76791_y;
            }
            sCanGenerateUniqueFeatureForThisChunk = true;
            for (WorldgenObject tWorldGen : sWorldgenList) {
                try {
                    tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX, this.mZ, this.mChunkGenerator, this.mChunkProvider);
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            sCanGenerateUniqueFeatureForThisChunk = true;
            Chunk tChunk = this.mWorld.func_72938_d(this.mX, this.mZ);
            if (tChunk != null) {
                tChunk.field_76643_l = true;
            }
        }
    }
}

