/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.Worldgenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Worldgen_GT_Ore_SmallPieces
extends WorldgenObject {
    public final short mMinY;
    public final short mMaxY;
    public final short mAmount;
    public final short mMeta;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;

    public Worldgen_GT_Ore_SmallPieces(String aName, boolean aDefault, int aMinY, int aMaxY, int aAmount, boolean aOverworld, boolean aNether, boolean aEnd, OreDictMaterial aPrimary) {
        super(aName, Worldgenerator.sWorldgenList, aDefault);
        this.mOverworld = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mMinY = (short)CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", (long)aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", (long)aMaxY));
        this.mAmount = (short)Math.max(1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Amount", (long)aAmount));
        this.mMeta = OreDictMaterial.get((String)CS.ConfigsGT.WORLDGEN.get((Object)new StringBuilder().append((String)"worldgen.").append((String)this.mWorldGenName).toString(), (String)"Ore", (String)aPrimary.mNameInternal)).mID;
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (!this.isGenerationAllowed(aWorld, aDimensionType, aDimensionType == -1 && this.mNether || aDimensionType == 0 && this.mOverworld || aDimensionType == 1 && this.mEnd ? aDimensionType : ~aDimensionType)) {
            return false;
        }
        if (this.mMeta > 0) {
            int j = Math.max(1, this.mAmount / 2 + aRandom.nextInt(this.mAmount) / 2);
            for (int i = 0; i < j; ++i) {
                Worldgenerator.setSmallOreBlock(aWorld, aChunkX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aChunkZ + aRandom.nextInt(16), this.mMeta);
            }
        }
        return true;
    }
}

