/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.Worldgenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Worldgen_GT_Ore_Layer
extends WorldgenObject {
    public static ArrayList<Worldgen_GT_Ore_Layer> sList = new ArrayListNoNulls<Worldgen_GT_Ore_Layer>();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public final short mPrimaryMeta;
    public final short mSecondaryMeta;
    public final short mBetweenMeta;
    public final short mSporadicMeta;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;

    public Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, OreDictMaterial aPrimary, OreDictMaterial aSecondary, OreDictMaterial aBetween, OreDictMaterial aSporadic) {
        super(aName, sList, aDefault);
        this.mOverworld = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mMinY = (short)CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", (long)aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 5, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", (long)aMaxY));
        this.mWeight = (short)CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", (long)aWeight);
        this.mDensity = (short)CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Density", (long)aDensity);
        this.mSize = (short)Math.max(1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Size", (long)aSize));
        this.mPrimaryMeta = OreDictMaterial.get((String)CS.ConfigsGT.WORLDGEN.get((Object)new StringBuilder().append((String)"worldgen.").append((String)this.mWorldGenName).toString(), (String)"OrePrimaryLayer", (String)aPrimary.mNameInternal)).mID;
        this.mSecondaryMeta = OreDictMaterial.get((String)CS.ConfigsGT.WORLDGEN.get((Object)new StringBuilder().append((String)"worldgen.").append((String)this.mWorldGenName).toString(), (String)"OreSecondaryLayer", (String)aSecondary.mNameInternal)).mID;
        this.mBetweenMeta = OreDictMaterial.get((String)CS.ConfigsGT.WORLDGEN.get((Object)new StringBuilder().append((String)"worldgen.").append((String)this.mWorldGenName).toString(), (String)"OreSporadiclyInbetween", (String)aBetween.mNameInternal)).mID;
        this.mSporadicMeta = OreDictMaterial.get((String)CS.ConfigsGT.WORLDGEN.get((Object)new StringBuilder().append((String)"worldgen.").append((String)this.mWorldGenName).toString(), (String)"OreSporaticlyAround", (String)aSporadic.mNameInternal)).mID;
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int aOriginChunkX, int aOriginChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (!this.isGenerationAllowed(aWorld, aDimensionType, aDimensionType == -1 && this.mNether || aDimensionType == 0 && this.mOverworld || aDimensionType == 1 && this.mEnd ? aDimensionType : ~aDimensionType)) {
            return false;
        }
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int cX = aOriginChunkX - aRandom.nextInt(this.mSize);
        int eX = aOriginChunkX + 16 + aRandom.nextInt(this.mSize);
        for (int tX = Math.max(aChunkX, cX); tX <= Math.min(aChunkX + 15, eX); ++tX) {
            int cZ = aOriginChunkZ - aRandom.nextInt(this.mSize);
            int eZ = aOriginChunkZ + 16 + aRandom.nextInt(this.mSize);
            for (int tZ = Math.max(aChunkZ, cZ); tZ <= Math.min(aChunkZ + 15, eZ); ++tZ) {
                int i;
                if (this.mSecondaryMeta >= 0) {
                    for (i = tMinY - 1; i < tMinY + 2; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        Worldgenerator.setOreBlock(aWorld, tX, i, tZ, this.mSecondaryMeta);
                    }
                }
                if (this.mBetweenMeta >= 0 && (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) == 0 || aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) == 0)) {
                    Worldgenerator.setOreBlock(aWorld, tX, tMinY + 2 + aRandom.nextInt(2), tZ, this.mBetweenMeta);
                }
                if (this.mPrimaryMeta >= 0) {
                    for (i = tMinY + 3; i < tMinY + 6; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                        Worldgenerator.setOreBlock(aWorld, tX, i, tZ, this.mPrimaryMeta);
                    }
                }
                if (this.mSporadicMeta < 0 || aRandom.nextInt(Math.max(1, Math.max(Math.abs(cZ - tZ), Math.abs(eZ - tZ)) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(Math.abs(cX - tX), Math.abs(eX - tX)) / this.mDensity)) != 0) continue;
                Worldgenerator.setOreBlock(aWorld, tX, tMinY - 1 + aRandom.nextInt(7), tZ, this.mSporadicMeta);
            }
        }
        return true;
    }
}

