/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.Worldgenerator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class Worldgen_GT_Ore_Bedrock
extends WorldgenObject {
    public final int mProbability;
    public final OreDictMaterial mMaterial;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;

    public Worldgen_GT_Ore_Bedrock(String aName, boolean aDefault, int aProbability, boolean aOverworld, boolean aNether, boolean aEnd, OreDictMaterial aPrimary) {
        super(aName, Worldgenerator.sWorldgenList, aDefault);
        this.mOverworld = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mProbability = Math.max(1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Probability", (long)aProbability));
        this.mMaterial = OreDictMaterial.get(CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Ore", aPrimary.mNameInternal));
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (this.mMaterial.mID <= 0 || this.mMaterial.mID == Short.MAX_VALUE || !Worldgenerator.sCanGenerateUniqueFeatureForThisChunk || !this.isGenerationAllowed(aWorld, aDimensionType, aDimensionType == -1 && this.mNether || aDimensionType == 0 && this.mOverworld || aDimensionType == 1 && this.mEnd ? aDimensionType : ~aDimensionType) || aRandom.nextInt(this.mProbability) != 0) {
            return false;
        }
        if (aWorld.func_147439_a(aChunkX + 8, 0, aChunkZ + 8) == Blocks.field_150357_h) {
            Worldgenerator.sCanGenerateUniqueFeatureForThisChunk = false;
            int[] tDistances = new int[]{0, 3, 6, 8, 9, 7, 4};
            for (int tY = 1; tY < 7; ++tY) {
                for (int tX = -tDistances[tY]; tX <= tDistances[tY]; ++tX) {
                    block10: for (int tZ = -tDistances[tY]; tZ <= tDistances[tY]; ++tZ) {
                        Worldgenerator.removeBedrock(aWorld, aChunkX + 8 + tX, tY, aChunkZ + 8 + tZ);
                        switch (aRandom.nextInt(6)) {
                            case 0: {
                                Worldgenerator.setOreBlock(aWorld, aChunkX + 8 + tX, tY, aChunkZ + 8 + tZ, this.mMaterial);
                                continue block10;
                            }
                            case 1: 
                            case 2: {
                                Worldgenerator.setSmallOreBlock(aWorld, aChunkX + 8 + tX, tY, aChunkZ + 8 + tZ, this.mMaterial);
                            }
                        }
                    }
                }
            }
            for (int tX = -2; tX <= 2; ++tX) {
                block12: for (int tZ = -2; tZ <= 2; ++tZ) {
                    switch (aRandom.nextInt(6)) {
                        case 0: {
                            CS.BlocksGT.oreBedrock.placeBlock(aWorld, aChunkX + 8 + tX, 0, aChunkZ + 8 + tZ, (byte)6, this.mMaterial.mID, null, false, true);
                            continue block12;
                        }
                        case 1: 
                        case 2: {
                            CS.BlocksGT.oreSmallBedrock.placeBlock(aWorld, aChunkX + 8 + tX, 0, aChunkZ + 8 + tZ, (byte)6, this.mMaterial.mID, null, false, true);
                        }
                    }
                }
            }
            CS.BlocksGT.oreBedrock.placeBlock(aWorld, aChunkX + 8, 0, aChunkZ + 8, (byte)6, this.mMaterial.mID, null, false, true);
        }
        return true;
    }
}

