/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.old.GT_Worldgen_Ore;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class Worldgen_Blob
extends GT_Worldgen_Ore {
    public Worldgen_Blob(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aDimensionType, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid) {
        super(aName, aDefault, aBlock, aBlockMeta, aDimensionType, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid);
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (this.isGenerationAllowed(aWorld, aDimensionType, this.mDimensionType) && (this.mBiomeList.isEmpty() || this.mBiomeList.contains(aBiome)) && (this.mProbability <= 1 || aRandom.nextInt(this.mProbability) == 0)) {
            for (int i = 0; i < this.mAmount; ++i) {
                int j;
                int tX = aChunkX + aRandom.nextInt(16);
                int tY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY);
                int tZ = aChunkZ + aRandom.nextInt(16);
                if (!this.mAllowToGenerateinVoid && aWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                float var6 = aRandom.nextFloat() * (float)Math.PI;
                double aX1 = (float)(tX + 8) + MathHelper.func_76126_a((float)var6) * (float)this.mSize / 8.0f;
                double aX2 = (float)(tX + 8) - MathHelper.func_76126_a((float)var6) * (float)this.mSize / 8.0f;
                double aZ1 = (float)(tZ + 8) + MathHelper.func_76134_b((float)var6) * (float)this.mSize / 8.0f;
                double aZ2 = (float)(tZ + 8) - MathHelper.func_76134_b((float)var6) * (float)this.mSize / 8.0f;
                double aY1 = tY + aRandom.nextInt(3) - 2;
                double aY2 = tY + aRandom.nextInt(3) - 2;
                int aMinX = Integer.MAX_VALUE;
                int aMinY = Integer.MAX_VALUE;
                int aMinZ = Integer.MAX_VALUE;
                int aMaxX = Integer.MIN_VALUE;
                int aMaxY = Integer.MIN_VALUE;
                int aMaxZ = Integer.MIN_VALUE;
                double[] tRandoms = new double[this.mSize + 1];
                for (j = 0; j < tRandoms.length; ++j) {
                    tRandoms[j] = aRandom.nextDouble() * (double)this.mSize / 16.0;
                }
                for (j = 0; j <= this.mSize; ++j) {
                    double bX = aX1 + (aX2 - aX1) * (double)j / (double)this.mSize;
                    double bY = aY1 + (aY2 - aY1) * (double)j / (double)this.mSize;
                    double bZ = aZ1 + (aZ2 - aZ1) * (double)j / (double)this.mSize;
                    double b = ((double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)this.mSize)) + 1.0f) * tRandoms[j] + 1.0) / 2.0;
                    aMinX = Math.min(aMinX, MathHelper.func_76128_c((double)(bX - b)));
                    aMinY = Math.min(aMinY, Math.max(0, MathHelper.func_76128_c((double)(bY - b))));
                    aMinZ = Math.min(aMinZ, MathHelper.func_76128_c((double)(bZ - b)));
                    aMaxX = Math.max(aMaxX, MathHelper.func_76128_c((double)(bX + b)));
                    aMaxY = Math.max(aMaxY, Math.min(aWorld.func_72800_K(), MathHelper.func_76128_c((double)(bY + b))));
                    aMaxZ = Math.max(aMaxZ, MathHelper.func_76128_c((double)(bZ + b)));
                }
                boolean[][][] tCheck = new boolean[aMaxX - aMinX + 1][aMaxY - aMinY + 1][aMaxZ - aMinZ + 1];
                for (int j2 = 0; j2 <= this.mSize; ++j2) {
                    double bX = aX1 + (aX2 - aX1) * (double)j2 / (double)this.mSize;
                    double bY = aY1 + (aY2 - aY1) * (double)j2 / (double)this.mSize;
                    double bZ = aZ1 + (aZ2 - aZ1) * (double)j2 / (double)this.mSize;
                    double b = ((double)(MathHelper.func_76126_a((float)((float)j2 * (float)Math.PI / (float)this.mSize)) + 1.0f) * tRandoms[j2] + 1.0) / 2.0;
                    int tMinX = MathHelper.func_76128_c((double)(bX - b));
                    int tMinY = Math.max(0, MathHelper.func_76128_c((double)(bY - b)));
                    int tMinZ = MathHelper.func_76128_c((double)(bZ - b));
                    int tMaxX = MathHelper.func_76128_c((double)(bX + b));
                    int tMaxY = Math.min(aWorld.func_72800_K(), MathHelper.func_76128_c((double)(bY + b)));
                    int tMaxZ = MathHelper.func_76128_c((double)(bZ + b));
                    for (int eX = tMinX; eX <= tMaxX; ++eX) {
                        double cX = ((double)eX + 0.5 - bX) / b;
                        if (!(cX * cX < 1.0)) continue;
                        for (int eY = tMinY; eY <= tMaxY; ++eY) {
                            double cY = ((double)eY + 0.5 - bY) / b;
                            if (!(cX * cX + cY * cY < 1.0)) continue;
                            for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                double cZ;
                                if (tCheck[eX - aMinX][eY - aMinY][eZ - aMinZ] || !(cX * cX + cY * cY + (cZ = ((double)eZ + 0.5 - bZ) / b) * cZ < 1.0)) continue;
                                tCheck[eX - aMinX][eY - aMinY][eZ - aMinZ] = true;
                            }
                        }
                    }
                }
                for (int a = 0; a < tCheck.length; ++a) {
                    for (int b = 0; b < tCheck[a].length; ++b) {
                        for (int c = 0; c < tCheck[a][b].length; ++c) {
                            if (!tCheck[a][b][c]) continue;
                            this.tryPlaceStuff(aWorld, aMinX + a, aMinY + b, aMinZ + c, aRandom);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public abstract boolean tryPlaceStuff(World var1, int var2, int var3, int var4, Random var5);
}

