/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.data.CS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class WorldgenObject {
    public final String mWorldGenName;
    public final boolean mEnabled;
    private final Map<String, Boolean> mDimensionMap = new HashMap<String, Boolean>();

    public WorldgenObject(String aName, List aList, boolean aDefault) {
        this.mWorldGenName = aName == null ? "" : aName;
        this.mEnabled = CS.ConfigsGT.WORLDGEN.get((Object)"worldgen", this.mWorldGenName, aDefault);
        if (this.mEnabled) {
            aList.add(this);
        }
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return false;
    }

    public boolean executeCavegen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return false;
    }

    public boolean isGenerationAllowed(String aDimName, int aDimensionType, int aAllowedDimensionType) {
        Boolean tAllowed = this.mDimensionMap.get(aDimName = aDimName.replaceAll(" ", "_"));
        if (tAllowed == null) {
            boolean tValue = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen.dimensions." + this.mWorldGenName), aDimName.replaceAll(" ", "_"), aDimensionType == aAllowedDimensionType);
            this.mDimensionMap.put(aDimName, tValue);
            return tValue;
        }
        return tAllowed;
    }

    public boolean isGenerationAllowed(World aWorld, int aDimensionType, int aAllowedDimensionType) {
        return this.isGenerationAllowed(aWorld.field_73011_w.func_80007_l(), aDimensionType, aAllowedDimensionType);
    }
}

