/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import buildcraft.api.transport.IInjectable;
import codechicken.nei.api.API;
import cofh.api.transport.IItemConduit;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.GT_API;
import gregapi.block.IBlockDebugable;
import gregapi.block.IBlockExtendedMetaData;
import gregapi.block.IBlockPlacable;
import gregapi.block.IBlockTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.code.ModData;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.enchants.Enchantment_Radioactivity;
import gregapi.event.BlockScanningEvent;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.IItemProjectile;
import gregapi.item.IItemUpdatable;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.lang.LanguageHandler;
import gregapi.network.packets.PacketSound;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.util.OM;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExt;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class UT {
    public static synchronized boolean removeSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (Stacks.invalid(aInput) && Stacks.invalid(aOutput) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<IRecipeInput, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = OM.get_(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<IRecipeInput, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (!Stacks.invalid(aOutput) && !Stacks.equal(OM.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static boolean addSimpleIC2MachineRecipe(IMachineRecipeManager aRecipeManager, ItemStack aInput, NBTTagCompound aNBT, Object ... aOutput) {
        if (Stacks.invalid(aInput) || aOutput == null || aRecipeManager == null) {
            return false;
        }
        if ((aOutput = Code.getWithoutNulls(aOutput).toArray(CS.ZL_OBJECT)).length == 0) {
            return false;
        }
        OreDictItemData tOreName = OM.association_(aInput);
        if (aRecipeManager instanceof IMachineRecipeManagerExt) {
            if (tOreName != null) {
                ((IMachineRecipeManagerExt)aRecipeManager).addRecipe((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.field_77994_a), aNBT, true, OreDictManager.INSTANCE.getStackArray(true, aOutput));
            } else {
                ((IMachineRecipeManagerExt)aRecipeManager).addRecipe((IRecipeInput)new RecipeInputItemStack(Stacks.copy(aInput), aInput.field_77994_a), aNBT, true, OreDictManager.INSTANCE.getStackArray(true, aOutput));
            }
        } else {
            try {
                if (tOreName != null) {
                    aRecipeManager.addRecipe((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.field_77994_a), aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput));
                } else {
                    aRecipeManager.addRecipe((IRecipeInput)new RecipeInputItemStack(Stacks.copy(aInput), aInput.field_77994_a), aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean addSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, NBTTagCompound aNBT, Object ... aOutput) {
        if (Stacks.invalid(aInput) || aOutput.length == 0 || aRecipeList == null) {
            return false;
        }
        OreDictItemData tOreName = OM.association_(aInput);
        if (tOreName != null) {
            aRecipeList.put((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.field_77994_a), new RecipeOutput(aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput)));
        } else {
            aRecipeList.put((IRecipeInput)new RecipeInputItemStack(Stacks.copy(aInput), aInput.field_77994_a), new RecipeOutput(aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput)));
        }
        return true;
    }

    public static class LoadingBar {
        public static boolean mEnabled = true;
        public static Object mBar = null;
        public static int mSize = 0;
        public static int mCount = 0;

        public static boolean start(String aName, int aSize) {
            if (mBar == null && mEnabled) {
                try {
                    mBar = ProgressManager.push((String)aName, (int)aSize);
                    mSize = aSize;
                    mCount = 0;
                    return true;
                }
                catch (NoClassDefFoundError e) {
                    mEnabled = false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }

        public static boolean step(Object aStep) {
            if (mBar != null && mEnabled) {
                if (mCount++ < mSize) {
                    try {
                        String tStepName = aStep == null ? "null" : aStep.toString();
                        ((ProgressManager.ProgressBar)mBar).step(tStepName);
                        return true;
                    }
                    catch (NoClassDefFoundError e) {
                        mEnabled = false;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return false;
                }
                CS.ERR.println("WARNING: Progress Bar needed forced Finish, because of too many Steps.");
                LoadingBar.finish();
                return false;
            }
            return false;
        }

        public static boolean finish() {
            if (mBar != null && mEnabled) {
                if (mCount != mSize) {
                    CS.ERR.println("WARNING: Progress Bar needed forced Finish, because of too few Steps.");
                }
                try {
                    ProgressManager.pop((ProgressManager.ProgressBar)((ProgressManager.ProgressBar)mBar));
                    mBar = null;
                    mSize = 0;
                    mCount = 0;
                    return true;
                }
                catch (NoClassDefFoundError e) {
                    mEnabled = false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                mBar = null;
                mSize = 0;
                mCount = 0;
                return false;
            }
            return false;
        }
    }

    public static class Worlds {
        public static ItemStack suckOneItemStackAt(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
            for (EntityItem tItem : (ArrayList)aWorld.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
                if (tItem.field_70128_L) continue;
                aWorld.func_72900_e((Entity)tItem);
                ItemStack rStack = tItem.func_92059_d();
                tItem.func_92058_a(Stacks.amount(0L, rStack));
                tItem.func_70106_y();
                return rStack;
            }
            return null;
        }

        public static boolean isSideObstructed(World aWorld, int aX, int aY, int aZ, byte aSide) {
            TileEntity tTileEntity = Worlds.getTileEntity(aWorld, aX += CS.OFFSETS_X[aSide], aY += CS.OFFSETS_Y[aSide], aZ += CS.OFFSETS_Z[aSide], true);
            if (tTileEntity instanceof ITileEntityQuickObstructionCheck) {
                return ((ITileEntityQuickObstructionCheck)tTileEntity).isObstructingBlockAt(CS.OPPOSITES[aSide]);
            }
            Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
            AxisAlignedBB tBoundingBox = tBlock.func_149668_a(aWorld, aX, aY, aZ);
            if (tBoundingBox == null) {
                return false;
            }
            switch (aSide) {
                case 0: {
                    return tBoundingBox.field_72337_e - (double)aY > (double)CS.PIXELS_NEG[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PIXELS_NEG[2];
                }
                case 1: {
                    return tBoundingBox.field_72338_b - (double)aY < (double)CS.PIXELS_POS[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PIXELS_NEG[2];
                }
                case 2: {
                    return tBoundingBox.field_72334_f - (double)aZ > (double)CS.PIXELS_NEG[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PIXELS_NEG[2];
                }
                case 3: {
                    return tBoundingBox.field_72339_c - (double)aZ < (double)CS.PIXELS_POS[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PIXELS_NEG[2];
                }
                case 4: {
                    return tBoundingBox.field_72336_d - (double)aX > (double)CS.PIXELS_NEG[4] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PIXELS_NEG[2];
                }
                case 5: {
                    return tBoundingBox.field_72340_a - (double)aX < (double)CS.PIXELS_POS[4] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PIXELS_NEG[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PIXELS_POS[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PIXELS_NEG[2];
                }
            }
            return false;
        }

        public static boolean isRealDimension(int aDimensionID) {
            try {
                if (DimensionManager.getProvider((int)aDimensionID).getClass().getName().contains("com.xcompwiz.mystcraft")) {
                    return true;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (DimensionManager.getProvider((int)aDimensionID).getClass().getName().contains("TwilightForest")) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return aDimensionID == -1 || aDimensionID == 0 || aDimensionID == 1;
        }

        public static boolean moveEntityToDimensionAtCoords(Entity aEntity, int aDimension, double aX, double aY, double aZ) {
            WorldServer tTargetWorld = DimensionManager.getWorld((int)aDimension);
            WorldServer tOriginalWorld = DimensionManager.getWorld((int)aEntity.field_70170_p.field_73011_w.field_76574_g);
            if (tTargetWorld != null && tOriginalWorld != null && tTargetWorld != tOriginalWorld) {
                if (aEntity.field_70154_o != null) {
                    aEntity.func_70078_a(null);
                }
                if (aEntity.field_70153_n != null) {
                    aEntity.field_70153_n.func_70078_a(null);
                }
                if (aEntity instanceof EntityPlayerMP) {
                    EntityPlayerMP aPlayer = (EntityPlayerMP)aEntity;
                    aPlayer.field_71093_bK = aDimension;
                    aPlayer.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(aPlayer.field_71093_bK, aPlayer.field_70170_p.field_73013_u, aPlayer.field_70170_p.func_72912_H().func_76067_t(), aPlayer.field_71134_c.func_73081_b()));
                    tOriginalWorld.func_72973_f((Entity)aPlayer);
                    aPlayer.field_70128_L = false;
                    aPlayer.func_70029_a((World)tTargetWorld);
                    MinecraftServer.func_71276_C().func_71203_ab().func_72375_a(aPlayer, tOriginalWorld);
                    aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                    aPlayer.field_71134_c.func_73080_a(tTargetWorld);
                    MinecraftServer.func_71276_C().func_71203_ab().func_72354_b(aPlayer, tTargetWorld);
                    MinecraftServer.func_71276_C().func_71203_ab().func_72385_f(aPlayer);
                    for (PotionEffect potioneffect : aPlayer.func_70651_bq()) {
                        aPlayer.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(aPlayer.func_145782_y(), potioneffect));
                    }
                    aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                    FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)aPlayer, tOriginalWorld.field_73011_w.field_76574_g, aDimension);
                } else {
                    aEntity.func_70107_b(aX + 0.5, aY + 0.5, aZ + 0.5);
                    aEntity.field_70170_p.func_72900_e(aEntity);
                    aEntity.field_71093_bK = aDimension;
                    aEntity.field_70128_L = false;
                    Entity tNewEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)aEntity), (World)tTargetWorld);
                    if (tNewEntity != null) {
                        tNewEntity.func_82141_a(aEntity, true);
                        aEntity.func_70106_y();
                        tNewEntity.field_70128_L = false;
                        boolean temp = tNewEntity.field_98038_p;
                        tNewEntity.field_98038_p = true;
                        tTargetWorld.func_72838_d(tNewEntity);
                        tNewEntity.field_98038_p = temp;
                        tNewEntity.field_70128_L = false;
                        aEntity = tNewEntity;
                    }
                }
                if (aEntity instanceof EntityLivingBase) {
                    ((EntityLivingBase)aEntity).func_70634_a(aX, aY, aZ);
                } else {
                    aEntity.func_70107_b(aX, aY, aZ);
                }
                tOriginalWorld.func_82742_i();
                tTargetWorld.func_82742_i();
                return true;
            }
            return false;
        }

        public static DelegatorTileEntity<TileEntity> getTileEntity(World aWorld, ChunkCoordinates aCoords, byte aSide, boolean aLoadUnloadedChunks) {
            TileEntity aTileEntity = Worlds.getTileEntity(aWorld, aCoords, aLoadUnloadedChunks);
            return aTileEntity instanceof ITileEntityDelegating ? ((ITileEntityDelegating)aTileEntity).getDelegateTileEntity(aSide) : new DelegatorTileEntity<TileEntity>(aTileEntity, aWorld, aCoords, aSide);
        }

        public static DelegatorTileEntity<TileEntity> getTileEntity(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
            TileEntity aTileEntity = Worlds.getTileEntity(aWorld, aX, aY, aZ, aLoadUnloadedChunks);
            return aTileEntity instanceof ITileEntityDelegating ? ((ITileEntityDelegating)aTileEntity).getDelegateTileEntity(aSide) : new DelegatorTileEntity<TileEntity>(aTileEntity, aWorld, aX, aY, aZ, aSide);
        }

        public static TileEntity getTileEntity(World aWorld, ChunkCoordinates aCoords, boolean aLoadUnloadedChunks) {
            if (aLoadUnloadedChunks || aWorld.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
                TileEntity rTileEntity = aWorld.func_147438_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
                if (rTileEntity != null) {
                    return rTileEntity;
                }
                Block tBlock = aWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
                return tBlock instanceof IBlockTileEntity ? ((IBlockTileEntity)tBlock).getTileEntity((IBlockAccess)aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) : null;
            }
            return null;
        }

        public static TileEntity getTileEntity(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
            if (aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ)) {
                TileEntity rTileEntity = aWorld.func_147438_o(aX, aY, aZ);
                if (rTileEntity != null) {
                    return rTileEntity;
                }
                Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
                return tBlock instanceof IBlockTileEntity ? ((IBlockTileEntity)tBlock).getTileEntity((IBlockAccess)aWorld, aX, aY, aZ) : null;
            }
            return null;
        }

        public static TileEntity setTileEntity(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
            if (aCauseTileEntityUpdates) {
                aWorld.func_147455_a(aX, aY, aZ, aTileEntity);
            } else {
                Chunk tChunk = aWorld.func_72964_e(aX >> 4, aZ >> 4);
                if (tChunk != null) {
                    aWorld.addTileEntity(aTileEntity);
                    tChunk.func_150812_a(aX & 0xF, aY, aZ & 0xF, aTileEntity);
                    tChunk.field_76643_l = true;
                }
            }
            return aTileEntity;
        }

        public static long getEnvironmentalTemperature(World aWorld, int aX, int aY, int aZ) {
            BiomeGenBase tBiome = aWorld.func_72807_a(aX, aZ);
            return Math.max(1L, tBiome == null ? 293L : (long)(270.0f + tBiome.func_150564_a(aX, aY, aZ) * 20.0f));
        }

        public static long getTemperature(World aWorld, int aX, int aY, int aZ) {
            long rTemperature = Worlds.getEnvironmentalTemperature(aWorld, aX, aY, aZ);
            if (Worlds.getCoordsOnFire(aWorld, aX, aY, aZ)) {
                rTemperature = Math.max(rTemperature, 473L);
            }
            for (ChunkCoordinates tCoords : new ChunkCoordinates[]{new ChunkCoordinates(aX, aY, aZ), new ChunkCoordinates(aX + 1, aY, aZ), new ChunkCoordinates(aX - 1, aY, aZ), new ChunkCoordinates(aX, aY + 1, aZ), new ChunkCoordinates(aX, aY - 1, aZ), new ChunkCoordinates(aX, aY, aZ + 1), new ChunkCoordinates(aX, aY, aZ - 1)}) {
                Block tBlock = Worlds.getBlock(aWorld, tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, false);
                if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                    rTemperature = Math.max(rTemperature, 773L);
                    continue;
                }
                if (!(tBlock instanceof BlockFire)) continue;
                rTemperature = Math.max(rTemperature, 473L);
            }
            return rTemperature;
        }

        public static ItemStack getStack(World aWorld, int aX, int aY, int aZ) {
            Block tBlock;
            return Stacks.make(tBlock, 1L, (tBlock = aWorld.func_147439_a(aX, aY, aZ)) instanceof IBlockExtendedMetaData ? (long)((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX, aY, aZ) : (long)aWorld.func_72805_g(aX, aY, aZ));
        }

        public static Block getBlock(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks) {
            if (aIgnoreUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ)) {
                return aWorld.func_147439_a(aX, aY, aZ);
            }
            return CS.NB;
        }

        public static boolean crossedChunkBorder(int aFromX, int aFromZ, int aToX, int aToZ) {
            return aFromX >> 4 != aToX >> 4 || aFromZ >> 4 != aToZ >> 4;
        }

        public static boolean areCoordsEven(TileEntity aTileEntity) {
            return Worlds.areCoordsEven(aTileEntity.field_145851_c, aTileEntity.field_145848_d, aTileEntity.field_145849_e);
        }

        public static boolean areCoordsEven(ChunkCoordinates aCoords) {
            return Worlds.areCoordsEven(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
        }

        public static boolean areCoordsEven(int ... aCoords) {
            int i = 0;
            for (int tCoord : aCoords) {
                if (tCoord % 2 != 0) continue;
                ++i;
            }
            return i % 2 == 0;
        }

        public static boolean setBlock(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
            Block tBlock = Stacks.block(aStack);
            if (tBlock == CS.NB) {
                return false;
            }
            if (tBlock instanceof IBlockPlacable) {
                return ((IBlockPlacable)tBlock).placeBlock(aWorld, aX, aY, aZ, (byte)6, Stacks.meta(aStack), aStack.func_77978_p(), true, false);
            }
            if (Stacks.meta(aStack) < 16) {
                return aWorld.func_147465_d(aX, aY, aZ, tBlock, (int)Stacks.meta(aStack), 3);
            }
            return false;
        }

        public static boolean isRegularStoneBlock(Block aBlock, short aMetaData) {
            ItemStackContainer tStack = new ItemStackContainer(aBlock, 1L, (long)aMetaData);
            if (CS.BlocksGT.stoneToBrokenOres.containsKey(tStack) || CS.BlocksGT.stoneToNormalOres.containsKey(tStack) || CS.BlocksGT.stoneToSmallOres.containsKey(tStack)) {
                return true;
            }
            return aBlock == Blocks.field_150343_Z;
        }

        public static boolean isOreBlock(Block aBlock, short aMetaData) {
            if (aBlock instanceof IBlockPlacable && (CS.BlocksGT.stoneToBrokenOres.containsValue(aBlock) || CS.BlocksGT.stoneToNormalOres.containsValue(aBlock) || CS.BlocksGT.stoneToSmallOres.containsValue(aBlock))) {
                return true;
            }
            return OM.prefixcontains(Stacks.make(aBlock, 1L, (long)aMetaData), TD.Prefix.ORE);
        }

        public static boolean isOreOrRegularStoneBlock(Block aBlock, short aMetaData) {
            return Worlds.isOreBlock(aBlock, aMetaData) || Worlds.isRegularStoneBlock(aBlock, aMetaData);
        }

        public static boolean isVisuallyOccluded(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return Worlds.isVisuallyOpaque(aWorld, aX + 1, aY, aZ, aIgnoreUnloadedChunks, aDefault) && Worlds.isVisuallyOpaque(aWorld, aX - 1, aY, aZ, aIgnoreUnloadedChunks, aDefault) && Worlds.isVisuallyOpaque(aWorld, aX, aY + 1, aZ, true, aDefault) && Worlds.isVisuallyOpaque(aWorld, aX, aY - 1, aZ, true, aDefault) && Worlds.isVisuallyOpaque(aWorld, aX, aY, aZ + 1, aIgnoreUnloadedChunks, aDefault) && Worlds.isVisuallyOpaque(aWorld, aX, aY, aZ - 1, aIgnoreUnloadedChunks, aDefault);
        }

        public static boolean isVisuallyOpaque(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return aIgnoreUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? Worlds.isVisuallyOpaque(aWorld.func_147439_a(aX, aY, aZ)) : aDefault;
        }

        public static boolean isVisuallyOpaque(Block aBlock) {
            return aBlock.func_149662_c() || CS.VISUALLY_OPAQUE_BLOCKS.contains(aBlock);
        }

        public static boolean isOccluded(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return Worlds.isOpaque(aWorld, aX + 1, aY, aZ, aIgnoreUnloadedChunks, aDefault) && Worlds.isOpaque(aWorld, aX - 1, aY, aZ, aIgnoreUnloadedChunks, aDefault) && Worlds.isOpaque(aWorld, aX, aY + 1, aZ, true, aDefault) && Worlds.isOpaque(aWorld, aX, aY - 1, aZ, true, aDefault) && Worlds.isOpaque(aWorld, aX, aY, aZ + 1, aIgnoreUnloadedChunks, aDefault) && Worlds.isOpaque(aWorld, aX, aY, aZ - 1, aIgnoreUnloadedChunks, aDefault);
        }

        public static boolean isOpaque(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            if (aIgnoreUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ)) {
                return aWorld.func_147439_a(aX, aY, aZ).func_149662_c();
            }
            return aDefault;
        }

        public static boolean isAir(World aWorld, int aX, int aY, int aZ) {
            return aWorld.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)aWorld, aX, aY, aZ);
        }

        public static boolean hasBlockHitBox(World aWorld, int aX, int aY, int aZ) {
            return aWorld.func_147439_a(aX, aY, aZ).func_149668_a(aWorld, aX, aY, aZ) != null;
        }

        public static void setOnFire(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter, boolean aCheckFlammability) {
            Worlds.setToFire(aWorld, aX + 1, aY, aZ, aCheckFlammability);
            Worlds.setToFire(aWorld, aX - 1, aY, aZ, aCheckFlammability);
            Worlds.setToFire(aWorld, aX, aY + 1, aZ, aCheckFlammability);
            Worlds.setToFire(aWorld, aX, aY - 1, aZ, aCheckFlammability);
            Worlds.setToFire(aWorld, aX, aY, aZ + 1, aCheckFlammability);
            Worlds.setToFire(aWorld, aX, aY, aZ - 1, aCheckFlammability);
            if (aReplaceCenter) {
                Worlds.setToFire(aWorld, aX, aY, aZ, aCheckFlammability);
            }
        }

        public static void setOnFire(World aWorld, ChunkCoordinates aCoords, boolean aReplaceCenter, boolean aCheckFlammability) {
            Worlds.setToFire(aWorld, aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c, aCheckFlammability);
            Worlds.setToFire(aWorld, aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c, aCheckFlammability);
            Worlds.setToFire(aWorld, aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c, aCheckFlammability);
            Worlds.setToFire(aWorld, aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c, aCheckFlammability);
            Worlds.setToFire(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1, aCheckFlammability);
            Worlds.setToFire(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1, aCheckFlammability);
            if (aReplaceCenter) {
                Worlds.setToFire(aWorld, aCoords, aCheckFlammability);
            }
        }

        public static boolean setToFire(World aWorld, int aX, int aY, int aZ, boolean aCheckFlammability) {
            Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (tBlock.func_149688_o() == Material.field_151593_r || tBlock.func_149668_a(aWorld, aX, aY, aZ) == null) {
                if (tBlock.getFlammability((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[6]) > 0) {
                    return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150480_ab, 0, 3);
                }
                if (aCheckFlammability) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (aWorld.func_147439_a(aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide]).getFlammability((IBlockAccess)aWorld, aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide], CS.FORGE_DIR_OPPOSITES[tSide]) <= 0) continue;
                        return aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                    }
                } else {
                    return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150480_ab, 0, 3);
                }
            }
            return false;
        }

        public static boolean setToFire(World aWorld, ChunkCoordinates aCoords, boolean aCheckFlammability) {
            Block tBlock = aWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
            if (tBlock.func_149688_o() == Material.field_151593_r || tBlock.func_149668_a(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) == null) {
                if (tBlock.getFlammability((IBlockAccess)aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, CS.FORGE_DIR[6]) > 0) {
                    return aWorld.func_147465_d(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, (Block)Blocks.field_150480_ab, 0, 3);
                }
                if (aCheckFlammability) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (aWorld.func_147439_a(aCoords.field_71574_a + CS.OFFSETS_X[tSide], aCoords.field_71572_b + CS.OFFSETS_Y[tSide], aCoords.field_71573_c + CS.OFFSETS_Z[tSide]).getFlammability((IBlockAccess)aWorld, aCoords.field_71574_a + CS.OFFSETS_X[tSide], aCoords.field_71572_b + CS.OFFSETS_Y[tSide], aCoords.field_71573_c + CS.OFFSETS_Z[tSide], CS.FORGE_DIR_OPPOSITES[tSide]) <= 0) continue;
                        return aWorld.func_147449_b(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, (Block)Blocks.field_150480_ab);
                    }
                } else {
                    return aWorld.func_147465_d(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, (Block)Blocks.field_150480_ab, 0, 3);
                }
            }
            return false;
        }

        public static boolean getCoordsOnFire(World aWorld, int aX, int aY, int aZ) {
            return Worlds.getBlock(aWorld, aX, aY, aZ, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX + 1, aY, aZ, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX - 1, aY, aZ, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX, aY + 1, aZ, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX, aY - 1, aZ, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX, aY, aZ + 1, false) instanceof BlockFire || Worlds.getBlock(aWorld, aX, aY, aZ - 1, false) instanceof BlockFire;
        }

        public static int getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, int aSide, float aClickX, float aClickY, float aClickZ) {
            Block tBlock;
            TileEntity tTileEntity;
            int rEUAmount;
            ArrayListNoNulls<String> tList;
            block57: {
                block56: {
                    block46: {
                        if (aList == null) {
                            return 0;
                        }
                        tList = new ArrayListNoNulls<String>();
                        rEUAmount = 0;
                        tTileEntity = Worlds.getTileEntity(aWorld, aX, aY, aZ, true);
                        tBlock = aWorld.func_147439_a(aX, aY, aZ);
                        ((ArrayList)tList).add("----- X: " + aX + " Y: " + aY + " Z: " + aZ + " -----");
                        try {
                            if (tTileEntity != null && tTileEntity instanceof IInventory) {
                                ((ArrayList)tList).add("Name: " + ((IInventory)tTileEntity).func_145825_b() + "  MetaData: " + aWorld.func_72805_g(aX, aY, aZ));
                            } else {
                                ((ArrayList)tList).add("Name: " + tBlock.func_149739_a() + "  MetaData: " + aWorld.func_72805_g(aX, aY, aZ));
                            }
                            ((ArrayList)tList).add("Hardness: " + tBlock.func_149712_f(aWorld, aX, aY, aZ) + "  Blast Resistance: " + tBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v));
                            if (tBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                                ((ArrayList)tList).add("Is valid Beacon Pyramid Material");
                            }
                        }
                        catch (Throwable e) {
                            if (!CS.D1) break block46;
                            e.printStackTrace(CS.ERR);
                        }
                    }
                    if (tTileEntity != null) {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block51: {
                                            block50: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            try {
                                                                if (tTileEntity instanceof IFluidHandler) {
                                                                    rEUAmount += 500;
                                                                    FluidTankInfo[] tTanks = ((IFluidHandler)tTileEntity).getTankInfo(CS.FORGE_DIR[aSide]);
                                                                    if (tTanks != null) {
                                                                        for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                                                                            ((ArrayList)tList).add("Tank " + i + ": " + (tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + " / " + tTanks[i].capacity + " " + Fluids.name(tTanks[i].fluid, true));
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                if (!CS.D1) break block47;
                                                                e.printStackTrace(CS.ERR);
                                                            }
                                                        }
                                                        try {
                                                            if (tTileEntity instanceof IReactorChamber) {
                                                                rEUAmount += 500;
                                                                tTileEntity = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            if (!CS.D1) break block48;
                                                            e.printStackTrace(CS.ERR);
                                                        }
                                                    }
                                                    try {
                                                        if (tTileEntity instanceof IReactor) {
                                                            rEUAmount += 500;
                                                            ((ArrayList)tList).add("Heat: " + ((IReactor)tTileEntity).getHeat() + "/" + ((IReactor)tTileEntity).getMaxHeat() + "  HEM: " + ((IReactor)tTileEntity).getHeatEffectModifier() + "  Base EU Output: ");
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        if (!CS.D1) break block49;
                                                        e.printStackTrace(CS.ERR);
                                                    }
                                                }
                                                try {
                                                    if (tTileEntity instanceof IWrenchable) {
                                                        rEUAmount += 100;
                                                        ((ArrayList)tList).add("Facing: " + ((IWrenchable)tTileEntity).getFacing() + " / Chance: " + ((IWrenchable)tTileEntity).getWrenchDropRate() * 100.0f + "%");
                                                        ((ArrayList)tList).add(((IWrenchable)tTileEntity).wrenchCanRemove(aPlayer) ? "You can remove this with a Wrench" : "You can NOT remove this with a Wrench");
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    if (!CS.D1) break block50;
                                                    e.printStackTrace(CS.ERR);
                                                }
                                            }
                                            try {
                                                if (tTileEntity instanceof IEnergyTile) {
                                                    rEUAmount += 200;
                                                }
                                            }
                                            catch (Throwable e) {
                                                if (!CS.D1) break block51;
                                                e.printStackTrace(CS.ERR);
                                            }
                                        }
                                        try {
                                            if (tTileEntity instanceof IEnergySink) {
                                                rEUAmount += 400;
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!CS.D1) break block52;
                                            e.printStackTrace(CS.ERR);
                                        }
                                    }
                                    try {
                                        if (tTileEntity instanceof IEnergySource) {
                                            rEUAmount += 400;
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!CS.D1) break block53;
                                        e.printStackTrace(CS.ERR);
                                    }
                                }
                                try {
                                    if (tTileEntity instanceof IEnergyConductor) {
                                        rEUAmount += 200;
                                        ((ArrayList)tList).add("Conduction Loss: " + ((IEnergyConductor)tTileEntity).getConductionLoss());
                                    }
                                }
                                catch (Throwable e) {
                                    if (!CS.D1) break block54;
                                    e.printStackTrace(CS.ERR);
                                }
                            }
                            try {
                                if (tTileEntity instanceof IEnergyStorage) {
                                    rEUAmount += 200;
                                    ((ArrayList)tList).add("Contained Energy: " + ((IEnergyStorage)tTileEntity).getStored() + " of " + ((IEnergyStorage)tTileEntity).getCapacity());
                                }
                            }
                            catch (Throwable e) {
                                if (!CS.D1) break block55;
                                e.printStackTrace(CS.ERR);
                            }
                        }
                        try {
                            if (tTileEntity instanceof ICropTile) {
                                if (((ICropTile)tTileEntity).getScanLevel() < 4) {
                                    rEUAmount += 10000;
                                    ((ICropTile)tTileEntity).setScanLevel((byte)4);
                                }
                                rEUAmount += 1000;
                                ((ArrayList)tList).add("Type -- Crop-Name: " + LanguageHandler.translate(((ICropTile)tTileEntity).getCrop().name()) + "  Growth: " + ((ICropTile)tTileEntity).getGrowth() + "  Gain: " + ((ICropTile)tTileEntity).getGain() + "  Resistance: " + ((ICropTile)tTileEntity).getResistance());
                                ((ArrayList)tList).add("Plant -- Fertilizer: " + ((ICropTile)tTileEntity).getNutrientStorage() + "  Water: " + ((ICropTile)tTileEntity).getHydrationStorage() + "  Weed-Ex: " + ((ICropTile)tTileEntity).getWeedExStorage() + "  Scan-Level: " + ((ICropTile)tTileEntity).getScanLevel());
                                ((ArrayList)tList).add("Environment -- Nutrients: " + ((ICropTile)tTileEntity).getNutrients() + "  Humidity: " + ((ICropTile)tTileEntity).getHumidity() + "  Air-Quality: " + ((ICropTile)tTileEntity).getAirQuality());
                                String tString = "";
                                for (String tAttribute : ((ICropTile)tTileEntity).getCrop().attributes()) {
                                    tString = tString + ", " + tAttribute;
                                }
                                ((ArrayList)tList).add("Attributes:" + tString.replaceFirst(",", ""));
                                ((ArrayList)tList).add("Discovered by: " + ((ICropTile)tTileEntity).getCrop().discoveredBy());
                            }
                        }
                        catch (Throwable e) {
                            if (!CS.D1) break block56;
                            e.printStackTrace(CS.ERR);
                        }
                    }
                }
                try {
                    if (tBlock instanceof IBlockDebugable) {
                        rEUAmount += 500;
                        ArrayList<String> temp = ((IBlockDebugable)tBlock).getDebugInfo(aPlayer, aX, aY, aZ, 3);
                        if (temp != null) {
                            ((ArrayList)tList).addAll(temp);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!CS.D1) break block57;
                    e.printStackTrace(CS.ERR);
                }
            }
            BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, (byte)aSide, aScanLevel, tBlock, tTileEntity, tList, aClickX, aClickY, aClickZ);
            tEvent.mEUCost = rEUAmount;
            MinecraftForge.EVENT_BUS.post((Event)tEvent);
            if (!tEvent.isCanceled()) {
                aList.addAll(tList);
            }
            return tEvent.mEUCost;
        }
    }

    public static class Entities {
        public static void sendchat(Object aPlayer, String ... aChatMessages) {
            if (aPlayer instanceof EntityPlayerMP) {
                for (String aMessage : aChatMessages) {
                    ((EntityPlayerMP)aPlayer).func_146105_b((IChatComponent)new ChatComponentText(aMessage));
                }
            }
        }

        public static void sendchat(Object aPlayer, IChatComponent ... aChatMessages) {
            if (aPlayer instanceof EntityPlayerMP) {
                for (IChatComponent aMessage : aChatMessages) {
                    ((EntityPlayerMP)aPlayer).func_146105_b(aMessage);
                }
            }
        }

        public static void sendchat(Object aPlayer, List aChatMessages, boolean aSkipFirst) {
            if (aChatMessages != null && aPlayer instanceof EntityPlayerMP) {
                for (Object aMessage : aChatMessages) {
                    if (aSkipFirst) {
                        aSkipFirst = false;
                        continue;
                    }
                    ((EntityPlayerMP)aPlayer).func_146105_b((IChatComponent)(aMessage instanceof IChatComponent ? (IChatComponent)aMessage : new ChatComponentText(aMessage.toString())));
                }
            }
        }

        public static void chat(Object aPlayer, String ... aChatMessages) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aPlayer instanceof EntityPlayer) {
                for (String aMessage : aChatMessages) {
                    ((EntityPlayer)aPlayer).func_146105_b((IChatComponent)new ChatComponentText(aMessage));
                }
            }
        }

        public static void chat(Object aPlayer, IChatComponent ... aChatMessages) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aPlayer instanceof EntityPlayer) {
                for (IChatComponent aMessage : aChatMessages) {
                    ((EntityPlayer)aPlayer).func_146105_b(aMessage);
                }
            }
        }

        public static void chat(Object aPlayer, List aChatMessages, boolean aSkipFirst) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aChatMessages != null && aPlayer instanceof EntityPlayer) {
                for (Object aMessage : aChatMessages) {
                    if (aSkipFirst) {
                        aSkipFirst = false;
                        continue;
                    }
                    ((EntityPlayer)aPlayer).func_146105_b((IChatComponent)(aMessage instanceof IChatComponent ? (IChatComponent)aMessage : new ChatComponentText(aMessage.toString())));
                }
            }
        }

        public static boolean isWearingFullFrostHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_FROST.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullHeatHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_HEAT.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullBioHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_BIO.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullChemHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_CHEM.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullInsectHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_INSECTS.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullRadioHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_RADIOACTIVE.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullElectroHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_LIGHTNING.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullGasHazmat(EntityLivingBase aEntity) {
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_GAS.contains(aEntity.func_71124_b(i), true)) continue;
                return false;
            }
            return true;
        }

        public static float getHeatDamageFromItem(ItemStack aStack) {
            OreDictItemData tData = OM.anydata(aStack);
            return tData == null ? 0.0f : (tData.mPrefix == null ? 0.0f : tData.mPrefix.mHeatDamage) + (tData.hasValidMaterialData() ? tData.mMaterial.mMaterial.mHeatDamage : 0.0f);
        }

        public static int getRadioactivityLevel(ItemStack aStack) {
            OreDictItemData tData = OM.anydata(aStack);
            long rLevel = 0L;
            if (tData != null && tData.hasValidMaterialData()) {
                for (ObjectStack<Enchantment> tEnchantment : tData.mMaterial.mMaterial.mEnchantmentTools) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : tData.mMaterial.mMaterial.mEnchantmentArmors) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
            }
            rLevel = Math.max(rLevel, (long)EnchantmentHelper.func_77506_a((int)Enchantment_Radioactivity.INSTANCE.field_77352_x, (ItemStack)aStack));
            return Code.bindInt(rLevel);
        }

        public static boolean isImmuneToBreathingGasses(EntityLivingBase aEntity) {
            return Entities.isWearingFullGasHazmat(aEntity);
        }

        public static boolean applyTemperatureDamage(Entity aEntity, long aTemperature, float aMultiplier) {
            if (aTemperature > 320L) {
                return Entities.applyHeatDamage(aEntity, aMultiplier * (float)(aTemperature - 300L) / 50.0f);
            }
            if (aTemperature < 260L) {
                return Entities.applyFrostDamage(aEntity, aMultiplier * (float)(270L - aTemperature) / 25.0f);
            }
            return false;
        }

        public static boolean applyChemDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && aEntity.getClass() != EntitySkeleton.class && !Entities.isWearingFullChemHazmat((EntityLivingBase)aEntity)) {
                aEntity.func_70097_a(DamageSources.getChemDamage(), aDamage);
                PotionEffect tEffect = null;
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76436_u);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, Math.max(20, (int)(aDamage * 100.0f + (float)Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()))), 1));
                return true;
            }
            return false;
        }

        public static boolean applyHeatDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && aEntity.getClass() != EntityBlaze.class && ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76426_n) == null && !Entities.isWearingFullHeatHazmat((EntityLivingBase)aEntity)) {
                aEntity.func_70097_a(DamageSources.getHeatDamage(), aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyFrostDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && !Entities.isWearingFullFrostHazmat((EntityLivingBase)aEntity)) {
                aEntity.func_70097_a(DamageSources.getFrostDamage(), aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyElectricityDamage(Entity aEntity, long aVoltage, long aAmperage) {
            long aDamage = (long)Code.tierMax(aVoltage) * aAmperage * 4L;
            if (aDamage > 0L && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && !Entities.isWearingFullElectroHazmat((EntityLivingBase)aEntity)) {
                aEntity.func_70097_a(DamageSources.getElectricDamage(), (float)aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyElectricityDamage(Entity aEntity, long aWattage) {
            long aDamage = Code.tierMax(aWattage) * 4;
            if (aDamage > 0L && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && !Entities.isWearingFullElectroHazmat((EntityLivingBase)aEntity)) {
                aEntity.func_70097_a(DamageSources.getElectricDamage(), (float)aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyRadioactivity(Entity aEntity, int aLevel, int aAmountOfItems) {
            if (aLevel > 0 && aEntity instanceof EntityLivingBase && ((EntityLivingBase)aEntity).func_70089_S() && ((EntityLivingBase)aEntity).func_70668_bt() != EnumCreatureAttribute.UNDEAD && ((EntityLivingBase)aEntity).func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !Entities.isWearingFullRadioHazmat((EntityLivingBase)aEntity)) {
                PotionEffect tEffect = null;
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76421_d);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76419_f);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76431_k);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76437_t);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76438_s);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                tEffect = ((EntityLivingBase)aEntity).func_70660_b(Potion.field_76425_a[CS.PotionsGT.ID_RADIATION]);
                ((EntityLivingBase)aEntity).func_70690_d(new PotionEffect(CS.PotionsGT.ID_RADIATION, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
                return true;
            }
            return false;
        }

        public static boolean isPlayer(Object aPlayer) {
            return aPlayer instanceof EntityPlayerMP && !(aPlayer instanceof FakePlayer);
        }

        public static boolean isCreative(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d;
        }

        public static boolean isInvincible(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d;
        }

        public static boolean hasInfiniteItems(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d;
        }
    }

    public static class Sounds {
        public static boolean MULTITHREADED = false;
        public static List<PlayedSound> sPlayedSounds = new ArrayListNoNulls<PlayedSound>();

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength) {
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength, (Entity)GT_API.api_proxy.getThePlayer());
        }

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, Entity aEntity) {
            if (!CS.CODE_CLIENT || aEntity == null || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength, MathHelper.func_76128_c((double)aEntity.field_70165_t), MathHelper.func_76128_c((double)aEntity.field_70163_u), MathHelper.func_76128_c((double)aEntity.field_70161_v));
        }

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, int aX, int aY, int aZ) {
            return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, ChunkCoordinates aCoords) {
            if (aCoords == null) {
                return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength);
            }
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength, 0.9f + CS.RANDOM.nextFloat() * 0.2f, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
        }

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
            return Sounds.play(aSoundName, aTimeUntilNextSound, aSoundStrength, aSoundModulation, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean play(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, ChunkCoordinates aCoords) {
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            EntityPlayer aPlayer = GT_API.api_proxy.getThePlayer();
            if (aPlayer == null || !aPlayer.field_70170_p.field_72995_K || Code.stringInvalid(aSoundName)) {
                return false;
            }
            if (MULTITHREADED) {
                new Thread((Runnable)new ThreadedSound(aPlayer.field_70170_p, MathHelper.func_76128_c((double)aCoords.field_71574_a), MathHelper.func_76128_c((double)aCoords.field_71572_b), MathHelper.func_76128_c((double)aCoords.field_71573_c), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation), "Sound Effect").start();
            } else {
                new ThreadedSound(aPlayer.field_70170_p, MathHelper.func_76128_c((double)aCoords.field_71574_a), MathHelper.func_76128_c((double)aCoords.field_71572_b), MathHelper.func_76128_c((double)aCoords.field_71573_c), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation).run();
            }
            return true;
        }

        public static boolean send(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
            return Sounds.send(aWorld, aSoundName, aSoundStrength, aSoundModulation, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean send(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, Entity aEntity) {
            return Sounds.send(aWorld, aSoundName, aSoundStrength, aSoundModulation, MathHelper.func_76128_c((double)aEntity.field_70165_t), MathHelper.func_76128_c((double)aEntity.field_70163_u), MathHelper.func_76128_c((double)aEntity.field_70161_v));
        }

        public static boolean send(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, ChunkCoordinates aCoords) {
            if (Code.stringInvalid(aSoundName) || aWorld == null || aWorld.field_72995_K) {
                return false;
            }
            CS.NW_API.sendToAllPlayersInRange(new PacketSound(aSoundName, aSoundStrength, aSoundModulation, aCoords), aWorld, aCoords);
            return true;
        }

        public static class ThreadedSound
        implements Runnable {
            private final int mX;
            private final int mY;
            private final int mZ;
            private final int mTimeUntilNextSound;
            private final World mWorld;
            private final String mSoundName;
            private final float mSoundStrength;
            private final float mSoundModulation;

            public ThreadedSound(World aWorld, int aX, int aY, int aZ, int aTimeUntilNextSound, String aSoundName, float aSoundStrength, float aSoundModulation) {
                this.mWorld = aWorld;
                this.mX = aX;
                this.mY = aY;
                this.mZ = aZ;
                this.mTimeUntilNextSound = aTimeUntilNextSound;
                this.mSoundName = aSoundName;
                this.mSoundStrength = aSoundStrength;
                this.mSoundModulation = aSoundModulation;
            }

            @Override
            public void run() {
                try {
                    PlayedSound tSound = new PlayedSound(this.mSoundName, this.mX, this.mY, this.mZ, this.mTimeUntilNextSound);
                    if (sPlayedSounds.contains(tSound)) {
                        return;
                    }
                    this.mWorld.func_72980_b((double)this.mX + 0.5, (double)this.mY + 0.5, (double)this.mZ + 0.5, this.mSoundName, this.mSoundStrength, this.mSoundModulation, true);
                    sPlayedSounds.add(tSound);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public static class PlayedSound {
            public final String mSoundName;
            public final int mX;
            public final int mY;
            public final int mZ;
            public int mTimer = 0;

            public PlayedSound(String aSoundName, int aX, int aY, int aZ, int aTimer) {
                this.mSoundName = aSoundName == null ? "" : aSoundName;
                this.mX = aX;
                this.mY = aY;
                this.mZ = aZ;
            }

            public boolean equals(Object aObject) {
                if (aObject != null && aObject instanceof PlayedSound) {
                    return ((PlayedSound)aObject).mX == this.mX && ((PlayedSound)aObject).mY == this.mY && ((PlayedSound)aObject).mZ == this.mZ && ((PlayedSound)aObject).mSoundName.equals(this.mSoundName);
                }
                return false;
            }

            public int hashCode() {
                return this.mX + this.mY + this.mZ + this.mSoundName.hashCode();
            }
        }
    }

    public static class Inventories {
        public static boolean TE_CHECK = false;
        public static boolean BC_CHECK = false;
        public static boolean CHECK_ALL = true;

        public static void checkAvailabilities() {
            if (CHECK_ALL) {
                Class<IItemConduit> tClass;
                try {
                    tClass = IItemConduit.class;
                    tClass.getCanonicalName();
                    TE_CHECK = true;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    tClass = IInjectable.class;
                    tClass.getCanonicalName();
                    BC_CHECK = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CHECK_ALL = false;
            }
        }

        public static boolean isConnectableNonInventoryPipe(Object aTileEntity, int aSide) {
            if (aTileEntity == null) {
                return false;
            }
            Inventories.checkAvailabilities();
            if (TE_CHECK && aTileEntity instanceof IItemConduit) {
                return true;
            }
            if (BC_CHECK && aTileEntity instanceof IInjectable) {
                return ((IInjectable)aTileEntity).canInjectItems(CS.FORGE_DIR[aSide]);
            }
            return false;
        }

        public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTarget, int[] aGrabSlots, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
                return 0;
            }
            Object aTileEntity2 = aTarget;
            if (aTarget instanceof DelegatorTileEntity) {
                aTileEntity2 = ((DelegatorTileEntity)aTarget).mTileEntity;
            }
            if (aTileEntity2 != null) {
                Inventories.checkAvailabilities();
                if (TE_CHECK && aTileEntity2 instanceof IItemConduit) {
                    for (int i = 0; i < aGrabSlots.length; ++i) {
                        ItemStack rStack;
                        ItemStack tStack;
                        byte tMovedItemCount;
                        if (!Stacks.inList(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !Inventories.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a || (tMovedItemCount = (byte)(tStack.field_77994_a - ((rStack = ((IItemConduit)aTileEntity2).insertItem(CS.FORGE_DIR[aPutTo], Stacks.copy(tStack = Stacks.amount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]))), false)) == null ? 0 : rStack.field_77994_a))) < 1) continue;
                        aTileEntity1.func_70298_a(aGrabSlots[i], (int)tMovedItemCount);
                        aTileEntity1.func_70296_d();
                        return tMovedItemCount;
                    }
                    return 0;
                }
                if (BC_CHECK && aTileEntity2 instanceof IInjectable) {
                    for (int i = 0; i < aGrabSlots.length; ++i) {
                        ItemStack tStack;
                        byte tMovedItemCount;
                        if (!Stacks.inList(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !Inventories.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a || (tMovedItemCount = (byte)((IInjectable)aTileEntity2).injectItem(Stacks.copy(tStack = Stacks.amount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]))), false, CS.FORGE_DIR[aPutTo], null)) < Math.max(aMinMoveAtOnce, aMinTargetStackSize)) continue;
                        tMovedItemCount = (byte)((IInjectable)aTileEntity2).injectItem(Stacks.amount(tMovedItemCount, tStack), true, CS.FORGE_DIR[aPutTo], null);
                        aTileEntity1.func_70298_a(aGrabSlots[i], (int)tMovedItemCount);
                        aTileEntity1.func_70296_d();
                        return tMovedItemCount;
                    }
                    return 0;
                }
            }
            if (aTarget instanceof DelegatorTileEntity && !Worlds.hasBlockHitBox(((DelegatorTileEntity)aTarget).mWorld, ((DelegatorTileEntity)aTarget).mX, ((DelegatorTileEntity)aTarget).mY, ((DelegatorTileEntity)aTarget).mZ)) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    if (!Stacks.inList(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !Inventories.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a) continue;
                    ItemStack tStack = Stacks.amount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]));
                    EntityItem tEntity = new EntityItem(((DelegatorTileEntity)aTarget).mWorld, (double)((DelegatorTileEntity)aTarget).mX + 0.5, (double)((DelegatorTileEntity)aTarget).mY + 0.5, (double)((DelegatorTileEntity)aTarget).mZ + 0.5, tStack);
                    tEntity.field_70179_y = 0.0;
                    tEntity.field_70181_x = 0.0;
                    tEntity.field_70159_w = 0.0;
                    ((DelegatorTileEntity)aTarget).mWorld.func_72838_d((Entity)tEntity);
                    aTileEntity1.func_70298_a(aGrabSlots[i], tStack.field_77994_a);
                    aTileEntity1.func_70296_d();
                    return (byte)tStack.field_77994_a;
                }
            }
            return 0;
        }

        public static byte moveStackFromSlotAToSlotB(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            if (aTileEntity1 == null || aTileEntity2 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
                return 0;
            }
            ItemStack tStack1 = aTileEntity1.func_70301_a(aGrabFrom);
            ItemStack tStack2 = aTileEntity2.func_70301_a(aPutTo);
            ItemStack tStack3 = null;
            if (tStack1 != null) {
                if (tStack2 != null && !Stacks.equal(tStack1, tStack2)) {
                    return 0;
                }
                tStack3 = Stacks.copy(tStack1);
                aMaxTargetStackSize = (byte)Math.min(aMaxTargetStackSize, Math.min(tStack3.func_77976_d(), Math.min(tStack2 == null ? Integer.MAX_VALUE : tStack2.func_77976_d(), aTileEntity2.func_70297_j_())));
                tStack3.field_77994_a = Math.min(tStack3.field_77994_a, aMaxTargetStackSize - (tStack2 == null ? 0 : tStack2.field_77994_a));
                if (tStack3.field_77994_a > aMaxMoveAtOnce) {
                    tStack3.field_77994_a = aMaxMoveAtOnce;
                }
                if (tStack3.field_77994_a + (tStack2 == null ? 0 : tStack2.field_77994_a) >= Math.min(tStack3.func_77976_d(), aMinTargetStackSize) && tStack3.field_77994_a >= aMinMoveAtOnce) {
                    tStack3 = aTileEntity1.func_70298_a(aGrabFrom, tStack3.field_77994_a);
                    aTileEntity1.func_70296_d();
                    if (tStack3 != null) {
                        if (tStack2 == null) {
                            aTileEntity2.func_70299_a(aPutTo, Stacks.copy(tStack3));
                            aTileEntity2.func_70296_d();
                        } else {
                            tStack2.field_77994_a += tStack3.field_77994_a;
                            aTileEntity2.func_70296_d();
                        }
                        return (byte)tStack3.field_77994_a;
                    }
                }
            }
            return 0;
        }

        public static boolean isAllowedToTakeFromSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack) {
            if (CS.SIDES_INVALID[aSide]) {
                return Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)0, aStack) || Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)1, aStack) || Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)2, aStack) || Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)3, aStack) || Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)4, aStack) || Inventories.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)5, aStack);
            }
            if (aTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)aTileEntity).func_102008_b(aSlot, aStack, (int)aSide);
            }
            return true;
        }

        public static boolean isAllowedToPutIntoSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack, int aMaxStackSize) {
            ItemStack tStack = aTileEntity.func_70301_a(aSlot);
            if (!(tStack == null || Stacks.equal(tStack, aStack) && tStack.field_77994_a < tStack.func_77976_d())) {
                return false;
            }
            if (CS.SIDES_INVALID[aSide]) {
                return Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)0, aStack, aMaxStackSize) || Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)1, aStack, aMaxStackSize) || Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)2, aStack, aMaxStackSize) || Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)3, aStack, aMaxStackSize) || Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)4, aStack, aMaxStackSize) || Inventories.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)5, aStack, aMaxStackSize);
            }
            if (aTileEntity instanceof ISidedInventory && !((ISidedInventory)aTileEntity).func_102007_a(aSlot, aStack, (int)aSide)) {
                return false;
            }
            return aTileEntity.func_94041_b(aSlot, aStack);
        }

        public static byte moveOneItemStack(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            if (aTileEntity1 instanceof IInventory) {
                return Inventories.moveOneItemStack((IInventory)aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
            }
            return 0;
        }

        private static byte moveOneItemStack(IInventory aTileEntity1, Object aTarget, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce, boolean aDoCheckChests) {
            if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
                return 0;
            }
            Object aTileEntity2 = aTarget;
            if (aTarget instanceof DelegatorTileEntity) {
                aTileEntity2 = ((DelegatorTileEntity)aTarget).mTileEntity;
            }
            int[] tGrabSlots = null;
            if (aTileEntity1 instanceof ISidedInventory) {
                tGrabSlots = ((ISidedInventory)aTileEntity1).func_94128_d((int)aGrabFrom);
            }
            if (tGrabSlots == null) {
                tGrabSlots = Code.getAscendingArray(aTileEntity1.func_70302_i_());
            }
            if (aTileEntity2 instanceof IInventory) {
                int i;
                int[] tPutSlots = null;
                if (aTileEntity2 instanceof ISidedInventory) {
                    tPutSlots = ((ISidedInventory)aTileEntity2).func_94128_d((int)aPutTo);
                }
                if (tPutSlots == null) {
                    tPutSlots = new int[((IInventory)aTileEntity2).func_70302_i_()];
                    for (i = 0; i < tPutSlots.length; ++i) {
                        tPutSlots[i] = i;
                    }
                }
                for (i = 0; i < tGrabSlots.length; ++i) {
                    for (int j = 0; j < tPutSlots.length; ++j) {
                        byte tMovedItemCount;
                        if (!Stacks.inList(aFilter, aTileEntity1.func_70301_a(tGrabSlots[i]), true, aInvertFilter) || !Inventories.isAllowedToTakeFromSlot(aTileEntity1, tGrabSlots[i], aGrabFrom, aTileEntity1.func_70301_a(tGrabSlots[i])) || !Inventories.isAllowedToPutIntoSlot((IInventory)aTileEntity2, tPutSlots[j], aPutTo, aTileEntity1.func_70301_a(tGrabSlots[i]), aMaxTargetStackSize) || (tMovedItemCount = Inventories.moveStackFromSlotAToSlotB(aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], tPutSlots[j], aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                        return tMovedItemCount;
                    }
                }
                if (aDoCheckChests) {
                    byte tAmount;
                    if (aTileEntity1 instanceof TileEntityChest) {
                        TileEntityChest tTileEntity1 = (TileEntityChest)aTileEntity1;
                        if (tTileEntity1.field_145984_a) {
                            tAmount = 0;
                            if (tTileEntity1.field_145991_k != null) {
                                tAmount = Inventories.moveOneItemStack((IInventory)tTileEntity1.field_145991_k, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity1.field_145992_i != null) {
                                tAmount = Inventories.moveOneItemStack((IInventory)tTileEntity1.field_145992_i, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity1.field_145990_j != null) {
                                tAmount = Inventories.moveOneItemStack((IInventory)tTileEntity1.field_145990_j, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity1.field_145988_l != null) {
                                tAmount = Inventories.moveOneItemStack((IInventory)tTileEntity1.field_145988_l, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            }
                            if (tAmount != 0) {
                                return tAmount;
                            }
                        }
                    }
                    if (aTileEntity2 instanceof TileEntityChest) {
                        TileEntityChest tTileEntity2 = (TileEntityChest)aTileEntity2;
                        if (tTileEntity2.field_145984_a) {
                            tAmount = 0;
                            if (tTileEntity2.field_145991_k != null) {
                                tAmount = Inventories.moveOneItemStack(aTileEntity1, tTileEntity2.field_145991_k, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity2.field_145992_i != null) {
                                tAmount = Inventories.moveOneItemStack(aTileEntity1, tTileEntity2.field_145992_i, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity2.field_145990_j != null) {
                                tAmount = Inventories.moveOneItemStack(aTileEntity1, tTileEntity2.field_145990_j, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            } else if (tTileEntity2.field_145988_l != null) {
                                tAmount = Inventories.moveOneItemStack(aTileEntity1, tTileEntity2.field_145988_l, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                            }
                            if (tAmount != 0) {
                                return tAmount;
                            }
                        }
                    }
                }
            }
            return Inventories.moveStackIntoPipe(aTileEntity1, aTarget, tGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
        }

        public static byte moveOneItemStackIntoSlot(Object aTileEntity1, Object aTarget, byte aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            if (aTileEntity1 == null || !(aTileEntity1 instanceof IInventory) || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
                return 0;
            }
            Object aTileEntity2 = aTarget;
            if (aTarget instanceof DelegatorTileEntity) {
                aTileEntity2 = ((DelegatorTileEntity)aTarget).mTileEntity;
            }
            int[] tGrabSlots = null;
            if (aTileEntity1 instanceof ISidedInventory) {
                tGrabSlots = ((ISidedInventory)aTileEntity1).func_94128_d((int)aGrabFrom);
            }
            if (tGrabSlots == null) {
                tGrabSlots = Code.getAscendingArray(((IInventory)aTileEntity1).func_70302_i_());
            }
            if (aTileEntity2 != null && aTileEntity2 instanceof IInventory) {
                for (int i = 0; i < tGrabSlots.length; ++i) {
                    byte tMovedItemCount;
                    if (!Stacks.inList(aFilter, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i]), true, aInvertFilter) || !Inventories.isAllowedToTakeFromSlot((IInventory)aTileEntity1, tGrabSlots[i], aGrabFrom, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i])) || !Inventories.isAllowedToPutIntoSlot((IInventory)aTileEntity2, aPutTo, (byte)6, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i]), aMaxTargetStackSize) || (tMovedItemCount = Inventories.moveStackFromSlotAToSlotB((IInventory)aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                    return tMovedItemCount;
                }
            }
            Inventories.moveStackIntoPipe((IInventory)aTileEntity1, aTarget, tGrabSlots, aGrabFrom, CS.OPPOSITES[aGrabFrom], aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
            return 0;
        }

        public static byte moveFromSlotToSlot(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            byte tMovedItemCount;
            if (aTileEntity1 == null || aTileEntity2 == null || aGrabFrom < 0 || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
                return 0;
            }
            if (Stacks.inList(aFilter, aTileEntity1.func_70301_a(aGrabFrom), true, aInvertFilter) && Inventories.isAllowedToTakeFromSlot(aTileEntity1, aGrabFrom, (byte)6, aTileEntity1.func_70301_a(aGrabFrom)) && Inventories.isAllowedToPutIntoSlot(aTileEntity2, aPutTo, (byte)6, aTileEntity1.func_70301_a(aGrabFrom), aMaxTargetStackSize) && (tMovedItemCount = Inventories.moveStackFromSlotAToSlotB(aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) > 0) {
                return tMovedItemCount;
            }
            return 0;
        }

        public static void removeNullStacksFromInventory(IInventory aInventory) {
            if (aInventory != null) {
                int j = aInventory.func_70302_i_();
                for (int i = 0; i < j; ++i) {
                    ItemStack tStack = aInventory.func_70301_a(i);
                    if (tStack == null || tStack.field_77994_a != 0 && tStack.func_77973_b() != null) continue;
                    aInventory.func_70299_a(i, null);
                }
            }
        }

        public static boolean addStackToPlayerInventory(EntityPlayer aPlayer, ItemStack aStack) {
            return Inventories.addStackToPlayerInventory(aPlayer, aStack, false);
        }

        public static boolean addStackToPlayerInventory(EntityPlayer aPlayer, ItemStack aStack, boolean aCurrentSlotFirst) {
            if (aPlayer != null && aStack != null) {
                ItemStack tStack;
                int i;
                for (i = 0; i < 36; ++i) {
                    if (i == aPlayer.field_71071_by.field_70461_c || !Stacks.equal(tStack = aPlayer.field_71071_by.func_70301_a(i), aStack) || aStack.field_77994_a + tStack.field_77994_a > tStack.func_77976_d()) continue;
                    tStack.field_77994_a += aStack.field_77994_a;
                    if (aPlayer.field_71070_bA != null) {
                        aPlayer.field_71070_bA.func_75142_b();
                    }
                    return true;
                }
                if (aCurrentSlotFirst) {
                    ItemStack tStack2 = aPlayer.field_71071_by.func_70301_a(aPlayer.field_71071_by.field_70461_c);
                    if (tStack2 == null || tStack2.field_77994_a == 0) {
                        aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, aStack);
                        if (aPlayer.field_71070_bA != null) {
                            aPlayer.field_71070_bA.func_75142_b();
                        }
                        return true;
                    }
                    if (Stacks.equal(tStack2, aStack) && aStack.field_77994_a + tStack2.field_77994_a <= tStack2.func_77976_d()) {
                        tStack2.field_77994_a += aStack.field_77994_a;
                        if (aPlayer.field_71070_bA != null) {
                            aPlayer.field_71070_bA.func_75142_b();
                        }
                        return true;
                    }
                }
                for (i = 0; i < 36; ++i) {
                    if (i == aPlayer.field_71071_by.field_70461_c || (tStack = aPlayer.field_71071_by.func_70301_a(i)) != null && tStack.field_77994_a > 0) continue;
                    aPlayer.field_71071_by.func_70299_a(i, aStack);
                    if (aPlayer.field_71070_bA != null) {
                        aPlayer.field_71070_bA.func_75142_b();
                    }
                    return true;
                }
                if (!aCurrentSlotFirst) {
                    ItemStack tStack3 = aPlayer.field_71071_by.func_70301_a(aPlayer.field_71071_by.field_70461_c);
                    if (tStack3 == null || tStack3.field_77994_a == 0) {
                        aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, aStack);
                        if (aPlayer.field_71070_bA != null) {
                            aPlayer.field_71070_bA.func_75142_b();
                        }
                        return true;
                    }
                    if (Stacks.equal(tStack3, aStack) && aStack.field_77994_a + tStack3.field_77994_a <= tStack3.func_77976_d()) {
                        tStack3.field_77994_a += aStack.field_77994_a;
                        if (aPlayer.field_71070_bA != null) {
                            aPlayer.field_71070_bA.func_75142_b();
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        public static ItemStack getProjectile(TagData aProjectileType, IInventory aInventory) {
            if (aInventory != null) {
                int j = aInventory.func_70302_i_();
                for (int i = 0; i < j; ++i) {
                    ItemStack rStack = aInventory.func_70301_a(i);
                    if (!Stacks.valid(rStack) || !(rStack.func_77973_b() instanceof IItemProjectile) || !((IItemProjectile)rStack.func_77973_b()).hasProjectile(aProjectileType, rStack)) continue;
                    return Stacks.update(rStack);
                }
            }
            return null;
        }
    }

    public static class Reflection {
        public static Field getPublicField(Object aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getClass().getDeclaredField(aField);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Field getField(Object aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getClass().getDeclaredField(aField);
                rField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Field getField(Class aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getDeclaredField(aField);
                rField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Method getMethod(Class aObject, String aMethod, Class<?> ... aParameterTypes) {
            Method rMethod = null;
            try {
                rMethod = aObject.getMethod(aMethod, aParameterTypes);
                rMethod.setAccessible(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            return rMethod;
        }

        public static Method getMethod(Object aObject, String aMethod, Class<?> ... aParameterTypes) {
            Method rMethod = null;
            try {
                rMethod = aObject.getClass().getMethod(aMethod, aParameterTypes);
                rMethod.setAccessible(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            return rMethod;
        }

        public static Field getField(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField;
                Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                return tField;
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return null;
            }
        }

        public static Object getFieldContent(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField;
                Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                return tField.get(aObject instanceof Class || aObject instanceof String ? null : aObject);
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return null;
            }
        }

        public static Object callPublicMethod(Object aObject, String aMethod, Object ... aParameters) {
            return Reflection.callMethod(aObject, aMethod, false, false, true, aParameters);
        }

        public static Object callPrivateMethod(Object aObject, String aMethod, Object ... aParameters) {
            return Reflection.callMethod(aObject, aMethod, true, false, true, aParameters);
        }

        public static Object callMethod(Object aObject, String aMethod, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
            try {
                Method tMethod;
                Class[] tParameterTypes = new Class[aParameters.length];
                for (int i = 0; i < aParameters.length; i = (int)((byte)(i + 1))) {
                    if (aParameters[i] instanceof Class) {
                        tParameterTypes[i] = (Class)aParameters[i];
                        aParameters[i] = null;
                    } else {
                        tParameterTypes[i] = aParameters[i].getClass();
                    }
                    if (aUseUpperCasedDataTypes) continue;
                    if (tParameterTypes[i] == Boolean.class) {
                        tParameterTypes[i] = Boolean.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] == Byte.class) {
                        tParameterTypes[i] = Byte.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] == Short.class) {
                        tParameterTypes[i] = Short.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] == Integer.class) {
                        tParameterTypes[i] = Integer.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] == Long.class) {
                        tParameterTypes[i] = Long.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] == Float.class) {
                        tParameterTypes[i] = Float.TYPE;
                        continue;
                    }
                    if (tParameterTypes[i] != Double.class) continue;
                    tParameterTypes[i] = Double.TYPE;
                }
                Method method = tMethod = aObject instanceof Class ? ((Class)aObject).getMethod(aMethod, tParameterTypes) : aObject.getClass().getMethod(aMethod, tParameterTypes);
                if (aPrivate) {
                    tMethod.setAccessible(true);
                }
                return tMethod.invoke(aObject, aParameters);
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return null;
            }
        }

        public static Object callConstructor(String aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
            try {
                return Reflection.callConstructor(Class.forName(aClass), aConstructorIndex, aReplacementObject, aLogErrors, aParameters);
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return aReplacementObject;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Object callConstructor(Class aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
            if (aConstructorIndex < 0) {
                try {
                    for (Constructor<?> tConstructor : aClass.getConstructors()) {
                        try {
                            return tConstructor.newInstance(aParameters);
                        }
                        catch (Throwable e) {
                        }
                    }
                    return aReplacementObject;
                }
                catch (Throwable e) {
                    if (!aLogErrors) return aReplacementObject;
                    e.printStackTrace(CS.ERR);
                    return aReplacementObject;
                }
            } else {
                try {
                    return aClass.getConstructors()[aConstructorIndex].newInstance(aParameters);
                }
                catch (Throwable e) {
                    if (!aLogErrors) return aReplacementObject;
                    e.printStackTrace(CS.ERR);
                }
            }
            return aReplacementObject;
        }

        public static String getClassName(Object aObject) {
            if (aObject == null) {
                return "null";
            }
            return aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1);
        }
    }

    public static class Enchantments {
        private static final BullshitIteratorA mBullshitIteratorA = new BullshitIteratorA();
        private static final BullshitIteratorB mBullshitIteratorB = new BullshitIteratorB();

        private static void applyBullshit(IBullshit aBullshitModifier, ItemStack aStack) {
            NBTTagList nbttaglist;
            if (aStack != null && (nbttaglist = aStack.func_77986_q()) != null) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    try {
                        short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.field_77331_b[short1] == null) continue;
                        aBullshitModifier.calculateModifier(Enchantment.field_77331_b[short1], short2);
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }

        private static void applyArrayOfBullshit(IBullshit aBullshitModifier, ItemStack[] aStacks) {
            for (int i = 0; i < aStacks.length; ++i) {
                Enchantments.applyBullshit(aBullshitModifier, aStacks[i]);
            }
        }

        public static void applyBullshitA(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            Enchantments.mBullshitIteratorA.mPlayer = aPlayer;
            Enchantments.mBullshitIteratorA.mEntity = aEntity;
            if (aPlayer != null) {
                Enchantments.applyArrayOfBullshit(mBullshitIteratorA, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                Enchantments.applyBullshit(mBullshitIteratorA, aStack);
            }
        }

        public static void applyBullshitB(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            Enchantments.mBullshitIteratorB.mPlayer = aPlayer;
            Enchantments.mBullshitIteratorB.mEntity = aEntity;
            if (aPlayer != null) {
                Enchantments.applyArrayOfBullshit(mBullshitIteratorB, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                Enchantments.applyBullshit(mBullshitIteratorB, aStack);
            }
        }

        static interface IBullshit {
            public void calculateModifier(Enchantment var1, int var2);
        }

        static final class BullshitIteratorB
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorB() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151368_a(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static final class BullshitIteratorA
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorA() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151367_b(this.mPlayer, this.mEntity, aLevel);
            }
        }
    }

    public static class NBT {
        public static NBTTagCompound getNBTs(NBTTagCompound aNBT, Object ... aTags) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            for (int i = 1; i < aTags.length; i += 2) {
                if (aTags[i] == null) continue;
                if (aTags[i] instanceof Boolean) {
                    aNBT.func_74757_a(aTags[i - 1].toString(), ((Boolean)aTags[i]).booleanValue());
                    continue;
                }
                if (aTags[i] instanceof Byte) {
                    aNBT.func_74774_a(aTags[i - 1].toString(), ((Byte)aTags[i]).byteValue());
                    continue;
                }
                if (aTags[i] instanceof Short) {
                    aNBT.func_74777_a(aTags[i - 1].toString(), ((Short)aTags[i]).shortValue());
                    continue;
                }
                if (aTags[i] instanceof Integer) {
                    aNBT.func_74768_a(aTags[i - 1].toString(), ((Integer)aTags[i]).intValue());
                    continue;
                }
                if (aTags[i] instanceof Long) {
                    aNBT.func_74772_a(aTags[i - 1].toString(), ((Long)aTags[i]).longValue());
                    continue;
                }
                if (aTags[i] instanceof Float) {
                    aNBT.func_74776_a(aTags[i - 1].toString(), ((Float)aTags[i]).floatValue());
                    continue;
                }
                if (aTags[i] instanceof Double) {
                    aNBT.func_74780_a(aTags[i - 1].toString(), ((Double)aTags[i]).doubleValue());
                    continue;
                }
                if (aTags[i] instanceof String) {
                    aNBT.func_74778_a(aTags[i - 1].toString(), (String)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof NBTBase) {
                    aNBT.func_74782_a(aTags[i - 1].toString(), (NBTBase)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof FluidStack) {
                    aNBT.func_74782_a(aTags[i - 1].toString(), (NBTBase)Fluids.save((FluidStack)aTags[i]));
                    continue;
                }
                if (aTags[i] instanceof OreDictMaterial) {
                    aNBT.func_74778_a(aTags[i - 1].toString(), ((OreDictMaterial)aTags[i]).mNameInternal);
                    continue;
                }
                if (aTags[i] instanceof Recipe.RecipeMap) {
                    aNBT.func_74778_a(aTags[i - 1].toString(), ((Recipe.RecipeMap)aTags[i]).mNameInternal);
                    continue;
                }
                aNBT.func_74778_a(aTags[i - 1].toString(), aTags[i].toString());
            }
            return aNBT;
        }

        public static NBTTagCompound fuseNBTs(NBTTagCompound aNBT1, NBTTagCompound aNBT2) {
            if (aNBT1 == null) {
                return aNBT2 == null ? new NBTTagCompound() : (NBTTagCompound)aNBT2.func_74737_b();
            }
            NBTTagCompound rNBT = (NBTTagCompound)aNBT1.func_74737_b();
            if (aNBT2 == null) {
                return rNBT;
            }
            for (Object tKey : aNBT2.func_150296_c()) {
                if (rNBT.func_74764_b(tKey.toString())) continue;
                rNBT.func_74782_a(tKey.toString(), aNBT2.func_74781_a(tKey.toString()));
            }
            return rNBT;
        }

        public static NBTTagCompound getNBTBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74757_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74774_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTShort(NBTTagCompound aNBT, Object aTag, short aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74777_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTInteger(NBTTagCompound aNBT, Object aTag, int aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74768_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTLong(NBTTagCompound aNBT, Object aTag, long aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            NBT.setNumber(aNBT, aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74776_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            aNBT.func_74780_a(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound getNBTString(NBTTagCompound aNBT, Object aTag, Object aValue) {
            if (aNBT == null) {
                aNBT = new NBTTagCompound();
            }
            if (aValue == null) {
                return aNBT;
            }
            aNBT.func_74778_a(aTag.toString(), aValue.toString());
            return aNBT;
        }

        public static NBTTagCompound setBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
            if (aValue) {
                aNBT.func_74757_a(aTag.toString(), aValue);
            } else {
                aNBT.func_82580_o(aTag.toString());
            }
            return aNBT;
        }

        public static NBTTagCompound setNumber(NBTTagCompound aNBT, Object aTag, long aValue) {
            if (aValue == 0L) {
                aNBT.func_82580_o(aTag.toString());
                return aNBT;
            }
            if (aValue > Integer.MAX_VALUE || aValue < Integer.MIN_VALUE) {
                aNBT.func_74772_a(aTag.toString(), aValue);
                return aNBT;
            }
            if (aValue > 32767L || aValue < -32768L) {
                aNBT.func_74768_a(aTag.toString(), (int)aValue);
                return aNBT;
            }
            if (aValue > 127L || aValue < -128L) {
                aNBT.func_74777_a(aTag.toString(), (short)aValue);
                return aNBT;
            }
            aNBT.func_74774_a(aTag.toString(), (byte)aValue);
            return aNBT;
        }

        public static void setNBT(ItemStack aStack, NBTTagCompound aNBT) {
            if (aNBT == null) {
                aStack.func_77982_d(null);
                return;
            }
            ArrayListNoNulls<String> tTagsToRemove = new ArrayListNoNulls<String>();
            for (Object e : aNBT.func_150296_c()) {
                NBTBase tValue = aNBT.func_74781_a((String)e);
                if (tValue != null && (!(tValue instanceof NBTBase.NBTPrimitive) || ((NBTBase.NBTPrimitive)tValue).func_150291_c() != 0L) && (!(tValue instanceof NBTTagString) || !Code.stringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
                ((ArrayList)tTagsToRemove).add((String)e);
            }
            for (Object e : tTagsToRemove) {
                aNBT.func_82580_o((String)e);
            }
            aStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        }

        public static NBTTagCompound getNBT(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.func_77978_p();
            return rNBT == null ? new NBTTagCompound() : rNBT;
        }

        public static NBTTagCompound setPunchCardData(ItemStack aStack, String aPunchCardData) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.func_74778_a("gt.punchcard", aPunchCardData);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static String getPunchCardData(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.func_74779_i("gt.punchcard");
        }

        public static NBTTagCompound setPunchCardData(NBTTagCompound aNBT, String aPunchCardData) {
            aNBT.func_74778_a("gt.punchcard", aPunchCardData);
            return aNBT;
        }

        public static String getPunchCardData(NBTTagCompound aNBT) {
            return aNBT.func_74779_i("gt.punchcard");
        }

        public static NBTTagCompound setBlueprintCrafting(ItemStack aStack, ItemStack ... aBlueprint) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            NBT.setBlueprintCrafting(tNBT, aBlueprint);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static ItemStack[] getBlueprintCrafting(ItemStack aStack) {
            return NBT.getBlueprintCrafting(NBT.getNBT(aStack));
        }

        public static NBTTagCompound setBlueprintCrafting(NBTTagCompound aNBT, ItemStack ... aBlueprint) {
            NBTTagCompound tList = new NBTTagCompound();
            boolean temp = false;
            for (int i = 0; i < aBlueprint.length; ++i) {
                if (!Stacks.valid(aBlueprint[i])) continue;
                Stacks.save(tList, "" + i, aBlueprint[i]);
                temp = true;
            }
            if (temp) {
                aNBT.func_74782_a("gt.blueprint.craft", (NBTBase)tList);
            }
            return aNBT;
        }

        public static ItemStack[] getBlueprintCrafting(NBTTagCompound aNBT) {
            NBTTagCompound tList;
            NBTTagCompound nBTTagCompound = tList = aNBT.func_74764_b("gt.blueprint.craft") ? aNBT.func_74775_l("gt.blueprint.craft") : null;
            if (tList != null) {
                ItemStack[] rRecipe = new ItemStack[9];
                for (int i = 0; i < rRecipe.length; ++i) {
                    rRecipe[i] = Stacks.amount(1L, Stacks.load(tList, "" + i));
                }
                return rRecipe;
            }
            return CS.ZL_ITEMSTACK;
        }

        public static NBTTagCompound setLighterFuel(ItemStack aStack, long aFuel) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            NBT.setNumber(tNBT, "gt.lighter", aFuel);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static long getLighterFuel(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.func_74763_f("gt.lighter");
        }

        public static NBTTagCompound setLighterFuel(NBTTagCompound aNBT, long aFuel) {
            NBT.setNumber(aNBT, "gt.lighter", aFuel);
            return aNBT;
        }

        public static long getLighterFuel(NBTTagCompound aNBT) {
            return aNBT.func_74763_f("gt.lighter");
        }

        public static NBTTagCompound setMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.func_74777_a("map_id", aMapID);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static short getMapID(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.func_74764_b("map_id")) {
                return -1;
            }
            return tNBT.func_74765_d("map_id");
        }

        public static NBTTagCompound setMapID(NBTTagCompound aNBT, short aMapID) {
            aNBT.func_74777_a("map_id", aMapID);
            return aNBT;
        }

        public static short getMapID(NBTTagCompound aNBT) {
            if (!aNBT.func_74764_b("map_id")) {
                return -1;
            }
            return aNBT.func_74765_d("map_id");
        }

        public static NBTTagCompound setBookMapping(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.func_74778_a("book", aTitle);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static String getBookMapping(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.func_74779_i("book");
        }

        public static NBTTagCompound setBookMapping(NBTTagCompound aNBT, String aTitle) {
            aNBT.func_74778_a("book", aTitle);
            return aNBT;
        }

        public static String getBookMapping(NBTTagCompound aNBT) {
            return aNBT.func_74779_i("book");
        }

        public static NBTTagCompound setBookTitle(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.func_74778_a("title", aTitle);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static String getBookTitle(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.func_74779_i("title");
        }

        public static NBTTagCompound setBookTitle(NBTTagCompound aNBT, String aTitle) {
            aNBT.func_74778_a("title", aTitle);
            return aNBT;
        }

        public static String getBookTitle(NBTTagCompound aNBT) {
            return aNBT.func_74779_i("title");
        }

        public static NBTTagCompound setBookAuthor(ItemStack aStack, String aAuthor) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.func_74778_a("author", aAuthor);
            NBT.setNBT(aStack, tNBT);
            return tNBT;
        }

        public static String getBookAuthor(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.func_74779_i("author");
        }

        public static NBTTagCompound setBookAuthor(NBTTagCompound aNBT, String aAuthor) {
            aNBT.func_74778_a("author", aAuthor);
            return aNBT;
        }

        public static String getBookAuthor(NBTTagCompound aNBT) {
            return aNBT.func_74779_i("author");
        }

        public static List<String> getDataToolTip(NBTTagCompound aData, List<String> aList, boolean aAllDetails) {
            if (aData.func_74764_b("gt.reactor.setup")) {
                aList.add(LH.Chat.CYAN + "Reactor Setup: " + aData.func_74779_i("gt.reactor.setup.name"));
                return aList;
            }
            if (aData.func_74764_b("gt.canvas.block")) {
                aList.add(LH.Chat.CYAN + "Block Image: " + Stacks.names(Stacks.make(Block.func_149729_e((int)aData.func_74762_e("gt.canvas.block")), 1L, (long)aData.func_74762_e("gt.canvas.meta"))));
                return aList;
            }
            if (aData.func_74764_b("gt.replicator.data")) {
                short tIndex = aData.func_74765_d("gt.replicator.data");
                if (Code.exists(tIndex, OreDictMaterial.MATERIAL_ARRAY)) {
                    OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[tIndex];
                    if (tMaterial.contains(TD.Processing.UUM)) {
                        if (aAllDetails) {
                            aList.add(LH.Chat.CYAN + "Material Data: " + LH.Chat.WHITE + tMaterial.getLocal());
                            aList.add(LH.Chat.CYAN + "Can be Replicated using");
                            if (tMaterial.contains(TD.Atomic.ANTIMATTER)) {
                                aList.add(LH.Chat.WHITE + "Neutral Antimatter: " + LH.Chat.YELLOW + tMaterial.mNeutrons);
                                aList.add(LH.Chat.WHITE + "Charged Antimatter: " + LH.Chat.RED + tMaterial.mProtons);
                            } else {
                                aList.add(LH.Chat.WHITE + "Neutral Matter: " + LH.Chat.YELLOW + tMaterial.mNeutrons);
                                aList.add(LH.Chat.WHITE + "Charged Matter: " + LH.Chat.RED + tMaterial.mProtons);
                            }
                            aList.add(LH.Chat.WHITE + "Energy: " + TD.Energy.QU.getChatFormat() + (tMaterial.mNeutrons + tMaterial.mProtons) * 65536L + " " + TD.Energy.QU.getLocalisedNameShort());
                        } else {
                            aList.add(LH.Chat.CYAN + "Mat Data: " + LH.Chat.WHITE + tMaterial.getLocal() + (aAllDetails ? "" : " (" + LH.Chat.YELLOW + tMaterial.mNeutrons + LH.Chat.WHITE + "/" + LH.Chat.RED + tMaterial.mProtons + LH.Chat.WHITE + "/" + TD.Energy.QU.getChatFormat() + (tMaterial.mNeutrons + tMaterial.mProtons) * 65536L + LH.Chat.WHITE + ")"));
                        }
                    } else {
                        aList.add(LH.Chat.CYAN + "Material Data: " + LH.Chat.WHITE + tMaterial.getLocal() + LH.Chat.ORANGE + " (Not Replicatable)");
                    }
                }
                return aList;
            }
            String tString = NBT.getBookTitle(aData);
            if (Code.stringValid(tString)) {
                aList.add(LH.Chat.CYAN + "Book: " + tString);
                if (aAllDetails && Code.stringValid(tString = NBT.getBookAuthor(aData))) {
                    aList.add(LH.Chat.CYAN + "by " + tString);
                }
                return aList;
            }
            short tMapID = NBT.getMapID(aData);
            if (tMapID >= 0) {
                aList.add(LH.Chat.CYAN + "Map ID: " + tMapID);
                return aList;
            }
            tString = NBT.getPunchCardData(aData);
            if (Code.stringValid(tString)) {
                aList.add(LH.Chat.CYAN + "Punch Card Data");
                if (aAllDetails) {
                    int j = tString.length();
                    for (int i = 0; i < j; i += 64) {
                        aList.add(LH.Chat.GREEN + tString.substring(i, Math.min(i + 64, j)));
                    }
                }
                return aList;
            }
            ItemStack[] tBlueprint = NBT.getBlueprintCrafting(aData);
            if (tBlueprint != CS.ZL_ITEMSTACK) {
                ItemStack tCrafted = GT_ModHandler.getAllRecipeOutput(null, tBlueprint);
                if (tCrafted == null) {
                    aList.add(LH.Chat.CYAN + "Blueprint with random Items");
                } else if (aAllDetails) {
                    aList.add(LH.Chat.CYAN + "Blueprint for " + tCrafted.func_82833_r());
                } else {
                    aList.add(LH.Chat.CYAN + "Blueprint: " + tCrafted.func_82833_r());
                }
                return aList;
            }
            return aList;
        }

        public static void addEnchantment(ItemStack aStack, Enchantment aEnchantment, long aLevel) {
            NBTTagCompound tEnchantmentTag;
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.func_150297_b("ench", 9)) {
                tNBT.func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList tList = tNBT.func_150295_c("ench", 10);
            boolean temp = true;
            for (int i = 0; i < tList.func_74745_c(); ++i) {
                tEnchantmentTag = tList.func_150305_b(i);
                if (tEnchantmentTag.func_74765_d("id") != aEnchantment.field_77352_x) continue;
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                temp = false;
                break;
            }
            if (temp) {
                tEnchantmentTag = new NBTTagCompound();
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                tList.func_74742_a((NBTBase)tEnchantmentTag);
            }
            aStack.func_77982_d(tNBT);
        }
    }

    public static class Code {
        private static final DateFormat sDateFormat = DateFormat.getInstance();
        public static final int[][] ASCENDING_ARRAYS = new int[256][];

        public static byte averageBytes(byte ... aBytes) {
            if (aBytes == null || aBytes.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (byte aByte : aBytes) {
                rValue += (long)aByte;
            }
            return (byte)(rValue / (long)aBytes.length);
        }

        public static byte averageUnsignedBytes(byte ... aBytes) {
            if (aBytes == null || aBytes.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (byte aByte : aBytes) {
                rValue += (long)Code.unsignB(aByte);
            }
            return (byte)(rValue / (long)aBytes.length);
        }

        public static short averageShorts(short ... aShorts) {
            if (aShorts == null || aShorts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (short aShort : aShorts) {
                rValue += (long)aShort;
            }
            return (short)(rValue / (long)aShorts.length);
        }

        public static short averageUnsignedShorts(short ... aShorts) {
            if (aShorts == null || aShorts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (short aShort : aShorts) {
                rValue += (long)Code.unsignS(aShort);
            }
            return (short)(rValue / (long)aShorts.length);
        }

        public static int averageInts(int ... aInts) {
            if (aInts == null || aInts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (int aInt : aInts) {
                rValue += (long)aInt;
            }
            return (int)(rValue / (long)aInts.length);
        }

        public static int averageUnsignedInts(int ... aInts) {
            if (aInts == null || aInts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (int aInt : aInts) {
                rValue += Code.unsignI(aInt);
            }
            return (int)(rValue / (long)aInts.length);
        }

        public static long averageLongs(long ... aLongs) {
            if (aLongs == null || aLongs.length <= 0) {
                return 0L;
            }
            long rValue = 0L;
            for (long aLong : aLongs) {
                rValue += aLong;
            }
            return rValue / (long)aLongs.length;
        }

        public static int roundDown(double aNumber) {
            int rRounded = (int)aNumber;
            return (double)rRounded > aNumber ? rRounded - 1 : rRounded;
        }

        public static short unsignB(byte aByte) {
            return aByte < 0 ? (short)(aByte + 256) : (short)aByte;
        }

        public static int unsignS(short aShort) {
            return aShort < 0 ? aShort + 65536 : aShort;
        }

        public static long unsignI(int aInteger) {
            return aInteger < 0 ? (long)aInteger + 0x100000000L : (long)aInteger;
        }

        public static byte toByteS(short aValue, int aIndex) {
            return (byte)(0xFF & aValue >> (aIndex << 3));
        }

        public static byte toByteI(int aValue, int aIndex) {
            return (byte)(0xFF & aValue >> (aIndex << 3));
        }

        public static byte toByteL(long aValue, int aIndex) {
            return (byte)(0xFFL & aValue >> (aIndex << 3));
        }

        public static short combine(byte aValue1, byte aValue2) {
            return (short)(0xFF & aValue1 | (0xFF & aValue2) << 8);
        }

        public static int combine(byte aValue1, byte aValue2, byte aValue3, byte aValue4) {
            return 0xFF & aValue1 | (0xFF & aValue2) << 8 | (0xFF & aValue3) << 16 | (0xFF & aValue4) << 24;
        }

        public static long combine(byte aValue1, byte aValue2, byte aValue3, byte aValue4, byte aValue5, byte aValue6, byte aValue7, byte aValue8) {
            return (long)(0xFF & aValue1 | (0xFF & aValue2) << 8 | (0xFF & aValue3) << 16 | (0xFF & aValue4) << 24) | (long)(0xFF & aValue5) << 32 | (long)(0xFF & aValue6) << 40 | (long)(0xFF & aValue7) << 48 | (long)(0xFF & aValue8) << 56;
        }

        public static long getBits(boolean ... aBits) {
            long rBits = 0L;
            for (int i = 0; i < 64 && i < aBits.length; ++i) {
                if (!aBits[i]) continue;
                rBits |= (long)(1 << i);
            }
            return rBits;
        }

        public static boolean[] getBitsB(byte aBits) {
            boolean[] rBits = new boolean[8];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsS(short aBits) {
            boolean[] rBits = new boolean[16];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsI(int aBits) {
            boolean[] rBits = new boolean[32];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsL(long aBits) {
            boolean[] rBits = new boolean[64];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & (long)(1 << i)) == 0L) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static ItemStack toStack(int aStack) {
            Item tItem = Item.func_150899_d((int)(aStack & 0xFFFF));
            if (tItem != null) {
                return Stacks.make(tItem, 1L, (long)(aStack >>> 16));
            }
            return null;
        }

        public static String makeString(long aNumber) {
            String tString = "";
            boolean temp = true;
            boolean negative = false;
            if (aNumber < 0L) {
                aNumber *= -1L;
                negative = true;
            }
            for (long i = 1000000000000000000L; i > 0L; i /= 10L) {
                long tDigit = aNumber / i % 10L;
                if (temp && tDigit != 0L) {
                    temp = false;
                }
                if (temp) continue;
                tString = tString + tDigit;
                if (i == 1L) continue;
                for (long j = i; j > 0L; j /= 1000L) {
                    if (j != 1L) continue;
                    tString = tString + ",";
                }
            }
            if (tString.equals("")) {
                tString = "0";
            }
            return negative ? "-" + tString : tString;
        }

        public static <E> boolean contains(E aTarget, E ... aArray) {
            if (aArray != null) {
                for (E tValue : aArray) {
                    if (tValue != aTarget && (tValue == null || aTarget == null || !tValue.equals(aTarget))) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean containsBoolean(boolean aTarget, boolean ... aArray) {
            if (aArray != null) {
                for (boolean tValue : aArray) {
                    if (tValue != aTarget) continue;
                    return true;
                }
            }
            return false;
        }

        public static <E> boolean containsSomething(E ... aArray) {
            if (aArray != null) {
                for (E tObject : aArray) {
                    if (tObject == null) continue;
                    return true;
                }
            }
            return false;
        }

        public static <E> E[] makeArray(E[] rArray, E ... aArray) {
            for (int i = 0; i < rArray.length && i < aArray.length; ++i) {
                rArray[i] = aArray[i];
            }
            return rArray;
        }

        public static <E> long getNonNulls(E ... aArray) {
            long rAmount = 0L;
            if (aArray != null) {
                for (E tObject : aArray) {
                    if (tObject == null) continue;
                    ++rAmount;
                }
            }
            return rAmount;
        }

        public static <E> ArrayList<E> getWithoutNulls(E ... aArray) {
            if (aArray == null) {
                return new ArrayListNoNulls();
            }
            ArrayListNoNulls<E> rList = new ArrayListNoNulls<E>(Arrays.asList(aArray));
            return rList;
        }

        public static <E> ArrayList<E> getWithoutTrailingNulls(E ... aArray) {
            if (aArray == null) {
                return new ArrayList(1);
            }
            ArrayList<E> rList = new ArrayList<E>(Arrays.asList(aArray));
            int i = rList.size() - 1;
            while (i >= 0 && rList.get(i) == null) {
                rList.remove(i--);
            }
            return rList;
        }

        public static String dateAndTime() {
            return sDateFormat.format(new Date());
        }

        public static byte tier(long aSize) {
            return Code.tierMax(aSize);
        }

        public static byte tierMax(long aSize) {
            byte i = -1;
            aSize = Math.abs(aSize);
            while ((i = (byte)((byte)(i + 1))) < CS.V.length) {
                if (aSize > CS.V[i]) continue;
                return i;
            }
            return i;
        }

        public static byte tierMin(long aSize) {
            byte i = -1;
            aSize = Math.abs(aSize);
            while ((i = (byte)((byte)(i + 1))) < CS.V.length) {
                if (aSize >= CS.V[i]) continue;
                return (byte)Math.max(0, i - 1);
            }
            i = (byte)(i - 1);
            return i;
        }

        public static boolean haveOneCommonElement(Iterable aCollection1, Collection aCollection2) {
            if (aCollection1 == aCollection2) {
                return true;
            }
            for (Object tObject : aCollection1) {
                if (!aCollection2.contains(tObject)) continue;
                return true;
            }
            return false;
        }

        public static <X, Y> Map<X, Y> reMap(Map<X, Y> aMap) {
            HashMap<X, Y> tMap = new HashMap<X, Y>();
            tMap.putAll(aMap);
            aMap.clear();
            aMap.putAll(tMap);
            return aMap;
        }

        public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesAcending(Map<X, Y> aMap) {
            LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
            Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

                @Override
                public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                    return ((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
                }
            });
            LinkedHashMap rMap = new LinkedHashMap();
            for (Map.Entry entry : tEntrySet) {
                rMap.put(entry.getKey(), entry.getValue());
            }
            return rMap;
        }

        public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesDescending(Map<X, Y> aMap) {
            LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
            Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

                @Override
                public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                    return -((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
                }
            });
            LinkedHashMap rMap = new LinkedHashMap();
            for (Map.Entry entry : tEntrySet) {
                rMap.put(entry.getKey(), entry.getValue());
            }
            return rMap;
        }

        public static <E> E selectInList(long aIndex, E aReplacement, List<E> aList) {
            if (aList == null || aList.isEmpty()) {
                return aReplacement;
            }
            if ((long)aList.size() <= aIndex) {
                return aList.get(aList.size() - 1);
            }
            if (aIndex < 0L) {
                return aList.get(0);
            }
            return aList.get((int)aIndex);
        }

        public static <E> E selectInArray(long aIndex, E aReplacement, E ... aArray) {
            if (aArray == null || aArray.length == 0) {
                return aReplacement;
            }
            if ((long)aArray.length <= aIndex) {
                return aArray[aArray.length - 1];
            }
            if (aIndex < 0L) {
                return aArray[0];
            }
            return aArray[(int)aIndex];
        }

        public static boolean inArray(Object aObject, Object ... aObjects) {
            return Code.inList(aObject, Arrays.asList(aObjects));
        }

        public static boolean inList(Object aObject, Collection aObjects) {
            if (aObjects == null) {
                return false;
            }
            return aObjects.contains(aObject);
        }

        public static int[] getAscendingArray(int aLength) {
            if (aLength < 0) {
                return CS.ZL_INTEGER;
            }
            if (aLength < ASCENDING_ARRAYS.length) {
                if (ASCENDING_ARRAYS[aLength] == null) {
                    Code.ASCENDING_ARRAYS[aLength] = new int[aLength];
                    for (int i = 0; i < aLength; ++i) {
                        Code.ASCENDING_ARRAYS[aLength][i] = i;
                    }
                }
                return ASCENDING_ARRAYS[aLength];
            }
            int[] rArray = new int[aLength];
            for (int i = 0; i < aLength; ++i) {
                rArray[i] = i;
            }
            return rArray;
        }

        public static boolean stringValid(Object aString) {
            return aString != null && !aString.toString().isEmpty();
        }

        public static boolean stringInvalid(Object aString) {
            return aString == null || aString.toString().isEmpty();
        }

        public static byte side(ForgeDirection aDirection) {
            return (byte)(aDirection == null ? 6 : aDirection.ordinal());
        }

        public static byte side(int aSide) {
            return aSide > 5 || aSide < 0 ? (byte)6 : (byte)aSide;
        }

        public static <E> boolean exists(int aIndex, E[] aArray) {
            return aIndex >= 0 && aIndex < aArray.length && aArray[aIndex] != null;
        }

        public static long scale(long aValue, long aMax, long aScale, boolean aInvert) {
            long rScale = aValue <= 0L ? 0L : (aValue >= aMax ? aScale : (aScale <= 2L ? 1L : 1L + aValue * (aScale - 1L) / aMax));
            return aInvert ? aScale - rScale : rScale;
        }

        public static long scale(long aValue, long aMin, long aMax, long aScale, boolean aInvert) {
            return Code.scale(aValue - aMin, aMax - aMin, aScale, aInvert);
        }

        public static long bind(long aMin, long aMax, long aBoundValue) {
            return aMin > aMax ? Math.max(aMax, Math.min(aMin, aBoundValue)) : Math.max(aMin, Math.min(aMax, aBoundValue));
        }

        public static long bind_(long aMin, long aMax, long aBoundValue) {
            return Math.max(aMin, Math.min(aMax, aBoundValue));
        }

        public static byte bind1(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(1L, aBoundValue));
        }

        public static byte bind2(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(3L, aBoundValue));
        }

        public static byte bind3(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(7L, aBoundValue));
        }

        public static byte bind4(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(15L, aBoundValue));
        }

        public static byte bind5(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(31L, aBoundValue));
        }

        public static byte bind6(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(63L, aBoundValue));
        }

        public static byte bind7(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(127L, aBoundValue));
        }

        public static short bind8(long aBoundValue) {
            return (short)Math.max(0L, Math.min(255L, aBoundValue));
        }

        public static short bind15(long aBoundValue) {
            return (short)Math.max(0L, Math.min(32767L, aBoundValue));
        }

        public static int bind16(long aBoundValue) {
            return (int)Math.max(0L, Math.min(65535L, aBoundValue));
        }

        public static int bind31(long aBoundValue) {
            return (int)Math.max(0L, Math.min(Integer.MAX_VALUE, aBoundValue));
        }

        public static byte bindStack(long aBoundValue) {
            return (byte)Math.max(1L, Math.min(64L, aBoundValue));
        }

        public static int bindInt(long aBoundValue) {
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, aBoundValue));
        }

        public static short[] bindRGBa(short[] aColors) {
            if (aColors == null) {
                return new short[]{255, 255, 255, 255};
            }
            for (int i = 0; i < aColors.length; ++i) {
                aColors[i] = Code.bind8(aColors[i]);
            }
            return aColors;
        }

        public static int mixRGBInt(int aRGB1, int aRGB2) {
            return Code.getRGBInt(new short[]{(short)(Code.getR(aRGB1) + Code.getR(aRGB2) >> 1), (short)(Code.getG(aRGB1) + Code.getG(aRGB2) >> 1), (short)(Code.getB(aRGB1) + Code.getB(aRGB2) >> 1)});
        }

        public static int getRGBInt(short[] aColors) {
            return aColors == null ? 0xFFFFFF : Code.bind8(aColors[0]) << 16 | Code.bind8(aColors[1]) << 8 | Code.bind8(aColors[2]);
        }

        public static int getRGBaInt(short[] aColors) {
            return aColors == null ? 0xFFFFFF : Code.bind8(aColors[0]) << 16 | Code.bind8(aColors[1]) << 8 | Code.bind8(aColors[2]) | Code.bind8(aColors[3]) << 24;
        }

        public static int getRGBInt(long aR, long aG, long aB) {
            return Code.bind8(aR) << 16 | Code.bind8(aG) << 8 | Code.bind8(aB);
        }

        public static int getRGBaInt(long aR, long aG, long aB, long aA) {
            return Code.bind8(aR) << 16 | Code.bind8(aG) << 8 | Code.bind8(aB) | Code.bind8(aA) << 24;
        }

        public static short[] getRGBaArray(int aColors) {
            return new short[]{(short)(aColors >> 16 & 0xFF), (short)(aColors >> 8 & 0xFF), (short)(aColors & 0xFF), (short)(aColors >> 24 & 0xFF)};
        }

        public static short getR(int aColors) {
            return (short)(aColors >> 16 & 0xFF);
        }

        public static short getG(int aColors) {
            return (short)(aColors >> 8 & 0xFF);
        }

        public static short getB(int aColors) {
            return (short)(aColors & 0xFF);
        }

        public static short getA(int aColors) {
            return (short)(aColors >> 24 & 0xFF);
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return CS.UNCOLOURED;
            }
            IIcon tIcon = aStack.func_77954_c();
            if (tIcon == null) {
                return CS.UNCOLOURED;
            }
            String tResourceLocation = tIcon.func_94215_i();
            if (Code.stringInvalid(tResourceLocation)) {
                return CS.UNCOLOURED;
            }
            short[] rColor = Code.color(tResourceLocation);
            if (rColor == null) {
                return CS.UNCOLOURED;
            }
            short[] rModulation = Code.getRGBaArray(aStack.func_77973_b().func_82790_a(aStack, 0));
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                rColor[i] = (short)(rColor[i] * rModulation[i] / 255);
            }
            return rColor;
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(String aResourceLocation) {
            ResourceLocation aux = null;
            if (aResourceLocation.contains(":")) {
                String[] modid_itemid = aResourceLocation.split(":");
                aux = new ResourceLocation(modid_itemid[0], "textures/items/" + modid_itemid[1] + ".png");
            } else {
                aux = new ResourceLocation("minecraft", "textures/items/" + aResourceLocation + ".png");
            }
            BufferedImage tIcon = null;
            try {
                tIcon = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(aux).func_110527_b());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return tIcon == null ? null : Code.color(tIcon);
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(BufferedImage icon) {
            long tR = 0L;
            long tG = 0L;
            long tB = 0L;
            long tPixels = 0L;
            for (int tWidth = 0; tWidth < icon.getWidth(); ++tWidth) {
                for (int tHeight = 0; tHeight < icon.getHeight(); ++tHeight) {
                    int tPixel = icon.getRGB(tWidth, tHeight);
                    if ((tPixel >> 24 & 0xFF) <= 128) continue;
                    tR += (long)(tPixel >> 16 & 0xFF);
                    tG += (long)(tPixel >> 8 & 0xFF);
                    tB += (long)(tPixel & 0xFF);
                    ++tPixels;
                }
            }
            return new short[]{(short)(tR / tPixels), (short)(tG / tPixels), (short)(tB / tPixels)};
        }

        public static String capitalise(String aString) {
            if (aString != null && !aString.isEmpty()) {
                return aString.substring(0, 1).toUpperCase() + aString.substring(1);
            }
            return "";
        }

        public static byte opposite(int aSide) {
            return aSide < CS.OPPOSITES.length && aSide >= 0 ? CS.OPPOSITES[aSide] : (byte)6;
        }

        public static long units(long aAmount, long aOriginalUnit, long aTargetUnit, boolean aRoundUp) {
            if (aOriginalUnit == aTargetUnit || aOriginalUnit == 0L) {
                return aAmount;
            }
            return Math.max(0L, aAmount * aTargetUnit / aOriginalUnit + (long)(aRoundUp && aAmount * aTargetUnit % aOriginalUnit > 0L ? 1 : 0));
        }

        public static long divup(long aNumber, long aDivider) {
            return aNumber / aDivider + (long)(aNumber % aDivider == 0L ? 0 : 1);
        }

        public static boolean abs_greater(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) > Math.abs(aAmount2);
        }

        public static boolean abs_smaller(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) < Math.abs(aAmount2);
        }

        public static boolean abs_greater_equal(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) >= Math.abs(aAmount2);
        }

        public static boolean abs_smaller_equal(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) <= Math.abs(aAmount2);
        }

        public static float[] getFacingCoordsClicked(byte aSide, float aHitX, float aHitY, float aHitZ) {
            switch (aSide) {
                case 0: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aHitX)), Math.min(0.99f, Math.max(0.0f, aHitZ))};
                }
                case 1: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitX)), Math.min(0.99f, Math.max(0.0f, aHitZ))};
                }
                case 2: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aHitX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 3: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 4: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 5: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aHitZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
            }
            return new float[]{0.5f, 0.5f};
        }

        public static byte getSideForPlayerPlacing(Entity aPlayer) {
            if (aPlayer.field_70125_A >= 65.0f) {
                return 1;
            }
            if (aPlayer.field_70125_A <= -65.0f) {
                return 0;
            }
            return CS.COMPASS_DIRECTIONS[MathHelper.func_76128_c((double)((double)(4.0f * aPlayer.field_70177_z / 360.0f) + 0.5)) & 3];
        }

        public static byte getSideForPlayerPlacing(Entity aPlayer, byte aDefaultFacing, boolean[] aAllowedFacings) {
            if (aPlayer.field_70125_A >= 65.0f && aAllowedFacings[1]) {
                return 1;
            }
            if (aPlayer.field_70125_A <= -65.0f && aAllowedFacings[0]) {
                return 0;
            }
            byte rFacing = CS.COMPASS_DIRECTIONS[MathHelper.func_76128_c((double)(0.5 + (double)(4.0f * aPlayer.field_70177_z / 360.0f))) & 3];
            if (aAllowedFacings[rFacing]) {
                return rFacing;
            }
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!aAllowedFacings[tSide]) continue;
                return tSide;
            }
            return aDefaultFacing;
        }

        public static byte getOppositeSideForPlayerPlacing(Entity aPlayer, byte aDefaultFacing, boolean[] aAllowedFacings) {
            if (aPlayer.field_70125_A >= 65.0f && aAllowedFacings[0]) {
                return 0;
            }
            if (aPlayer.field_70125_A <= -65.0f && aAllowedFacings[1]) {
                return 1;
            }
            byte rFacing = CS.OPPOSITES[CS.COMPASS_DIRECTIONS[MathHelper.func_76128_c((double)(0.5 + (double)(4.0f * aPlayer.field_70177_z / 360.0f))) & 3]];
            if (aAllowedFacings[rFacing]) {
                return rFacing;
            }
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!aAllowedFacings[tSide]) continue;
                return tSide;
            }
            return aDefaultFacing;
        }

        public static byte getSideWrenching(byte aSide, float aHitX, float aHitY, float aHitZ) {
            switch (aSide) {
                case 0: 
                case 1: {
                    if ((double)aHitX < 0.25) {
                        return (byte)((double)aHitZ < 0.25 || (double)aHitZ > 0.75 ? CS.OPPOSITES[aSide] : 4);
                    }
                    if ((double)aHitX > 0.75) {
                        return (byte)((double)aHitZ < 0.25 || (double)aHitZ > 0.75 ? CS.OPPOSITES[aSide] : 5);
                    }
                    if ((double)aHitZ < 0.25) {
                        return 2;
                    }
                    if ((double)aHitZ > 0.75) {
                        return 3;
                    }
                    return aSide;
                }
                case 2: 
                case 3: {
                    if ((double)aHitX < 0.25) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPPOSITES[aSide] : 4);
                    }
                    if ((double)aHitX > 0.75) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPPOSITES[aSide] : 5);
                    }
                    if ((double)aHitY < 0.25) {
                        return 0;
                    }
                    if ((double)aHitY > 0.75) {
                        return 1;
                    }
                    return aSide;
                }
                case 4: 
                case 5: {
                    if ((double)aHitZ < 0.25) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPPOSITES[aSide] : 2);
                    }
                    if ((double)aHitZ > 0.75) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPPOSITES[aSide] : 3);
                    }
                    if ((double)aHitY < 0.25) {
                        return 0;
                    }
                    if ((double)aHitY > 0.75) {
                        return 1;
                    }
                    return aSide;
                }
            }
            return -1;
        }
    }

    public static class Stacks {
        private static final Map<String, ItemStack> sIC2ItemMap = new HashMap<String, ItemStack>();

        public static boolean debugItem(ItemStack aStack) {
            return IL.IC2_Debug.equal(aStack, true, true);
        }

        public static ItemStack update(ItemStack aStack) {
            return Stacks.valid(aStack) ? Stacks.update_(aStack) : aStack;
        }

        public static ItemStack update_(ItemStack aStack) {
            if (aStack.func_77942_o() && aStack.func_77978_p().func_82582_d()) {
                aStack.func_77982_d(null);
            }
            if (aStack.func_77973_b() instanceof IItemUpdatable) {
                ((IItemUpdatable)aStack.func_77973_b()).updateItemStack(aStack);
            }
            return aStack;
        }

        public static boolean inList(Collection<ItemStack> aList, ItemStack aStack, boolean aTrueIfListEmpty, boolean aInvertFilter) {
            if (aStack == null || aStack.field_77994_a < 1) {
                return false;
            }
            if (aList == null) {
                return aTrueIfListEmpty;
            }
            while (aList.contains(null)) {
                aList.remove(null);
            }
            if (aList.size() < 1) {
                return aTrueIfListEmpty;
            }
            Iterator<ItemStack> tIterator = aList.iterator();
            ItemStack tStack = null;
            while (tIterator.hasNext()) {
                tStack = tIterator.next();
                if (tStack == null || !Stacks.equal(aStack, tStack)) continue;
                return !aInvertFilter;
            }
            return aInvertFilter;
        }

        public static ItemStack set(Object aSetStack, Object aToStack) {
            if (Stacks.invalid(aSetStack) || Stacks.invalid(aToStack)) {
                return null;
            }
            ((ItemStack)aSetStack).func_150996_a(((ItemStack)aToStack).func_77973_b());
            ((ItemStack)aSetStack).field_77994_a = ((ItemStack)aToStack).field_77994_a;
            Stacks.meta((ItemStack)aSetStack, Stacks.meta((ItemStack)aToStack));
            ((ItemStack)aSetStack).func_77982_d(((ItemStack)aToStack).func_77978_p());
            return (ItemStack)aSetStack;
        }

        public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            if (Stacks.invalid(aStack)) {
                return CS.NI;
            }
            if (aStack.func_77973_b().hasContainerItem(aStack)) {
                return Stacks.copy(aStack.func_77973_b().getContainerItem(aStack));
            }
            if (IL.Cell_Empty.equal(aStack, false, true)) {
                return CS.NI;
            }
            if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
                ItemStack tStack = Stacks.amount(1L, aStack);
                ((IFluidContainerItem)aStack.func_77973_b()).drain(tStack, Integer.MAX_VALUE, true);
                return tStack.field_77994_a > 0 ? tStack : CS.NI;
            }
            if (IL.IC2_ForgeHammer.equal(aStack, true, true) || IL.IC2_WireCutter.equal(aStack, true, true)) {
                return Stacks.copyMeta(Stacks.meta(aStack) + 1, aStack);
            }
            return CS.NI;
        }

        public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems, int aStacksize) {
            return Stacks.amount(aStacksize, Stacks.container(aStack, aCheckIFluidContainerItems));
        }

        public static boolean equal(ItemStack aStack1, ItemStack aStack2) {
            return Stacks.equal(aStack1, aStack2, false);
        }

        public static boolean equalTools(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return aStack1 != null && aStack2 != null && Stacks.equalTools_(aStack1, aStack2, aIgnoreNBT);
        }

        public static boolean equalTools_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return !(aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && !(aStack1.func_77973_b() instanceof IItemGTContainerTool) && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || Stacks.meta(aStack1) != Stacks.meta(aStack2) && Stacks.meta(aStack1) != Short.MAX_VALUE && Stacks.meta(aStack2) != Short.MAX_VALUE);
        }

        public static boolean equal(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return aStack1 != null && aStack2 != null && Stacks.equal_(aStack1, aStack2, aIgnoreNBT);
        }

        public static boolean equal_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return !(aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || Stacks.meta(aStack1) != Stacks.meta(aStack2) && Stacks.meta(aStack1) != Short.MAX_VALUE && Stacks.meta(aStack2) != Short.MAX_VALUE);
        }

        public static short id(Item aItem) {
            return aItem == null ? (short)0 : (short)Item.func_150891_b((Item)aItem);
        }

        public static short id(ItemStack aStack) {
            return aStack == null ? (short)0 : Stacks.id(aStack.func_77973_b());
        }

        public static Item item(ItemStack aStack) {
            return aStack == null ? null : aStack.func_77973_b();
        }

        public static short meta(ItemStack aStack) {
            return (short)Items.field_151008_G.getDamage(aStack);
        }

        public static ItemStack meta(ItemStack aStack, long aMeta) {
            Items.field_151008_G.setDamage(aStack, (int)((short)aMeta));
            return aStack;
        }

        public static boolean rotten(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return false;
            }
            if (aStack.func_77973_b() instanceof MultiItemRandom) {
                IFoodStat tStat = ((MultiItemRandom)aStack.func_77973_b()).mFoodStats.get(Stacks.meta(aStack));
                return tStat != null && tStat.isRotten((MultiItemRandom)aStack.func_77973_b(), aStack, null);
            }
            return aStack.func_77973_b() == Items.field_151078_bh || OM.materialcontained(aStack, MT.MeatRotten, MT.FishRotten);
        }

        public static int food(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return 0;
            }
            if (aStack.func_77973_b() instanceof ItemFood) {
                return ((ItemFood)aStack.func_77973_b()).func_150905_g(aStack);
            }
            if (aStack.func_77973_b() instanceof MultiItemRandom) {
                IFoodStat tStat = ((MultiItemRandom)aStack.func_77973_b()).mFoodStats.get(Stacks.meta(aStack));
                return tStat == null ? 0 : tStat.getFoodLevel((MultiItemRandom)aStack.func_77973_b(), aStack, null);
            }
            return 0;
        }

        public static float saturation(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return 0.0f;
            }
            if (aStack.func_77973_b() instanceof ItemFood) {
                return ((ItemFood)aStack.func_77973_b()).func_150906_h(aStack);
            }
            if (aStack.func_77973_b() instanceof MultiItemRandom) {
                IFoodStat tStat = ((MultiItemRandom)aStack.func_77973_b()).mFoodStats.get(Stacks.meta(aStack));
                return tStat == null ? 0.0f : tStat.getSaturation((MultiItemRandom)aStack.func_77973_b(), aStack, null);
            }
            return 0.0f;
        }

        public static ItemStack fuel(ItemStack aStack, short aValue) {
            aStack.func_77982_d(NBT.getNBTShort(aStack.func_77978_p(), "gt.fuelvalue", aValue));
            return aStack;
        }

        public static long fuel(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return 0L;
            }
            long rFuelValue = GameRegistry.getFuelValue((ItemStack)aStack);
            if (rFuelValue > 0L) {
                return rFuelValue;
            }
            Item tItem = aStack.func_77973_b();
            if (tItem instanceof ItemBlock && Block.func_149634_a((Item)tItem) != CS.NB) {
                Block tBlock = Block.func_149634_a((Item)tItem);
                if (tBlock == Blocks.field_150345_g) {
                    return 100L;
                }
                if (tBlock == Blocks.field_150376_bx) {
                    return 150L;
                }
                if (tBlock == Blocks.field_150402_ci) {
                    return 16000L;
                }
                if (tBlock.func_149688_o() == Material.field_151575_d) {
                    return 300L;
                }
            }
            if (tItem instanceof ItemTool && ((ItemTool)tItem).func_77861_e().equals("WOOD")) {
                return 200L;
            }
            if (tItem instanceof ItemSword && ((ItemSword)tItem).func_150932_j().equals("WOOD")) {
                return 200L;
            }
            if (tItem instanceof ItemHoe && ((ItemHoe)tItem).func_77842_f().equals("WOOD")) {
                return 200L;
            }
            if (tItem == Items.field_151055_y) {
                return 100L;
            }
            if (tItem == Items.field_151044_h) {
                return 1600L;
            }
            if (tItem == Items.field_151072_bj) {
                return 2400L;
            }
            if (tItem == Items.field_151129_at) {
                return 20000L;
            }
            return 0L;
        }

        public static ItemStack makeIC2(String aItem, long aAmount, ItemStack aReplacement) {
            if (Code.stringInvalid(aItem) || !GT_API.sAllowCrossModItemAccess) {
                return null;
            }
            if (!sIC2ItemMap.containsKey(aItem)) {
                try {
                    ItemStack tStack = IC2Items.getItem((String)aItem);
                    sIC2ItemMap.put(aItem, tStack);
                    if (tStack == null && CS.D1) {
                        CS.ERR.println(aItem + " is not found in the IC2 Items!");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return Stacks.amount(aAmount, sIC2ItemMap.get(aItem), aReplacement);
        }

        public static ItemStack makeIC2(String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            ItemStack rStack = Stacks.makeIC2(aItem, aAmount, aReplacement);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        public static ItemStack makeIC2(String aItem, long aAmount, int aMeta) {
            return Stacks.makeIC2(aItem, aAmount, aMeta, null);
        }

        public static ItemStack makeIC2(String aItem, long aAmount) {
            return Stacks.makeIC2(aItem, aAmount, null);
        }

        public static Block block(ModData aModID, String aBlock) {
            return Stacks.block(Stacks.make(aModID, aBlock, 1L, null));
        }

        public static Block block(ModData aModID, String aBlock, Block aReplacement) {
            Block rBlock = Stacks.block(aModID, aBlock);
            return rBlock == CS.NB ? aReplacement : rBlock;
        }

        public static Block block(String aModID, String aBlock) {
            return Stacks.block(Stacks.make(aModID, aBlock, 1L, null));
        }

        public static Block block(String aModID, String aBlock, Block aReplacement) {
            Block rBlock = Stacks.block(aModID, aBlock);
            return rBlock == CS.NB ? aReplacement : rBlock;
        }

        public static ItemStack make(ModData aModID, String aItem, long aAmount) {
            return Stacks.make(aModID, aItem, aAmount, null);
        }

        public static ItemStack make(ModData aModID, String aItem, long aAmount, ItemStack aReplacement) {
            if (Code.stringInvalid(aItem) || !GT_API.sAllowCrossModItemAccess) {
                return null;
            }
            if (aItem.length() > 5 && aItem.charAt(0) == 't' && aItem.charAt(1) == 'i' && aItem.charAt(2) == 'l' && aItem.charAt(3) == 'e' && aItem.charAt(4) == '.') {
                return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID.mID, (String)aItem, (int)((int)aAmount)), GameRegistry.findItemStack((String)aModID.mID, (String)aItem.substring(5), (int)((int)aAmount)), aReplacement);
            }
            return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID.mID, (String)aItem, (int)((int)aAmount)), aReplacement);
        }

        public static ItemStack make(ModData aModID, String aItem, long aAmount, int aMeta) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        public static ItemStack make(ModData aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount, aReplacement);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        public static ItemStack make(String aModID, String aItem, long aAmount) {
            return Stacks.make(aModID, aItem, aAmount, null);
        }

        public static ItemStack make(String aModID, String aItem, long aAmount, ItemStack aReplacement) {
            if (Code.stringInvalid(aItem) || !GT_API.sAllowCrossModItemAccess) {
                return null;
            }
            if (aItem.length() > 5 && aItem.charAt(0) == 't' && aItem.charAt(1) == 'i' && aItem.charAt(2) == 'l' && aItem.charAt(3) == 'e' && aItem.charAt(4) == '.') {
                return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), GameRegistry.findItemStack((String)aModID, (String)aItem.substring(5), (int)((int)aAmount)), aReplacement);
            }
            return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), aReplacement);
        }

        public static ItemStack make(String aModID, String aItem, long aAmount, int aMeta) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        public static ItemStack make(String aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount, aReplacement);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        public static ItemStack make(long aItemID, long aStacksize, long aMetaData) {
            return aItemID == 0L ? null : Stacks.make(Item.func_150899_d((int)((int)aItemID)), aStacksize, aMetaData);
        }

        public static ItemStack make(Item aItem, long aStacksize, long aMetaData) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), null);
        }

        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), null);
        }

        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aItemID == 0L ? null : Stacks.make(Item.func_150899_d((int)((int)aItemID)), aStacksize, aMetaData, aNBT);
        }

        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aNBT);
        }

        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aNBT);
        }

        public static ItemStack make(ItemStack aStack, NBTTagCompound aNBT) {
            return Stacks.make(aStack, null, aNBT);
        }

        public static ItemStack make(ItemStackContainer aStack, NBTTagCompound aNBT) {
            return Stacks.make(aStack, null, aNBT);
        }

        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, String aName) {
            return aItemID == 0L ? null : Stacks.make(Item.func_150899_d((int)((int)aItemID)), aStacksize, aMetaData, aName);
        }

        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, String aName) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aName, null);
        }

        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, String aName) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aName, null);
        }

        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aItemID == 0L ? null : Stacks.make(Item.func_150899_d((int)((int)aItemID)), aStacksize, aMetaData, aName, aNBT);
        }

        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aName, aNBT);
        }

        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aName, aNBT);
        }

        public static ItemStack make(ItemStack aStack, String aName, NBTTagCompound aNBT) {
            if (aStack == null) {
                return null;
            }
            aStack = aStack.func_77946_l();
            aStack.func_77982_d(aNBT);
            if (aName != null) {
                aStack.func_151001_c(aName);
            }
            return aStack;
        }

        public static ItemStack make(ItemStackContainer aStack, String aName, NBTTagCompound aNBT) {
            if (aStack == null) {
                return null;
            }
            ItemStack rStack = aStack.toStack();
            if (rStack == null) {
                return null;
            }
            rStack.func_77982_d(aNBT);
            if (aName != null) {
                rStack.func_151001_c(aName);
            }
            return rStack;
        }

        public static ItemStack[] copyArray(Object ... aStacks) {
            ItemStack[] rStacks = new ItemStack[aStacks.length];
            for (int i = 0; i < aStacks.length; ++i) {
                rStacks[i] = Stacks.copy(aStacks[i]);
            }
            return rStacks;
        }

        public static ItemStack copy(Object ... aStacks) {
            for (Object tStack : aStacks) {
                if (!Stacks.valid(tStack)) continue;
                return ((ItemStack)tStack).func_77946_l();
            }
            return null;
        }

        public static ItemStack amount(long aAmount, Object ... aStacks) {
            ItemStack rStack = Stacks.copy(aStacks);
            if (Stacks.invalid(rStack)) {
                return null;
            }
            rStack.field_77994_a = (int)aAmount;
            return rStack;
        }

        public static ItemStack copyAmount(long aAmount, Object ... aStacks) {
            return Stacks.amount(aAmount, aStacks);
        }

        public static ItemStack copyMeta(long aMetaData, Object ... aStacks) {
            ItemStack rStack = Stacks.copy(aStacks);
            if (Stacks.invalid(rStack)) {
                return null;
            }
            return Stacks.meta(rStack, aMetaData);
        }

        public static ItemStack copyAmountAndMeta(long aAmount, long aMetaData, Object ... aStacks) {
            ItemStack rStack = Stacks.amount(aAmount, aStacks);
            if (Stacks.invalid(rStack)) {
                return null;
            }
            return Stacks.meta(rStack, aMetaData);
        }

        public static ItemStack mul(long aMultiplier, Object ... aStacks) {
            ItemStack rStack = Stacks.copy(aStacks);
            if (rStack == null) {
                return null;
            }
            rStack.field_77994_a = (int)((long)rStack.field_77994_a * aMultiplier);
            return rStack;
        }

        public static ItemStack div(long aDivider, Object ... aStacks) {
            ItemStack rStack = Stacks.copy(aStacks);
            if (rStack == null) {
                return null;
            }
            rStack.field_77994_a = (int)((long)rStack.field_77994_a / aDivider);
            return rStack;
        }

        public static int toInt(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return 0;
            }
            return Stacks.id(aStack) | Stacks.meta(aStack) << 16;
        }

        public static int toIntWildcard(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return 0;
            }
            return Stacks.id(aStack) | 0x7FFF0000;
        }

        public static ItemStack toStack(int aStack) {
            Item tItem = Item.func_150899_d((int)(aStack & 0xFFFF));
            if (tItem != null) {
                return Stacks.make(tItem, 1L, (long)(aStack >>> 16));
            }
            return null;
        }

        public static Integer[] toIntegerArray(ItemStack ... aStacks) {
            Integer[] rArray = new Integer[aStacks.length];
            for (int i = 0; i < rArray.length; ++i) {
                rArray[i] = Stacks.toInt(aStacks[i]);
            }
            return rArray;
        }

        public static int[] toIntArray(ItemStack ... aStacks) {
            int[] rArray = new int[aStacks.length];
            for (int i = 0; i < rArray.length; ++i) {
                rArray[i] = Stacks.toInt(aStacks[i]);
            }
            return rArray;
        }

        public static Block block(Object aStack) {
            if (Stacks.invalid(aStack)) {
                return CS.NB;
            }
            return Block.func_149634_a((Item)((ItemStack)aStack).func_77973_b());
        }

        public static Block block_(Object aStack) {
            return Block.func_149634_a((Item)((ItemStack)aStack).func_77973_b());
        }

        public static boolean valid(Object aStack) {
            return aStack != null && aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
        }

        public static boolean invalid(Object aStack) {
            return aStack == null || !(aStack instanceof ItemStack) || ((ItemStack)aStack).func_77973_b() == null || ((ItemStack)aStack).field_77994_a < 0;
        }

        public static String configName(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return "";
            }
            Object rName = OreDictManager.INSTANCE.getAssociation_(aStack, true);
            if (rName != null) {
                return rName.toString();
            }
            try {
                rName = aStack.func_77977_a();
                if (Code.stringValid(rName)) {
                    return rName.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return aStack.func_77973_b() + "." + Stacks.meta(aStack);
        }

        public static String configNames(ItemStack ... aStacks) {
            String rString = "";
            for (ItemStack tStack : aStacks) {
                rString = rString + (tStack == null ? "null;" : Stacks.configName(tStack) + ";");
            }
            return rString;
        }

        public static String names(ItemStack ... aStacks) {
            String rString = "";
            for (ItemStack tStack : aStacks) {
                rString = rString + (tStack == null ? "null; " : tStack.func_82833_r() + "; ");
            }
            return rString;
        }

        public static String namesAndSizes(ItemStack ... aStacks) {
            String rString = "";
            for (ItemStack tStack : aStacks) {
                rString = rString + (tStack == null ? "null; " : tStack.func_82833_r() + " " + tStack.field_77994_a + "; ");
            }
            return rString;
        }

        public static void hide(Item aItem) {
            Stacks.hide(aItem, 32767L);
        }

        public static void hide(Item aItem, long aMetaData) {
            Stacks.hide(Stacks.make(aItem, 1L, aMetaData));
        }

        public static void hide(Block aBlock) {
            Stacks.hide(aBlock, 32767L);
        }

        public static void hide(Block aBlock, long aMetaData) {
            Stacks.hide(Stacks.make(aBlock, 1L, aMetaData));
        }

        public static void hide(ItemStack aStack) {
            if (aStack != null) {
                try {
                    API.hideItem((ItemStack)aStack);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public static ItemStack load(NBTTagCompound aNBT, String aTagName) {
            return aNBT == null ? null : Stacks.load(aNBT.func_74775_l(aTagName));
        }

        public static ItemStack load(NBTTagCompound aNBT) {
            if (aNBT == null || aNBT.func_82582_d()) {
                return null;
            }
            ItemStack rStack = Stacks.make(Item.func_150899_d((int)aNBT.func_74765_d("id")), (long)aNBT.func_74762_e("Count"), (long)aNBT.func_74765_d("Damage"), aNBT.func_150297_b("tag", 10) ? aNBT.func_74775_l("tag") : null);
            if (rStack == null) {
                return null;
            }
            if (rStack.func_77973_b().getClass().getName().startsWith("ic2.core.migration")) {
                rStack.func_77973_b().func_77663_a(rStack, (World)CS.DW, null, 0, false);
            }
            return Stacks.update_(OM.get_(rStack));
        }

        public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, ItemStack aStack) {
            NBTTagCompound rNBT = Stacks.save(aStack);
            if (rNBT != null) {
                aNBT.func_74782_a(aTagName, (NBTBase)rNBT);
            }
            return rNBT;
        }

        public static NBTTagCompound save(ItemStack aStack) {
            if (Stacks.invalid(aStack)) {
                return null;
            }
            NBTTagCompound rNBT = new NBTTagCompound();
            aStack = OM.get_(aStack);
            rNBT.func_74777_a("id", (short)Item.func_150891_b((Item)aStack.func_77973_b()));
            NBT.setNumber(rNBT, "Count", aStack.field_77994_a);
            rNBT.func_74777_a("Damage", Stacks.meta(aStack));
            if (aStack.func_77942_o()) {
                rNBT.func_74782_a("tag", (NBTBase)aStack.func_77978_p());
            }
            return rNBT;
        }
    }

    public static class Books {
        public static final Map<String, ItemStack> BOOK_MAP = new HashMap<String, ItemStack>();
        public static final List<String> BOOK_LIST = new ArrayListNoNulls<String>();
        public static final List<String> MATERIAL_DICTIONARIES = new ArrayListNoNulls<String>();

        public static ItemStack getWrittenBook(String aMapping) {
            return Books.getWrittenBook(aMapping, null);
        }

        public static ItemStack getWrittenBook(String aMapping, ItemStack aStackToPutNBT) {
            ItemStack tStack = BOOK_MAP.get(aMapping);
            if (tStack == null) {
                return aStackToPutNBT == null ? Stacks.make(Items.field_151164_bB, 1L, 0L) : aStackToPutNBT;
            }
            if (aStackToPutNBT == null) {
                aStackToPutNBT = Stacks.copy(tStack);
            }
            aStackToPutNBT.func_77982_d((NBTTagCompound)tStack.func_77978_p().func_74737_b());
            return aStackToPutNBT;
        }

        public static ItemStack getBookWithTitle(String aMapping) {
            return Books.getBookWithTitle(aMapping, null);
        }

        public static ItemStack getBookWithTitle(String aMapping, ItemStack aStackToPutNBT) {
            ItemStack tStack = BOOK_MAP.get(aMapping);
            if (tStack == null) {
                return aStackToPutNBT == null ? Stacks.make(Items.field_151164_bB, 1L, 0L) : aStackToPutNBT;
            }
            if (aStackToPutNBT == null) {
                aStackToPutNBT = Stacks.copy(tStack);
            }
            aStackToPutNBT.func_77982_d(NBT.getNBTs(null, "title", NBT.getBookTitle(tStack), "author", NBT.getBookAuthor(tStack), "book", aMapping));
            return aStackToPutNBT;
        }

        public static ItemStack createWrittenBook(String aMapping, String aTitle, String aAuthor, ItemStack aDefaultBook, String ... aPages) {
            return Books.createWrittenBook(aMapping, aTitle, aAuthor, aDefaultBook, true, aPages);
        }

        public static ItemStack createWrittenBook(String aMapping, String aTitle, String aAuthor, ItemStack aDefaultBook, boolean aLogging, String ... aPages) {
            NBTTagCompound rNBT;
            if (Code.stringInvalid(aMapping)) {
                return null;
            }
            ItemStack rStack = BOOK_MAP.get(aMapping);
            if (rStack == null) {
                ItemStack itemStack = rStack = aDefaultBook == null ? Stacks.make(Items.field_151164_bB, 1L, 0L) : Stacks.amount(1L, aDefaultBook);
            }
            if ((rNBT = rStack.func_77978_p()) != null) {
                return Stacks.copy(rStack);
            }
            if (Code.stringInvalid(aTitle) || Code.stringInvalid(aAuthor) || aPages.length <= 0) {
                return null;
            }
            rNBT = new NBTTagCompound();
            rNBT.func_74778_a("title", aTitle);
            rNBT.func_74778_a("author", aAuthor);
            NBTTagList tNBTList = new NBTTagList();
            for (int i = 0; i < aPages.length; i = (int)((byte)(i + 1))) {
                if (i == 49 && CS.D1) {
                    CS.OUT.println("NOTE: Written Book has more than 50 Pages -> " + aMapping);
                }
                if (aPages[i].length() < 256) {
                    tNBTList.func_74742_a((NBTBase)new NBTTagString(aPages[i]));
                    continue;
                }
                CS.ERR.println("WARNING: String for Page of written Book too long! -> " + aPages[i]);
            }
            rNBT.func_74782_a("pages", (NBTBase)tNBTList);
            if (aLogging) {
                CS.OUT.println("NOTE: Added Book to Book List  -  Mapping: '" + aMapping + "'  -  Name: '" + aTitle + "'  -  Author: '" + aAuthor + "'");
            }
            rStack.func_77982_d(rNBT);
            BOOK_MAP.put(aMapping, Stacks.copy(rStack));
            BOOK_LIST.add(aMapping);
            return Stacks.copy(rStack);
        }

        /*
         * WARNING - void declaration
         */
        public static ItemStack createMaterialDictionary(OreDictMaterial aMat, ItemStack aDefaultBook, ItemStack aDefaultLargeBook) {
            String tPage = "";
            ArrayListNoNulls<String> tBook = new ArrayListNoNulls<String>();
            boolean temp = false;
            int tCounter = 0;
            tBook.add("===================\n" + aMat.getLocal() + "\n===================\nID: " + (aMat.mID < 0 ? "NONE" : Short.valueOf(aMat.mID)) + "\nMelting: " + aMat.mMeltingPoint + " K\nBoiling: " + aMat.mBoilingPoint + " K\nPlasma: " + aMat.mPlasmaPoint + " K\n===================\nDensity:\n" + aMat.mGramPerCubicCentimeter + " g/cm3\n" + aMat.getWeight(420076800L) + " kg/unit\n===================\n");
            if (aMat.mComponents == null) {
                if (aMat.contains(TD.Atomic.ELEMENT)) {
                    temp = true;
                    tPage = "Atomic Structure:\nProtons: " + aMat.mProtons + "\nElectrons: " + aMat.mElectrons + "\nNeutrons: " + aMat.mNeutrons + "\nMass: " + aMat.mMass + "\n===================\n";
                    for (TagData tTag : TD.Atomic.ALL) {
                        if (tTag == TD.Atomic.ELEMENT || tTag == TD.Atomic.NONMETAL || !aMat.contains(tTag)) continue;
                        tPage = tPage + tTag.getLocalisedNameLong() + "\n";
                    }
                }
            } else {
                temp = true;
                tPage = "Components per " + aMat.mComponents.getCommonDivider() + "\n===================\n";
                for (OreDictMaterialStack tMaterial : aMat.mComponents.getUndividedComponents()) {
                    tPage = tPage + tMaterial.mAmount / 420076800L + " " + tMaterial.mMaterial.getLocal() + "\n";
                }
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Tool Properties\n===================\n";
            if (aMat.contains(TD.Properties.HAS_TOOL_STATS)) {
                temp = true;
                tPage = tPage + "Durability:\n" + aMat.mToolDurability + "\nQuality:\n" + aMat.mToolQuality + "\nSpeed:\n" + aMat.mToolSpeed + "\nHandle:\n" + aMat.mHandleMaterial.getLocal() + "\n";
            }
            for (ObjectStack<Object> tEnchantment : aMat.mEnchantmentTools) {
                temp = true;
                tPage = tPage + "Tool Enchantment:\n" + ((Enchantment)tEnchantment.mObject).func_77316_c((int)tEnchantment.mAmount) + "\n";
            }
            for (ObjectStack<Object> tEnchantment : aMat.mEnchantmentArmors) {
                temp = true;
                tPage = tPage + "Armor Enchantment:\n" + ((Enchantment)tEnchantment.mObject).func_77316_c((int)tEnchantment.mAmount) + "\n";
            }
            if (temp) {
                tBook.add(tPage + "===================\n");
                temp = false;
            }
            tPage = "Properties\n===================\n";
            for (TagData tTag : TD.Properties.ALL_RELEVANTS) {
                if (!aMat.contains(tTag)) continue;
                temp = true;
                tPage = tPage + tTag.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Machine Processing\n===================\n";
            for (TagData tTag : TD.Processing.ALL_MACHINES) {
                if (!aMat.contains(tTag)) continue;
                temp = true;
                tPage = tPage + tTag.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Materials which can be decomposed to this\n===================\n";
            tCounter = 0;
            block6: for (OreDictMaterial tMat : OreDictMaterial.MATERIAL_MAP.values()) {
                if (tMat.mComponents == null || !tMat.contains(TD.Compounds.DECOMPOSABLE)) continue;
                for (OreDictMaterialStack tMt2 : tMat.mComponents.getUndividedComponents()) {
                    if (tMt2.mMaterial != aMat) continue;
                    temp = tCounter++ % 6 != 5;
                    tPage = tPage + tMat.getLocal() + "\n";
                    if (temp) continue block6;
                    tBook.add(tPage);
                    tPage = "Materials which can be decomposed to this\n===================\n";
                    continue block6;
                }
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ore Processing\n===================\n";
            for (TagData tTag : TD.Processing.ALL_ORES) {
                if (!aMat.contains(tTag)) continue;
                temp = true;
                tPage = tPage + tTag.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ore Byproducts\n===================\n";
            for (OreDictMaterial tMat : aMat.mByProducts) {
                temp = true;
                tPage = tPage + tMat.getLocal() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ores with this as Byproduct\n===================\n";
            tCounter = 0;
            for (OreDictMaterial tMat : OreDictMaterial.MATERIAL_MAP.values()) {
                if (!tMat.mByProducts.contains(aMat)) continue;
                temp = tCounter++ % 6 != 5;
                tPage = tPage + tMat.getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Ores with this as Byproduct\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Smelting:\n" + aMat.mTargetSmelting.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetSmelting.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetSmelting.mAmount <= 0L ? "nothing" : (aMat.mTargetSmelting.mMaterial == aMat ? "itself" : aMat.mTargetSmelting.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Solidifying:\n" + aMat.mTargetSolidifying.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetSolidifying.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetSolidifying.mAmount <= 0L ? "nothing" : (aMat.mTargetSolidifying.mMaterial == aMat ? "itself" : aMat.mTargetSolidifying.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Burning:\n" + aMat.mTargetBurning.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetBurning.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetBurning.mAmount <= 0L ? "nothing" : (aMat.mTargetBurning.mMaterial == aMat ? "itself" : aMat.mTargetBurning.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Pulverising:\n" + aMat.mTargetPulver.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetPulver.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetPulver.mAmount <= 0L ? "nothing" : (aMat.mTargetPulver.mMaterial == aMat ? "itself" : aMat.mTargetPulver.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Crushing:\n" + aMat.mTargetCrushing.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetCrushing.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetCrushing.mAmount <= 0L ? "nothing" : (aMat.mTargetCrushing.mMaterial == aMat ? "itself" : aMat.mTargetCrushing.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Bending:\n" + aMat.mTargetBending.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetBending.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetBending.mAmount <= 0L ? "nothing" : (aMat.mTargetBending.mMaterial == aMat ? "itself" : aMat.mTargetBending.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Compressing:\n" + aMat.mTargetCompressing.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetCompressing.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetCompressing.mAmount <= 0L ? "nothing" : (aMat.mTargetCompressing.mMaterial == aMat ? "itself" : aMat.mTargetCompressing.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Cutting:\n" + aMat.mTargetCutting.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetCutting.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetCutting.mAmount <= 0L ? "nothing" : (aMat.mTargetCutting.mMaterial == aMat ? "itself" : aMat.mTargetCutting.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Forging:\n" + aMat.mTargetForging.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetForging.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetForging.mAmount <= 0L ? "nothing" : (aMat.mTargetForging.mMaterial == aMat ? "itself" : aMat.mTargetForging.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Smashing:\n" + aMat.mTargetSmashing.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetSmashing.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetSmashing.mAmount <= 0L ? "nothing" : (aMat.mTargetSmashing.mMaterial == aMat ? "itself" : aMat.mTargetSmashing.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Working:\n" + aMat.mTargetWorking.mAmount / 420076800L + "." + (int)((double)(aMat.mTargetWorking.mAmount % 420076800L) / 4.200768E8 * 1000.0) + " " + (aMat.mTargetWorking.mAmount <= 0L ? "nothing" : (aMat.mTargetWorking.mMaterial == aMat ? "itself" : aMat.mTargetWorking.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Thaumaturgic Data\n===================\nAspects:\n";
            if (aMat.mAspects.isEmpty()) {
                tPage = tPage + "None\n";
            } else {
                for (TC.TC_AspectStack tAspect : aMat.mAspects) {
                    tPage = tPage + tAspect.mAmount + "x " + tAspect.mAspect.mName + "\n";
                }
            }
            tPage = tPage + "===================\n";
            tBook.add(tPage);
            HashMap<OreDictMaterial, Long> tMap = new HashMap<OreDictMaterial, Long>();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetSmelting.mMaterial != aMat || oreDictMaterial.mTargetSmelting.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetSmelting.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to smelt for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to smelt for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetBurning.mMaterial != aMat || oreDictMaterial.mTargetBurning.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetBurning.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to burn for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to burn for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetPulver.mMaterial != aMat || oreDictMaterial.mTargetPulver.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetPulver.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to pulverise for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to pulverise for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetBending.mMaterial != aMat || oreDictMaterial.mTargetBending.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetBending.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to bend for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to bend for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetCompressing.mMaterial != aMat || oreDictMaterial.mTargetCompressing.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCompressing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to compress for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to compress for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetCrushing.mMaterial != aMat || oreDictMaterial.mTargetCrushing.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCrushing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to crush for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to crush for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetCutting.mMaterial != aMat || oreDictMaterial.mTargetCutting.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCutting.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to cut for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to cut for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetForging.mMaterial != aMat || oreDictMaterial.mTargetForging.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetForging.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to forge for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to forge for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetSmashing.mMaterial != aMat || oreDictMaterial.mTargetSmashing.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetSmashing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to smash for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to smash for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || oreDictMaterial.mTargetWorking.mMaterial != aMat || oreDictMaterial.mTargetWorking.mAmount <= 0L || oreDictMaterial.getLocal().equals(aMat.getLocal())) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetWorking.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to use in other ways for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            Iterator<Object> i$ = tMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 420076800L + "." + (int)((double)((Long)entry.getValue() % 420076800L) / 4.200768E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to use in other ways for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            if ((i$ = aMat.mAlloyCreationRecipes.iterator()).hasNext()) {
                IOreDictConfigurationComponent iOreDictConfigurationComponent = (IOreDictConfigurationComponent)i$.next();
                tPage = "Alloy:\n" + aMat.getLocal() + "\n===================\nMelting: " + aMat.mMeltingPoint + " K\nBoiling: " + aMat.mBoilingPoint + " K\n===================\nComponents per " + iOreDictConfigurationComponent.getCommonDivider() + "\n";
                for (OreDictMaterialStack tMt2 : iOreDictConfigurationComponent.getUndividedComponents()) {
                    tPage = tPage + tMt2.mAmount / 420076800L + " " + tMt2.mMaterial.getLocal() + "\n";
                }
                tBook.add(tPage);
            }
            for (OreDictMaterial oreDictMaterial : aMat.mAlloyComponentReferences) {
                block34: for (IOreDictConfigurationComponent tConfig : oreDictMaterial.mAlloyCreationRecipes) {
                    for (OreDictMaterialStack tMatStack : tConfig.getUndividedComponents()) {
                        if (tMatStack.mMaterial != aMat) continue;
                        tPage = "Alloy:\n" + oreDictMaterial.getLocal() + "\n===================\nMelting: " + oreDictMaterial.mMeltingPoint + " K\nBoiling: " + oreDictMaterial.mBoilingPoint + " K\n===================\nComponents per " + tConfig.getCommonDivider() + "\n";
                        for (OreDictMaterialStack tMt2 : tConfig.getUndividedComponents()) {
                            tPage = tPage + tMt2.mAmount / 420076800L + " " + tMt2.mMaterial.getLocal() + "\n";
                        }
                        tBook.add(tPage);
                        continue block34;
                    }
                }
            }
            if (aMat.mDescription != null) {
                boolean bl = false;
                for (int i = 0; i < aMat.mDescription.length; ++i) {
                    void var9_56;
                    if (!Code.stringValid(aMat.mDescription[i])) continue;
                    tBook.add("Description Pg " + (int)(++var9_56) + "\n===================\n" + aMat.mDescription[i]);
                }
            }
            MATERIAL_DICTIONARIES.add("Material_Dictionary_" + aMat.mNameInternal);
            Object[] objectArray = new Object[1];
            aMat.mDictionaryBook = Books.createWrittenBook("Material_Dictionary_" + aMat.mNameInternal, aMat.getLocal(), "Material Dictionary Foundation", tBook.size() <= 50 ? (aDefaultBook != null ? aDefaultBook : (CS.ItemsGT.sMultiItemBooks == null ? CS.NI : Stacks.make(CS.ItemsGT.sMultiItemBooks, 1L, 32002L))) : (aDefaultLargeBook != null ? aDefaultLargeBook : (CS.ItemsGT.sMultiItemBooks == null ? CS.NI : Stacks.make(CS.ItemsGT.sMultiItemBooks, 1L, 32003L))), false, tBook.toArray(CS.ZL_STRING));
            objectArray[0] = aMat.mDictionaryBook;
            return Stacks.copy(objectArray);
        }
    }

    public static class Fluids {
        private static final Map<ItemStackContainer, FluidContainerRegistry.FluidContainerData> sFilledContainerToData = new ItemStackMap();
        private static final Map<ItemStackContainer, Map<String, FluidContainerRegistry.FluidContainerData>> sEmptyContainerToFluidToData = new ItemStackMap();

        public static int id(FluidStack aFluid) {
            if (aFluid.getFluid() == null) {
                return -1;
            }
            return FluidRegistry.getFluidID((Fluid)aFluid.getFluid());
        }

        public static Fluid fluid(int aID) {
            if (aID < 0) {
                return null;
            }
            return FluidRegistry.getFluid((int)aID);
        }

        public static Fluid fluid(String aFluidName) {
            if (Code.stringInvalid(aFluidName)) {
                return null;
            }
            return FluidRegistry.getFluid((String)aFluidName);
        }

        public static boolean equal(FluidStack aFluid1, FluidStack aFluid2) {
            return Fluids.equal(aFluid1, aFluid2, false);
        }

        public static boolean equal(FluidStack aFluid1, FluidStack aFluid2, boolean aIgnoreNBT) {
            return aFluid1 != null && aFluid2 != null && aFluid1.getFluid() == aFluid2.getFluid() && (aIgnoreNBT || aFluid1.tag == null == (aFluid2.tag == null) && (aFluid1.tag == null || aFluid1.tag.equals((Object)aFluid2.tag)));
        }

        public static ItemStack display(Fluid aFluid) {
            return aFluid == null ? null : Fluids.display(Fluids.make(aFluid, 0L), false);
        }

        public static ItemStack display(FluidStack aFluid, boolean aUseStackSize) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return null;
            }
            ItemStack rStack = IL.Display_Fluid.getWithMeta(aUseStackSize ? (long)(aFluid.amount / 1000) : 1L, Fluids.id(aFluid), new Object[0]);
            if (rStack == null) {
                return null;
            }
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74778_a("f", aFluid.getFluid().getName());
            NBT.setNumber(tNBT, "a", aFluid.amount);
            NBT.setNumber(tNBT, "h", Fluids.temperature(aFluid));
            NBT.setBoolean(tNBT, "s", Fluids.gas(aFluid));
            rStack.func_77982_d(tNBT);
            return rStack;
        }

        public static boolean is(FluidStack aFluid, String ... aNames) {
            return aFluid != null && Fluids.is(aFluid.getFluid(), aNames);
        }

        public static boolean is(Fluid aFluid, String ... aNames) {
            if (aFluid != null) {
                for (String aName : aNames) {
                    if (!aFluid.getName().equalsIgnoreCase(aName)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean water(FluidStack aFluid) {
            return aFluid != null && Fluids.water(aFluid.getFluid());
        }

        public static boolean water(Fluid aFluid) {
            return aFluid != null && (aFluid == FluidRegistry.WATER || aFluid.getName().equals("ic2distilledwater"));
        }

        public static FluidStack water(long aAmount) {
            return Fluids.make("water", aAmount);
        }

        public static boolean distilledwater(FluidStack aFluid) {
            return aFluid != null && Fluids.distilledwater(aFluid.getFluid());
        }

        public static boolean distilledwater(Fluid aFluid) {
            return aFluid != null && aFluid.getName().equals("ic2distilledwater");
        }

        public static FluidStack distilledwater(long aAmount) {
            return Fluids.make("ic2distilledwater", aAmount, "water", aAmount);
        }

        public static boolean lava(FluidStack aFluid) {
            return aFluid != null && Fluids.lava(aFluid.getFluid());
        }

        public static boolean lava(Fluid aFluid) {
            return aFluid != null && aFluid == FluidRegistry.LAVA;
        }

        public static FluidStack lava(long aAmount) {
            return Fluids.make("lava", aAmount);
        }

        public static boolean anysteam(FluidStack aFluid) {
            return Fluids.is(aFluid, "steam", "ic2steam", "ic2superheatedsteam");
        }

        public static boolean anysteam(Fluid aFluid) {
            return Fluids.is(aFluid, "steam", "ic2steam", "ic2superheatedsteam");
        }

        public static boolean simple(FluidStack aFluid) {
            return aFluid != null && CS.FluidsGT.SIMPLE.contains(aFluid.getFluid().getName());
        }

        public static boolean simple(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.SIMPLE.contains(aFluid.getName());
        }

        public static boolean acid(FluidStack aFluid) {
            return aFluid != null && CS.FluidsGT.ACID.contains(aFluid.getFluid().getName());
        }

        public static boolean acid(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.ACID.contains(aFluid.getName());
        }

        public static boolean steam(FluidStack aFluid) {
            return aFluid != null && Fluids.steam(aFluid.getFluid());
        }

        public static boolean steam(Fluid aFluid) {
            return aFluid != null && aFluid.getName().equals("steam");
        }

        public static FluidStack steam(long aAmount) {
            return Fluids.make("steam", aAmount);
        }

        public static boolean milk(FluidStack aFluid) {
            return aFluid != null && Fluids.milk(aFluid.getFluid());
        }

        public static boolean milk(Fluid aFluid) {
            return aFluid != null && aFluid.getName().equals("milk");
        }

        public static FluidStack milk(long aAmount) {
            return Fluids.make("milk", aAmount);
        }

        public static boolean exists(String aFluidName) {
            return FluidRegistry.getFluid((String)aFluidName) != null;
        }

        public static FluidStack make(Fluid aFluid, long aAmount) {
            if (aFluid == null) {
                return null;
            }
            return new FluidStack(aFluid, Code.bindInt(aAmount));
        }

        public static FluidStack make(String aFluidName, long aAmount) {
            return Fluids.make(FluidRegistry.getFluid((String)aFluidName), aAmount);
        }

        public static FluidStack make(String aFluidName, long aAmount, String aReplacementFluidName) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make(aReplacementFluidName, aAmount) : rFluid;
        }

        public static FluidStack make(String aFluidName, long aAmount, String aReplacementFluidName, long aReplacementAmount) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make(aReplacementFluidName, aReplacementAmount) : rFluid;
        }

        public static FluidStack make(String aFluidName, long aAmount, FluidStack aReplacementFluid) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? aReplacementFluid : rFluid;
        }

        public static FluidStack mul(FluidStack aFluid, long aMultiplier) {
            return aFluid == null ? null : Fluids.make(aFluid.getFluid(), (long)aFluid.amount * aMultiplier);
        }

        public static FluidStack mul(FluidStack aFluid, long aMultiplier, long aDivider, boolean aRoundUp) {
            return aFluid == null ? null : Fluids.make(aFluid.getFluid(), Code.units(aFluid.amount, aDivider, aMultiplier, aRoundUp));
        }

        public static long temperature(FluidStack aFluid) {
            return Fluids.temperature(aFluid, 293L);
        }

        public static long temperature(FluidStack aFluid, long aDefault) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return aDefault;
            }
            if (aFluid.getFluid().getName().equals("steam")) {
                return 373L;
            }
            return aFluid.getFluid().getTemperature(aFluid);
        }

        public static boolean gas(FluidStack aFluid) {
            return Fluids.gas(aFluid, false);
        }

        public static boolean gas(FluidStack aFluid, boolean aDefault) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return aDefault;
            }
            return Fluids.anysteam(aFluid) || aFluid.getFluid().isGaseous(aFluid);
        }

        public static String configName(FluidStack aFluid) {
            return aFluid == null || aFluid.getFluid() == null ? "" : aFluid.getFluid().getName();
        }

        public static String configNames(FluidStack ... aFluids) {
            String rString = "";
            for (FluidStack tFluid : aFluids) {
                rString = rString + (tFluid == null ? "null;" : Fluids.configName(tFluid) + ";");
            }
            return rString;
        }

        public static String name(Fluid aFluid, boolean aLocalized) {
            String rName;
            if (aFluid == null) {
                return "";
            }
            String string = rName = aLocalized ? aFluid.getLocalizedName(Fluids.make(aFluid, 0L)) : aFluid.getUnlocalizedName();
            if (rName.contains("fluid.") || rName.contains("tile.")) {
                return Code.capitalise(rName.replaceAll("fluid.", "").replaceAll("tile.", ""));
            }
            return rName;
        }

        public static String name(FluidStack aFluid, boolean aLocalized) {
            if (aFluid == null) {
                return "";
            }
            return Fluids.name(aFluid.getFluid(), aLocalized);
        }

        public static FluidStack[] copyArray(FluidStack ... aStacks) {
            FluidStack[] rStacks = new FluidStack[aStacks.length];
            for (int i = 0; i < aStacks.length; ++i) {
                if (aStacks[i] == null) continue;
                rStacks[i] = aStacks[i].copy();
            }
            return rStacks;
        }

        public static void addFluidContainerData(FluidContainerRegistry.FluidContainerData aData) {
            sFilledContainerToData.put(new ItemStackContainer(aData.filledContainer), aData);
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new ItemStackContainer(aData.emptyContainer));
            if (tFluidToContainer == null) {
                tFluidToContainer = new HashMap<String, FluidContainerRegistry.FluidContainerData>();
                sEmptyContainerToFluidToData.put(new ItemStackContainer(aData.emptyContainer), tFluidToContainer);
            }
            tFluidToContainer.put(aData.fluid.getFluid().getName(), aData);
        }

        public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
            return Fluids.fillFluidContainer(aFluid, aStack, aRemoveFluidDirectly, aCheckIFluidContainerItems, false);
        }

        public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems, boolean aAllowPartialFilling) {
            if (Stacks.invalid(aStack) || aFluid == null) {
                return null;
            }
            if (aFluid.getFluid() == FluidRegistry.WATER && Stacks.equal(aStack, Stacks.make(Items.field_151069_bo, 1L, 32767L))) {
                if (aFluid.amount >= 250) {
                    if (aRemoveFluidDirectly) {
                        aFluid.amount -= 250;
                    }
                    return Stacks.make((Item)Items.field_151068_bn, 1L, 0L);
                }
                return null;
            }
            if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0 && (((IFluidContainerItem)aStack.func_77973_b()).getFluid(aStack) == null || Fluids.equal(((IFluidContainerItem)aStack.func_77973_b()).getFluid(aStack), aFluid) && ((IFluidContainerItem)aStack.func_77973_b()).getFluid((ItemStack)aStack).amount < ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack)) && (aAllowPartialFilling || ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) <= aFluid.amount)) {
                if (aRemoveFluidDirectly) {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                    aStack = Stacks.amount(1L, aStack);
                    aFluid.amount -= iFluidContainerItem.fill(aStack, aFluid, true);
                } else {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                    aStack = Stacks.amount(1L, aStack);
                    iFluidContainerItem.fill(aStack, aFluid, true);
                }
                return aStack;
            }
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new ItemStackContainer(aStack));
            if (tFluidToContainer == null) {
                return null;
            }
            FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid().getName());
            if (tData == null || tData.fluid.amount > aFluid.amount) {
                return null;
            }
            if (aRemoveFluidDirectly) {
                aFluid.amount -= tData.fluid.amount;
            }
            return Stacks.amount(1L, tData.filledContainer);
        }

        public static boolean containsFluid(ItemStack aStack, FluidStack aFluid, boolean aCheckIFluidContainerItems) {
            if (Stacks.invalid(aStack) || aFluid == null) {
                return false;
            }
            if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = Stacks.amount(1L, aStack);
                return aFluid.isFluidEqual(iFluidContainerItem.getFluid(aStack));
            }
            FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new ItemStackContainer(aStack));
            return tData != null && tData.fluid.isFluidEqual(aFluid);
        }

        public static FluidStack getFluidForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            if (Stacks.invalid(aStack)) {
                return null;
            }
            if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
                return ((IFluidContainerItem)aStack.func_77973_b()).drain(Stacks.amount(1L, aStack), Integer.MAX_VALUE, true);
            }
            FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new ItemStackContainer(aStack));
            return tData == null ? null : tData.fluid.copy();
        }

        public static ItemStack getContainerForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            if (Stacks.invalid(aStack)) {
                return null;
            }
            FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new ItemStackContainer(aStack));
            if (tData != null) {
                return Stacks.amount(1L, tData.emptyContainer);
            }
            if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = Stacks.amount(1L, aStack);
                iFluidContainerItem.drain(aStack, Integer.MAX_VALUE, true);
                return aStack;
            }
            return null;
        }

        public static FluidStack load(NBTTagCompound aNBT, String aTagName) {
            return aNBT == null ? null : Fluids.load(aNBT.func_74775_l(aTagName));
        }

        public static FluidStack load(NBTTagCompound aNBT) {
            if (aNBT == null || aNBT.func_82582_d()) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT);
        }

        public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, FluidStack aFluid) {
            NBTTagCompound rNBT = Fluids.save(aFluid);
            if (rNBT != null) {
                aNBT.func_74782_a(aTagName, (NBTBase)rNBT);
            }
            return rNBT;
        }

        public static NBTTagCompound save(FluidStack aFluid) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return null;
            }
            return aFluid.writeToNBT(new NBTTagCompound());
        }
    }
}

