/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.tools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Holo;
import gregapi.gui.Slot_Normal;
import gregapi.gui.Slot_Whitelist;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.old.Textures;
import gregapi.recipes.GT_ModHandler;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import invtweaks.api.container.ChestContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityAdvancedCraftingTable
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityFunnelAccessible {
    public boolean mFlushMode = false;
    public boolean mBlocked16 = false;
    public boolean mBlocked36 = false;
    public boolean mFilter16 = false;
    public boolean mFilter36 = false;
    public String mGUITexture = CS.RES_PATH_GUI + "machines/AdvancedCraftingTable.png";
    protected static final int[] SLOTS = new int[]{33};
    protected static final int[] SLOTS_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    protected static final int[] SLOTS_16 = new int[]{33, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    protected static final int[] SLOTS_16_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    protected static final int[] SLOTS_36 = new int[]{33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 63, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_36_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_ALL = new int[]{33, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 63, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_ALL_FLUSHING = new int[]{33, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_CONSUMPTION = new int[]{70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 21, 22, 23, 24, 25, 26, 27, 28, 29, 33};
    protected static final int[] SLOTS_INPUT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_STORAGE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
    protected static final int[] SLOTS_CRAFTING = new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29};
    protected static final int[] SLOTS_TOOLS = new int[]{16, 17, 18, 19, 20};
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/top"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/front"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/back"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/craftingtables/advanced/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode.16.blocked")) {
            this.mBlocked16 = aNBT.func_74767_n("gt.mode.16.blocked");
        }
        if (aNBT.func_74764_b("gt.mode.36.blocked")) {
            this.mBlocked36 = aNBT.func_74767_n("gt.mode.36.blocked");
        }
        if (aNBT.func_74764_b("gt.mode.16.filter")) {
            this.mFilter16 = aNBT.func_74767_n("gt.mode.16.filter");
        }
        if (aNBT.func_74764_b("gt.mode.36.filter")) {
            this.mFilter36 = aNBT.func_74767_n("gt.mode.36.filter");
        }
        if (aNBT.func_74764_b("gt.flush")) {
            this.mFlushMode = aNBT.func_74767_n("gt.flush");
        }
        if (CS.CODE_CLIENT && aNBT.func_74764_b("gt.gui")) {
            this.mGUITexture = aNBT.func_74779_i("gt.gui");
            if (!this.mGUITexture.endsWith(".png")) {
                this.mGUITexture = this.mGUITexture + ".png";
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.mode.16.blocked", this.mBlocked16);
        UT.NBT.setBoolean(aNBT, "gt.mode.36.blocked", this.mBlocked36);
        UT.NBT.setBoolean(aNBT, "gt.mode.16.filter", this.mFilter16);
        UT.NBT.setBoolean(aNBT, "gt.mode.36.filter", this.mFilter36);
        UT.NBT.setBoolean(aNBT, "gt.flush", this.mFlushMode);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.inputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (CS.SIDES_TOP[aSide]) {
            return !this.isServerSide() || this.openGUI(aPlayer, 0);
        }
        if (CS.ALONG_AXIS[aSide][this.mFacing]) {
            return !this.isServerSide() || this.openGUI(aPlayer, 1);
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("monkeywrench")) {
            if (CS.SIDES_TOP[aSide]) {
                boolean bl = this.mBlocked16 = !this.mBlocked16;
                if (aChatReturn != null) {
                    aChatReturn.add("4x4-Automation-Access: " + (this.mBlocked16 ? "OFF" : "ON"));
                }
            } else {
                boolean bl = this.mBlocked36 = !this.mBlocked36;
                if (aChatReturn != null) {
                    aChatReturn.add("9x4-Automation-Access: " + (this.mBlocked36 ? "OFF" : "ON"));
                }
            }
            return 10000L;
        }
        if (aTool.equals("screwdriver")) {
            if (CS.SIDES_TOP[aSide]) {
                boolean bl = this.mFilter16 = !this.mFilter16;
                if (aChatReturn != null) {
                    aChatReturn.add("4x4-Diversity-Filter: " + (this.mFilter16 ? "ON" : "OFF"));
                }
            } else {
                boolean bl = this.mFilter36 = !this.mFilter36;
                if (aChatReturn != null) {
                    aChatReturn.add("9x4-Diversity-Filter: " + (this.mFilter36 ? "ON" : "OFF"));
                }
            }
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide) {
            this.getCraftingOutput();
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mInventoryChanged) {
                this.getCraftingOutput();
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                }
            }
            this.refill();
            if (this.mFlushMode) {
                this.mFlushMode = false;
                for (int i : SLOTS_CRAFTING) {
                    if (!this.slotHas(i)) continue;
                    if (this.slot((int)i).field_77994_a == 0) {
                        this.slot(i, null);
                        continue;
                    }
                    this.mFlushMode = true;
                    break;
                }
            }
        }
    }

    public void sortIntoTheInputSlots() {
        for (int i : SLOTS_CRAFTING) {
            if (!this.slotHas(i)) continue;
            if (this.slot((int)i).field_77994_a == 0) {
                this.slot(i, null);
            }
            if (this.slotHas(i)) {
                for (int j : SLOTS_STORAGE) {
                    if (!UT.Stacks.equal(this.slot(i), this.slot(j))) continue;
                    UT.Inventories.moveStackFromSlotAToSlotB(this, this, i, j, 64, 1, 64, 1);
                }
            }
            if (!this.slotHas(i)) continue;
            for (int j : SLOTS_STORAGE) {
                if (this.slotHas(j)) continue;
                UT.Inventories.moveStackFromSlotAToSlotB(this, this, i, j, 64, 1, 64, 1);
            }
        }
    }

    protected void refill() {
    }

    public void setBluePrint(ItemStack aStack) {
        if (aStack == null) {
            aStack = this.slot(30);
        }
        if (!IL.Paper_Blueprint_Empty.equal(aStack, false, true)) {
            return;
        }
        ItemStack[] itemStackArray = new ItemStack[9];
        ItemStack itemStack = this.slotHas(21) ? (this.slot(21).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(21), null) : this.slot(21)) : (itemStackArray[0] = null);
        ItemStack itemStack2 = this.slotHas(22) ? (this.slot(22).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(22), null) : this.slot(22)) : (itemStackArray[1] = null);
        ItemStack itemStack3 = this.slotHas(23) ? (this.slot(23).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(23), null) : this.slot(23)) : (itemStackArray[2] = null);
        ItemStack itemStack4 = this.slotHas(24) ? (this.slot(24).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(24), null) : this.slot(24)) : (itemStackArray[3] = null);
        ItemStack itemStack5 = this.slotHas(25) ? (this.slot(25).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(25), null) : this.slot(25)) : (itemStackArray[4] = null);
        ItemStack itemStack6 = this.slotHas(26) ? (this.slot(26).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(26), null) : this.slot(26)) : (itemStackArray[5] = null);
        ItemStack itemStack7 = this.slotHas(27) ? (this.slot(27).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(27), null) : this.slot(27)) : (itemStackArray[6] = null);
        ItemStack itemStack8 = this.slotHas(28) ? (this.slot(28).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(28), null) : this.slot(28)) : (itemStackArray[7] = null);
        itemStackArray[8] = this.slotHas(29) ? (this.slot(29).func_77973_b() instanceof IItemGTContainerTool ? UT.Stacks.make(this.slot(29), null) : this.slot(29)) : null;
        UT.NBT.setBlueprintCrafting(aStack, itemStackArray);
        if (this.slotHas(31)) {
            aStack.func_151001_c(this.slot(31).func_82833_r());
        }
        UT.Stacks.set(aStack, IL.Paper_Blueprint_Used.getWithNBT(aStack.field_77994_a, aStack.func_77978_p(), new Object[0]));
    }

    public ItemStack getCraftingOutput() {
        ItemStack[] tRecipe;
        if (IL.Paper_Blueprint_Used.equal(this.slot(30), false, true) && (tRecipe = UT.NBT.getBlueprintCrafting(this.slot(30))) != CS.ZL_ITEMSTACK) {
            for (int i = 0; i < tRecipe.length; ++i) {
                if (this.slotHas(i + 21)) continue;
                this.slot(i + 21, UT.Stacks.amount(0L, tRecipe[i]));
            }
        }
        return this.slot(31, GT_ModHandler.getAllRecipeOutput(this.field_145850_b, this.slot(21), this.slot(22), this.slot(23), this.slot(24), this.slot(25), this.slot(26), this.slot(27), this.slot(28), this.slot(29)));
    }

    public boolean canDoCraftingOutput() {
        if (!this.slotHas(31)) {
            return false;
        }
        for (ItemStack tStack : this.recipeContent()) {
            if (tStack.field_77994_a <= this.getAmountOf(tStack)) continue;
            return false;
        }
        return true;
    }

    protected int getAmountOf(ItemStack aStack) {
        int tAmount = 0;
        for (int n : SLOTS_CONSUMPTION) {
            if (!UT.Stacks.equalTools(aStack, this.slot(n), false) || (tAmount += this.slot((int)n).field_77994_a) < SLOTS_CRAFTING.length) continue;
            return tAmount;
        }
        for (byte by : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(by);
            if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory) || (tAmount = (int)((long)tAmount + ((ITileEntityConnectedInventory)tDelegator.mTileEntity).getAmountOfItemsInConnectedInventory(tDelegator.mSideOfTileEntity, aStack, SLOTS_CRAFTING.length - tAmount))) < SLOTS_CRAFTING.length) continue;
            return tAmount;
        }
        return tAmount;
    }

    protected ArrayList<ItemStack> recipeContent() {
        ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
        for (int i : SLOTS_CRAFTING) {
            if (!this.slotHas(i)) continue;
            boolean temp = false;
            for (int j = 0; j < tList.size(); ++j) {
                if (!UT.Stacks.equalTools(this.slot(i), tList.get(j), false)) continue;
                ++tList.get((int)j).field_77994_a;
                temp = true;
                break;
            }
            if (temp) continue;
            tList.add(UT.Stacks.amount(1L, this.slot(i)));
        }
        return tList;
    }

    public ItemStack consumeMaterials(EntityPlayer aPlayer, ItemStack aHoldStack, boolean aSubsequentClick) {
        if (!this.slotHas(31)) {
            return aHoldStack;
        }
        if (aHoldStack != null) {
            if (!UT.Stacks.equal(aHoldStack, this.slot(31))) {
                if (!aSubsequentClick) {
                    UT.Sounds.play("mob.villager.idle", 50, 1.0f, 1.0f, this.getCoords());
                }
                return aHoldStack;
            }
            if (aHoldStack.field_77994_a + this.slot((int)31).field_77994_a > aHoldStack.func_77976_d()) {
                return aHoldStack;
            }
            for (int i : SLOTS_CRAFTING) {
                if (!OM.is("gt:autocrafterinfinite", this.slot(i))) continue;
                if (!aSubsequentClick) {
                    UT.Sounds.play("mob.villager.idle", 50, 1.0f, 1.0f, this.getCoords());
                }
                return aHoldStack;
            }
        }
        MultiItemTool.LAST_TOOL_COORDS_BEFORE_DAMAGE = this.getCoords();
        try {
            FMLCommonHandler.instance().firePlayerCraftingEvent(aPlayer, UT.Stacks.copy(this.slot(31)), (IInventory)new InventoryCrafting(null, 3, 3));
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        boolean tOldToolSounds = CS.TOOL_SOUNDS;
        block3: for (int i : SLOTS_CRAFTING) {
            int k;
            int i$;
            if (!this.slotHas(i)) continue;
            boolean tNeeds = true;
            if (this.isClientSide()) {
                CS.TOOL_SOUNDS = tOldToolSounds && !aSubsequentClick;
            }
            ItemStack tContainer = UT.Stacks.container(this.slot(i), false);
            if (this.isClientSide()) {
                CS.TOOL_SOUNDS = false;
            }
            if (UT.Stacks.equal(this.slot(i), tContainer, false)) continue;
            block4: for (byte tSide : CS.ALL_SIDES_VALID) {
                int len$;
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory) || ((ITileEntityConnectedInventory)tDelegator.mTileEntity).removeStackFromConnectedInventory(tDelegator.mSideOfTileEntity, UT.Stacks.amount(1L, this.slot(i)), true) < 1) continue;
                tNeeds = false;
                if (tContainer != null) {
                    byte[] byArray = CS.ALL_SIDES_VALID;
                    len$ = byArray.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        byte tSide2 = byArray[i$];
                        tDelegator = this.getAdjacentTileEntity(tSide2);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory)) continue;
                        int tRemoved = ((ITileEntityConnectedInventory)tDelegator.mTileEntity).addStackToConnectedInventory(tDelegator.mSideOfTileEntity, UT.Stacks.copy(tContainer), true);
                        tContainer.field_77994_a -= tRemoved;
                        if (tContainer.field_77994_a >= 1) continue;
                        tContainer = null;
                        break;
                    }
                }
                if (tContainer == null) break;
                int[] nArray = SLOTS_INPUT;
                len$ = nArray.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    k = nArray[i$];
                    if (!this.slotHas(k)) {
                        this.slot(k, tContainer);
                        break block4;
                    }
                    if (!UT.Stacks.equal(tContainer, this.slot(k)) || tContainer.field_77994_a + this.slot((int)k).field_77994_a > this.slot(k).func_77976_d()) continue;
                    this.slot((int)k).field_77994_a += tContainer.field_77994_a;
                    this.updateInventory();
                    break block4;
                }
                break;
            }
            if (!tNeeds) continue;
            for (int j : SLOTS_CONSUMPTION) {
                FluidStack fluidStack;
                if (j >= 21 && j < 30 && j != i || !UT.Stacks.equalTools(this.slot(i), this.slot(j), false) || this.slot((int)j).field_77994_a <= 0) continue;
                tNeeds = false;
                ItemStack tContainer2 = UT.Stacks.container(this.slot(j), false);
                if (tContainer2 != null && (fluidStack = UT.Fluids.getFluidForFilledItem(this.slot(j), true)) != null && UT.Stacks.equal(this.slot(j), UT.Fluids.fillFluidContainer(fluidStack, tContainer2, false, true), false)) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedTank) || ((ITileEntityConnectedTank)tDelegator.mTileEntity).removeFluidFromConnectedTank(tDelegator.mSideOfTileEntity, fluidStack, true) < fluidStack.amount) continue;
                        tContainer2 = null;
                        break;
                    }
                    if (tContainer2 == null) continue block3;
                }
                if (tContainer2 != null) {
                    byte[] byArray = CS.ALL_SIDES_VALID;
                    int len$ = byArray.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        byte tSide = byArray[i$];
                        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityConnectedInventory)) continue;
                        int tRemoved = ((ITileEntityConnectedInventory)tDelegator.mTileEntity).addStackToConnectedInventory(tDelegator.mSideOfTileEntity, UT.Stacks.copy(tContainer2), true);
                        tContainer2.field_77994_a -= tRemoved;
                        if (tContainer2.field_77994_a >= 1) continue;
                        tContainer2 = null;
                        break;
                    }
                }
                if (tContainer2 == null || tContainer2.func_77984_f() && tContainer2.func_77960_j() >= tContainer2.func_77958_k()) {
                    this.func_70298_a(j, 1);
                    continue block3;
                }
                if (this.slot((int)j).field_77994_a == 1) {
                    this.slot(j, tContainer2);
                    continue block3;
                }
                this.func_70298_a(j, 1);
                int[] nArray = SLOTS_INPUT;
                int len$ = nArray.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    k = nArray[i$];
                    if (!this.slotHas(k)) {
                        this.slot(k, tContainer2);
                        continue block3;
                    }
                    if (!UT.Stacks.equal(tContainer2, this.slot(k)) || tContainer2.field_77994_a + this.slot((int)k).field_77994_a > this.slot(k).func_77976_d()) continue;
                    this.slot((int)k).field_77994_a += tContainer2.field_77994_a;
                    this.updateInventory();
                    continue block3;
                }
                continue block3;
            }
        }
        if (aHoldStack == null) {
            aHoldStack = UT.Stacks.copy(this.slot(31));
        } else {
            aHoldStack.field_77994_a += this.slot((int)31).field_77994_a;
        }
        aHoldStack.func_77980_a(this.field_145850_b, aPlayer, this.slot((int)31).field_77994_a);
        if (aHoldStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai)) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76017_h, 1);
        }
        if (aHoldStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150460_al)) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76015_j, 1);
        }
        if (aHoldStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150381_bn)) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_75998_D, 1);
        }
        if (aHoldStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150342_X)) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76000_F, 1);
        }
        if (aHoldStack.func_77973_b() == Items.field_151025_P) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76014_m, 1);
        }
        if (aHoldStack.func_77973_b() == Items.field_151105_aU) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
        }
        if (aHoldStack.func_77973_b() instanceof ItemHoe) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76013_l, 1);
        }
        if (aHoldStack.func_77973_b() instanceof ItemSword) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76024_r, 1);
        }
        if (aHoldStack.func_77973_b() instanceof ItemPickaxe) {
            aPlayer.func_71064_a((StatBase)AchievementList.field_76018_i, 1);
            if (aHoldStack.func_77973_b() != Items.field_151039_o) {
                aPlayer.func_71064_a((StatBase)AchievementList.field_76012_o, 1);
            }
        }
        this.refill();
        MultiItemTool.LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
        if (this.isClientSide()) {
            CS.TOOL_SOUNDS = tOldToolSounds;
        }
        return aHoldStack;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return this.mBlocked16 ? (this.mBlocked36 ? (this.mFlushMode ? SLOTS_FLUSHING : SLOTS) : (this.mFlushMode ? SLOTS_36_FLUSHING : SLOTS_36)) : (this.mBlocked36 ? (this.mFlushMode ? SLOTS_16_FLUSHING : SLOTS_16) : (this.mFlushMode ? SLOTS_ALL_FLUSHING : SLOTS_ALL));
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return aInventorySlot < 31 || aInventorySlot > 32;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[71];
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return aSlot == 30 ? 1 : 64;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot < 16) {
            if (this.mFilter16) {
                for (int i = 0; i < 16; ++i) {
                    if (!UT.Stacks.equalTools(aStack, this.slot(i), false)) continue;
                    return aSlot == i;
                }
            }
            return true;
        }
        if (aSlot >= 35 && aSlot < 71) {
            if (this.mFilter36) {
                for (int i = 35; i < 71; ++i) {
                    if (!UT.Stacks.equalTools(aStack, this.slot(i), false)) continue;
                    return aSlot == i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 33 || this.mFlushMode && aSlot >= 21 && aSlot < 30;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        return aFluid != null && this.fill(aDirection, UT.Fluids.make(aFluid, Integer.MAX_VALUE), false) > 0;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        for (int i : SLOTS_TOOLS) {
            ItemStack tOutput = UT.Fluids.fillFluidContainer(aFluid, this.slot(i), false, true);
            if (tOutput == null) continue;
            if (this.slot((int)i).field_77994_a == 1) {
                if (aDoFill) {
                    this.slot(i, tOutput);
                }
                return UT.Fluids.getFluidForFilledItem((ItemStack)tOutput, (boolean)true).amount * tOutput.field_77994_a;
            }
            for (int j : SLOTS_TOOLS) {
                if (this.slotHas(j) && (!UT.Stacks.equal(tOutput, this.slot(j)) || this.slot((int)j).field_77994_a + tOutput.field_77994_a > tOutput.func_77976_d())) continue;
                if (aDoFill) {
                    this.func_70298_a(i, 1);
                    if (this.slotHas(j)) {
                        ++this.slot((int)j).field_77994_a;
                        this.updateInventory();
                    } else {
                        this.slot(j, tOutput);
                    }
                }
                return UT.Fluids.getFluidForFilledItem((ItemStack)tOutput, (boolean)true).amount * tOutput.field_77994_a;
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        return CS.L1_FLUIDTANKINFO_DUMMY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new MultiTileEntityGUIClientAdvancedCraftingTableStorage(aPlayer.field_71071_by, this) : new MultiTileEntityGUIClientAdvancedCraftingTable(aPlayer.field_71071_by, this);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new MultiTileEntityGUICommonAdvancedCraftingTableStorage(aPlayer.field_71071_by, this) : new MultiTileEntityGUICommonAdvancedCraftingTable(aPlayer.field_71071_by, this);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        byte aIndex = aSide < 2 ? aSide : (aSide == this.mFacing ? (byte)2 : (aSide == CS.OPPOSITES[this.mFacing] ? (byte)3 : 4));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.crafting.advanced";
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientAdvancedCraftingTableStorage
    extends ContainerClient {
        public MultiTileEntityGUIClientAdvancedCraftingTableStorage(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity) {
            super(new MultiTileEntityGUICommonAdvancedCraftingTableStorage(aInventoryPlayer, aTileEntity), CS.RES_PATH_GUI + "chests/36.png");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientAdvancedCraftingTable
    extends ContainerClient {
        public MultiTileEntityGUIClientAdvancedCraftingTable(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity) {
            super(new MultiTileEntityGUICommonAdvancedCraftingTable(aInventoryPlayer, aTileEntity), aTileEntity.mGUITexture);
        }
    }

    @ChestContainer
    public class MultiTileEntityGUICommonAdvancedCraftingTableStorage
    extends ContainerCommon {
        public MultiTileEntityGUICommonAdvancedCraftingTableStorage(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity) {
            super(aInventoryPlayer, aTileEntity);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 35, 8, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 36, 26, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 37, 44, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 38, 62, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 39, 80, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 40, 98, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 41, 116, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 42, 134, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 43, 152, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 44, 8, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 45, 26, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 46, 44, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 47, 62, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 48, 80, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 49, 98, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 50, 116, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 51, 134, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 52, 152, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 53, 8, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 54, 26, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 55, 44, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 56, 62, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 57, 80, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 58, 98, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 59, 116, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 60, 134, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 61, 152, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 62, 8, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 63, 26, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 64, 44, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 65, 62, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 66, 80, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 67, 98, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 68, 116, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 69, 134, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 70, 152, 62));
            return super.addSlots(aInventoryPlayer);
        }

        @Override
        public int getSlotCount() {
            return 36;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 36;
        }
    }

    public class MultiTileEntityGUICommonAdvancedCraftingTable
    extends ContainerCommon {
        public MultiTileEntityGUICommonAdvancedCraftingTable(InventoryPlayer aInventoryPlayer, MultiTileEntityAdvancedCraftingTable aTileEntity) {
            super(aInventoryPlayer, aTileEntity);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 0, 7, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 1, 25, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 2, 43, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 3, 61, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 4, 7, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 5, 25, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 6, 43, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 7, 61, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 8, 7, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 9, 25, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 10, 43, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 11, 61, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 12, 7, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 13, 25, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 14, 43, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 15, 61, 62));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 16, 80, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 17, 98, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 18, 116, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 19, 134, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 20, 152, 8));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 21, 80, 28));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 22, 98, 28));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 23, 116, 28));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 24, 80, 46));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 25, 98, 46));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 26, 116, 46));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 27, 80, 64));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 28, 98, 64));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 29, 116, 64));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 33, 153, 28).setTooltip("gt.advcrafting.drop.slot", LH.Chat.WHITE));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 34, 153, 64).setTooltip("gt.advcrafting.neutral.slot", LH.Chat.WHITE));
            this.func_75146_a(new Slot_Whitelist(this.mTileEntity, 30, 135, 28, IL.Paper_Blueprint_Empty.get(1L, new Object[0]), IL.Paper_Blueprint_Used.get(1L, new Object[0])).setTooltip("gt.advcrafting.insert.blueprint", LH.Chat.WHITE));
            this.func_75146_a(new Slot_Holo(this.mTileEntity, 31, 135, 64, false, false, 1));
            this.func_75146_a(new Slot_Holo(this.mTileEntity, 32, 153, 46, false, false, 1).setTooltip("gt.advcrafting.automation.access", LH.Chat.WHITE));
            this.func_75146_a(new Slot_Holo(this.mTileEntity, 32, 135, 46, false, false, 1).setTooltip("gt.advcrafting.put.to.storage", LH.Chat.WHITE));
            return super.addSlots(aInventoryPlayer);
        }

        @Override
        public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
            if (aSlotIndex < 21 || aSlotIndex > 35) {
                return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
            }
            try {
                Slot tSlot = (Slot)this.field_75151_b.get(aSlotIndex);
                ItemStack tStack = tSlot.func_75211_c();
                if (tStack != null && tStack.field_77994_a <= 0) {
                    tSlot.func_75215_d(null);
                    return aSlotIndex < 30 ? super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer) : null;
                }
                if (aSlotIndex == 32) {
                    if (aMouseclick == 0 && aShifthold == 1) {
                        ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).setBluePrint(null);
                        return null;
                    }
                } else {
                    if (aSlotIndex == 33) {
                        ItemStack tCraftedStack = ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).getCraftingOutput();
                        if (tCraftedStack != null) {
                            if (aShifthold == 1) {
                                for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
                                    for (int j = 0; j < tCraftedStack.func_77976_d() / tCraftedStack.field_77994_a && ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).canDoCraftingOutput(); ++j) {
                                        ItemStack tStack2 = ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).getCraftingOutput();
                                        if (!UT.Stacks.equal(tStack2, tCraftedStack) || tStack != null && tStack.field_77994_a != tStack2.field_77994_a) {
                                            return aPlayer.field_71071_by.func_70445_o();
                                        }
                                        aPlayer.field_71071_by.field_70462_a[i] = ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).consumeMaterials(aPlayer, aPlayer.field_71071_by.field_70462_a[i], i != 0 || j != 0);
                                    }
                                }
                            } else {
                                if (aMouseclick == 0) {
                                    if (((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).canDoCraftingOutput()) {
                                        aPlayer.field_71071_by.func_70437_b(((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).consumeMaterials(aPlayer, aPlayer.field_71071_by.func_70445_o(), false));
                                    }
                                    return aPlayer.field_71071_by.func_70445_o();
                                }
                                for (int i = 0; i < tCraftedStack.func_77976_d() / tCraftedStack.field_77994_a && ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).canDoCraftingOutput(); ++i) {
                                    ItemStack tStack2 = ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).getCraftingOutput();
                                    if (!UT.Stacks.equal(tStack2, tCraftedStack) || tStack != null && tStack.field_77994_a != tStack2.field_77994_a) {
                                        return aPlayer.field_71071_by.func_70445_o();
                                    }
                                    aPlayer.field_71071_by.func_70437_b(((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).consumeMaterials(aPlayer, aPlayer.field_71071_by.func_70445_o(), i != 0));
                                }
                                return aPlayer.field_71071_by.func_70445_o();
                            }
                        }
                        return null;
                    }
                    if (aSlotIndex == 34) {
                        ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).mFlushMode = true;
                        return null;
                    }
                    if (aSlotIndex == 35) {
                        ((MultiTileEntityAdvancedCraftingTable)this.mTileEntity).sortIntoTheInputSlots();
                        return null;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
        }

        @Override
        public int getSlotCount() {
            return 33;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 21;
        }
    }
}

