/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntityBasicMachine;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.IMultiBlockInventory;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase10MultiBlockMachine
extends MultiTileEntityBasicMachine
implements IMultiBlockFluidHandler,
IMultiBlockInventory,
IMultiBlockEnergy {
    public boolean mStructureChanged = false;
    public boolean mStructureOkay = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state.str")) {
            this.mStructureOkay = aNBT.func_74767_n("gt.state.str");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.state.str", this.mStructureOkay);
    }

    @Override
    public long onToolClickMultiBlock(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (this.isClientSide()) {
            return this.mStructureOkay;
        }
        if (this.mStructureChanged || aForceReset) {
            this.mStructureOkay = this.checkStructure2();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public int getDefaultTankCapacity() {
        return UT.Code.bindInt(Math.max(16000L, (long)this.mRecipes.mMaxFluidInputSize * 32L));
    }

    @Override
    public void updateAdjacentToggleableEnergySources() {
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.onStructureChange();
    }

    @Override
    public boolean doDefaultStructuralChecks() {
        return true;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public abstract boolean checkStructure2();

    @Override
    public abstract DelegatorTileEntity<IInventory> getItemInputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<TileEntity> getItemOutputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte var1, Fluid var2);

    @Override
    public abstract String getTileEntityName();

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable2(aSide, aFluidToFill);
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable2(aSide, aFluidToDrain);
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks2(aSide);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getAccessibleSlotsFromSide2(aSide);
    }

    @Override
    public boolean canInsertItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canInsertItem2(aSlot, aStack, aSide);
    }

    @Override
    public boolean canExtractItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canExtractItem2(aSlot, aStack, aSide);
    }

    @Override
    public int getSizeInventory(MultiTileEntityMultiBlockPart aPart) {
        return this.func_70302_i_();
    }

    @Override
    public ItemStack getStackInSlot(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.func_70301_a(aSlot);
    }

    @Override
    public ItemStack decrStackSize(MultiTileEntityMultiBlockPart aPart, int aSlot, int aDecrement) {
        return this.func_70298_a(aSlot, aDecrement);
    }

    @Override
    public ItemStack getStackInSlotOnClosing(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.func_70304_b(aSlot);
    }

    @Override
    public void setInventorySlotContents(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        this.func_70299_a(aSlot, aStack);
    }

    @Override
    public String getInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.func_145825_b();
    }

    @Override
    public boolean hasCustomInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.func_145818_k_();
    }

    @Override
    public int getInventoryStackLimit(MultiTileEntityMultiBlockPart aPart) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirty(MultiTileEntityMultiBlockPart aPart) {
        this.func_70296_d();
    }

    @Override
    public boolean isUseableByPlayer(MultiTileEntityMultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.func_70300_a(aPlayer);
    }

    @Override
    public void openInventory(MultiTileEntityMultiBlockPart aPart) {
        this.func_70295_k_();
    }

    @Override
    public void closeInventory(MultiTileEntityMultiBlockPart aPart) {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlot(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }
}

