/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.GT_API;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase10MultiBlockBase
extends TileEntityBase09FacingSingle
implements ITileEntityMultiBlockController {
    public boolean mStructureChanged = false;
    public boolean mStructureOkay = false;
    public IIconContainer[] mTextures = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesFront = CS.L6_IICONCONTAINER;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state.str")) {
            this.mStructureOkay = aNBT.func_74767_n("gt.state.str");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                String tTextureName = aNBT.func_74779_i("gt.texture");
                this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/side")};
                this.mTexturesFront = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/side")};
            } else if (this.getMultiTileEntityRegistryID() != Short.MAX_VALUE && this.getMultiTileEntityID() != Short.MAX_VALUE) {
                TileEntityBase10MultiBlockBase tCanonicalTileEntity = (TileEntityBase10MultiBlockBase)MultiTileEntityRegistry.getRegistry((int)this.getMultiTileEntityRegistryID()).getClassContainer((int)this.getMultiTileEntityID()).mCanonicalTileEntity;
                this.mTextures = tCanonicalTileEntity.mTextures;
                this.mTexturesFront = tCanonicalTileEntity.mTexturesFront;
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.state.str", this.mStructureOkay);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide) {
            this.checkStructure(true);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mTimer % 600L == 5L) {
            if (!this.checkStructure(false)) {
                this.checkStructure(true);
            }
            this.doDefaultStructuralChecks();
        }
    }

    @Override
    public long onToolClickMultiBlock(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (this.isClientSide()) {
            return this.mStructureOkay;
        }
        if (this.mStructureChanged || aForceReset) {
            this.mStructureOkay = this.checkStructure2();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get((aSide == this.mFacing ? this.mTexturesFront : this.mTextures)[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get((aSide == this.mFacing ? this.mTexturesFront : this.mTextures)[CS.FACES_TBS[aSide] + 3])) : null;
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.onStructureChange();
    }

    @Override
    public boolean doDefaultStructuralChecks() {
        return true;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public abstract boolean checkStructure2();

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable2(aSide, aFluidToFill);
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable2(aSide, aFluidToDrain);
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks2(aSide);
    }

    public int[] getAccessibleSlotsFromSide(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getAccessibleSlotsFromSide2(aSide);
    }

    public boolean canInsertItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canInsertItem2(aSlot, aStack, aSide);
    }

    public boolean canExtractItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canExtractItem2(aSlot, aStack, aSide);
    }

    public int getSizeInventory(MultiTileEntityMultiBlockPart aPart) {
        return this.func_70302_i_();
    }

    public ItemStack getStackInSlot(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.func_70301_a(aSlot);
    }

    public ItemStack decrStackSize(MultiTileEntityMultiBlockPart aPart, int aSlot, int aDecrement) {
        return this.func_70298_a(aSlot, aDecrement);
    }

    public ItemStack getStackInSlotOnClosing(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.func_70304_b(aSlot);
    }

    public void setInventorySlotContents(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        this.func_70299_a(aSlot, aStack);
    }

    public String getInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.func_145825_b();
    }

    public boolean hasCustomInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.func_145818_k_();
    }

    public int getInventoryStackLimit(MultiTileEntityMultiBlockPart aPart) {
        return this.func_70297_j_();
    }

    public void markDirty(MultiTileEntityMultiBlockPart aPart) {
        this.func_70296_d();
    }

    public boolean isUseableByPlayer(MultiTileEntityMultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.func_70300_a(aPlayer);
    }

    public void openInventory(MultiTileEntityMultiBlockPart aPart) {
        this.func_70295_k_();
    }

    public void closeInventory(MultiTileEntityMultiBlockPart aPart) {
        this.func_70305_f();
    }

    public boolean isItemValidForSlot(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }
}

