/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.GT_API;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockEnergyDataCapacitor;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.IMultiBlockInventory;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.notick.TileEntityBase05Paintable;
import gregapi.util.UT;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityMultiBlockPart
extends TileEntityBase05Paintable
implements ITileEntityEnergy,
ITileEntityEnergyDataCapacitor,
ITileEntityAdjacentInventoryUpdatable,
IFluidHandler,
IMultiTileEntity.IMTE_BreakBlock {
    public ChunkCoordinates mTargetPos = null;
    public ITileEntityMultiBlockController mTarget = null;
    protected IIconContainer[][] mTextures = CS.L1L6_IICONCONTAINER;
    public short mDesign = 0;
    public byte mMode = 0;
    public static final byte EVERYTHING = 0;
    public static final byte NO_ENERGY_OUT = 1;
    public static final byte NO_ENERGY_IN = 2;
    public static final byte NO_FLUID_OUT = 4;
    public static final byte NO_FLUID_IN = 8;
    public static final byte NO_ITEM_OUT = 16;
    public static final byte NO_ITEM_IN = 32;
    public static final byte NO_ENERGY = 3;
    public static final byte NO_FLUID = 12;
    public static final byte NO_ITEM = 48;
    public static final byte ONLY_ENERGY_OUT = -2;
    public static final byte ONLY_ENERGY_IN = -3;
    public static final byte ONLY_FLUID_OUT = -5;
    public static final byte ONLY_FLUID_IN = -9;
    public static final byte ONLY_ITEM_OUT = -17;
    public static final byte ONLY_ITEM_IN = -33;
    public static final byte ONLY_ITEM_FLUID_OUT = -21;
    public static final byte ONLY_ITEM_FLUID_IN = -41;
    public static final byte ONLY_ENERGY = -4;
    public static final byte ONLY_FLUID = -13;
    public static final byte ONLY_ITEM = -49;
    public static final byte ONLY_ITEM_FLUID = -61;
    public static final byte NOTHING = -1;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(UT.Code.bindInt(aNBT.func_74763_f("gt.target.x")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.y")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.z")));
        }
        if (aNBT.func_74764_b("gt.design")) {
            this.mDesign = UT.Code.unsignB(aNBT.func_74771_c("gt.design"));
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                String tTextureName = aNBT.func_74779_i("gt.texture");
                this.mTextures = new IIconContainer[UT.Code.bind8(aNBT.func_74765_d("gt.designs")) + 1][6];
                for (int i = 0; i < this.mTextures.length; i = (int)((short)(i + 1))) {
                    this.mTextures[i] = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockparts/" + tTextureName + "/" + i + "/overlay/side")};
                }
            } else if (this.getMultiTileEntityRegistryID() != Short.MAX_VALUE && this.getMultiTileEntityID() != Short.MAX_VALUE) {
                MultiTileEntityMultiBlockPart tCanonicalTileEntity = (MultiTileEntityMultiBlockPart)MultiTileEntityRegistry.getRegistry((int)this.getMultiTileEntityRegistryID()).getClassContainer((int)this.getMultiTileEntityID()).mCanonicalTileEntity;
                this.mTextures = tCanonicalTileEntity.mTextures;
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mDesign != 0) {
            aNBT.func_74774_a("gt.design", (byte)this.mDesign);
        }
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        if (this.mTargetPos != null) {
            UT.NBT.setBoolean(aNBT, "gt.target", true);
            UT.NBT.setNumber(aNBT, "gt.target.x", this.mTargetPos.field_71574_a);
            UT.NBT.setNumber(aNBT, "gt.target.y", this.mTargetPos.field_71572_b);
            UT.NBT.setNumber(aNBT, "gt.target.z", this.mTargetPos.field_71573_c);
        }
    }

    @Override
    public boolean breakBlock() {
        ITileEntityMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            tTarget.onStructureChange();
        }
        return false;
    }

    public ITileEntityMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.mTargetPos == null) {
            return null;
        }
        if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
                TileEntity tTarget = UT.Worlds.getTileEntity(this.field_145850_b, this.mTargetPos, true);
                if (tTarget instanceof ITileEntityMultiBlockController && ((ITileEntityMultiBlockController)tTarget).isInsideStructure(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    this.mTarget = (ITileEntityMultiBlockController)tTarget;
                } else {
                    this.mTargetPos = null;
                    this.setDesign(0);
                }
            }
        }
        return aCheckValidity ? (this.mTarget != null && this.mTarget.checkStructure(false) ? this.mTarget : null) : this.mTarget;
    }

    public void setTarget(ITileEntityMultiBlockController aTarget, int aDesign, byte aMode) {
        this.mTarget = aTarget;
        this.mTargetPos = this.mTarget == null ? null : this.mTarget.getCoords();
        this.mMode = aMode;
        this.setDesign(aDesign);
    }

    public boolean setDesign(int aDesign) {
        if ((aDesign = (int)UT.Code.bind8(aDesign)) != this.mDesign) {
            this.mDesign = (short)aDesign;
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[this.mDesign][CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(this.mTextures[this.mDesign][CS.FACES_TBS[aSide] + 3])) : null;
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityAdjacentInventoryUpdatable) {
            ((ITileEntityAdjacentInventoryUpdatable)((Object)tTileEntity)).adjacentInventoryUpdated(aSide, aTileEntity);
        }
    }

    @Override
    public byte getVisualData() {
        return (byte)this.mDesign;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mDesign = UT.Code.unsignB(aData);
        if (this.mDesign >= this.mTextures.length) {
            this.mDesign = 0;
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("wrench") || aTool.equals("crowbar")) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity == null) {
            if (aTool.equals("magnifyingglass")) {
                aChatReturn.add("There is no Multiblock Controller, that has this Block as Part of it.");
                return 1L;
            }
        } else {
            if (tTileEntity.isInsideStructure(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return tTileEntity.onToolClickMultiBlock(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ, this.getCoords());
            }
            this.mTargetPos = null;
            this.mTarget = null;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).decrStackSize(this, aSlot, aDecrement);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int aSlot) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getStackInSlotOnClosing(this, aSlot);
        }
        return null;
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getStackInSlot(this, aSlot);
        }
        return null;
    }

    @Override
    public String func_145825_b() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getInventoryName(this);
        }
        return this.getCustomName();
    }

    @Override
    public int func_70302_i_() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getSizeInventory(this);
        }
        return 0;
    }

    @Override
    public int func_70297_j_() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getInventoryStackLimit(this);
        }
        return 0;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            ((IMultiBlockInventory)tTileEntity).setInventorySlotContents(this, aSlot, aStack);
        }
    }

    @Override
    public boolean func_145818_k_() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).hasCustomInventoryName(this);
        }
        return this.getCustomName() != null;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).isItemValidForSlot(this, aSlot, aStack);
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        if ((this.mMode & 0x30) == 48) {
            return CS.ZL_INTEGER;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).getAccessibleSlotsFromSide(this, aSide);
        }
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if ((this.mMode & 0x20) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).canInsertItem(this, aSlot, aStack, aSide);
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        if ((this.mMode & 0x10) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockInventory) {
            return ((IMultiBlockInventory)tTileEntity).canExtractItem(this, aSlot, aStack, aSide);
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if ((this.mMode & 8) != 0) {
            return 0;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).fill(this, UT.Code.side(from), resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if ((this.mMode & 4) != 0) {
            return CS.NF;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).drain(this, UT.Code.side(from), resource, doDrain);
        }
        return CS.NF;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if ((this.mMode & 4) != 0) {
            return CS.NF;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).drain(this, UT.Code.side(from), maxDrain, doDrain);
        }
        return CS.NF;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if ((this.mMode & 8) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).canFill(this, UT.Code.side(from), fluid);
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if ((this.mMode & 4) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).canDrain(this, UT.Code.side(from), fluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockFluidHandler) {
            return ((IMultiBlockFluidHandler)tTileEntity).getTankInfo(this, UT.Code.side(from));
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    public boolean getStateRunningPossible() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningPossible) {
            return ((ITileEntityRunningPossible)((Object)tTileEntity)).getStateRunningPossible();
        }
        return false;
    }

    public boolean getStateRunningPassively() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningPassively) {
            return ((ITileEntityRunningPassively)((Object)tTileEntity)).getStateRunningPassively();
        }
        return false;
    }

    public boolean getStateRunningActively() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningActively) {
            return ((ITileEntityRunningActively)((Object)tTileEntity)).getStateRunningActively();
        }
        return false;
    }

    public boolean getStateRunningSuccessfully() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityRunningSuccessfully) {
            return ((ITileEntityRunningSuccessfully)((Object)tTileEntity)).getStateRunningSuccessfully();
        }
        return false;
    }

    public boolean getStateOnOff() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableOnOff) {
            return ((ITileEntitySwitchableOnOff)((Object)tTileEntity)).getStateOnOff();
        }
        return false;
    }

    public byte getStateMode() {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableMode) {
            return ((ITileEntitySwitchableMode)((Object)tTileEntity)).getStateMode();
        }
        return 0;
    }

    public boolean setStateOnOff(boolean aOnOff) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableOnOff) {
            return ((ITileEntitySwitchableOnOff)((Object)tTileEntity)).setStateOnOff(aOnOff);
        }
        return false;
    }

    public byte setStateMode(byte aMode) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntitySwitchableMode) {
            return ((ITileEntitySwitchableMode)((Object)tTileEntity)).setStateMode(aMode);
        }
        return 0;
    }

    public long getProgressValue(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)((Object)tTileEntity)).getProgressValue(aSide);
        }
        return 0L;
    }

    public long getProgressMax(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof ITileEntityProgress) {
            return ((ITileEntityProgress)((Object)tTileEntity)).getProgressMax(aSide);
        }
        return 0L;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        if (aEmitting ? (this.mMode & 1) != 0 : (this.mMode & 2) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyType(this, aEnergyType, aSide, aEmitting);
        }
        return false;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        if ((this.mMode & 3) == 3) {
            return Collections.EMPTY_LIST;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyTypes(this, aSide);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        if ((this.mMode & 2) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyAcceptingFrom(this, aEnergyType, aSide, aTheoretical);
        }
        return false;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        if ((this.mMode & 1) != 0) {
            return false;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).isEnergyEmittingTo(this, aEnergyType, aSide, aTheoretical);
        }
        return false;
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).doEnergyInjection(this, aEnergyType, aSide, aSize, aAmount, aDoInject);
        }
        return 0L;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyDemanded(this, aEnergyType, aSide, aSize);
        }
        return 0L;
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).doEnergyExtraction(this, aEnergyType, aSide, aSize, aAmount, aDoExtract);
        }
        return 0L;
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergyOffered(this, aEnergyType, aSide, aSize);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputMin(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputMin(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputRecommended(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputRecommended(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 2) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeInputMax(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        if ((this.mMode & 1) != 0) {
            return 0L;
        }
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergy) {
            return ((IMultiBlockEnergy)tTileEntity).getEnergySizeOutputMax(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyStored(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyCapacity(this, aEnergyType, aSide);
        }
        return 0L;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).isEnergyCapacitorType(this, aEnergyType, aSide);
        }
        return false;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        ITileEntityMultiBlockController tTileEntity = this.getTarget(true);
        if (tTileEntity instanceof IMultiBlockEnergyDataCapacitor) {
            return ((IMultiBlockEnergyDataCapacitor)tTileEntity).getEnergyCapacitorTypes(this, aSide);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean func_70300_a(EntityPlayer aPlayer) {
        return aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }
}

