/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase10FacingDouble;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public abstract class MultiTileEntitySensor
extends TileEntityBase10FacingDouble
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SyncDataShort {
    protected byte mMode = 0;
    protected int mDisplayedNumber = 0;
    protected int oDisplayedNumber = 0;
    protected int mSetNumber = 0;
    protected byte mRedstone = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.visual")) {
            this.mDisplayedNumber = UT.Code.unsignS(aNBT.func_74765_d("gt.visual"));
        }
        this.mSetNumber = aNBT.func_74764_b("gt.value") ? UT.Code.unsignS(aNBT.func_74765_d("gt.value")) : this.mDisplayedNumber;
        if (aNBT.func_74764_b("gt.connection")) {
            this.mSecondFacing = aNBT.func_74771_c("gt.connection");
        }
        if (aNBT.func_74764_b("gt.redstone")) {
            this.mRedstone = aNBT.func_74771_c("gt.redstone");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74777_a("gt.visual", (short)this.mDisplayedNumber);
        aNBT.func_74777_a("gt.value", (short)this.mSetNumber);
        aNBT.func_74774_a("gt.mode", this.mMode);
        aNBT.func_74774_a("gt.redstone", this.mRedstone);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.func_74777_a("gt.value", (short)this.mSetNumber);
        aNBT.func_74774_a("gt.mode", this.mMode);
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.getSensorDescription());
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.buttons"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.display"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.modes"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.set.input.side"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte aTargetSide;
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("wrench") && CS.SIDES_VALID[aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ)]) {
            this.mFacing = aTargetSide;
            this.mSecondFacing = CS.OPPOSITES[this.mFacing];
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        if (aTool.equals("monkeywrench") && CS.SIDES_VALID[aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ)] && aTargetSide != this.mFacing) {
            this.mSecondFacing = aTargetSide;
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mDisplayedNumber = UT.Code.bind16(this.mDisplayedNumber);
        return super.onTickCheck(aTimer) || Math.abs(this.mDisplayedNumber - this.oDisplayedNumber) > (CS.SERVER_TIME % 20L == 0L ? 0 : 49);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedNumber = this.mDisplayedNumber;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, UT.Code.toByteS((short)this.mDisplayedNumber, 0), UT.Code.toByteS((short)this.mDisplayedNumber, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mMode);
        }
        return this.getClientDataPacketShort(false, (short)this.mDisplayedNumber);
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedNumber = UT.Code.unsignS(aData);
        return true;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedNumber = UT.Code.unsignS(UT.Code.combine(aData[0], aData[1]));
        if (aData.length >= 7) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
            this.setDirectionData(aData[5]);
            this.mMode = aData[6];
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            aBlock.func_149676_a(CS.PIXELS_POS[4 == this.mFacing ? 14 : 0], CS.PIXELS_POS[0 == this.mFacing ? 14 : 0], CS.PIXELS_POS[2 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[5 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[1 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[3 == this.mFacing ? 14 : 0]);
            return true;
        }
        if (this.mFacing == 4) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[2], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[12]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[4], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[10]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[8]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[8], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[6]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[10], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[4]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_POS[12], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[2]);
                    return true;
                }
            }
        }
        if (this.mFacing == 5) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[12], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[10], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[4]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[8], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[6]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[6], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[8]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[4], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[10]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[2], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[12]);
                    return true;
                }
            }
        }
        if (this.mFacing == 2) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[4], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[8], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[6], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[8], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[10], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_NEG[12], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0]);
                    return true;
                }
            }
        }
        if (this.mFacing == 3) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[12], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[10], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[8], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[4], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f);
                    return true;
                }
            }
        }
        if (this.mFacing == 0) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[12], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[10], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[8], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[4], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[14] - 0.001f, CS.PIXELS_POS[12], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0], CS.PIXELS_NEG[2]);
                    return true;
                }
            }
        }
        if (this.mFacing == 1) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[10], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[8], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PIXELS_POS[8], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[6], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[4], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[14] + 0.001f, CS.PIXELS_NEG[12]);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aSide == this.mFacing) {
            if (aRenderPass == 0) {
                return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureFront(), this.mRGBa), BlockTextureDefault.get(this.getOverlayFront()));
            }
            return BlockTextureDefault.get(this.getCharacterIcon(aRenderPass - 1), this.getCharacterColor(aRenderPass - 1), false, true, true, true);
        }
        if (aShouldSideBeRendered[aSide] && aRenderPass == 0) {
            if (aSide == CS.OPPOSITES[this.mFacing]) {
                return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureBack(), this.mRGBa), BlockTextureDefault.get(this.getOverlayBack()));
            }
            return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureSide(), this.mRGBa), BlockTextureDefault.get(this.getOverlaySide()));
        }
        return null;
    }

    public boolean hasHitDisplay(byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
        return tCoords[0] >= CS.PIXELS_POS[2] && tCoords[0] <= CS.PIXELS_NEG[2] && tCoords[1] >= CS.PIXELS_POS[2] && tCoords[1] <= CS.PIXELS_POS[4];
    }

    public short[] getCharacterColor(int aIndex) {
        return CS.CA_WHITE;
    }

    public abstract IIconContainer getCharacterIcon(int var1);

    public abstract IIconContainer getTextureFront();

    public abstract IIconContainer getTextureBack();

    public abstract IIconContainer getTextureSide();

    public abstract IIconContainer getOverlayFront();

    public abstract IIconContainer getOverlayBack();

    public abstract IIconContainer getOverlaySide();

    public abstract String getSensorDescription();

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return aSide == CS.OPPOSITES[this.mSecondFacing] ? (byte)0 : this.mRedstone;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[4 == this.mFacing ? 14 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0 == this.mFacing ? 14 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2 == this.mFacing ? 14 : 0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5 == this.mFacing ? 14 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1 == this.mFacing ? 14 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[3 == this.mFacing ? 14 : 0]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[4 == this.mFacing ? 14 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0 == this.mFacing ? 14 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2 == this.mFacing ? 14 : 0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5 == this.mFacing ? 14 : 0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1 == this.mFacing ? 14 : 0]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[3 == this.mFacing ? 14 : 0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[4 == this.mFacing ? 14 : 0], CS.PIXELS_POS[0 == this.mFacing ? 14 : 0], CS.PIXELS_POS[2 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[5 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[1 == this.mFacing ? 14 : 0], CS.PIXELS_NEG[3 == this.mFacing ? 14 : 0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? CS.PIXELS_NEG[2] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return aSide == CS.OPPOSITES[this.mFacing];
    }

    @Override
    public boolean[] getValidSecondSides() {
        return CS.SIDES_ANY_BUT[this.mFacing];
    }

    static {
        LH.add("gt.tooltip.sensor.screwdrive.buttons", "Use Screwdriver on Buttons to enable Averaging Mode.");
        LH.add("gt.tooltip.sensor.screwdrive.display", "Use Screwdriver on Display toggle Hexadecimal Display.");
        LH.add("gt.tooltip.sensor.screwdrive.modes", "Use Screwdriver on anything else to switch Modes.");
    }
}

