/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import gregapi.GT_API;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientBasicMachine;
import gregapi.gui.ContainerCommonBasicMachine;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraft|Core")})
public class MultiTileEntityBasicMachine
extends TileEntityBase09FacingSingle
implements IHasWork,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible,
ITileEntitySwitchableOnOff,
ITileEntityRunningSuccessfully,
ITileEntityAdjacentInventoryUpdatable,
ITileEntityEnergy,
ITileEntityProgress,
IFluidHandler {
    public boolean mCheapOverclocking = false;
    public boolean mCouldUseRecipe = false;
    public boolean mStopped = false;
    public boolean oActive = false;
    public boolean oRunning = false;
    public boolean mStateNew = false;
    public boolean mStateOld = false;
    public boolean mDisabledItemInput = false;
    public boolean mDisabledItemOutput = false;
    public boolean mDisabledFluidInput = false;
    public boolean mDisabledFluidOutput = false;
    public boolean mRequiresIgnition = false;
    public boolean mIgnited = false;
    public byte mEnergyInputs = 0;
    public byte mOutputBlocked = 0;
    public byte mMode = 0;
    public byte mItemInputs = 0;
    public byte mItemOutputs = 0;
    public byte mItemAutoInput = (byte)6;
    public byte mItemAutoOutput = (byte)6;
    public byte mFluidInputs = 0;
    public byte mFluidOutputs = 0;
    public byte mFluidAutoInput = (byte)6;
    public byte mFluidAutoOutput = (byte)6;
    public short mEfficiency = (short)10000;
    public long mEnergy = 0L;
    public long mInputMin = 16L;
    public long mInput = 32L;
    public long mInputMax = 64L;
    public long mMinEnergy = 0L;
    public TagData mEnergyTypeAccepted = TD.Energy.TU;
    public Recipe mLastRecipe = null;
    public FluidTank[] mTanksInput = CS.ZL_FLUIDTANK;
    public FluidTank[] mTanksOutput = CS.ZL_FLUIDTANK;
    public ItemStack[] mOutputItems = CS.ZL_ITEMSTACK;
    public FluidStack[] mOutputFluids = CS.ZL_FLUIDSTACK;
    public IIconContainer[] mTexturesMaterial = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesInactive = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesActive = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesRunning = CS.L6_IICONCONTAINER;
    public String mGUITexture = "";
    public Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sFurnaceRecipes;
    public long mProgress = 0L;
    public long mMaxProgress = 0L;
    public boolean mSuccessful = false;
    public boolean mActive = false;
    public boolean mRunning = false;
    public int[] ACCESSIBLE_SLOTS;
    public static final int DID_NOT_FIND_RECIPE = 0;
    public static final int FOUND_RECIPE_BUT_DID_NOT_MEET_REQUIREMENTS = 1;
    public static final int FOUND_AND_SUCCESSFULLY_USED_RECIPE = 2;
    public static final int FOUND_AND_COULD_HAVE_USED_RECIPE = 3;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        this.mGUITexture = this.mRecipes.mGUIPath;
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.active")) {
            this.mCouldUseRecipe = this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.running")) {
            this.mRunning = aNBT.func_74767_n("gt.running");
        }
        if (aNBT.func_74764_b("gt.state.new")) {
            this.mStateNew = aNBT.func_74767_n("gt.state.new");
        }
        if (aNBT.func_74764_b("gt.state.old")) {
            this.mStateOld = aNBT.func_74767_n("gt.state.old");
        }
        if (aNBT.func_74764_b("gt.needignite")) {
            this.mRequiresIgnition = aNBT.func_74767_n("gt.needignite");
        }
        if (aNBT.func_74764_b("gt.cheap.overclocking")) {
            this.mCheapOverclocking = aNBT.func_74767_n("gt.cheap.overclocking");
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
            this.mInputMin = this.mInput / 2L;
            this.mInputMax = this.mInput * 2L;
        }
        if (aNBT.func_74764_b("gt.input.min")) {
            this.mInputMin = aNBT.func_74763_f("gt.input.min");
        }
        if (aNBT.func_74764_b("gt.input.max")) {
            this.mInputMax = aNBT.func_74763_f("gt.input.max");
        }
        if (aNBT.func_74764_b("gt.minenergy")) {
            this.mMinEnergy = aNBT.func_74763_f("gt.minenergy");
        }
        if (aNBT.func_74764_b("gt.progress")) {
            this.mProgress = aNBT.func_74763_f("gt.progress");
        }
        if (aNBT.func_74764_b("gt.maxprogress")) {
            this.mMaxProgress = aNBT.func_74763_f("gt.maxprogress");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.invsidein")) {
            this.mItemInputs = (byte)(aNBT.func_74771_c("gt.invsidein") | CS.SBIT[6]);
        }
        if (aNBT.func_74764_b("gt.invsideout")) {
            this.mItemOutputs = (byte)(aNBT.func_74771_c("gt.invsideout") | CS.SBIT[6]);
        }
        if (aNBT.func_74764_b("gt.invsideautoin")) {
            this.mItemAutoInput = aNBT.func_74771_c("gt.invsideautoin");
        }
        if (aNBT.func_74764_b("gt.invsideautoout")) {
            this.mItemAutoOutput = aNBT.func_74771_c("gt.invsideautoout");
        }
        if (aNBT.func_74764_b("gt.invdisabledin")) {
            this.mDisabledItemInput = aNBT.func_74767_n("gt.invdisabledin");
        }
        if (aNBT.func_74764_b("gt.invdisabledout")) {
            this.mDisabledItemOutput = aNBT.func_74767_n("gt.invdisabledout");
        }
        if (aNBT.func_74764_b("gt.tanksidein")) {
            this.mFluidInputs = (byte)(aNBT.func_74771_c("gt.tanksidein") | CS.SBIT[6]);
        }
        if (aNBT.func_74764_b("gt.tanksideout")) {
            this.mFluidOutputs = (byte)(aNBT.func_74771_c("gt.tanksideout") | CS.SBIT[6]);
        }
        if (aNBT.func_74764_b("gt.tanksideautoin")) {
            this.mFluidAutoInput = aNBT.func_74771_c("gt.tanksideautoin");
        }
        if (aNBT.func_74764_b("gt.tanksideautoout")) {
            this.mFluidAutoOutput = aNBT.func_74771_c("gt.tanksideautoout");
        }
        if (aNBT.func_74764_b("gt.tankdisabledin")) {
            this.mDisabledFluidInput = aNBT.func_74767_n("gt.tankdisabledin");
        }
        if (aNBT.func_74764_b("gt.tankdisabledout")) {
            this.mDisabledFluidOutput = aNBT.func_74767_n("gt.tankdisabledout");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted.sides")) {
            this.mEnergyInputs = (byte)(aNBT.func_74771_c("gt.energy.accepted.sides") | CS.SBIT[6]);
        }
        int tCapacity = this.getDefaultTankCapacity();
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = UT.Code.bindInt(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanksInput = new FluidTank[this.mRecipes.mInputFluidCount];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i] = new FluidTank(tCapacity).readFromNBT(aNBT.func_74775_l("gt.tank.in." + i));
        }
        this.mTanksOutput = new FluidTank[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i] = new FluidTank(tCapacity).readFromNBT(aNBT.func_74775_l("gt.tank.out." + i));
        }
        this.mOutputFluids = new FluidStack[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            this.mOutputFluids[i] = UT.Fluids.load(aNBT, "gt.tankout." + i);
        }
        this.mOutputItems = new ItemStack[this.mRecipes.mOutputItemsCount];
        for (i = 0; i < this.mOutputItems.length; ++i) {
            this.mOutputItems[i] = UT.Stacks.load(aNBT, "gt.invout." + i);
        }
        if (CS.CODE_CLIENT) {
            if (aNBT.func_74764_b("gt.gui")) {
                this.mGUITexture = aNBT.func_74779_i("gt.gui");
                if (!this.mGUITexture.endsWith(".png")) {
                    this.mGUITexture = this.mGUITexture + ".png";
                }
            }
            if (GT_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                String tTextureName = aNBT.func_74779_i("gt.texture");
                this.mTexturesMaterial = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/back")};
                this.mTexturesInactive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/back")};
                this.mTexturesActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/back")};
                this.mTexturesRunning = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/back")};
            } else if (this.getMultiTileEntityRegistryID() != Short.MAX_VALUE && this.getMultiTileEntityID() != Short.MAX_VALUE) {
                MultiTileEntityBasicMachine tCanonicalTileEntity = (MultiTileEntityBasicMachine)MultiTileEntityRegistry.getRegistry((int)this.getMultiTileEntityRegistryID()).getClassContainer((int)this.getMultiTileEntityID()).mCanonicalTileEntity;
                this.mTexturesMaterial = tCanonicalTileEntity.mTexturesMaterial;
                this.mTexturesInactive = tCanonicalTileEntity.mTexturesInactive;
                this.mTexturesRunning = tCanonicalTileEntity.mTexturesRunning;
                this.mTexturesActive = tCanonicalTileEntity.mTexturesActive;
            } else {
                this.mTexturesActive = CS.L6_IICONCONTAINER;
                this.mTexturesRunning = CS.L6_IICONCONTAINER;
                this.mTexturesInactive = this.mTexturesRunning;
                this.mTexturesMaterial = this.mTexturesRunning;
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setNumber(aNBT, "gt.minenergy", this.mMinEnergy);
        UT.NBT.setNumber(aNBT, "gt.progress", this.mProgress);
        UT.NBT.setNumber(aNBT, "gt.maxprogress", this.mMaxProgress);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.running", this.mRunning);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.state.new", this.mStateNew);
        UT.NBT.setBoolean(aNBT, "gt.state.old", this.mStateOld);
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledin", this.mDisabledItemInput);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledout", this.mDisabledItemOutput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledin", this.mDisabledFluidInput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledout", this.mDisabledFluidOutput);
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (this.mTanksInput[i] == null) continue;
            aNBT.func_74782_a("gt.tank.in." + i, (NBTBase)this.mTanksInput[i].writeToNBT(new NBTTagCompound()));
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            if (this.mTanksOutput[i] == null) continue;
            aNBT.func_74782_a("gt.tank.out." + i, (NBTBase)this.mTanksOutput[i].writeToNBT(new NBTTagCompound()));
        }
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            UT.Fluids.save(aNBT, "gt.tankout." + i, this.mOutputFluids[i]);
        }
        for (i = 0; i < this.mOutputItems.length; ++i) {
            UT.Stacks.save(aNBT, "gt.invout." + i, this.mOutputItems[i]);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        super.writeItemNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledin", this.mDisabledItemInput);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledout", this.mDisabledItemOutput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledin", this.mDisabledFluidInput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledout", this.mDisabledFluidOutput);
        return aNBT;
    }

    public int getDefaultTankCapacity() {
        return UT.Code.bindInt(Math.max(1000L, (long)this.mRecipes.mMaxFluidInputSize * 2L));
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        if (this.mCheapOverclocking) {
            aList.add(LH.Chat.YELLOW + LH.get("gt.lang.cheap.overclocking"));
        }
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        this.addToolTipsSided(aList, aStack, aF3_H);
        if (this.mRequiresIgnition) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.inputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsSided(List aList, ItemStack aStack, boolean aF3_H) {
        String tSideNames = "";
        boolean temp = false;
        if (this.mEnergyTypeAccepted != TD.Energy.TU) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!CS.FACE_CONNECTED[tSide][this.mEnergyInputs]) continue;
                tSideNames = tSideNames + (temp ? ", " : "") + LH.get(LH.FACES[tSide]);
                temp = true;
            }
            LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, tSideNames, null);
        }
        tSideNames = "";
        temp = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!CS.FACE_CONNECTED[tSide][this.mItemInputs]) continue;
            tSideNames = tSideNames + (temp ? ", " : "") + LH.get(LH.FACES[tSide]);
            temp = true;
        }
        if (UT.Code.stringValid(tSideNames)) {
            aList.add(LH.Chat.GREEN + LH.get("gt.lang.item.input") + ": " + LH.Chat.WHITE + tSideNames);
        }
        tSideNames = "";
        temp = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!CS.FACE_CONNECTED[tSide][this.mItemOutputs]) continue;
            tSideNames = tSideNames + (temp ? ", " : "") + LH.get(LH.FACES[tSide]);
            temp = true;
        }
        if (UT.Code.stringValid(tSideNames)) {
            aList.add(LH.Chat.RED + LH.get("gt.lang.item.output") + ": " + LH.Chat.WHITE + tSideNames);
        }
        tSideNames = "";
        temp = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!CS.FACE_CONNECTED[tSide][this.mFluidInputs]) continue;
            tSideNames = tSideNames + (temp ? ", " : "") + LH.get(LH.FACES[tSide]);
            temp = true;
        }
        if (UT.Code.stringValid(tSideNames)) {
            aList.add(LH.Chat.GREEN + LH.get("gt.lang.fluid.input") + ": " + LH.Chat.WHITE + tSideNames);
        }
        tSideNames = "";
        temp = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!CS.FACE_CONNECTED[tSide][this.mFluidOutputs]) continue;
            tSideNames = tSideNames + (temp ? ", " : "") + LH.get(LH.FACES[tSide]);
            temp = true;
        }
        if (UT.Code.stringValid(tSideNames)) {
            aList.add(LH.Chat.RED + LH.get("gt.lang.fluid.output") + ": " + LH.Chat.WHITE + tSideNames);
        }
    }

    public long onToolClick3(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("screwdriver")) {
            this.mMode = (byte)((this.mMode + 1) % 2);
            aChatReturn.add((this.mMode & 1) != 0 ? "Only produce when Output is completely empty" : "Produce whenever there is space");
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("softhammer")) {
            this.mMaxProgress = 0L;
            this.mMinEnergy = 0L;
            this.mProgress = 0L;
            this.mOutputFluids = CS.ZL_FLUIDSTACK;
            this.mOutputItems = CS.ZL_ITEMSTACK;
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("igniter")) {
            if (this.mRequiresIgnition) {
                this.mIgnited = true;
                return 10000L;
            }
            return 0L;
        }
        if (aTool.equals("plunger")) {
            this.updateInventory();
            for (FluidTank tTank : this.mTanksOutput) {
                if (tTank.drain(1000, true) == CS.NF) continue;
                return 10000L;
            }
            for (FluidTank tTank : this.mTanksInput) {
                if (tTank.drain(1000, true) == CS.NF) continue;
                return 10000L;
            }
        }
        if (aTool.equals("monkeywrench")) {
            long rOutput = 0L;
            if (CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput] == aSide) {
                this.mDisabledItemInput = !this.mDisabledItemInput;
                aChatReturn.add(this.mDisabledItemInput ? "Auto Item Input Disabled" : "Auto Item Input Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput] == aSide) {
                this.mDisabledItemOutput = !this.mDisabledItemOutput;
                aChatReturn.add(this.mDisabledItemOutput ? "Auto Item Output Disabled" : "Auto Item Output Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoInput] == aSide) {
                this.mDisabledFluidInput = !this.mDisabledFluidInput;
                aChatReturn.add(this.mDisabledFluidInput ? "Auto Fluid Input Disabled" : "Auto Fluid Input Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoOutput] == aSide) {
                this.mDisabledFluidOutput = !this.mDisabledFluidOutput;
                aChatReturn.add(this.mDisabledFluidOutput ? "Auto Fluid Output Disabled" : "Auto Fluid Output Enabled");
                rOutput += 10000L;
            }
            if (rOutput > 0L) {
                this.updateInventory();
                return rOutput;
            }
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add((this.mMode & 1) != 0 ? "Only produce when Output is completely empty" : "Produce whenever there is space");
                aChatReturn.add(this.mDisabledItemInput ? "Auto Item Input Disabled" : "Auto Item Input Enabled");
                aChatReturn.add(this.mDisabledItemOutput ? "Auto Item Output Disabled" : "Auto Item Output Enabled");
                aChatReturn.add(this.mDisabledFluidInput ? "Auto Fluid Input Disabled" : "Auto Fluid Input Enabled");
                aChatReturn.add(this.mDisabledFluidOutput ? "Auto Fluid Output Disabled" : "Auto Fluid Output Enabled");
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onCoordinateChange() {
        this.updateAdjacentToggleableEnergySources();
    }

    @Override
    public void onTickFailed(long aTimer, boolean aIsServerSide) {
        super.onTickFailed(aTimer, aIsServerSide);
        this.mMaxProgress = 0L;
        this.mMinEnergy = 0L;
        this.mProgress = 0L;
        this.mOutputFluids = CS.ZL_FLUIDSTACK;
        this.mOutputItems = CS.ZL_ITEMSTACK;
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide) {
            this.updateAdjacentToggleableEnergySources();
            if (this.checkStructure(true) && !this.mActive) {
                this.checkRecipe(false, this.mRunning || this.mStopped);
            }
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            int i;
            if (this.mBlockUpdated) {
                this.updateAdjacentToggleableEnergySources();
            }
            if (this.mEnergyTypeAccepted == TD.Energy.TU && !this.mStopped) {
                ++this.mEnergy;
            }
            if (!this.mDisabledFluidOutput && CS.SIDES_VALID[this.mFluidAutoOutput]) {
                this.doOutputFluids();
            }
            this.doWork(aTimer);
            if (this.mTimer % 600L == 5L) {
                this.doDefaultStructuralChecks();
            }
            for (i = 0; i < this.mTanksInput.length; ++i) {
                this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + i, UT.Fluids.display(this.mTanksInput[i].getFluid(), true));
            }
            for (i = 0; i < this.mTanksOutput.length; ++i) {
                this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + i + this.mTanksInput.length, UT.Fluids.display(this.mTanksOutput[i].getFluid(), true));
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActive != this.oActive || this.mRunning != this.oRunning || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oRunning = this.mRunning;
        this.oActive = this.mActive;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            this.openGUI(aPlayer, aSide);
        }
        return true;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (this.mStopped) {
            return 0L;
        }
        if (aDoInject) {
            boolean bl = this.mStateNew = aSize > 0L;
        }
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        long tInput = Math.min(this.mInputMax - this.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (aTheoretical || !this.mStopped) && CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mEnergyInputs] && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.mInputMin;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mInputMax;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        this.ACCESSIBLE_SLOTS = UT.Code.getAscendingArray(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount);
        return new ItemStack[this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + this.mRecipes.mInputFluidCount + this.mRecipes.mOutputFluidCount];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return this.ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return aInventorySlot < this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mItemInputs] || aSlot >= this.mRecipes.mInputItemsCount) {
            return false;
        }
        for (int i = 0; i < this.mRecipes.mInputItemsCount; ++i) {
            if (!UT.Stacks.equal(aStack, this.slot(i), true)) continue;
            return i == aSlot;
        }
        return this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mItemOutputs] && aSlot >= this.mRecipes.mInputItemsCount && aSlot < this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount;
    }

    @Override
    public IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        int i;
        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidInputs]) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!UT.Fluids.equal(aFluidToFill, this.mTanksInput[i].getFluid(), false)) continue;
            return this.mTanksInput[i];
        }
        if (!this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount))) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (this.mTanksInput[i].getFluidAmount() != 0) continue;
            return this.mTanksInput[i];
        }
        return null;
    }

    @Override
    public IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
            return null;
        }
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (this.mTanksOutput[i].getFluidAmount() == 0) continue;
                return this.mTanksOutput[i];
            }
        } else {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (!UT.Fluids.equal(aFluidToDrain, this.mTanksOutput[i].getFluid(), false)) continue;
                return this.mTanksOutput[i];
            }
        }
        return null;
    }

    @Override
    public IFluidTank[] getFluidTanks2(byte aSide) {
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidInputs]) {
            if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
                int i;
                IFluidTank[] rTanks = new IFluidTank[this.mTanksInput.length + this.mTanksOutput.length];
                for (i = 0; i < this.mTanksInput.length; ++i) {
                    rTanks[i] = this.mTanksInput[i];
                }
                for (i = 0; i < this.mTanksOutput.length; ++i) {
                    rTanks[this.mTanksInput.length + i] = this.mTanksOutput[i];
                }
                return rTanks;
            }
            return this.mTanksInput;
        }
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
            return this.mTanksOutput;
        }
        return CS.ZL_FLUIDTANK;
    }

    @Override
    public boolean breakBlock() {
        this.setStateOnOff(true);
        return super.breakBlock();
    }

    public void updateAdjacentToggleableEnergySources() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!this.isEnergyAcceptingFrom(this.mEnergyTypeAccepted, tSide, true)) continue;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!(tDelegator.mTileEntity instanceof ITileEntitySwitchableOnOff) || !(tDelegator.mTileEntity instanceof ITileEntityEnergy) || !((ITileEntityEnergy)tDelegator.mTileEntity).isEnergyEmittingTo(this.mEnergyTypeAccepted, tDelegator.mSideOfTileEntity, true)) continue;
            ((ITileEntitySwitchableOnOff)tDelegator.mTileEntity).setStateOnOff(this.getStateOnOff());
        }
    }

    public boolean canOutput(Recipe aRecipe) {
        int i = 0;
        int j = this.mRecipes.mInputItemsCount;
        while (i < this.mRecipes.mOutputItemsCount && i < aRecipe.mOutputs.length) {
            if (this.slot(j) != null && ((this.mMode & 1) != 0 || aRecipe.mNeedsEmptyOutput || aRecipe.mOutputs[i] != null && (!UT.Stacks.equal(this.slot(j), aRecipe.mOutputs[i], false) || this.slot((int)j).field_77994_a + aRecipe.mOutputs[i].field_77994_a > this.slot(j).func_77976_d()))) {
                this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                return false;
            }
            ++i;
            ++j;
        }
        for (i = 0; i < this.mTanksOutput.length && i < aRecipe.mFluidOutputs.length; ++i) {
            if (this.mTanksOutput[i].getFluidAmount() == 0 || (this.mMode & 1) == 0 && !aRecipe.mNeedsEmptyOutput && (aRecipe.mFluidOutputs[i] == null || UT.Fluids.equal(this.mTanksOutput[i].getFluid(), aRecipe.mFluidOutputs[i], false) && this.mTanksOutput[i].getFluidAmount() < Math.max(this.getDefaultTankCapacity(), aRecipe.mFluidOutputs[i].amount + 1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int checkRecipe(boolean aApplyRecipe, boolean aUseAutoInputs) {
        void var8_15;
        FluidTankInfo[] tInfos;
        DelegatorTileEntity<IFluidHandler> tTileEntity;
        this.mCouldUseRecipe = false;
        if (this.mRecipes == null) {
            return 0;
        }
        DelegatorTileEntity<IInventory> tInventory = null;
        byte tAutoInput = CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput];
        if (aUseAutoInputs && !this.mDisabledItemInput && CS.SIDES_VALID[tAutoInput] && (tInventory = this.getItemInputTarget(tAutoInput)) != null && tInventory.mTileEntity == null) {
            tInventory = null;
        }
        ItemStack[] tInputs = new ItemStack[this.mRecipes.mInputItemsCount];
        for (int i = 0; i < this.mRecipes.mInputItemsCount; ++i) {
            if (tInventory != null) {
                UT.Inventories.moveOneItemStackIntoSlot(tInventory.mTileEntity, this, tInventory.mSideOfTileEntity, i, null, false, 64, 1, 64, 1);
            }
            tInputs[i] = this.slot(i);
        }
        tAutoInput = CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoInput];
        if (aUseAutoInputs && !this.mDisabledFluidInput && CS.SIDES_VALID[tAutoInput] && (tTileEntity = this.getFluidInputTarget(tAutoInput)) != null && tTileEntity.mTileEntity != null && (tInfos = ((IFluidHandler)tTileEntity.mTileEntity).getTankInfo(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity])) != null) {
            for (FluidTankInfo tInfo : tInfos) {
                FluidStack tDrained;
                if (tInfo == null || tInfo.fluid == null || tInfo.fluid.amount <= 0 || this.getFluidTankFillable((byte)6, tInfo.fluid) == null || (tDrained = ((IFluidHandler)tTileEntity.mTileEntity).drain(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tInfo.fluid, false)) == null) continue;
                tDrained.amount = this.fill(CS.FORGE_DIR[tAutoInput], tDrained, false);
                if (tDrained.amount <= 0) continue;
                this.fill(CS.FORGE_DIR[tAutoInput], ((IFluidHandler)tTileEntity.mTileEntity).drain(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tDrained, true), true);
            }
        }
        FluidStack[] tInputFluids = new FluidStack[this.mTanksInput.length];
        for (int i = 0; i < this.mTanksInput.length; ++i) {
            tInputFluids[i] = this.mTanksInput[i].getFluid();
        }
        Recipe tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, false, this.mEnergyTypeAccepted == TD.Energy.RF ? this.mInputMax / 4L : this.mInputMax, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount), tInputFluids, tInputs);
        if (tRecipe == null) {
            return 0;
        }
        if (tRecipe.mCanBeBuffered) {
            this.mLastRecipe = tRecipe;
        }
        if (!this.canOutput(tRecipe)) {
            return 1;
        }
        if (aApplyRecipe) {
            boolean bl = aApplyRecipe = !this.mRequiresIgnition || this.mIgnited || this.mSuccessful || this.mActive;
        }
        if (!tRecipe.isRecipeInputEqual(aApplyRecipe, false, tInputFluids, tInputs)) {
            return 1;
        }
        this.mCouldUseRecipe = true;
        if (!aApplyRecipe) {
            return 3;
        }
        for (byte tSide : CS.ALL_SIDES_VALID_FIRST[CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput]]) {
            DelegatorTileEntity<IInventory> tDelegator;
            if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][tSide]][this.mItemInputs] || (tDelegator = this.getItemInputTarget(tSide)) == null || !(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
            ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
        }
        this.mOutputItems = tRecipe.getOutputs(this.field_145850_b.field_73012_v);
        this.mOutputFluids = tRecipe.getFluidOutputs(this.field_145850_b.field_73012_v);
        this.mMinEnergy = Math.max(1L, this.mEnergyTypeAccepted == TD.Energy.RF ? tRecipe.mEUt * 4L : tRecipe.mEUt);
        this.mMaxProgress = Math.max(1L, UT.Code.units(this.mMinEnergy * Math.max(1L, tRecipe.mDuration), this.mEfficiency, 10000L, true));
        if (this.mMinEnergy > 0L && !this.mCheapOverclocking) {
            while (this.mMinEnergy < this.mInputMin && this.mMinEnergy * 4L <= this.mInputMax) {
                this.mMinEnergy *= 4L;
                this.mMaxProgress *= 2L;
            }
        }
        this.removeAllDroppableNullStacks();
        boolean bl = false;
        while (var8_15 < this.mTanksInput.length) {
            if (this.mTanksInput[var8_15].getFluidAmount() == 0) {
                this.mTanksInput[var8_15].setFluid(null);
            }
            ++var8_15;
        }
        return 2;
    }

    public void doWork(long aTimer) {
        this.mSuccessful = false;
        if (this.mEnergy >= this.mInputMin && this.mEnergy >= this.mMinEnergy && this.checkStructure(false)) {
            this.mActive = this.doActive(aTimer, Math.min(this.mInputMax, this.mEnergy));
            this.mRunning = true;
        } else if (this.mTimer > 20L) {
            this.mActive = this.doInactive(aTimer);
            this.mRunning = false;
        }
        this.mEnergy -= this.mInputMax;
        if (this.mEnergy < 0L) {
            this.mEnergy = 0L;
        }
        this.mIgnited = false;
    }

    public boolean doActive(long aTimer, long aEnergy) {
        boolean rActive = false;
        if (this.mMaxProgress > 0L) {
            rActive = true;
            if (this.mProgress <= this.mMaxProgress) {
                this.mProgress += aEnergy;
            }
            if (this.mProgress >= this.mMaxProgress && (this.mStateOld && !this.mStateNew || !TD.Energy.ALL_ALTERNATING.contains(this.mEnergyTypeAccepted))) {
                int i;
                for (i = 0; i < this.mOutputItems.length; ++i) {
                    if (this.mOutputItems[i] == null || !this.addStackToSlot(this.mRecipes.mInputItemsCount + i % this.mRecipes.mOutputItemsCount, this.mOutputItems[i])) continue;
                    this.mSuccessful = true;
                    this.mOutputItems[i] = null;
                    break;
                }
                block1: for (i = 0; i < this.mTanksOutput.length; ++i) {
                    for (int j = 0; j < this.mOutputFluids.length; ++j) {
                        if (this.mOutputFluids[j] == null) continue;
                        if (this.mTanksOutput[i].getFluidAmount() == 0) {
                            this.mTanksOutput[i].setFluid(this.mOutputFluids[j]);
                            this.mSuccessful = true;
                            this.mOutputFluids[j] = null;
                            continue block1;
                        }
                        if (!UT.Fluids.equal(this.mTanksOutput[i].getFluid(), this.mOutputFluids[j], false)) continue;
                        this.updateInventory();
                        this.mTanksOutput[i].getFluid().amount += this.mOutputFluids[j].amount;
                        this.mSuccessful = true;
                        this.mOutputFluids[j] = null;
                        continue block1;
                    }
                }
                if (UT.Code.containsSomething(this.mOutputItems) || UT.Code.containsSomething(this.mOutputFluids)) {
                    this.mMinEnergy = 0L;
                    this.mProgress = this.mMaxProgress;
                } else {
                    this.mProgress -= this.mMaxProgress;
                    this.mMinEnergy = 0L;
                    this.mMaxProgress = 0L;
                    this.mOutputItems = CS.ZL_ITEMSTACK;
                    this.mOutputFluids = CS.ZL_FLUIDSTACK;
                    this.mSuccessful = true;
                    for (byte tSide : CS.ALL_SIDES_VALID_FIRST[CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput]]) {
                        DelegatorTileEntity<TileEntity> tDelegator;
                        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][tSide]][this.mItemOutputs] || (tDelegator = this.getItemOutputTarget(tSide)) == null || !(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                        ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                    }
                    this.onProcessFinished();
                }
            }
        }
        this.mStateOld = this.mStateNew;
        if (!this.mDisabledItemOutput && CS.SIDES_VALID[this.mItemAutoOutput]) {
            int i;
            boolean tOutputEmpty = true;
            int j = i + this.mRecipes.mOutputItemsCount;
            for (i = this.mRecipes.mInputItemsCount; i < j; ++i) {
                if (this.slot(i) == null) continue;
                tOutputEmpty = false;
                break;
            }
            if (!tOutputEmpty && (this.mSuccessful || this.mIgnited || this.mInventoryChanged || !this.mRunning || this.mOutputBlocked == 1 || aTimer % 1200L == 5L)) {
                this.doOutputItems();
            }
            tOutputEmpty = true;
            j = i + this.mRecipes.mOutputItemsCount;
            for (i = this.mRecipes.mInputItemsCount; i < j; ++i) {
                if (this.slot(i) == null) continue;
                tOutputEmpty = false;
                this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                break;
            }
            if (tOutputEmpty) {
                this.mOutputBlocked = 0;
            }
        }
        if (this.mMaxProgress <= 0L) {
            if ((this.mIgnited || this.mSuccessful || this.mInventoryChanged || !this.mRunning || aTimer % 1200L == 5L) && this.checkRecipe(true, true) == 2) {
                this.onProcessStarted();
            } else {
                this.mProgress = 0L;
            }
        }
        return rActive;
    }

    public boolean doInactive(long aTimer) {
        if (this.mProgress > 0L || this.mActive) {
            this.doSoundInterrupt();
        }
        this.mProgress = 0L;
        if (this.mRunning || this.mIgnited || this.mInventoryChanged || aTimer % 1200L == 5L) {
            if (!this.checkStructure(false)) {
                this.checkStructure(true);
            }
            this.checkRecipe(false, true);
        }
        return false;
    }

    public boolean doSoundInterrupt() {
        return UT.Sounds.send(this.field_145850_b, this.mRequiresIgnition ? "random.fizz" : CS.SFX.IC_MACHINE_INTERRUPT, 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean checkStructure(boolean aForceReset) {
        return true;
    }

    public DelegatorTileEntity<IInventory> getItemInputTarget(byte aSide) {
        return this.getAdjacentInventory(aSide);
    }

    public DelegatorTileEntity<TileEntity> getItemOutputTarget(byte aSide) {
        return this.getAdjacentTileEntity(aSide);
    }

    public DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte aSide) {
        return this.getAdjacentTank(aSide);
    }

    public DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte aSide, Fluid aOutput) {
        return this.getAdjacentTank(aSide);
    }

    public void doOutputItems() {
        byte tAutoOutput = CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput];
        DelegatorTileEntity<TileEntity> tTileEntity = this.getItemOutputTarget(tAutoOutput);
        if (tTileEntity != null) {
            for (int i = 0; i < this.mRecipes.mOutputItemsCount; ++i) {
                UT.Inventories.moveOneItemStack(this, tTileEntity, tAutoOutput, tTileEntity.mSideOfTileEntity, null, false, 64, 1, 64, 1);
            }
        }
    }

    public void doOutputFluids() {
        for (FluidTank tCheck : this.mTanksOutput) {
            if (tCheck.getFluidAmount() <= 0) continue;
            byte tAutoOutput = CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoOutput];
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getFluidOutputTarget(tAutoOutput, tCheck.getFluid().getFluid());
            if (tTileEntity == null || tTileEntity.mTileEntity == null) break;
            for (FluidTank tTank : this.mTanksOutput) {
                FluidStack tDrained = tTank.drain(Integer.MAX_VALUE, false);
                if (tDrained == null) continue;
                tDrained.amount = ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tDrained, false);
                if (tDrained.amount <= 0 || ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tTank.drain(tDrained.amount, true), true) <= 0) continue;
                this.updateInventory();
            }
            break;
        }
    }

    public void onProcessStarted() {
    }

    public void onProcessFinished() {
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientBasicMachine(aPlayer.field_71071_by, this, this.mRecipes, this.mGUITexture);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonBasicMachine(aPlayer.field_71071_by, this, this.mRecipes);
    }

    @Override
    public byte getVisualData() {
        return (byte)((this.mActive ? 1 : 0) | (this.mRunning ? 2 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        this.mRunning = (aData & 2) != 0;
        this.mActive = (aData & 1) != 0;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(this.mTexturesMaterial[CS.FACING_ROTATIONS[this.mFacing][aSide]], this.mRGBa), BlockTextureDefault.get((this.mActive || this.field_145850_b == null ? this.mTexturesActive : (this.mRunning ? this.mTexturesRunning : this.mTexturesInactive))[CS.FACING_ROTATIONS[this.mFacing][aSide]])) : null;
    }

    public boolean hasWork() {
        return this.mMaxProgress > 0L;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mSuccessful ? this.getProgressMax(aSide) : (this.mMinEnergy < 1L ? this.mProgress : this.mProgress / this.mMinEnergy + (long)(this.mProgress % this.mMinEnergy == 0L ? 0 : 1));
    }

    @Override
    public long getProgressMax(byte aSide) {
        return Math.max(1L, this.mMinEnergy < 1L ? this.mMaxProgress : this.mMaxProgress / this.mMinEnergy + (long)(this.mMaxProgress % this.mMinEnergy == 0L ? 0 : 1));
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mCouldUseRecipe || this.mActive;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mRunning;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        return this.mSuccessful;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        if (this.mStopped == aOnOff) {
            this.mStopped = !aOnOff;
            this.updateAdjacentToggleableEnergySources();
        }
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.machine.basic";
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mItemInputs | this.mItemOutputs]) {
            this.updateInventory();
        }
    }
}

