/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import gregapi.data.CS;
import gregapi.recipes.Recipe;
import gregapi.tileentity.data.ITileEntityProgress;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface ITileEntityProcessor
extends ITileEntityProgress {
    public ProcessorData getProcessingData(ItemStack[] var1, FluidStack[] var2);

    public static class ProcessorDataDefault {
        public final byte mItemInputSide;
        public final byte mFluidInputSide;
        public final byte mItemOutputSide;
        public final byte mFluidOutputSide;
        public final ItemStack[] mItemInputs;
        public final ItemStack[] mItemOutputs;
        public final FluidStack[] mFluidInputs;
        public final FluidStack[] mFluidOutputs;

        public ProcessorDataDefault(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack[] aItemOutputs, FluidStack[] aFluidOutputs, byte aItemInputSide, byte aFluidInputSide, byte aItemOutputSide, byte aFluidOutputSide) {
            this.mItemInputSide = aItemInputSide;
            this.mFluidInputSide = aFluidInputSide;
            this.mItemOutputSide = aItemOutputSide;
            this.mFluidOutputSide = aFluidOutputSide;
            this.mItemInputs = aItemInputs;
            this.mFluidInputs = aFluidInputs;
            this.mItemOutputs = aItemOutputs;
            this.mFluidOutputs = aFluidOutputs;
        }

        public ItemStack[] getItemInputs() {
            return this.mItemInputs;
        }

        public FluidStack[] getFluidInputs() {
            return this.mFluidInputs;
        }

        public ItemStack[] getItemOutputs() {
            return this.mItemOutputs;
        }

        public FluidStack[] getFluidOutputs() {
            return this.mFluidOutputs;
        }

        public byte getValidItemInputSide(ItemStack aStack) {
            return this.mItemInputSide;
        }

        public byte getValidFluidInputSide(FluidStack aFluid) {
            return this.mFluidInputSide;
        }

        public byte getValidItemOutputSide(ItemStack aStack) {
            return this.mItemOutputSide;
        }

        public byte getValidFluidOutputSide(FluidStack aFluid) {
            return this.mFluidOutputSide;
        }
    }

    public static class ProcessorDataRecipe {
        public final byte mItemInputSide;
        public final byte mFluidInputSide;
        public final byte mItemOutputSide;
        public final byte mFluidOutputSide;
        public final Recipe mRecipe;

        public ProcessorDataRecipe(Recipe aRecipe, byte aItemInputSide, byte aFluidInputSide, byte aItemOutputSide, byte aFluidOutputSide) {
            this.mItemInputSide = aItemInputSide;
            this.mFluidInputSide = aFluidInputSide;
            this.mItemOutputSide = aItemOutputSide;
            this.mFluidOutputSide = aFluidOutputSide;
            this.mRecipe = aRecipe;
        }

        public ItemStack[] getItemInputs() {
            return this.mRecipe.mInputs;
        }

        public FluidStack[] getFluidInputs() {
            return this.mRecipe.mFluidInputs;
        }

        public ItemStack[] getItemOutputs() {
            return this.mRecipe.mOutputs;
        }

        public FluidStack[] getFluidOutputs() {
            return this.mRecipe.mFluidOutputs;
        }

        public byte getValidItemInputSide(ItemStack aStack) {
            return this.mItemInputSide;
        }

        public byte getValidFluidInputSide(FluidStack aFluid) {
            return this.mFluidInputSide;
        }

        public byte getValidItemOutputSide(ItemStack aStack) {
            return this.mItemInputSide;
        }

        public byte getValidFluidOutputSide(FluidStack aFluid) {
            return this.mFluidInputSide;
        }
    }

    public static abstract class ProcessorData {
        public ItemStack[] getItemInputs() {
            return CS.ZL_ITEMSTACK;
        }

        public FluidStack[] getFluidInputs() {
            return CS.ZL_FLUIDSTACK;
        }

        public ItemStack[] getItemOutputs() {
            return CS.ZL_ITEMSTACK;
        }

        public FluidStack[] getFluidOutputs() {
            return CS.ZL_FLUIDSTACK;
        }

        public byte getValidItemInputSide(ItemStack aStack) {
            return 6;
        }

        public byte getValidFluidInputSide(FluidStack aFluid) {
            return 6;
        }

        public byte getValidItemOutputSide(ItemStack aStack) {
            return 6;
        }

        public byte getValidFluidOutputSide(FluidStack aFluid) {
            return 6;
        }
    }
}

