/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase11Motor
extends TileEntityBase10EnergyConverter
implements ITileEntitySwitchableOnOff {
    protected boolean mCounterClockwise = false;
    protected boolean mFast = false;
    protected boolean oCounterClockwise = false;
    protected boolean oFast = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mCounterClockwise = aNBT.func_74767_n("gt.state");
        }
        if (aNBT.func_74764_b("gt.visual")) {
            this.mFast = aNBT.func_74767_n("gt.visual");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.state", this.mCounterClockwise);
        UT.NBT.setBoolean(aNBT, "gt.visual", this.mFast);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.direction"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mCounterClockwise = !this.mCounterClockwise;
            return 10000L;
        }
        return 0L;
    }

    @Override
    public void doConversion(long aTimer) {
        long tOutput = UT.Code.units(this.mEnergy, this.mInput, this.mOutput, false);
        long tMaxOut = this.getEnergySizeOutputMax(this.mEnergyTypeEmitted, (byte)6);
        this.mActive = tOutput >= this.getEnergySizeOutputMin(this.mEnergyTypeEmitted, (byte)6);
        this.mFast = tOutput > this.mOutput;
        this.mEmitsEnergy = false;
        if (this.mActive) {
            if (tOutput > tMaxOut && TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mEnergyTypeAccepted)) {
                tOutput = tMaxOut;
            }
            if (tOutput > tMaxOut) {
                this.overload(this.mEnergy, this.mEnergyTypeEmitted);
            } else if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyTypeEmitted)) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, tOutput * this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L;
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mCounterClockwise ? tOutput : -tOutput, this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L;
            }
        }
        if (this.mWasteEnergy) {
            this.mEnergy = Math.max(0L, this.mEnergy - this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6));
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mCounterClockwise != this.oCounterClockwise || this.mFast != this.oFast || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oCounterClockwise = this.mCounterClockwise;
        this.oFast = this.mFast;
    }

    @Override
    public byte getVisualData() {
        return (byte)(super.getVisualData() | (this.mCounterClockwise ? 4 : 0) | (this.mFast ? 8 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        super.setVisualData(aData);
        this.mCounterClockwise = (aData & 4) != 0;
        this.mFast = (aData & 8) != 0;
    }
}

