/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class TileEntityBase11Bipolar
extends TileEntityBase10EnergyConverter
implements ITileEntitySwitchableOnOff {
    @Override
    public void addToolTipsEfficiency(List aList, ItemStack aStack, boolean aF3_H) {
        if (TD.Energy.ALL_EU.contains(this.mEnergyTypeAccepted)) {
            if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted)) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * 2L, false)));
            } else if (this.mEnergyTypeEmitted == TD.Energy.RF) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput * 4L, this.mOutput * 2L, false)));
            }
        } else if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted) && this.mEnergyTypeAccepted == TD.Energy.RF) {
            aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * 8L, false)));
        }
    }

    @Override
    public void doConversion(long aTimer) {
        long tOutput = UT.Code.units(this.mEnergy, this.mInput, this.mOutput, false);
        long tMaxOut = this.getEnergySizeOutputMax(this.mEnergyTypeEmitted, (byte)6);
        this.mActive = tOutput >= this.getEnergySizeOutputMin(this.mEnergyTypeEmitted, (byte)6);
        this.mEmitsEnergy = false;
        if (this.mActive) {
            if (tOutput > tMaxOut && TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mEnergyTypeAccepted)) {
                tOutput = tMaxOut;
            }
            if (tOutput > tMaxOut) {
                this.overload(this.mEnergy, this.mEnergyTypeEmitted);
            } else if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyTypeEmitted)) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, this.mFacing, 1L, tOutput * this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L;
                tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, CS.OPPOSITES[this.mFacing], 1L, tOutput * this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, this.mFacing, tOutput, this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L;
                tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, CS.OPPOSITES[this.mFacing], -tOutput, this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
            }
        }
        if (this.mWasteEnergy) {
            this.mEnergy = Math.max(0L, this.mEnergy - this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6));
        }
    }

    @Override
    public boolean isInput(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isOutput(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.any.but.front.back");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front.back");
    }
}

