/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.TagData;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase11Bidirectional
extends TileEntityBase10EnergyConverter
implements ITileEntitySwitchableOnOff {
    protected boolean mReversed = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.reversed")) {
            this.mReversed = aNBT.func_74767_n("gt.reversed");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.reversed", this.mReversed);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting != this.mReversed ? aEnergyType == this.mEnergyTypeEmitted : aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return (this.mReversed ? this.mInput : this.mOutput) <= 8L ? 1L : (this.mReversed ? this.mInput : this.mOutput) / 2L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mReversed ? this.mInput : this.mOutput;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return (this.mReversed ? this.mInput : this.mOutput) * 2L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return (this.mReversed ? this.mOutput : this.mInput) <= 8L ? 1L : (this.mReversed ? this.mOutput : this.mInput) / 2L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mReversed ? this.mOutput : this.mInput;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return (this.mReversed ? this.mOutput : this.mInput) * 2L;
    }

    @Override
    public long getMaxBuffered(TagData aEnergyType, byte aSide) {
        return Math.max(this.mInput, this.mOutput * this.mMultiplier);
    }

    @Override
    public boolean isInput(byte aSide) {
        return this.mReversed ? aSide != this.mFacing : aSide == this.mFacing;
    }

    @Override
    public boolean isOutput(byte aSide) {
        return this.mReversed ? aSide == this.mFacing : aSide != this.mFacing;
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.front");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.any.but.front");
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.direction"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mReversed = !this.mReversed;
            this.causeBlockUpdate();
            this.doEnetUpdate();
            return 10000L;
        }
        return 0L;
    }

    @Override
    public void doConversion(long aTimer) {
        long tOutput = UT.Code.units(this.mEnergy, this.mReversed ? this.mOutput * this.mMultiplier : this.mInput, this.mReversed ? this.mInput : this.mOutput, false);
        long tMaxOut = this.getEnergySizeOutputMax(this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted, (byte)6);
        this.mActive = tOutput >= this.getEnergySizeOutputMin(this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted, (byte)6);
        this.mEmitsEnergy = false;
        if (this.mActive) {
            if (tOutput > tMaxOut && TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mReversed ? this.mEnergyTypeEmitted : this.mEnergyTypeAccepted)) {
                tOutput = tMaxOut;
            }
            if (tOutput > tMaxOut) {
                this.overload(tOutput, this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted);
            } else if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted)) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted, 1L, tOutput * (this.mReversed ? 1L : this.mMultiplier), this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets, this.mReversed ? this.mInput : this.mOutput * this.mMultiplier, this.mReversed ? this.mOutput * this.mMultiplier : this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L;
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mReversed ? this.mEnergyTypeAccepted : this.mEnergyTypeEmitted, tOutput, this.mReversed ? 1L : this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mReversed ? this.mInput : this.mOutput * this.mMultiplier, this.mReversed ? this.mOutput * this.mMultiplier : this.mInput, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L;
            }
        }
        if (this.mWasteEnergy) {
            this.mEnergy = Math.max(0L, this.mEnergy - this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6));
        }
    }
}

