/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase10EnergyConverter
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityRunningActively {
    protected boolean mWasteEnergy = false;
    protected boolean mEmitsEnergy = false;
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected long mEnergy = 0L;
    protected long mInput = 32L;
    protected long mOutput = 16L;
    protected long mMultiplier = 1L;
    protected long mActiveData = 0L;
    protected byte mActiveState = 0;
    protected byte mExplosionPrevention = 0;
    protected TagData mEnergyTypeAccepted = TD.Energy.QU;
    protected TagData mEnergyTypeEmitted = TD.Energy.QU;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.func_74767_n("gt.active.energy");
        }
        if (aNBT.func_74764_b("gt.wasteenergy")) {
            this.mWasteEnergy = aNBT.func_74767_n("gt.wasteenergy");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.active.data")) {
            this.mActiveData = aNBT.func_74763_f("gt.active.data");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutput = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.multiplier")) {
            this.mMultiplier = aNBT.func_74763_f("gt.multiplier");
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.active.data", this.mActiveData);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        this.addToolTipsEnergy(aList, aStack, aF3_H);
        this.addToolTipsEfficiency(aList, aStack, aF3_H);
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEnergy(List aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, this.mEnergyTypeEmitted, this.getLocalisedInputSide(), this.getLocalisedOutputSide());
    }

    public void addToolTipsEfficiency(List aList, ItemStack aStack, boolean aF3_H) {
        if (TD.Energy.ALL_EU.contains(this.mEnergyTypeAccepted)) {
            if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted)) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * this.mMultiplier, false)));
            } else if (this.mEnergyTypeEmitted == TD.Energy.RF) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput * 4L, this.mOutput * this.mMultiplier, false)));
            }
        } else if (TD.Energy.ALL_EU.contains(this.mEnergyTypeEmitted)) {
            if (this.mEnergyTypeAccepted == TD.Energy.RF) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * this.mMultiplier * 4L, false)));
            }
            if (this.mEnergyTypeAccepted == TD.Energy.STEAM) {
                aList.add(LH.getToolTipEfficiency(UT.Code.units(10000L, this.mInput, this.mOutput * this.mMultiplier * (long)CS.STEAM_PER_EU, false)));
            }
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.doConversion(aTimer);
            if (this.mTimer % 600L == 5L) {
                if (this.mActive) {
                    this.doDefaultStructuralChecks();
                } else if (this.mExplosionPrevention > 0) {
                    this.mExplosionPrevention = (byte)(this.mExplosionPrevention - 1);
                }
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mActiveData <<= 1;
        if (this.mActive) {
            this.mActiveData |= 1L;
        }
        byte tActiveState = this.mActiveState;
        this.mActiveState = this.mActiveData == 0L || this.mStopped ? (byte)0 : (this.mActiveData == -1L ? (byte)1 : (byte)2);
        return tActiveState != this.mActiveState || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActiveState = aData;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overload(aSize, aEnergyType);
            }
            return aAmount;
        }
        long tMaxBuffer = this.getMaxBuffered(aEnergyType, aSide);
        if (this.mEnergy >= tMaxBuffer) {
            return 0L;
        }
        long tInput = Math.min(tMaxBuffer - this.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    public void overload(long aSize, TagData aEnergyType) {
        if (this.mExplosionPrevention < 100) {
            if (this.mTimer < 100L) {
                CS.DEB.println("Machine overloaded on startup with: " + aSize + " " + aEnergyType.getLocalisedNameLong());
            }
            this.mExplosionPrevention = (byte)(this.mExplosionPrevention + 1);
            this.mEnergy = 0L;
        } else {
            this.overcharge(aSize, aEnergyType);
        }
    }

    public long getMaxBuffered(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputMax(aEnergyType, aSide);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting ? aEnergyType == this.mEnergyTypeEmitted : aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && this.mStopped || !CS.SIDES_INVALID[aSide] && !this.isInput(aSide) || !super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (CS.SIDES_INVALID[aSide] || this.isOutput(aSide)) && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeAccepted, this.mEnergyTypeEmitted);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    public void doConversion(long aTimer) {
        long tOutput = UT.Code.units(this.mEnergy, this.mInput, this.mOutput, false);
        long tMaxOut = this.getEnergySizeOutputMax(this.mEnergyTypeEmitted, (byte)6);
        this.mActive = tOutput >= this.getEnergySizeOutputMin(this.mEnergyTypeEmitted, (byte)6);
        this.mEmitsEnergy = false;
        if (this.mActive) {
            if (tOutput > tMaxOut && TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mEnergyTypeAccepted)) {
                tOutput = tMaxOut;
            }
            if (tOutput > tMaxOut) {
                if (this.mTimer > 2L) {
                    this.overload(this.mEnergy, this.mEnergyTypeEmitted);
                } else {
                    this.mEnergy = 0L;
                    CS.DEB.println("Machine overcharged on startup with: " + this.mEnergy + " " + this.mEnergyTypeEmitted.getLocalisedNameLong());
                }
            } else if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyTypeEmitted)) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, tOutput * this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                this.mEmitsEnergy = tEmittedPackets > 0L;
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, tOutput, this.mMultiplier, this);
                if (!this.mWasteEnergy) {
                    this.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mOutput * this.mMultiplier, this.mInput, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L;
            }
        }
        if (this.mWasteEnergy) {
            this.mEnergy = Math.max(0L, this.mEnergy - this.getEnergySizeInputMax(this.mEnergyTypeAccepted, (byte)6));
        }
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte getVisualData() {
        return this.mActiveState;
    }

    public boolean isInput(byte aSide) {
        return aSide != this.mFacing;
    }

    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.any.but.front");
    }

    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }
}

