/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.item.IItemEnergy;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase10EnergyBattery
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy,
ITileEntityEnergyDataCapacitor,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff,
ITileEntitySwitchableMode,
ITileEntityProgress {
    public boolean mEmitsEnergy = false;
    public boolean mStopped = false;
    public boolean mActive = false;
    public long mEnergy = 0L;
    public long mInput = 32L;
    public long mOutput = 32L;
    public byte mActiveState = 0;
    public byte mMode = 0;
    public TagData mEnergyType = TD.Energy.QU;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.func_74767_n("gt.active.energy");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutput = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyType = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        this.addToolTipsEnergy(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.1"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.energybattery.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsEnergy(List aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, this.mEnergyType, this.mEnergyType, this.getLocalisedInputSide(), this.getLocalisedOutputSide());
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            long tOutput = 0L;
            for (ItemStack tStack : this.getInventory()) {
                if (tStack == null || !(tStack.func_77973_b() instanceof IItemEnergy) || !((IItemEnergy)tStack.func_77973_b()).canEnergyExtraction(this.mEnergyType, tStack, this.mOutput)) continue;
                ++tOutput;
            }
            if (this.mEnergy >= this.mInput * (long)this.func_70302_i_() * 6L) {
                for (ItemStack tStack : this.getInventory()) {
                    if (tStack == null || !(tStack.func_77973_b() instanceof IItemEnergy)) continue;
                    this.mEnergy -= this.mInput * ((IItemEnergy)tStack.func_77973_b()).doEnergyInjection(this.mEnergyType, tStack, this.mInput, 1L, this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                }
            } else if (this.mEnergy <= this.mInput * (long)this.func_70302_i_() * 2L) {
                for (ItemStack tStack : this.getInventory()) {
                    if (tStack == null || !(tStack.func_77973_b() instanceof IItemEnergy)) continue;
                    this.mEnergy += this.mOutput * ((IItemEnergy)tStack.func_77973_b()).doEnergyExtraction(this.mEnergyType, tStack, this.mOutput, 1L, this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                }
            }
            boolean bl = this.mActive = this.mEnergy >= this.mOutput;
            if (this.mActive) {
                if (this.mMode != 0) {
                    tOutput = Math.min((long)this.mMode, tOutput);
                }
                if (!this.mStopped && tOutput > 0L) {
                    long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyType, this.mOutput, tOutput, this);
                    this.mEmitsEnergy = tEmittedPackets > 0L;
                    this.mEnergy -= this.mOutput * tEmittedPackets;
                }
                if (this.mTimer % 600L == 5L) {
                    this.doDefaultStructuralChecks();
                }
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        if (aTimer % 20L != 0L) {
            return super.onTickCheck(aTimer);
        }
        byte tActiveState = this.mActiveState;
        this.mActiveState = this.mEnergy < this.mOutput ? (byte)0 : (this.mEnergy >= this.mInput * (long)this.func_70302_i_() * 8L ? (byte)1 : (byte)2);
        return tActiveState != this.mActiveState || super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActiveState = aData;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (this.mEnergy >= this.mInput * (long)this.func_70302_i_() * 8L) {
            return 0L;
        }
        long tInput = Math.min(this.mInput * (long)this.func_70302_i_() * 8L - this.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.field_71071_by, this);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this);
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(this.func_70302_i_());
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aStack != null && aStack.func_77973_b() instanceof IItemEnergy;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEnergyType == this.mEnergyType;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyType;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (CS.SIDES_INVALID[aSide] || this.isInput(aSide)) && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && this.mStopped || !CS.SIDES_INVALID[aSide] && !this.isOutput(aSide) || !super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        long rAmount = 0L;
        for (ItemStack tStack : this.getInventory()) {
            if (tStack == null || !(tStack.func_77973_b() instanceof IItemEnergy)) continue;
            rAmount += ((IItemEnergy)tStack.func_77973_b()).getEnergyStored(aEnergyType, tStack);
        }
        return rAmount;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        long rAmount = 0L;
        for (ItemStack tStack : this.getInventory()) {
            if (tStack == null || !(tStack.func_77973_b() instanceof IItemEnergy)) continue;
            rAmount += ((IItemEnergy)tStack.func_77973_b()).getEnergyCapacity(aEnergyType, tStack);
        }
        return rAmount;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyType.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyType.AS_LIST;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mEnergy;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mInput * (long)this.func_70302_i_() * 8L;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mEnergy > this.mOutput;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    @Override
    public byte getStateMode() {
        return this.mMode;
    }

    @Override
    public byte getVisualData() {
        return this.mActiveState;
    }

    public boolean isInput(byte aSide) {
        return aSide != this.mFacing;
    }

    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.any.but.front");
    }

    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    static {
        LH.add("gt.tooltip.energybattery.1", "Selector Covers can set the amount of emitted Packets");
        LH.add("gt.tooltip.energybattery.2", "Mode 0 = Emit as much as possible, this is Default");
        LH.add("gt.tooltip.energybattery.3", "Mode 1 - 15 = Emit up to 1 - 15 Packets if enough Energy Storages");
    }
}

