/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.delegate;

import cpw.mods.fml.common.FMLCommonHandler;
import gregapi.data.CS;
import gregapi.random.IHasCoords;
import gregapi.random.IHasWorld;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public final class DelegatorTileEntity<T>
implements IHasWorld,
IHasCoords {
    public final T mTileEntity;
    public final int mX;
    public final int mY;
    public final int mZ;
    public final World mWorld;
    public final byte mSideOfTileEntity;

    public DelegatorTileEntity(DelegatorTileEntity<T> aDelegator) {
        this.mTileEntity = aDelegator.mTileEntity;
        this.mWorld = aDelegator.mWorld;
        this.mX = aDelegator.mX;
        this.mY = aDelegator.mY;
        this.mZ = aDelegator.mZ;
        this.mSideOfTileEntity = aDelegator.mSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, byte aSideOfTileEntity) {
        this.mTileEntity = aTileEntity;
        this.mSideOfTileEntity = aSideOfTileEntity;
        if (!(aTileEntity instanceof TileEntity)) {
            throw new IllegalArgumentException("Parameter must be an instance of TileEntity and != null");
        }
        this.mWorld = ((TileEntity)aTileEntity).func_145831_w();
        this.mX = ((TileEntity)aTileEntity).field_145851_c;
        this.mY = ((TileEntity)aTileEntity).field_145848_d;
        this.mZ = ((TileEntity)aTileEntity).field_145849_e;
    }

    public DelegatorTileEntity(T aTileEntity, DelegatorTileEntity aDelegator) {
        this.mTileEntity = aTileEntity;
        this.mWorld = aDelegator.mWorld;
        this.mX = aDelegator.mX;
        this.mY = aDelegator.mY;
        this.mZ = aDelegator.mZ;
        this.mSideOfTileEntity = aDelegator.mSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, World aWorld, int aX, int aY, int aZ, byte aSideOfTileEntity) {
        this.mTileEntity = aTileEntity;
        this.mWorld = aWorld;
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mSideOfTileEntity = aSideOfTileEntity;
    }

    public DelegatorTileEntity(T aTileEntity, World aWorld, ChunkCoordinates aCoords, byte aSideOfTileEntity) {
        this.mTileEntity = aTileEntity;
        this.mWorld = aWorld;
        this.mX = aCoords.field_71574_a;
        this.mY = aCoords.field_71572_b;
        this.mZ = aCoords.field_71573_c;
        this.mSideOfTileEntity = aSideOfTileEntity;
    }

    public ForgeDirection getForgeSideOfTileEntity() {
        return CS.FORGE_DIR[this.mSideOfTileEntity];
    }

    public Block getBlock() {
        return this.mWorld.func_147439_a(this.mX, this.mY, this.mZ);
    }

    public byte getMetaData() {
        return UT.Code.bind4(this.mWorld.func_72805_g(this.mX, this.mY, this.mZ));
    }

    public boolean setBlock(Block aBlock) {
        return this.mWorld.func_147465_d(this.mX, this.mY, this.mZ, aBlock, 0, 3);
    }

    public boolean setBlock(Block aBlock, int aMetaData) {
        return this.mWorld.func_147465_d(this.mX, this.mY, this.mZ, aBlock, (int)UT.Code.bind4(aMetaData), 3);
    }

    public boolean setBlock(Block aBlock, int aMetaData, int aFlags) {
        return this.mWorld.func_147465_d(this.mX, this.mY, this.mZ, aBlock, (int)UT.Code.bind4(aMetaData), aFlags);
    }

    public boolean setMetaData(int aMetaData) {
        return this.mWorld.func_72921_c(this.mX, this.mY, this.mZ, (int)UT.Code.bind4(aMetaData), 3);
    }

    public boolean setMetaData(int aMetaData, int aFlags) {
        return this.mWorld.func_72921_c(this.mX, this.mY, this.mZ, (int)UT.Code.bind4(aMetaData), aFlags);
    }

    public boolean equalCoords(DelegatorTileEntity aOther) {
        return aOther.mX == this.mX && aOther.mY == this.mY && aOther.mZ == this.mZ;
    }

    public boolean equalSideAndCoords(DelegatorTileEntity aOther) {
        return aOther.mSideOfTileEntity == this.mSideOfTileEntity && this.equalCoords(aOther);
    }

    public boolean equalSideWorldAndCoords(DelegatorTileEntity aOther) {
        return aOther.mWorld == this.mWorld && this.equalSideAndCoords(aOther);
    }

    public boolean equalSideTileEntityAndCoords(DelegatorTileEntity aOther) {
        return aOther.mTileEntity == this.mTileEntity && this.equalSideAndCoords(aOther);
    }

    public boolean exists() {
        return this.mTileEntity instanceof ITileEntityUnloadable ? !((ITileEntityUnloadable)this.mTileEntity).isDead() : this.mTileEntity != null && !((TileEntity)this.mTileEntity).func_145837_r() && this.mWorld != null && this.mWorld.func_72899_e(this.mX, this.mY, this.mZ);
    }

    @Override
    public World getWorld() {
        return this.mWorld;
    }

    @Override
    public int getX() {
        return this.mX;
    }

    @Override
    public int getY() {
        return this.mY;
    }

    @Override
    public int getZ() {
        return this.mZ;
    }

    @Override
    public int getOffsetX(byte aSide) {
        return this.mX + CS.OFFSETS_X[aSide];
    }

    @Override
    public int getOffsetY(byte aSide) {
        return this.mY + CS.OFFSETS_Y[aSide];
    }

    @Override
    public int getOffsetZ(byte aSide) {
        return this.mZ + CS.OFFSETS_Z[aSide];
    }

    @Override
    public int getOffsetX(byte aSide, int aMultiplier) {
        return this.mX + CS.OFFSETS_X[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetY(byte aSide, int aMultiplier) {
        return this.mY + CS.OFFSETS_Y[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZ(byte aSide, int aMultiplier) {
        return this.mZ + CS.OFFSETS_Z[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetXN(byte aSide) {
        return this.mX - CS.OFFSETS_X[aSide];
    }

    @Override
    public int getOffsetYN(byte aSide) {
        return this.mY - CS.OFFSETS_Y[aSide];
    }

    @Override
    public int getOffsetZN(byte aSide) {
        return this.mZ - CS.OFFSETS_Z[aSide];
    }

    @Override
    public int getOffsetXN(byte aSide, int aMultiplier) {
        return this.mX - CS.OFFSETS_X[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetYN(byte aSide, int aMultiplier) {
        return this.mY - CS.OFFSETS_Y[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZN(byte aSide, int aMultiplier) {
        return this.mZ - CS.OFFSETS_Z[aSide] * aMultiplier;
    }

    @Override
    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates(this.mX, this.mY, this.mZ);
    }

    @Override
    public ChunkCoordinates getOffset(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetX(aSide, aMultiplier), this.getOffsetY(aSide, aMultiplier), this.getOffsetZ(aSide, aMultiplier));
    }

    @Override
    public ChunkCoordinates getOffsetN(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetXN(aSide, aMultiplier), this.getOffsetYN(aSide, aMultiplier), this.getOffsetZN(aSide, aMultiplier));
    }

    @Override
    public boolean isServerSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isServer() : !this.mWorld.field_72995_K;
    }

    @Override
    public boolean isClientSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : this.mWorld.field_72995_K;
    }

    @Override
    public int getRandomNumber(int aRange) {
        return (this.mWorld == null ? CS.RANDOM : this.mWorld.field_73012_v).nextInt(aRange);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.mWorld == null ? null : this.mWorld.func_147438_o(aX, aY, aZ);
    }

    @Override
    public Block getBlock(int aX, int aY, int aZ) {
        return this.mWorld == null ? CS.NB : this.mWorld.func_147439_a(aX, aY, aZ);
    }

    @Override
    public byte getMetaData(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.func_72805_g(aX, aY, aZ));
    }

    @Override
    public byte getLightLevel(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.func_72801_o(aX, aY, aZ) * 15L);
    }

    @Override
    public boolean getOpacity(int aX, int aY, int aZ) {
        return this.mWorld != null && this.mWorld.func_147439_a(aX, aY, aZ).func_149662_c();
    }

    @Override
    public boolean getSky(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_72937_j(aX, aY, aZ);
    }

    @Override
    public boolean getRain(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_72874_g(aX, aZ) <= aY;
    }

    @Override
    public boolean getAir(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)this.mWorld, aX, aY, aZ);
    }

    @Override
    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.mWorld == null ? null : this.mWorld.func_72807_a(aX, aZ);
    }

    @Override
    public TileEntity getTileEntity(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.func_147438_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public Block getBlock(ChunkCoordinates aCoords) {
        return this.mWorld == null ? CS.NB : this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public byte getMetaData(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c));
    }

    @Override
    public byte getLightLevel(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.func_72801_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) * 15L);
    }

    @Override
    public boolean getOpacity(ChunkCoordinates aCoords) {
        return this.mWorld != null && this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).func_149662_c();
    }

    @Override
    public boolean getSky(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_72937_j(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public boolean getRain(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_72874_g(aCoords.field_71574_a, aCoords.field_71573_c) <= aCoords.field_71572_b;
    }

    @Override
    public boolean getAir(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).isAir((IBlockAccess)this.mWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public BiomeGenBase getBiome(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.func_72807_a(aCoords.field_71574_a, aCoords.field_71573_c);
    }
}

