/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.connectors.TileEntityBase09Connector;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public abstract class TileEntityBase10ConnectorRendered
extends TileEntityBase09Connector
implements ITileEntityFoamable {
    public float mDiameter = 1.0f;
    public boolean mTransparent = false;
    public boolean mIsGlowing = false;
    public boolean mContactDamage = false;
    public boolean mFoam = false;
    public boolean mFoamDried = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.diameter")) {
            this.mDiameter = Math.max(CS.PIXELS_POS[2], Math.min(CS.PIXELS_NEG[0], (float)aNBT.func_74769_h("gt.diameter")));
        }
        if (aNBT.func_74764_b("gt.transparent")) {
            this.mTransparent = aNBT.func_74767_n("gt.transparent");
        }
        if (aNBT.func_74764_b("gt.contactdamage")) {
            this.mContactDamage = aNBT.func_74767_n("gt.contactdamage");
        }
        if (aNBT.func_74764_b("gt.foamdried")) {
            this.mFoamDried = aNBT.func_74767_n("gt.foamdried");
        }
        if (aNBT.func_74764_b("gt.foamed")) {
            this.mFoam = aNBT.func_74767_n("gt.foamed");
        }
        this.mIsGlowing = this.mMaterial.contains(TD.Properties.GLOWING);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamed", this.mFoam);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        super.writeItemNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamed", this.mFoam);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        return aNBT;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer >= 100L && this.getRandomNumber(5900) == 0) {
            this.dryFoam((byte)6);
        }
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        if (this.field_145850_b == null) {
            this.mConnections = (byte)(CS.SBIT[3] | CS.SBIT[2]);
        }
        return this.mFoamDried || this.mDiameter >= 1.0f ? 1 : (this.mFoam ? 8 : (this.mConnections == 0 ? 1 : 7));
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            if (this.mFoamDried || this.mDiameter >= 1.0f) {
                return false;
            }
            aBlock.func_149676_a((1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f);
            return true;
        }
        if (aRenderPass <= 6) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity((byte)(aRenderPass - 1), false, false);
            float tDiameter = this.getConnectorDiameter((byte)(aRenderPass - 1), tDelegator);
            float tLength = this.getConnectorLength((byte)(aRenderPass - 1), tDelegator);
            switch (aRenderPass - 1) {
                case 4: {
                    aBlock.func_149676_a(0.0f - tLength, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 0: {
                    aBlock.func_149676_a((1.0f - tDiameter) / 2.0f, 0.0f - tLength, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a((1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 0.0f - tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 1: {
                    aBlock.func_149676_a((1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a((1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 7) {
            return aShouldSideBeRendered[aSide] ? this.getTextureCFoam(aSide, this.mConnections, this.mDiameter, aRenderPass) : null;
        }
        if (aRenderPass == 0) {
            return this.mFoamDried ? (aShouldSideBeRendered[aSide] ? this.getTextureCFoamDry(aSide, this.mConnections, this.mDiameter, aRenderPass) : null) : (this.mConnections == 0 || this.mDiameter >= 1.0f && this.connected(aSide) ? this.getTextureConnected(aSide, this.mConnections, this.mDiameter, aRenderPass) : this.getTextureSide(aSide, this.mConnections, this.mDiameter, aRenderPass));
        }
        return aSide == CS.OPPOSITES[aRenderPass - 1] ? null : (aSide == aRenderPass - 1 ? (aShouldSideBeRendered[aSide] ? this.getTextureConnected(aSide, this.mConnections, this.mDiameter, aRenderPass) : null) : this.getTextureSide(aSide, this.mConnections, this.mDiameter, aRenderPass));
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 0 || aRenderPass == 7 || this.connected((byte)(aRenderPass - 1));
    }

    @Override
    public int getLightOpacity() {
        return this.mFoamDried ? 255 : (this.mTransparent ? (this.mDiameter >= 1.0f ? 3 : (this.mDiameter > 0.5f ? 1 : 0)) : (this.mDiameter >= 1.0f ? 255 : (this.mDiameter > 0.5f ? 3 : 1)));
    }

    @Override
    public boolean applyFoam(byte aSide, short[] aCFoamRGB, byte aVanillaColor) {
        if (this.mDiameter >= 1.0f || this.mFoam || this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoam = true;
        this.mFoamDried = false;
        this.mIsPainted = true;
        this.mRGBa = UT.Code.getRGBInt(aCFoamRGB);
        this.updateClientData();
        return true;
    }

    @Override
    public boolean dryFoam(byte aSide) {
        if (!this.mFoam || this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoam = true;
        this.mFoamDried = true;
        this.updateClientData();
        return true;
    }

    @Override
    public boolean removeFoam(byte aSide) {
        if (!this.mFoam || !this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoam = false;
        this.mFoamDried = false;
        this.unpaint();
        this.updateClientData();
        return true;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return Math.max(this.mFoam && this.mFoamDried ? 24.0f : 0.0f, super.getExplosionResistance(aExploder, aExplosionX, aExplosionY, aExplosionZ));
    }

    @Override
    public byte getDirectionData() {
        return (byte)((byte)(this.mConnections & 0x3F) | (byte)(this.mFoam ? 64 : 0) | (byte)(this.mFoamDried ? 128 : 0));
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mConnections = (byte)(aData & 0x3F);
        this.mFoam = (aData & 0x40) != 0;
        this.mFoamDried = (aData & 0xFFFFFF80) != 0;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return this.mFoamDried ? 1.0f : this.mDiameter;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return this.mDiameter;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return this.mFoamDried || this.connected(aSide) ? 0.0f : (1.0f - this.mDiameter) / 2.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f && !this.mTransparent;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f;
    }

    @Override
    public boolean usePipePlacementMode(byte aSide) {
        return true;
    }

    @Override
    public boolean hasFoam(byte aSide) {
        return this.mFoam;
    }

    @Override
    public boolean driedFoam(byte aSide) {
        return this.mFoam && this.mFoamDried;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return this.mDiameter >= 1.0f || this.mFoamDried;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.mContactDamage && !this.mFoamDried ? AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[2]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[2]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2])) : super.getCollisionBoundingBoxFromPool();
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List aList, Entity aEntity) {
        if (!this.addDefaultCollisionBoxToList()) {
            DelegatorTileEntity<TileEntity> tDelegator;
            float tDiameter;
            float tLength;
            AxisAlignedBB tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (1.0f - this.mDiameter) / 2.0f), (double)((float)this.field_145848_d + (1.0f - this.mDiameter) / 2.0f), (double)((float)this.field_145849_e + (1.0f - this.mDiameter) / 2.0f), (double)((float)(this.field_145851_c + 1) - (1.0f - this.mDiameter) / 2.0f), (double)((float)(this.field_145848_d + 1) - (1.0f - this.mDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) - (1.0f - this.mDiameter) / 2.0f));
            if (aAABB.func_72326_a(tBox)) {
                aList.add(tBox);
            }
            byte tSide = 4;
            if (this.connected((byte)4) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)(this.field_145851_c + 0) - (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f)), (double)((float)this.field_145848_d + (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)this.field_145849_e + (1.0f - tDiameter) / 2.0f), (double)((float)this.field_145851_c + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145848_d + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) - (1.0f - tDiameter) / 2.0f)))) {
                aList.add(tBox);
            }
            tSide = 0;
            if (this.connected((byte)0) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)(this.field_145848_d + 0) - (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f)), (double)((float)this.field_145849_e + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145851_c + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)this.field_145848_d + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) - (1.0f - tDiameter) / 2.0f)))) {
                aList.add(tBox);
            }
            tSide = 2;
            if (this.connected((byte)2) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)this.field_145848_d + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 0) - (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f)), (double)((float)(this.field_145851_c + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145848_d + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)this.field_145849_e + (1.0f - tDiameter) / 2.0f)))) {
                aList.add(tBox);
            }
            tSide = 5;
            if (this.connected((byte)5) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)(this.field_145851_c + 1) - (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)this.field_145848_d + (1.0f - tDiameter) / 2.0f), (double)((float)this.field_145849_e + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145851_c + 1) + (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f)), (double)((float)(this.field_145848_d + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) - (1.0f - tDiameter) / 2.0f)))) {
                aList.add(tBox);
            }
            tSide = 1;
            if (this.connected((byte)1) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)(this.field_145848_d + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)this.field_145849_e + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145851_c + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145848_d + 1) + (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f)), (double)((float)(this.field_145849_e + 1) - (1.0f - tDiameter) / 2.0f)))) {
                aList.add(tBox);
            }
            tSide = 3;
            if (this.connected((byte)3) && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (1.0f - (tDiameter = this.getConnectorDiameter(tSide, tDelegator = this.getAdjacentTileEntity(tSide, false, false)))) / 2.0f), (double)((float)this.field_145848_d + (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145851_c + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145848_d + 1) - (1.0f - tDiameter) / 2.0f), (double)((float)(this.field_145849_e + 1) + (tLength = this.mContactDamage ? -CS.PIXELS_POS[2] : 0.0f))))) {
                aList.add(tBox);
            }
        }
    }

    public float getConnectorLength(byte aConnectorSide, DelegatorTileEntity<TileEntity> aDelegator) {
        float rLength;
        float f = rLength = this.mDiameter != 1.0f && this.hasCovers() && this.mCovers.mBehaviours[aConnectorSide] != null ? 0.001f : 0.0f;
        if (aDelegator.mTileEntity instanceof ITileEntitySurface) {
            return Math.max(rLength, ((ITileEntitySurface)aDelegator.mTileEntity).getSurfaceDistance(aDelegator.mSideOfTileEntity));
        }
        return rLength;
    }

    public float getConnectorDiameter(byte aConnectorSide, DelegatorTileEntity<TileEntity> aDelegator) {
        float rDiameter = this.mDiameter;
        if (aDelegator.mTileEntity instanceof ITileEntitySurface) {
            rDiameter = ((ITileEntitySurface)aDelegator.mTileEntity).getSurfaceSizeAttachable(aDelegator.mSideOfTileEntity);
        }
        if (rDiameter <= 0.0f || rDiameter > this.mDiameter) {
            rDiameter = this.mDiameter;
        } else if (rDiameter < CS.PIXELS_POS[2]) {
            rDiameter = CS.PIXELS_POS[2];
        }
        return rDiameter;
    }

    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
    }

    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
    }

    public ITexture getTextureCFoam(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.CFOAM_FRESH, this.mRGBa);
    }

    public ITexture getTextureCFoamDry(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.CFOAM_HARDENED, this.mRGBa);
    }

    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return CS.IconsGT.INDEX_BLOCK_PIPE_SIDE;
    }

    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return aDiameter < 0.37f ? OP.pipeTiny.mIconIndexBlock : (aDiameter < 0.49f ? OP.pipeSmall.mIconIndexBlock : (aDiameter < 0.74f ? OP.pipeMedium.mIconIndexBlock : (aDiameter < 0.99f ? OP.pipeLarge.mIconIndexBlock : OP.pipeHuge.mIconIndexBlock)));
    }
}

