/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase08Directional;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityBase09Connector
extends TileEntityBase08Directional
implements ITileEntityConnector,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_AddToolTips {
    protected byte mConnections = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.connection")) {
            this.mConnections = (byte)(aNBT.func_74771_c("gt.connection") & 0x3F);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.connection", this.mConnections);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.connection.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.connection.post"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals(this.getFacingTool())) {
            byte aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            return (this.connected(aTargetSide) ? this.disconnect(aTargetSide, true) : this.connect(aTargetSide, true)) ? 10000L : 0L;
        }
        return 0L;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            aSide = CS.OPPOSITES[aSide];
            this.connect(aSide, true);
            for (byte tSide : CS.ALL_SIDES_VALID_BUT[aSide]) {
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityConnector) || !CS.SIDES_VALID[tDelegator.mSideOfTileEntity] || !UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(tSide)) || !((ITileEntityConnector)tDelegator.mTileEntity).connected(tDelegator.mSideOfTileEntity)) continue;
                this.connect(tSide, true);
            }
        }
        return true;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mConnections & 0x3F);
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mConnections = (byte)(aData & 0x3F);
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short aSide) {
        if (this.isClientSide()) {
            return;
        }
        if (this.connected((byte)aSide)) {
            this.disconnect((byte)aSide, true);
        } else {
            this.connect((byte)aSide, true);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer aPlayer, int aSide) {
        return this.getFacingTool().equals("wrench");
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public boolean connected(byte aSide) {
        return CS.FACE_CONNECTED[aSide][this.mConnections];
    }

    @Override
    public boolean connect(byte aSide, boolean aNotify) {
        if (CS.SIDES_INVALID[aSide]) {
            return this.connected(aSide);
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        if (tDelegator.mTileEntity instanceof ITileEntityConnector) {
            if (CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(aSide))) {
                byte oConnections = this.mConnections;
                this.mConnections = (byte)(this.mConnections | CS.SBIT[aSide]);
                this.updateClientData();
                this.causeBlockUpdate();
                this.onConnectionChange(oConnections);
                this.checkCoverValidity();
                this.doEnetUpdate();
                if (aNotify) {
                    ((ITileEntityConnector)tDelegator.mTileEntity).connect(tDelegator.mSideOfTileEntity, false);
                }
                if (this.hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this.getWorld(), this.getCoords(), this.getBlock(this.getCoords()), this.getMetaData(this.getCoords()), false);
                }
                return true;
            }
        } else if (UT.Worlds.isAir(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ) || this.canConnect(aSide, tDelegator)) {
            byte oConnections = this.mConnections;
            this.mConnections = (byte)(this.mConnections | CS.SBIT[aSide]);
            this.updateClientData();
            this.causeBlockUpdate();
            this.onConnectionChange(oConnections);
            this.checkCoverValidity();
            this.doEnetUpdate();
            if (this.hasMultiBlockMachineRelevantData()) {
                ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this.getWorld(), this.getCoords(), this.getBlock(this.getCoords()), this.getMetaData(this.getCoords()), false);
            }
            return true;
        }
        return this.connected(aSide);
    }

    @Override
    public boolean disconnect(byte aSide, boolean aNotify) {
        if (CS.SIDES_INVALID[aSide]) {
            return !this.connected(aSide);
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        byte oConnections = this.mConnections;
        this.mConnections = (byte)(this.mConnections & ~CS.SBIT[aSide]);
        this.updateClientData();
        this.causeBlockUpdate();
        this.onConnectionChange(oConnections);
        this.checkCoverValidity();
        this.doEnetUpdate();
        if (this.hasMultiBlockMachineRelevantData()) {
            ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this.getWorld(), this.getCoords(), this.getBlock(this.getCoords()), this.getMetaData(this.getCoords()), false);
        }
        if (aNotify && tDelegator.mTileEntity instanceof ITileEntityConnector && CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(aSide))) {
            ((ITileEntityConnector)tDelegator.mTileEntity).disconnect(tDelegator.mSideOfTileEntity, false);
        }
        return true;
    }

    public void onConnectionChange(byte aPreviousConnections) {
    }

    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return false;
    }
}

