/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.connectors.ITileEntityRedstoneWire;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class MultiTileEntityWireRedstone
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
ITileEntityRedstoneWire,
ITileEntityProgress,
ITileEntitySwitchableMode,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_GetLightValue {
    public static final int REDSTONE_ID = -1;
    public long mRedstone = 0L;
    public long mLoss = 1L;
    public byte mRenderType = 0;
    public byte mReceived = (byte)6;
    public byte mState = 0;
    public byte mMode = 0;
    public boolean mConnectedToNonWire = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mreceived")) {
            this.mReceived = aNBT.func_74771_c("gt.mreceived");
        }
        if (aNBT.func_74764_b("gt.mredstone")) {
            this.mRedstone = aNBT.func_74771_c("gt.mredstone");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.pipeloss")) {
            this.mLoss = Math.max(1L, aNBT.func_74763_f("gt.pipeloss"));
        }
        if (aNBT.func_74764_b("gt.piperender")) {
            this.mRenderType = aNBT.func_74771_c("gt.piperender");
        }
        if (aNBT.func_74764_b("gt.state")) {
            this.mState = aNBT.func_74771_c("gt.state");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        if (this.mState != 0) {
            aNBT.func_74774_a("gt.state", this.mState);
        }
        aNBT.func_74774_a("gt.mreceived", this.mReceived);
        UT.NBT.setNumber(aNBT, "gt.mredstone", this.mRedstone);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.range") + Integer.MAX_VALUE / this.mLoss);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.bandwidth") + 1);
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        this.updateConnectionStatus();
    }

    @Override
    public void onConnectionChange(byte aPreviousConnections) {
        super.onConnectionChange(aPreviousConnections);
        this.updateConnectionStatus();
        if (this.updateRedstone(-1)) {
            ITileEntityRedstoneWire.Util.doRedstoneUpdate(this, -1);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mBlockUpdated) {
                this.updateConnectionStatus();
            }
            if (this.updateRedstone(-1)) {
                ITileEntityRedstoneWire.Util.doRedstoneUpdate(this, -1);
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        byte tOldState = this.mState;
        this.mState = UT.Code.bind4(this.mRedstone / Integer.MAX_VALUE);
        if (tOldState != this.mState) {
            if (this.mIsGlowing) {
                this.updateLightValue();
            }
            return true;
        }
        return super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        if (aData != this.mState) {
            this.mState = aData;
            if (this.mIsGlowing) {
                this.updateLightValue();
            }
        }
    }

    @Override
    public byte getVisualData() {
        return this.mState;
    }

    @Override
    public int getLightOpacity() {
        return this.mIsGlowing ? 0 : super.getLightOpacity();
    }

    public long getRedstoneAtSide(byte aSide) {
        if (CS.SIDES_INVALID[aSide]) {
            return 0L;
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        return tDelegator.mTileEntity instanceof ITileEntityRedstoneWire ? (this.canAcceptRedstoneFromWire(aSide, -1) && ((ITileEntityRedstoneWire)tDelegator.mTileEntity).canEmitRedstoneToWire(tDelegator.mSideOfTileEntity, -1) ? ((ITileEntityRedstoneWire)tDelegator.mTileEntity).getRedstoneMinusLoss(tDelegator.mSideOfTileEntity, -1) : 0L) : (this.canAcceptRedstoneFromVanilla(aSide) ? Integer.MAX_VALUE * (long)this.getRedstoneIncoming(aSide) - this.mLoss : 0L);
    }

    @Override
    public boolean updateRedstone(int aRedstoneID) {
        if (aRedstoneID != -1) {
            return false;
        }
        long tRedstoneOld = this.mRedstone;
        long tRedstone = (long)this.mMode * Integer.MAX_VALUE - this.mLoss;
        byte tReceivedOld = this.mReceived;
        this.mRedstone = this.getRedstoneAtSide(tReceivedOld);
        if (this.mRedstone <= tRedstone) {
            this.mRedstone = tRedstone;
            this.mReceived = (byte)6;
        }
        for (byte tSide : CS.ALL_SIDES_VALID_BUT[tReceivedOld]) {
            tRedstone = this.getRedstoneAtSide(tSide);
            if (tRedstone <= this.mRedstone) continue;
            this.mRedstone = tRedstone;
            this.mReceived = tSide;
        }
        if (this.mRedstone != tRedstoneOld) {
            if (this.mConnectedToNonWire) {
                this.causeBlockUpdate();
            }
            return true;
        }
        return false;
    }

    public void updateConnectionStatus() {
        this.mConnectedToNonWire = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!this.canAcceptRedstoneFromVanilla(tSide) || this.getAdjacentTileEntity((byte)tSide).mTileEntity instanceof ITileEntityRedstoneWire) continue;
            this.mConnectedToNonWire = true;
        }
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        if (!this.canEmitRedstoneToVanilla(aSide = CS.OPPOSITES[aSide]) || this.mRedstone <= 0L) {
            return 0;
        }
        Block tBlock = this.getBlockAtSide(aSide);
        return UT.Code.bind4(UT.Code.divup(this.mRedstone, Integer.MAX_VALUE) - (long)(tBlock instanceof BlockRedstoneWire || tBlock.isNormalCube((IBlockAccess)this.field_145850_b, this.field_145851_c + CS.OFFSETS_X[aSide], this.field_145848_d + CS.OFFSETS_Y[aSide], this.field_145849_e + CS.OFFSETS_Z[aSide]) ? 1 : 0));
    }

    @Override
    public byte isProvidingStrongPower2(byte aSide) {
        if (!this.canEmitRedstoneToVanilla(aSide = CS.OPPOSITES[aSide]) || this.mRedstone <= 0L) {
            return 0;
        }
        Block tBlock = this.getBlockAtSide(aSide);
        return UT.Code.bind4(UT.Code.divup(this.mRedstone, Integer.MAX_VALUE) - (long)(tBlock instanceof BlockRedstoneWire || tBlock.isNormalCube((IBlockAccess)this.field_145850_b, this.field_145851_c + CS.OFFSETS_X[aSide], this.field_145848_d + CS.OFFSETS_Y[aSide], this.field_145849_e + CS.OFFSETS_Z[aSide]) ? 1 : 0));
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return UT.Code.bind4(this.mRedstone / Integer.MAX_VALUE);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    public boolean canEmitRedstoneToVanilla(byte aSide) {
        return aSide != this.mReceived && this.connected(aSide) && !(this.getAdjacentTileEntity((byte)aSide).mTileEntity instanceof ITileEntityRedstoneWire);
    }

    public boolean canAcceptRedstoneFromVanilla(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public boolean canEmitRedstoneToWire(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 && this.connected(aSide);
    }

    @Override
    public boolean canAcceptRedstoneFromWire(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 && this.connected(aSide);
    }

    @Override
    public long getRedstoneLoss(int aRedstoneID) {
        return aRedstoneID == -1 ? this.mLoss : Integer.MAX_VALUE;
    }

    @Override
    public long getRedstoneValue(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 ? this.mRedstone : 0L;
    }

    @Override
    public long getRedstoneMinusLoss(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 ? this.mRedstone - this.mLoss : 0L;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return true;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return 1000L * this.mRedstone / Integer.MAX_VALUE;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return 16000L;
    }

    @Override
    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    @Override
    public byte getStateMode() {
        return this.mMode;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mState > 0, this.mRGBa);
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mState > 0, this.mRGBa);
    }

    @Override
    public ITexture getTextureCFoam(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(Textures.BlockIcons.CFOAM_FRESH, this.mRGBa, this.mState > 0);
    }

    @Override
    public ITexture getTextureCFoamDry(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(Textures.BlockIcons.CFOAM_HARDENED, this.mRGBa, this.mState > 0);
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.WIRE_REDSTONE.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "cutter";
    }

    @Override
    public int getLightValue() {
        return this.mIsGlowing ? this.mState : (byte)0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.redstone";
    }
}

