/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.GT_API_Proxy;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.GT_ModHandler;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityServerTickPre;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityPipeFluid
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
IFluidHandler,
ITileEntityGibbl,
ITileEntityTemperature,
ITileEntityProgress,
ITileEntityServerTickPre,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    private static double HEAT_RESISTANCE_BONUS = 1.25;
    public byte mLastReceivedFrom = 0;
    public byte mRenderType = 0;
    public long mTemperature = 293L;
    public long mTransferredAmount = 0L;
    public int mCapacity = 1000;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public FluidTank[] mTanks = CS.ZL_FLUIDTANK;

    public static void addFluidPipes(int aID, int aCreativeTabID, long aStat, boolean aGasProof, boolean aAcidProof, boolean aContactDamage, boolean aRecipe, MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aBlock, Class aClass, OreDictMaterial aMat) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object[] objectArray4;
        Object[] objectArray5;
        String string = "Tiny " + aMat.getLocal() + " Fluid Pipe";
        byte by = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound = UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[4]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray6 = new Object[4];
            objectArray6[0] = "sP ";
            objectArray6[1] = "wzh";
            objectArray6[2] = Character.valueOf('P');
            objectArray5 = objectArray6;
            objectArray6[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray5 = CS.ZL_OBJECT;
        }
        OM.reg_(OP.pipeTiny, aMat, aRegistry.add(string, "Fluid Pipes", aID, aCreativeTabID, aClass, by, 64, aBlock, nBTTagCompound, objectArray5));
        String string2 = "Small " + aMat.getLocal() + " Fluid Pipe";
        byte by2 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound2 = UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[6]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 2L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray7 = new Object[4];
            objectArray7[0] = " P ";
            objectArray7[1] = "wzh";
            objectArray7[2] = Character.valueOf('P');
            objectArray4 = objectArray7;
            objectArray7[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray4 = CS.ZL_OBJECT;
        }
        OM.reg_(OP.pipeSmall, aMat, aRegistry.add(string2, "Fluid Pipes", aID + 1, aCreativeTabID, aClass, by2, 64, aBlock, nBTTagCompound2, objectArray4));
        String string3 = aMat.getLocal() + " Fluid Pipe";
        byte by3 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound3 = UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[8]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 6L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray8 = new Object[4];
            objectArray8[0] = "PPP";
            objectArray8[1] = "wzh";
            objectArray8[2] = Character.valueOf('P');
            objectArray3 = objectArray8;
            objectArray8[3] = OP.plateCurved.dat(aMat);
        } else {
            objectArray3 = CS.ZL_OBJECT;
        }
        OM.reg_(OP.pipeMedium, aMat, aRegistry.add(string3, "Fluid Pipes", aID + 2, aCreativeTabID, aClass, by3, 32, aBlock, nBTTagCompound3, objectArray3));
        String string4 = "Large " + aMat.getLocal() + " Fluid Pipe";
        byte by4 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound4 = UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[12]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 12L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray9 = new Object[5];
            objectArray9[0] = "PPP";
            objectArray9[1] = "wzh";
            objectArray9[2] = "PPP";
            objectArray9[3] = Character.valueOf('P');
            objectArray2 = objectArray9;
            objectArray9[4] = OP.plateCurved.dat(aMat);
        } else {
            objectArray2 = CS.ZL_OBJECT;
        }
        OM.reg_(OP.pipeLarge, aMat, aRegistry.add(string4, "Fluid Pipes", aID + 3, aCreativeTabID, aClass, by4, 16, aBlock, nBTTagCompound4, objectArray2));
        String string5 = "Huge " + aMat.getLocal() + " Fluid Pipe";
        byte by5 = aMat.mToolQuality;
        NBTTagCompound nBTTagCompound5 = UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 24L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 1);
        if (aRecipe) {
            Object[] objectArray10 = new Object[5];
            objectArray10[0] = "PPP";
            objectArray10[1] = "wzh";
            objectArray10[2] = "PPP";
            objectArray10[3] = Character.valueOf('P');
            objectArray = objectArray10;
            objectArray10[4] = OP.plateDouble.dat(aMat);
        } else {
            objectArray = CS.ZL_OBJECT;
        }
        OM.reg_(OP.pipeHuge, aMat, aRegistry.add(string5, "Fluid Pipes", aID + 4, aCreativeTabID, aClass, by5, 16, aBlock, nBTTagCompound5, objectArray));
        OM.reg_(OP.pipeQuadruple, aMat, aRegistry.add("Quadruple " + aMat.getLocal() + " Fluid Pipe", "Fluid Pipes", aID + 5, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 6L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 4), "PP", "PP", Character.valueOf('P'), OP.pipeMedium.dat(aMat)));
        OM.reg_(OP.pipeNonuple, aMat, aRegistry.add("Nonuple " + aMat.getLocal() + " Fluid Pipe", "Fluid Pipes", aID + 6, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.getNBTs(null, "gt.material", aMat, "gt.hardness", Float.valueOf(6.0f), "gt.resistance", Float.valueOf(6.0f), "gt.color", UT.Code.getRGBInt(aMat.mRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PIXELS_POS[16]), "gt.contactdamage", aContactDamage, "gt.tankcap", aStat * 2L, "gt.gasproof", aGasProof, "gt.acidproof", aAcidProof, "gt.tankcount", 9), "PPP", "PPP", "PPP", Character.valueOf('P'), OP.pipeSmall.dat(aMat)));
        GT_ModHandler.addShapelessCraftingRecipe(aRegistry.getItem(aID + 2, 4L), GT_ModHandler.RecipeBits.DEFAULT_NCC, new Object[]{aRegistry.getItem(aID + 5)});
        GT_ModHandler.addShapelessCraftingRecipe(aRegistry.getItem(aID + 1, 9L), GT_ModHandler.RecipeBits.DEFAULT_NCC, new Object[]{aRegistry.getItem(aID + 6)});
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mlast")) {
            this.mLastReceivedFrom = aNBT.func_74771_c("gt.mlast");
        }
        if (aNBT.func_74764_b("gt.mtransfer")) {
            this.mTransferredAmount = aNBT.func_74763_f("gt.mtransfer");
        }
        if (aNBT.func_74764_b("gt.piperender")) {
            this.mRenderType = aNBT.func_74771_c("gt.piperender");
        }
        if (aNBT.func_74764_b("gt.gasproof")) {
            this.mGasProof = aNBT.func_74767_n("gt.gasproof");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        if (aNBT.func_74764_b("gt.tankcap")) {
            this.mCapacity = aNBT.func_74762_e("gt.tankcap") * 2;
        }
        if (aNBT.func_74764_b("gt.tankcount")) {
            this.mTanks = new FluidTank[aNBT.func_74762_e("gt.tankcount")];
            for (i = 0; i < this.mTanks.length; ++i) {
                this.mTanks[i] = new FluidTank(this.mCapacity);
            }
        } else {
            this.mTanks = new FluidTank[]{new FluidTank(this.mCapacity)};
        }
        if (aNBT.func_74764_b("gt.tank")) {
            this.mTanks[0].readFromNBT(aNBT.func_74775_l("gt.tank"));
        } else {
            for (i = 0; i < this.mTanks.length; ++i) {
                this.mTanks[i].readFromNBT(aNBT.func_74775_l("gt.tank." + i));
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.mlast", this.mLastReceivedFrom);
        for (int i = 0; i < this.mTanks.length; ++i) {
            if (this.mTanks[i] == null) continue;
            aNBT.func_74782_a("gt.tank." + i, (NBTBase)this.mTanks[i].writeToNBT(new NBTTagCompound()));
        }
        UT.NBT.setNumber(aNBT, "gt.mtransfer", this.mTransferredAmount);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.bandwidth") + this.mCapacity / 4 + " L/t");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.capacity") + this.mCapacity + " L");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getTemperatureMax((byte)6) + " K)");
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mContactDamage) {
            aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide) {
            GT_API_Proxy.SERVER_TICK_PRE.add(this);
        }
    }

    @Override
    public void onServerTickPre() {
        if (CS.SERVER_TIME % 2L == 0L != UT.Worlds.areCoordsEven(this)) {
            this.mTransferredAmount = 0L;
            for (FluidTank tTank : this.mTanks) {
                FluidStack tFluid = tTank.getFluid();
                if (tFluid != null && tFluid.amount > 0) {
                    block18: {
                        this.mTemperature = UT.Fluids.temperature(tFluid);
                        if (!this.mGasProof && UT.Fluids.gas(tFluid)) {
                            this.mTransferredAmount += (long)Math.min(8, tTank.getFluidAmount());
                            tTank.drain(8, true);
                            UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.getCoords());
                            try {
                                for (Entity tEntity : (ArrayList)this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3)))) {
                                    UT.Entities.applyTemperatureDamage(tEntity, this.mTemperature, 2.0f);
                                }
                            }
                            catch (Throwable e) {
                                if (!CS.D1) break block18;
                                e.printStackTrace(CS.ERR);
                            }
                        }
                    }
                    if (!this.mAcidProof && UT.Fluids.acid(tFluid)) {
                        block19: {
                            this.mTransferredAmount += (long)Math.min(16, tTank.getFluidAmount());
                            tTank.drain(16, true);
                            UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 0.5f, this.getCoords());
                            try {
                                for (Entity tEntity : (ArrayList)this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2)))) {
                                    UT.Entities.applyChemDamage(tEntity, 2.0f);
                                }
                            }
                            catch (Throwable e) {
                                if (!CS.D1) break block19;
                                e.printStackTrace(CS.ERR);
                            }
                        }
                        if (this.getRandomNumber(100) == 0) {
                            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            return;
                        }
                    }
                } else {
                    long tEnvTemp = UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (this.mTemperature < tEnvTemp) {
                        ++this.mTemperature;
                    } else if (this.mTemperature > tEnvTemp) {
                        --this.mTemperature;
                    }
                }
                if (this.mTemperature > this.getTemperatureMax((byte)6)) {
                    this.setOnFire();
                    if (this.getRandomNumber(100) == 0) {
                        this.setToFire();
                        return;
                    }
                }
                this.distribute(CS.ALL_SIDES_VALID, tTank);
            }
            this.mLastReceivedFrom = 0;
        }
    }

    public void distribute(byte[] aSides, FluidTank aTank) {
        int tDrained;
        DelegatorTileEntity tTank;
        ArrayListNoNulls<DelegatorTileEntity> tAdjacentTanks = new ArrayListNoNulls<DelegatorTileEntity>();
        ArrayListNoNulls<DelegatorTileEntity> tAdjacentPipes = new ArrayListNoNulls<DelegatorTileEntity>();
        long tAmount = aTank.getFluidAmount();
        if (tAmount <= 0L) {
            return;
        }
        int tPipeCount = 1;
        for (byte aSide : aSides) {
            byte tMeta;
            if (!this.canEmitFluidsTo(aSide) || CS.FACE_CONNECTED[aSide][this.mLastReceivedFrom] || this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aTank.getFluid())) continue;
            tTank = this.getAdjacentTank(aSide);
            if (tTank.mTileEntity != null) {
                if (tTank.mTileEntity instanceof MultiTileEntityPipeFluid) {
                    IFluidTank tTarget = ((MultiTileEntityPipeFluid)tTank.mTileEntity).getFluidTankFillable2(tTank.mSideOfTileEntity, aTank.getFluid());
                    if (tTarget == null || tTarget.getFluidAmount() >= aTank.getFluidAmount()) continue;
                    tAmount += (long)tTarget.getFluidAmount();
                    tPipeCount = (byte)(tPipeCount + 1);
                    tAdjacentTanks.add(tTank);
                    continue;
                }
                if (((IFluidHandler)tTank.mTileEntity).fill(tTank.getForgeSideOfTileEntity(), aTank.getFluid(), false) <= 0) continue;
                tAdjacentTanks.add(tTank);
                continue;
            }
            if (!(tTank.getBlock() instanceof BlockCauldron) || (tMeta = tTank.getMetaData()) >= 3 || !UT.Fluids.water(aTank.getFluid()) || aTank.getFluidAmount() < 334) continue;
            aTank.drain(334, true);
            tTank.setMetaData((byte)(tMeta + 1));
        }
        if (tAmount % (long)tPipeCount == 0L) {
            tAmount /= (long)tPipeCount;
        } else {
            tAmount /= (long)tPipeCount;
            ++tAmount;
        }
        if (tAmount > 0L) {
            int i = tAdjacentTanks.size();
            while (i > 0 && aTank.getFluidAmount() > 0) {
                tTank = (DelegatorTileEntity)tAdjacentTanks.get(--i);
                if (!(tTank.mTileEntity instanceof MultiTileEntityPipeFluid)) continue;
                tAdjacentTanks.remove(i);
                tAdjacentPipes.add(tTank);
                IFluidTank tTarget = ((MultiTileEntityPipeFluid)tTank.mTileEntity).getFluidTankFillable2(tTank.mSideOfTileEntity, aTank.getFluid());
                if (tTarget == null) continue;
                tDrained = ((IFluidHandler)tTank.mTileEntity).fill(tTank.getForgeSideOfTileEntity(), aTank.drain(UT.Code.bindInt(tAmount - (long)tTarget.getFluidAmount()), false), true);
                this.mTransferredAmount += (long)tDrained;
                aTank.drain(tDrained, true);
            }
        }
        if (!tAdjacentTanks.isEmpty()) {
            tAmount = aTank.getFluidAmount() / tAdjacentTanks.size();
            if (tAmount <= 0L) {
                while (aTank.getFluidAmount() > 0 && !tAdjacentTanks.isEmpty()) {
                    tTank = (DelegatorTileEntity)tAdjacentTanks.get(this.getRandomNumber(tAdjacentTanks.size()));
                    tAdjacentTanks.remove(tTank);
                    int tDrained2 = ((IFluidHandler)tTank.mTileEntity).fill(tTank.getForgeSideOfTileEntity(), aTank.drain(1, false), true);
                    this.mTransferredAmount += (long)tDrained2;
                    aTank.drain(tDrained2, true);
                }
            } else {
                for (DelegatorTileEntity tTank2 : tAdjacentTanks) {
                    tDrained = ((IFluidHandler)tTank2.mTileEntity).fill(tTank2.getForgeSideOfTileEntity(), aTank.drain(UT.Code.bindInt(tAmount), false), true);
                    this.mTransferredAmount += (long)tDrained;
                    aTank.drain(tDrained, true);
                }
            }
        }
        if (!tAdjacentPipes.isEmpty() && aTank.getFluidAmount() > this.mCapacity / 2 && (tAmount = (long)((aTank.getFluidAmount() - this.mCapacity / 2) / tAdjacentPipes.size())) > 0L) {
            for (DelegatorTileEntity tTank2 : tAdjacentPipes) {
                tDrained = ((IFluidHandler)tTank2.mTileEntity).fill(tTank2.getForgeSideOfTileEntity(), aTank.drain(UT.Code.bindInt(tAmount), false), true);
                this.mTransferredAmount += (long)tDrained;
                aTank.drain(tDrained, true);
            }
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mContactDamage) {
            UT.Entities.applyTemperatureDamage(aEntity, this.mTemperature, 1.0f);
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        if (CS.SIDES_VALID[aSide] && !this.canAcceptFluidsFrom(aSide)) {
            return null;
        }
        for (FluidTank tTank : this.mTanks) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluidToFill)) continue;
            return tTank;
        }
        for (FluidTank tTank : this.mTanks) {
            if (tTank.getFluid() != null) continue;
            return tTank;
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (CS.SIDES_VALID[aSide] && !this.canEmitFluidsTo(aSide)) {
            return null;
        }
        for (FluidTank tTank : this.mTanks) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluidToDrain)) continue;
            return tTank;
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aDoFill) {
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | CS.SBIT[UT.Code.side(aDirection)]);
        }
        return super.fill(aDirection, aFluid, aDoFill);
    }

    public boolean canEmitFluidsTo(byte aSide) {
        return this.connected(aSide);
    }

    public boolean canAcceptFluidsFrom(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return this.mCapacity >= 250 && aDelegator.getBlock() instanceof BlockCauldron || aDelegator.mTileEntity instanceof IFluidHandler && UT.Code.exists(0, ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(aDelegator.getForgeSideOfTileEntity()));
    }

    @Override
    public long getGibblValue(byte aSide) {
        long rAmount = 0L;
        for (FluidTank tTank : this.mTanks) {
            rAmount += (long)tTank.getFluidAmount();
        }
        return rAmount;
    }

    @Override
    public long getGibblMax(byte aSide) {
        return this.mCapacity * this.mTanks.length;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mTransferredAmount / 2L;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mCapacity * this.mTanks.length / 2;
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        return this.mTemperature;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        return (long)((double)this.mMaterial.mMeltingPoint * HEAT_RESISTANCE_BONUS);
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        BlockTextureDefault tBase = BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
        switch (this.mRenderType) {
            case 1: {
                return BlockTextureMulti.get(tBase, BlockTextureDefault.get(Textures.BlockIcons.PIPE_RESTRICTOR));
            }
        }
        return tBase;
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return CS.IconsGT.INDEX_BLOCK_PIPE_SIDE;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return this.mTanks.length >= 9 ? OP.pipeNonuple.mIconIndexBlock : (this.mTanks.length >= 4 ? OP.pipeQuadruple.mIconIndexBlock : (aDiameter < 0.37f ? OP.pipeTiny.mIconIndexBlock : (aDiameter < 0.49f ? OP.pipeSmall.mIconIndexBlock : (aDiameter < 0.74f ? OP.pipeMedium.mIconIndexBlock : (aDiameter < 0.99f ? OP.pipeLarge.mIconIndexBlock : OP.pipeHuge.mIconIndexBlock)))));
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.PIPE_FLUID.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.pipe.fluid";
    }
}

