/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import net.minecraft.tileentity.TileEntity;

public interface ITileEntityRedstoneWire
extends ITileEntityConnector {
    public static final long MAX_RANGE = Integer.MAX_VALUE;

    public boolean canEmitRedstoneToWire(byte var1, int var2);

    public boolean canAcceptRedstoneFromWire(byte var1, int var2);

    public boolean updateRedstone(int var1);

    public long getRedstoneMinusLoss(byte var1, int var2);

    public long getRedstoneValue(byte var1, int var2);

    public long getRedstoneLoss(int var1);

    public static class Util {
        public static void doRedstoneUpdate(ITileEntityRedstoneWire aTileEntity, int aRedstoneID) {
            HashSetNoNulls<ITileEntityRedstoneWire> tSetUpdating = new HashSetNoNulls<ITileEntityRedstoneWire>(false, aTileEntity);
            HashSetNoNulls<ITileEntityRedstoneWire> tSetNext = new HashSetNoNulls<ITileEntityRedstoneWire>();
            while (!tSetUpdating.isEmpty()) {
                for (ITileEntityRedstoneWire tTileEntity : tSetUpdating) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (!tTileEntity.canEmitRedstoneToWire(tSide, aRedstoneID)) continue;
                        DelegatorTileEntity<TileEntity> tDelegator = tTileEntity.getAdjacentTileEntity(tSide);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityRedstoneWire) || !((ITileEntityRedstoneWire)tDelegator.mTileEntity).canAcceptRedstoneFromWire(tDelegator.mSideOfTileEntity, aRedstoneID) || !((ITileEntityRedstoneWire)tDelegator.mTileEntity).updateRedstone(aRedstoneID)) continue;
                        tSetNext.add((ITileEntityRedstoneWire)tDelegator.mTileEntity);
                    }
                }
                tSetUpdating.clear();
                tSetUpdating.addAll(tSetNext);
                tSetNext.clear();
            }
        }
    }
}

